/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.gui.guiUtil;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IListenerStripper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;

public class SetChooser<T extends IMerlinObj>
extends guiPanel
implements Modifiable,
IEventObserver {
    protected final MerlinData d_data;
    protected boolean d_modified = false;
    private final JEditorPane d_editor;
    protected final String d_desc;
    private final String d_emptyDesc;
    protected final Composite<? extends ICompElement> d_root;
    protected final Class<T> d_clazz;
    protected Predicate<? super T> d_filter;
    protected boolean d_anyAllowed;
    protected List<T> d_availObjs;
    protected Set<T> d_objs;
    private boolean d_showGroupsAllowed;

    public SetChooser(MerlinData md, String desc, String emptyDesc, boolean anyAllowed, boolean showGroupsAllowed, Composite<? extends ICompElement> root, Class<T> clazz, Predicate<? super T> availFilter) {
        this.d_data = md;
        this.d_desc = desc;
        this.d_emptyDesc = emptyDesc;
        this.d_anyAllowed = anyAllowed;
        this.d_showGroupsAllowed = showGroupsAllowed;
        this.d_root = root;
        this.d_clazz = clazz;
        this.d_objs = Collections.EMPTY_SET;
        this.d_filter = availFilter == null ? Filters.acceptAll(clazz) : availFilter;
        this.d_editor = guiUtil.newHTMLLabel();
        this.d_editor.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && SetChooser.this.d_editor.isEnabled()) {
                    SetChooser.this.edit();
                }
            }
        });
        GridBagHelper gb = new GridBagHelper(this);
        gb.addRow(this.d_editor, 1.0);
        gb.finalizeRows();
        this.d_data.getEvents().addObserver(this);
        this.updateAvailable();
    }

    protected void edit() {
        Window parent = guiUtil.getWindow(this);
        ObjDlg<T> dlg = new ObjDlg<T>(parent, this.d_desc, this.d_root, this.d_anyAllowed, this.d_showGroupsAllowed);
        dlg.setObjs(this.d_availObjs, this.d_objs);
        if (dlg.doModal() != 1) {
            return;
        }
        this.setObjs(dlg.getObjs());
        this.d_modified = true;
        this.getComm().touch(this);
    }

    @Override
    public void update(Events events) {
        if (events.isAffected(this.d_clazz)) {
            this.updateAvailable();
        }
    }

    protected void updateAvailable() {
        this.d_availObjs = this.getAllAvailableObjs();
        if (this.d_objs != null && !this.d_objs.isEmpty()) {
            this.d_objs = new LinkedIdentityHashSet<T>(this.d_objs);
            this.d_objs.retainAll(this.d_availObjs);
        }
        this.updateDesc();
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
        super.setModified(modified);
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    protected List<T> getAllAvailableObjs() {
        ArrayList<IMerlinObj> all = new ArrayList<IMerlinObj>();
        for (IMerlinObj obj : this.d_root.getDeepMembers(this.d_clazz)) {
            if (!this.d_filter.test(obj)) continue;
            all.add(obj);
        }
        Collections.sort(all, ObjSorter.INSTANCE);
        return all;
    }

    public void setFilter(Predicate<? super T> filter) {
        if (Objects.equals(this.d_filter, filter)) {
            return;
        }
        this.d_filter = filter;
        this.updateAvailable();
    }

    public void setAnyAllowed(boolean anyAllowed) {
        this.d_anyAllowed = anyAllowed;
        this.updateDesc();
    }

    public void setObjs(Set<T> objs) {
        this.d_objs = objs;
        this.updateDesc();
        this.d_modified = false;
    }

    public Set<T> getObjs() {
        return this.d_objs;
    }

    public Set<T> getUnselectedObjs() {
        return theUtil.filter(this.d_availObjs, o -> !this.d_objs.contains(o));
    }

    protected void updateDesc() {
        boolean isShortened;
        String desc = null;
        if (this.d_objs == null) {
            desc = Intl.intl("[mixed]");
        } else if (this.d_objs.isEmpty()) {
            String emptyDesc = this.d_anyAllowed ? Intl.intl("any") : this.d_emptyDesc;
            desc = "[" + emptyDesc + "]";
        } else {
            ArrayList<T> objList = new ArrayList<T>(this.d_objs);
            Collections.sort(objList, ObjSorter.INSTANCE);
            desc = "";
            for (IMerlinObj obj : objList) {
                if (!desc.isEmpty()) {
                    desc = desc + "; ";
                }
                desc = desc + MerlinUtil.getName(obj);
            }
        }
        FontMetrics fm = this.d_editor.getFontMetrics(this.d_editor.getFont());
        String displayDesc = guiUtil.shorten(desc, 100, fm);
        boolean bl = isShortened = !displayDesc.equals(desc);
        if (!this.d_availObjs.isEmpty()) {
            displayDesc = "<html><a href=\"blank\">" + displayDesc + "</a></html>";
        }
        this.d_editor.setText(displayDesc);
        if (isShortened) {
            this.d_editor.setToolTipText(desc);
        } else {
            this.d_editor.setToolTipText(null);
        }
    }

    public Class getObjClass() {
        return this.d_clazz;
    }

    private static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer,
    MouseListener {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                header.removeMouseListener(this);
                header.addMouseListener(this);
            }
            return this;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.doClick(0);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private static class ObjDlg<T extends IMerlinObj>
    extends guiDialog {
        private final guiRadioButton d_anyBtn;
        private final guiRadioButton d_chooseBtn;
        private final guiTable d_table;
        private final BooleanRenderer d_enabledRend;
        private final Composite<? extends ICompElement> d_root;
        private final boolean d_anyAllowed;
        private final guiLabel d_countLbl;
        private final Semaphore d_lock;

        public ObjDlg(Window parent, String desc, Composite<? extends ICompElement> root, boolean anyAllowed, boolean showGroupsAllowed) {
            super(parent, desc, 9);
            this.d_root = root;
            this.d_anyAllowed = anyAllowed;
            this.d_anyBtn = new guiRadioButton(Intl.intl("Any"));
            this.d_chooseBtn = new guiRadioButton(Intl.intl("Choose"));
            this.d_lock = new Semaphore(1);
            this.d_countLbl = new guiLabel("test");
            this.d_countLbl.setFont(this.d_countLbl.getFont().deriveFont(1));
            new guiButtonGroup(this.d_anyBtn, this.d_chooseBtn);
            if (!this.d_anyAllowed) {
                this.d_anyBtn.setVisible(false);
                this.d_chooseBtn.setVisible(false);
                this.d_chooseBtn.setSelected(true);
            } else {
                this.d_anyBtn.setVisible(true);
                this.d_chooseBtn.setVisible(true);
                this.d_chooseBtn.setSelected(false);
            }
            ObjTableModel tm = new ObjTableModel();
            tm.setColumnCount(2);
            this.d_table = new guiTable((TableModel)tm, 0);
            this.d_table.setRowSelectionAllowed(true);
            this.d_table.setColumnSelectionAllowed(false);
            this.d_table.setShowVerticalLines(false);
            this.d_enabledRend = new BooleanRenderer();
            final boolean[] showPath = new boolean[]{false};
            TableColumn enabledCol = this.d_table.getColumnModel().getColumn(0);
            enabledCol.setHeaderValue(Boolean.FALSE);
            enabledCol.setHeaderRenderer(this.d_enabledRend);
            enabledCol.setCellRenderer(this.d_table.getDefaultRenderer(Boolean.class));
            enabledCol.setCellEditor(this.d_table.getDefaultEditor(Boolean.class));
            TableColumn objCol = this.d_table.getColumnModel().getColumn(1);
            objCol.setHeaderValue(desc);
            MouseAdapter selColList = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int col;
                    if (SwingUtilities.isLeftMouseButton(e) && (col = d_table.columnAtPoint(e.getPoint())) == 1) {
                        int row = d_table.rowAtPoint(e.getPoint());
                        Boolean val = (Boolean)d_table.getValueAt(row, 0);
                        val = val != null ? !val.booleanValue() : true;
                        d_table.setValueAt(val, row, 0);
                    }
                }
            };
            this.d_table.addMouseListener(selColList);
            objCol.setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    this.setText(ObjDlg.format((IMerlinObj)value, showPath[0], d_root));
                    return comp;
                }
            });
            this.d_enabledRend.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!d_lock.tryAcquire()) {
                        return;
                    }
                    IListenerStripper listeners = this.stripModelListeners(d_table);
                    for (int m = 0; m < d_table.getModel().getRowCount(); ++m) {
                        d_table.setValueAt(d_enabledRend.isSelected(), m, 0);
                    }
                    d_lock.release();
                    listeners.restore();
                    this.handleTableChanged();
                    d_table.getTableHeader().repaint();
                    d_table.repaint();
                }
            });
            this.d_table.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    this.handleTableChanged();
                }
            });
            final guiCheckBox showPathBox = new guiCheckBox(Intl.intl("Show groups"));
            showPathBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    showPath[0] = showPathBox.isSelected();
                    d_table.repaint();
                }
            });
            LinkStatus.link((AbstractButton)this.d_chooseBtn, this.d_table, this.d_countLbl, showPathBox);
            JScrollPane sp = new JScrollPane(this.d_table);
            sp.setPreferredSize(new Dimension(150, 120));
            GridBagHelper gb = new GridBagHelper(this.getDialogPane());
            gb.addRow(this.d_anyBtn);
            gb.addRow(this.d_chooseBtn);
            gb.indent();
            gb.addRow(sp, new double[]{1.0, 1.0});
            gb.addRow(this.d_countLbl);
            if (showGroupsAllowed) {
                gb.addRow(showPathBox);
            }
            enabledCol.sizeWidthToFit();
            this.setResizable(true);
        }

        private void handleTableChanged() {
            int count = this.getEnabledCount();
            String text = count == 1 ? Intl.intl("1 object selected.") : String.format(Intl.intl("%d objects selected."), count);
            this.d_countLbl.setText(text);
            if (!this.d_lock.tryAcquire()) {
                return;
            }
            boolean allEnabled = this.areAllEnabled();
            this.d_enabledRend.setSelected(allEnabled);
            this.d_table.getTableHeader().repaint();
            this.d_lock.release();
        }

        private static <T extends IMerlinObj> String format(T mobj, boolean showPath, Composite<? extends ICompElement> root) {
            MerlinData md = MerlinApp.getApp().getData();
            if (showPath) {
                Object[] path = md.hierarchy.getPath(mobj, root, false);
                String desc = "";
                for (int m = 0; m < path.length; ++m) {
                    String name;
                    Object obj = path[m];
                    if (!(obj instanceof IMerlinObj) || (name = MerlinUtil.getName((IMerlinObj)obj)) == null || name.isEmpty()) continue;
                    if (!desc.isEmpty()) {
                        desc = desc + "->";
                    }
                    desc = desc + name;
                }
                return desc;
            }
            return MerlinUtil.getName(mobj);
        }

        private IListenerStripper stripModelListeners(JTable table) {
            DefaultTableModel model = (DefaultTableModel)this.d_table.getModel();
            return guiUtil.stripListeners(model::addTableModelListener, model::getTableModelListeners, model::removeTableModelListener);
        }

        public void setObjs(List<T> availObjs, Set<T> objs) {
            DefaultTableModel model = (DefaultTableModel)this.d_table.getModel();
            IListenerStripper listeners = this.stripModelListeners(this.d_table);
            model.setRowCount(availObjs.size());
            for (int m = 0; m < availObjs.size(); ++m) {
                IMerlinObj obj = (IMerlinObj)availObjs.get(m);
                boolean enabled = objs != null && (this.d_anyAllowed && objs.isEmpty() || objs.contains(obj));
                model.setValueAt(enabled, m, 0);
                model.setValueAt(obj, m, 1);
            }
            listeners.restore();
            this.handleTableChanged();
            if (objs == null) {
                this.d_anyBtn.setSelected(false);
                this.d_chooseBtn.setSelected(false);
            } else if (objs.isEmpty() && this.d_anyAllowed) {
                this.d_anyBtn.setSelected(true);
            } else {
                this.d_chooseBtn.setSelected(true);
            }
        }

        public Set<T> getObjs() {
            if (this.d_anyBtn.isSelected()) {
                return Collections.EMPTY_SET;
            }
            if (this.d_chooseBtn.isSelected()) {
                LinkedIdentityHashSet objs = new LinkedIdentityHashSet();
                TableModel model = this.d_table.getModel();
                for (int m = 0; m < model.getRowCount(); ++m) {
                    Boolean enabled = (Boolean)model.getValueAt(m, 0);
                    if (!enabled.booleanValue()) continue;
                    objs.add((IMerlinObj)model.getValueAt(m, 1));
                }
                return objs;
            }
            return null;
        }

        private boolean areAllEnabled() {
            return this.getEnabledCount() == this.d_table.getRowCount();
        }

        private int getEnabledCount() {
            int count = 0;
            for (int m = 0; m < this.d_table.getRowCount(); ++m) {
                Boolean val = (Boolean)this.d_table.getValueAt(m, 0);
                if (val == null || !val.booleanValue()) continue;
                ++count;
            }
            return count;
        }

        private static class ObjTableModel
        extends DefaultTableModel {
            private ObjTableModel() {
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 0;
            }
        }
    }

    protected static class ObjSorter<T extends IMerlinObj>
    implements Comparator<T> {
        public static final ObjSorter<IMerlinObj> INSTANCE = new ObjSorter();

        protected ObjSorter() {
        }

        @Override
        public int compare(T o1, T o2) {
            return MerlinUtil.getName(o1).compareToIgnoreCase(MerlinUtil.getName(o2));
        }
    }
}

