/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.plaf.basic.BasicArrowButton;
import merlin.gui.ActionMapAction;

public class PanPane
extends JPanel {
    public static final int SCROLL_DT = 1;
    private final JScrollPane d_scrollPane;
    private final ArrowButton d_west;
    private final ArrowButton d_east;
    private int d_scrollDt = 1;
    private ComponentAdapter d_compListener;

    public PanPane() {
        this((Component)null);
    }

    public PanPane(Component c) {
        this.setLayout(new BorderLayout());
        this.setBorder(null);
        this.d_scrollPane = new JScrollPane(c, 21, 31);
        this.d_scrollPane.setBorder(null);
        JScrollBar horizontal = this.d_scrollPane.getHorizontalScrollBar();
        this.d_west = this.createArrowButton(horizontal, 7, "negativeUnitIncrement");
        this.add((Component)this.d_west, "West");
        this.d_east = this.createArrowButton(horizontal, 3, "positiveUnitIncrement");
        this.add((Component)this.d_east, "East");
        this.add(this.d_scrollPane);
        this.d_compListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                PanPane.this.updateBtnVis();
            }
        };
        this.d_scrollPane.addComponentListener(this.d_compListener);
        this.d_scrollPane.getViewport().addChangeListener(e -> SwingUtilities.invokeLater(() -> this.updateBtnVis()));
        if (c != null) {
            c.addComponentListener(this.d_compListener);
        }
        this.updateBtnVis();
    }

    public JScrollPane getScrollPane() {
        return this.d_scrollPane;
    }

    private ArrowButton createArrowButton(final JScrollBar bar, int dir, final String actionCommand) {
        ArrowButton btn = new ArrowButton(dir);
        btn.setBorder(BorderFactory.createEtchedBorder(1));
        final ActionMapAction action = new ActionMapAction("", bar, actionCommand);
        btn.setAction(action);
        btn.addMouseListener(new MouseAdapter(){
            private Timer timer;

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    this.timer = new Timer(PanPane.this.d_scrollDt, evt -> action.actionPerformed(new ActionEvent(bar, 1001, actionCommand, e.getWhen(), e.getModifiers())));
                    this.timer.start();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 1 && this.timer != null) {
                    this.timer.stop();
                    this.timer = null;
                }
            }
        });
        return btn;
    }

    public void scroll(ScrollDir dir) {
        int value;
        JScrollBar bar;
        switch (dir) {
            case LEFT: {
                bar = this.getScrollPane().getHorizontalScrollBar();
                value = 0;
                break;
            }
            case RIGHT: {
                bar = this.getScrollPane().getHorizontalScrollBar();
                value = bar.getMaximum() - bar.getVisibleAmount();
                break;
            }
            case TOP: {
                bar = this.getScrollPane().getVerticalScrollBar();
                value = 0;
                break;
            }
            default: {
                bar = this.getScrollPane().getVerticalScrollBar();
                value = bar.getMaximum() - bar.getVisibleAmount();
            }
        }
        SwingUtilities.invokeLater(() -> bar.setValue(value));
    }

    public void setScrollDt(int dt) {
        this.d_scrollDt = dt;
    }

    public int getScrollDt() {
        return this.d_scrollDt;
    }

    public void setViewportView(Component c) {
        if (this.getViewportView() != null) {
            this.getViewportView().removeComponentListener(this.d_compListener);
        }
        this.d_scrollPane.setViewportView(c);
        if (c != null) {
            c.addComponentListener(this.d_compListener);
        }
        this.updateBtnVis();
    }

    public Component getViewportView() {
        return this.d_scrollPane.getViewport().getView();
    }

    protected void updateBtnVis() {
        Component comp = this.d_scrollPane.getViewport().getView();
        boolean vis = false;
        if (comp != null) {
            Dimension d = comp.getPreferredSize();
            vis = d.width > this.d_scrollPane.getSize().width;
        }
        JScrollBar sb = this.d_scrollPane.getHorizontalScrollBar();
        int pos = sb.getValue();
        boolean wvis = vis && pos > 0;
        boolean evis = vis && pos < sb.getMaximum() - sb.getVisibleAmount();
        this.d_west.setDrawEnabled(wvis);
        this.d_east.setDrawEnabled(evis);
    }

    private static class ArrowButton
    extends BasicArrowButton {
        private boolean d_drawEnabled = true;

        public ArrowButton(int dir) {
            super(dir);
        }

        public void setDrawEnabled(boolean enabled) {
            this.d_drawEnabled = enabled;
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            if (!this.d_drawEnabled) {
                int w = this.getSize().width;
                int h = this.getSize().height;
                g.setColor(this.getBackground());
                g.fillRect(0, 0, w, h);
                return;
            }
            super.paint(g);
        }
    }

    public static enum ScrollDir {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

