/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import inferno.io.fdsout.DataFinder;
import inferno.io.fdsout.DataFinderSmvPlot3d;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.data.SimParams;
import merlin.gui.MerlinUDF;
import merlin.gui.MerlinValueFields;
import merlin.gui.guiUtil;
import merlin.unitsystem.SIUS;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiDoubleField;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiSeparator;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;

public class EditSimParamsDlg
extends guiDialog {
    private Map<String, EditorPanel> d_tabs = new LinkedHashMap<String, EditorPanel>();

    public EditSimParamsDlg(JFrame owner) {
        super((Window)owner, Intl.intl("Simulation Parameters"), 9);
        this.d_tabs.put(Intl.intl("Time"), new TimeEditor());
        this.d_tabs.put(Intl.intl("Output"), new OutputEditor());
        this.d_tabs.put(Intl.intl("Paths"), new PathingEditor());
        this.d_tabs.put(Intl.intl("Behavior"), new BehaviorEditor());
        this.d_tabs.put(Intl.intl("FDS Data"), new FdsOutputLinkageEditor());
        this.d_tabs.put(Intl.intl("Misc"), new MiscEditor());
        JTabbedPane jtp = new JTabbedPane();
        for (Map.Entry<String, EditorPanel> entry : this.d_tabs.entrySet()) {
            jtp.addTab(entry.getKey(), entry.getValue());
        }
        guiPanel dlgPanel = this.getDialogPane();
        dlgPanel.setLayout(new BorderLayout());
        dlgPanel.add((Component)jtp, "Center");
    }

    public void load(SimParams sp) {
        for (Map.Entry<String, EditorPanel> entry : this.d_tabs.entrySet()) {
            entry.getValue().load(sp);
        }
        this.setModified(false);
    }

    public void store(SimParams sp) {
        for (Map.Entry<String, EditorPanel> entry : this.d_tabs.entrySet()) {
            entry.getValue().store(sp);
        }
    }

    private static class FdsOutputLinkageEditor
    extends EditorPanel {
        private guiCheckBox d_enableSmvData;
        private guiCheckBox d_enableSmokeSlowing;
        private JButton d_smvFileEdit;
        private guiTextField d_smvFileField;
        private guiLabel d_dataSourceMsg;
        private guiLabel d_dataFreqMsg;
        private guiLabel d_dataTempMsg;
        private guiLabel d_dataCoMsg;
        private guiLabel d_dataCo2Msg;
        private guiLabel d_dataO2Msg;
        private guiLabel d_dataSootVisMsg;
        private guiLabel d_dataFedMsg;
        private final ValueField<UnitDouble> d_o2HypoxiaThreshold;
        private static final int STATUS_HAPPY = 0;
        private static final int STATUS_SAD = 1;
        private static final Color PATHFINDERGREEN = new Color(0, 96, 0);
        private static final Color DISABLEDGRAY = new Color(109, 109, 109);

        public FdsOutputLinkageEditor() {
            GridBagHelper gb = new GridBagHelper(this, true);
            this.d_o2HypoxiaThreshold = MerlinValueFields.udFld(DoubleVR.between(0.0, 100.0, true, true), NonSI.PERCENT, 10);
            guiLabel hypoxiaLbl = new guiLabel(Intl.intl("Hypoxia FED Threshold:"));
            hypoxiaLbl.setToolTipText(Intl.intl("The oxygen concentration at hypoxia contributes to FED."));
            this.d_enableSmvData = new guiCheckBox(Intl.intl("Enable FDS Integration"));
            gb.addRow(this.d_enableSmvData, 3);
            this.d_enableSmokeSlowing = new guiCheckBox(Intl.intl("Occupants Slow Down in Smoke"));
            this.d_enableSmokeSlowing.setToolTipText(Intl.intl("Requires SOOT Visibility"));
            gb.addRow(this.d_enableSmokeSlowing, 3);
            guiLabel smvFileLabel = new guiLabel(Intl.intl("Smokeview File:"));
            this.d_smvFileField = new guiTextField();
            this.d_smvFileField.setPreferredSize(new Dimension(200, this.d_smvFileField.getPreferredSize().height));
            this.d_smvFileField.setEditable(false);
            this.d_smvFileEdit = new JButton(Intl.intl("Edit..."));
            Dimension d = this.d_smvFileEdit.getPreferredSize();
            this.d_smvFileEdit.setPreferredSize(new Dimension(d.width, this.d_smvFileField.getPreferredSize().height + 2));
            guiLabel warningLbl = new guiLabel(Intl.intl("NOTE: Occupants outside FDS meshes will pause their FED calculation."));
            warningLbl.setFont(warningLbl.getFont().deriveFont(1));
            gb.addRow(smvFileLabel, this.d_smvFileField, this.d_smvFileEdit);
            gb.addFilledRow(new guiSeparator());
            guiLabel dataSource = new guiLabel(Intl.intl("Data Source:"));
            this.d_dataSourceMsg = new guiLabel();
            gb.addRow(dataSource, this.d_dataSourceMsg, 2);
            guiLabel dataFreq = new guiLabel(Intl.intl("Data Interval:"));
            this.d_dataFreqMsg = new guiLabel();
            gb.addRow(dataFreq, this.d_dataFreqMsg, 2);
            guiLabel dataT = new guiLabel(Intl.intl("Temperature:"));
            this.d_dataTempMsg = new guiLabel();
            gb.addRow(dataT, this.d_dataTempMsg, 2);
            guiLabel dataCO = new guiLabel(Intl.intl("CO Volume Fraction:"));
            this.d_dataCoMsg = new guiLabel();
            gb.addRow(dataCO, this.d_dataCoMsg, 2);
            guiLabel dataCO2 = new guiLabel(Intl.intl("CO2 Volume Fraction:"));
            this.d_dataCo2Msg = new guiLabel();
            gb.addRow(dataCO2, this.d_dataCo2Msg, 2);
            guiLabel dataO2 = new guiLabel(Intl.intl("O2 Volume Fraction:"));
            this.d_dataO2Msg = new guiLabel();
            gb.addRow(dataO2, this.d_dataO2Msg, 2);
            guiLabel dataSootVis = new guiLabel(Intl.intl("SOOT Visibility:"));
            this.d_dataSootVisMsg = new guiLabel();
            gb.addRow(dataSootVis, this.d_dataSootVisMsg, 2);
            guiLabel dataFed = new guiLabel(Intl.intl("FED Output:"));
            this.d_dataFedMsg = new guiLabel();
            gb.addRow(dataFed, this.d_dataFedMsg, 2);
            gb.addRow(warningLbl, 0);
            gb.addFilledRow(new guiSeparator());
            gb.addRow(hypoxiaLbl, this.d_o2HypoxiaThreshold, 0);
            gb.finalizeRows();
            GridBagUtil.addGlue(this);
            LinkStatus.link((AbstractButton)this.d_enableSmvData, this.d_enableSmokeSlowing, smvFileLabel, this.d_smvFileField, this.d_smvFileEdit, hypoxiaLbl, this.d_o2HypoxiaThreshold, dataSource, this.d_dataSourceMsg, dataFreq, this.d_dataFreqMsg, dataT, this.d_dataTempMsg, dataCO, this.d_dataCoMsg, dataCO2, this.d_dataCo2Msg, dataO2, this.d_dataO2Msg, dataSootVis, this.d_dataSootVisMsg, dataFed, this.d_dataFedMsg, warningLbl);
            this.updateStatusMsg(1, Intl.intl("Not Found"), this.d_dataSourceMsg, this.d_dataFreqMsg, this.d_dataTempMsg, this.d_dataCoMsg, this.d_dataCo2Msg, this.d_dataO2Msg, this.d_dataSootVisMsg, this.d_dataFedMsg);
            this.d_smvFileEdit.addActionListener(evt -> this.doClickEditButton());
            this.d_enableSmvData.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String fn = d_smvFileField.getValue();
                    if (e.getStateChange() == 1 && fn != null && fn.length() > 0) {
                        new Thread(new UpdateLoader(true, fn)).start();
                    }
                }
            });
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (!this.d_enableSmvData.isSelected()) {
                return true;
            }
            DataFinderSmvPlot3d parser = null;
            try {
                File smvFile = new File(this.d_smvFileField.getValue());
                parser = new DataFinderSmvPlot3d(smvFile);
                parser.update();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (showWarn) {
                    String msg = Intl.intl("FDS integration is enabled, but FDS output data not found:\n" + this.d_smvFileField.getValue() + "\n\n" + "Disable FDS integration to continue.");
                    guiDialog.showInvalidEntryMessage(this, msg);
                }
                return false;
            }
            if (!parser.hasMeshData()) {
                if (showWarn) {
                    String msg = Intl.intl("FDS integration is enabled, but FDS output does not contain XYZ data.\nPlease verify FDS parameter WRITE_XYZ=.TRUE.\n\nDisable FDS integration to continue.");
                    guiDialog.showInvalidEntryMessage(this, msg);
                }
                return false;
            }
            return true;
        }

        private void updateStatusMsg(int style, String msg, guiLabel ... comps) {
            for (guiLabel comp : comps) {
                comp.setText(msg);
                comp.setFont(comp.getFont().deriveFont(1));
                comp.setEnabled(style == 0);
                if (style == 0) {
                    comp.setForeground(PATHFINDERGREEN);
                    continue;
                }
                if (style == 1) {
                    comp.setForeground(DISABLEDGRAY);
                    continue;
                }
                assert (false) : "Unknown status!";
            }
        }

        private void doClickEditButton() {
            Window owner;
            int result;
            guiFileChooser chooser = guiUtil.getChooser(MerlinPrefs.OPEN_DIR_PREF, Optional.empty(), "SMV", "Smokeview File");
            String prevValue = this.d_smvFileField.getValue();
            if (prevValue != null) {
                chooser.setCurrentDirectory(new File(prevValue), false);
            }
            if ((result = chooser.showOpenDialog(owner = SwingUtilities.getWindowAncestor(this))) == 0) {
                this.updateStatusMsg(1, Intl.intl("Detecting..."), this.d_dataSourceMsg, this.d_dataFreqMsg, this.d_dataTempMsg, this.d_dataCoMsg, this.d_dataCo2Msg, this.d_dataO2Msg, this.d_dataSootVisMsg, this.d_dataFedMsg);
                new Thread(new UpdateLoader(true, chooser.getSelectedFile().getPath())).start();
            }
        }

        @Override
        public void load(SimParams sp) {
            this.d_enableSmvData.setSelected(sp.smvDataEnable);
            this.d_enableSmokeSlowing.setSelected(sp.smvSmokeSlowEnable);
            if (sp.smvDataEnable && sp.smvDataFileName != null) {
                this.d_smvFileField.setValue(sp.smvDataFileName);
                this.updateStatusMsg(1, Intl.intl("Detecting..."), this.d_dataSourceMsg, this.d_dataFreqMsg, this.d_dataTempMsg, this.d_dataCoMsg, this.d_dataCo2Msg, this.d_dataO2Msg, this.d_dataSootVisMsg, this.d_dataFedMsg);
                new Thread(new UpdateLoader(false, sp.smvDataFileName)).start();
            }
            this.d_o2HypoxiaThreshold.setValue(sp.hypoxiaLimit);
        }

        @Override
        public void store(SimParams sp) {
            sp.smvDataEnable = this.d_enableSmvData.isSelected();
            sp.smvSmokeSlowEnable = this.d_enableSmokeSlowing.isSelected();
            sp.smvDataFileName = this.d_smvFileField.getValue();
            sp.hypoxiaLimit = (UnitDouble)this.d_o2HypoxiaThreshold.getValue();
        }

        private class UpdateResultLoaded
        implements Runnable {
            private DataFinderSmvPlot3d d_parser;

            public UpdateResultLoaded(DataFinderSmvPlot3d parser) {
                this.d_parser = parser;
            }

            @Override
            public void run() {
                if (this.d_parser.hasMeshData()) {
                    FdsOutputLinkageEditor.this.updateStatusMsg(0, "PLOT3D", new guiLabel[]{FdsOutputLinkageEditor.this.d_dataSourceMsg});
                } else {
                    FdsOutputLinkageEditor.this.updateStatusMsg(1, Intl.intl("PLOT3D: XYZ Data Not Found"), new guiLabel[]{FdsOutputLinkageEditor.this.d_dataSourceMsg});
                }
                Float[] times = this.d_parser.getTimes();
                if (times.length > 1) {
                    String sdt = String.format("%.2f", this.getAverageInterval(times));
                    FdsOutputLinkageEditor.this.updateStatusMsg(0, String.format(Intl.intl("%s s"), sdt), new guiLabel[]{FdsOutputLinkageEditor.this.d_dataFreqMsg});
                } else {
                    FdsOutputLinkageEditor.this.updateStatusMsg(1, Intl.intl("Insufficient Data"), new guiLabel[]{FdsOutputLinkageEditor.this.d_dataFreqMsg});
                }
                DataFinder.Quantity[] quantities = this.d_parser.getQuantities();
                this.updateFoundMsg(this.containsQuantities(quantities, "TEMPERATURE"), FdsOutputLinkageEditor.this.d_dataTempMsg);
                this.updateFoundMsg(this.containsQuantities(quantities, "CARBON DIOXIDE VOLUME FRACTION"), FdsOutputLinkageEditor.this.d_dataCo2Msg);
                this.updateFoundMsg(this.containsQuantities(quantities, "CARBON MONOXIDE VOLUME FRACTION"), FdsOutputLinkageEditor.this.d_dataCoMsg);
                this.updateFoundMsg(this.containsQuantities(quantities, "OXYGEN VOLUME FRACTION"), FdsOutputLinkageEditor.this.d_dataO2Msg);
                this.updateFoundMsg(this.containsQuantities(quantities, "SOOT VISIBILITY"), FdsOutputLinkageEditor.this.d_dataSootVisMsg);
                String[] fedQuantities = new String[]{"CARBON DIOXIDE VOLUME FRACTION", "OXYGEN VOLUME FRACTION", "CARBON MONOXIDE VOLUME FRACTION"};
                if (this.containsQuantities(quantities, fedQuantities)) {
                    FdsOutputLinkageEditor.this.updateStatusMsg(0, Intl.intl("Enabled"), new guiLabel[]{FdsOutputLinkageEditor.this.d_dataFedMsg});
                } else {
                    FdsOutputLinkageEditor.this.updateStatusMsg(1, Intl.intl("Disabled. Requires CO, CO2, and O2."), new guiLabel[]{FdsOutputLinkageEditor.this.d_dataFedMsg});
                }
            }

            private void updateFoundMsg(boolean flag, guiLabel comp) {
                if (flag) {
                    FdsOutputLinkageEditor.this.updateStatusMsg(0, Intl.intl("Enabled"), new guiLabel[]{comp});
                } else {
                    FdsOutputLinkageEditor.this.updateStatusMsg(1, Intl.intl("Not Found"), new guiLabel[]{comp});
                }
            }

            private boolean containsQuantities(DataFinder.Quantity[] qs, String ... fdsName) {
                ArrayList<String> fdsNames = new ArrayList<String>(Arrays.asList(fdsName));
                for (int i = 0; i < qs.length; ++i) {
                    fdsNames.remove(qs[i].fdsName);
                }
                return fdsNames.isEmpty();
            }

            private double getAverageInterval(Float[] fs) {
                double allIntervals = 0.0;
                for (int i = 1; i < fs.length; ++i) {
                    allIntervals += (double)(fs[i].floatValue() - fs[i - 1].floatValue());
                }
                return allIntervals / (double)(fs.length - 1);
            }
        }

        private class UpdateResultError
        implements Runnable {
            public boolean d_promptOnFail;

            public UpdateResultError(boolean flag) {
                this.d_promptOnFail = flag;
            }

            @Override
            public void run() {
                if (this.d_promptOnFail) {
                    JOptionPane.showMessageDialog(FdsOutputLinkageEditor.this, Intl.intl("Error loading SMV file."));
                }
                FdsOutputLinkageEditor.this.updateStatusMsg(1, Intl.intl("Error"), new guiLabel[]{FdsOutputLinkageEditor.this.d_dataSourceMsg});
                FdsOutputLinkageEditor.this.updateStatusMsg(1, Intl.intl("Not Found"), new guiLabel[]{FdsOutputLinkageEditor.this.d_dataFreqMsg, FdsOutputLinkageEditor.this.d_dataTempMsg, FdsOutputLinkageEditor.this.d_dataCoMsg, FdsOutputLinkageEditor.this.d_dataCo2Msg, FdsOutputLinkageEditor.this.d_dataO2Msg, FdsOutputLinkageEditor.this.d_dataSootVisMsg, FdsOutputLinkageEditor.this.d_dataFedMsg});
            }
        }

        private class UpdateLoader
        implements Runnable {
            public boolean d_promptOnFail;
            private String d_smvFile;

            public UpdateLoader(boolean flag, String smvFile) {
                this.d_promptOnFail = flag;
                this.d_smvFile = smvFile;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                File smvFile = new File(this.d_smvFile);
                FdsOutputLinkageEditor.this.d_smvFileField.setText(smvFile.getPath());
                DataFinderSmvPlot3d parser = new DataFinderSmvPlot3d(smvFile);
                try {
                    parser.update();
                    EventQueue.invokeLater(new UpdateResultLoaded(parser));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    EventQueue.invokeLater(new UpdateResultError(this.d_promptOnFail));
                }
                finally {
                    FdsOutputLinkageEditor.this.setModified(true);
                }
            }
        }
    }

    private static class MiscEditor
    extends EditorPanel {
        private final guiCheckBox d_ckShowVis = new guiCheckBox(Intl.intl("Show Runtime Visualization"));
        private final guiCheckBox d_autoSnapshots = new guiCheckBox(Intl.intl("Save Restart Files"), true);
        private final guiUnitDoubleField d_ssInterval = new MerlinUDF(120.0, DoubleVR.above(0.0, false), SI.SECOND);
        private final ValueField<Double> d_extractEdgeError = ValueFields.doubleFld(DoubleVR.above(0.0, false));
        private final ValueField<Double> d_extractFaceError = ValueFields.doubleFld(DoubleVR.above(0.0, false));
        private final guiCheckBox d_enableVehicleLateralMovement = new guiCheckBox(Intl.intl("Enable visualized sideways movement of vehicles"));

        public MiscEditor() {
            this.d_enableVehicleLateralMovement.setToolTipText("<html>" + Intl.intl("Enables the visualization of vehicles moving sideways without changing the simulation.<br>NOTE: Sideways movement must still be enabled per vehicle shape."));
            guiLabel curveLbl = new guiLabel(Intl.intl("Curve error:"));
            curveLbl.setToolTipText(Intl.intl("Sets the amount of error when converting curved CAD lines to straight lines when generating model elements."));
            guiLabel faceLbl = new guiLabel(Intl.intl("Face error:"));
            faceLbl.setToolTipText(Intl.intl("Sets the amount of error when converting curved CAD faces to polygons when generating model elements."));
            guiLabel ssIntervalLbl = new guiLabel(Intl.intl("Snapshot Interval:"));
            LinkStatus.link((AbstractButton)this.d_autoSnapshots, ssIntervalLbl, this.d_ssInterval);
            GridBagHelper gb = new GridBagHelper(this, true);
            if (MerlinApp.isDev()) {
                gb.addRow(this.d_ckShowVis, 0);
            }
            gb.addRow(this.d_autoSnapshots, 0);
            gb.addIdentRow(ssIntervalLbl, this.d_ssInterval, 0);
            gb.addTitle(Intl.intl("Generating Model Elements"));
            gb.indent();
            gb.addRow(curveLbl, this.d_extractEdgeError, 0);
            gb.addRow(faceLbl, this.d_extractFaceError, 0);
            gb.unindent();
            gb.addTitle(Intl.intl("Experimental"));
            gb.indent();
            gb.addRow(this.d_enableVehicleLateralMovement, 0);
            gb.unindent();
            gb.finalizeRows();
            GridBagUtil.addGlue(this);
        }

        @Override
        public void load(SimParams sp) {
            this.d_ckShowVis.setSelected(sp.showVis);
            UnitDouble ssint = sp.dtSnapshot;
            if (ssint.getValueNoUnit() > 0.0) {
                this.d_autoSnapshots.setSelected(true);
                this.d_ssInterval.setValue(ssint);
            } else {
                this.d_autoSnapshots.setSelected(false);
                this.d_ssInterval.setValue(new UnitDouble(60.0, SI.SECOND));
            }
            this.d_extractEdgeError.setValue(sp.edgeError);
            this.d_extractFaceError.setValue(sp.faceError);
            this.d_enableVehicleLateralMovement.setSelected(sp.enableVehicleLateralMovementVis);
        }

        @Override
        public void store(SimParams sp) {
            sp.showVis = this.d_ckShowVis.isSelected();
            sp.dtSnapshot = this.d_autoSnapshots.isSelected() ? (UnitDouble)this.d_ssInterval.getValue() : new UnitDouble(0.0, SI.SECOND);
            sp.edgeError = (Double)this.d_extractEdgeError.getValue();
            sp.faceError = (Double)this.d_extractFaceError.getValue();
            sp.enableVehicleLateralMovementVis = this.d_enableVehicleLateralMovement.isSelected();
        }
    }

    private static class PathingEditor
    extends EditorPanel {
        private guiCheckBox d_ckMaxEdge = new guiCheckBox(Intl.intl("Constrain Edge Length"));
        private guiUnitDoubleField d_dfMaxEdge = new MerlinUDF(2.5, DoubleVR.above(0.0, false), SI.METER);
        private guiLabel d_labLMax;
        private guiLabel d_labMinAngle;
        private guiDoubleField d_fldMinAngle;
        private guiLabel d_uMinAngle;
        private guiUnitDoubleField d_dfMaxTrimError;

        public PathingEditor() {
            this.d_dfMaxEdge.setEnabled(false);
            this.d_labLMax = new guiLabel(Intl.intl("Max Edge Length:"));
            this.d_labMinAngle = new guiLabel(Intl.intl("Min Angle:"));
            DoubleVR vrMinAngle = DoubleVR.between(0.0, 45.0, true, true);
            this.d_fldMinAngle = new guiDoubleField(vrMinAngle);
            this.d_uMinAngle = new guiLabel("<html>&deg;");
            guiLabel trimErrorLbl = new guiLabel(Intl.intl("Max Agent Radius Trim Error:"));
            this.d_dfMaxTrimError = new MerlinUDF(1.0, DoubleVR.above(0.0, true), NonSI.INCH);
            LinkStatus.link((AbstractButton)this.d_ckMaxEdge, this.d_dfMaxEdge, this.d_labLMax, this.d_labMinAngle, this.d_fldMinAngle, this.d_uMinAngle);
            this.setLayout(new GridBagLayout());
            int r = 0;
            GridBagUtil.add(this, trimErrorLbl, 0, r, 1, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_dfMaxTrimError, 1, r, 1, 1, 12, 0, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_ckMaxEdge, 0, ++r, 3, 1, 0, 12, 6, 13, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_labLMax, 0, ++r, 1, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_dfMaxEdge, 1, r, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_labMinAngle, 0, ++r, 1, 1, 0, 30, 12, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_fldMinAngle, 1, r, 1, 1, 0, 0, 12, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_uMinAngle, 2, r, 1, 1, 0, 0, 12, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        @Override
        public void load(SimParams sp) {
            this.d_ckMaxEdge.setSelected(sp.maxEdgeLengthFlag);
            this.d_dfMaxEdge.setValue(sp.maxEdgeLength);
            this.d_fldMinAngle.setValue(sp.minAngle);
            this.d_dfMaxTrimError.setValue(sp.maxTrimError);
        }

        @Override
        public void store(SimParams sp) {
            sp.maxEdgeLengthFlag = this.d_ckMaxEdge.isSelected();
            sp.maxEdgeLength = (UnitDouble)this.d_dfMaxEdge.getValue();
            sp.minAngle = (Double)this.d_fldMinAngle.getValue();
            sp.maxTrimError = (UnitDouble)this.d_dfMaxTrimError.getValue();
        }
    }

    private static class BehaviorEditor
    extends EditorPanel {
        private final guiCheckBox d_ckCollideSteering;
        private final guiCheckBox d_ckForcedSeparation;
        private final guiCheckBox d_ckLimitFlowrateSteering;
        private final MerlinUDF d_fldSteerUpdate;
        private final MerlinUDF d_fldDoorBndLayerSteering;
        private final MerlinUDF d_fldSpFlowSteering;
        private final ValueField<Double> d_fldMinFlowrateFactorSteering;
        private final MerlinUDF d_fldDMax;
        private final MerlinUDF d_fldDoorBndLayerSFPE;
        private final ValueField<Double> d_fldMinVelSFPE;
        private final guiRadioButton d_rbUseProfileFundamental;
        private final guiRadioButton d_rbUseSFPEFundamental;
        private final guiRadioButton d_rbUseMaxFlow;
        private final guiRadioButton d_rbFlowFromDensity;
        private final String[] OPTS = new String[]{Intl.intl("Steering"), Intl.intl("SFPE")};
        private final int REACTIVE_OPT = 0;
        private final int SFPE_OPT = 1;
        private guiComboBox<?> d_behaviorBox = new guiComboBox<Object>((T[])this.OPTS);

        public BehaviorEditor() {
            Unit siInvOccDensityu = SIUS.unit(3);
            Unit siShortLen = SIUS.unit(6);
            guiPanel reactivePanel = new guiPanel(new GridBagLayout());
            this.d_ckCollideSteering = new guiCheckBox(Intl.intl("Collision Handling"));
            this.d_ckForcedSeparation = new guiCheckBox(Intl.intl("Enable Forced Separation"));
            this.d_ckForcedSeparation.setToolTipText(Intl.intl("Agents will always attempt to maintain personal distance (from profile) spacing."));
            this.d_fldSteerUpdate = new MerlinUDF(0.1, DoubleVR.above(0.0, true), SI.SECOND);
            this.d_ckLimitFlowrateSteering = new guiCheckBox(Intl.intl("Limit Door Flow Rate"));
            guiLabel doorBndLayerSteeringLbl = new guiLabel(Intl.intl("Boundary Layer:"));
            this.d_fldDoorBndLayerSteering = new MerlinUDF(0.0, DoubleVR.above(0.0, true), siShortLen);
            this.d_fldSpFlowSteering = new MerlinUDF(12, DoubleVR.above(0.0, false));
            guiLabel defMaxFlowrateLbl = new guiLabel(Intl.intl("Specific Flow:"));
            LinkStatus.link((AbstractButton)this.d_ckLimitFlowrateSteering, doorBndLayerSteeringLbl, this.d_fldDoorBndLayerSteering, defMaxFlowrateLbl, this.d_fldSpFlowSteering);
            this.d_fldMinFlowrateFactorSteering = ValueFields.doubleFld(0.1, DoubleVR.between(0.0, 1.0, true, true));
            guiLabel minFlowLbl = new guiLabel(Intl.intl("Minimum flowrate factor:"));
            minFlowLbl.setToolTipText("<html>" + Intl.intl("Controls the minimum flowrate occupants will observe at doors.<br>Lower values will allow occupants to recognize low-flow doors<br>but may cause excessive queue-switching."));
            GridBagHelper gb = new GridBagHelper(reactivePanel);
            gb.addRow(Intl.intl("Steering update interval:"), this.d_fldSteerUpdate, 0);
            gb.addRow(minFlowLbl, this.d_fldMinFlowrateFactorSteering, 0);
            gb.addRow(this.d_ckCollideSteering, 0);
            gb.addRow(this.d_ckForcedSeparation, 0);
            gb.addRow(this.d_ckLimitFlowrateSteering);
            gb.indent();
            gb.addRow(doorBndLayerSteeringLbl, this.d_fldDoorBndLayerSteering, 0);
            gb.addRow(defMaxFlowrateLbl, this.d_fldSpFlowSteering);
            gb.finalizeRows();
            guiPanel sfpePanel = new guiPanel(new GridBagLayout());
            this.d_fldDMax = new MerlinUDF(1.0, DoubleVR.above(0.0, false), siInvOccDensityu);
            this.d_fldDoorBndLayerSFPE = new MerlinUDF(0.0, DoubleVR.above(0.0, true), siShortLen);
            this.d_rbUseMaxFlow = new guiRadioButton(Intl.intl("Always Use Max Specific Flow"));
            this.d_rbUseMaxFlow.setToolTipText(Intl.intl("Uses Fs=(1-aD)kD with D always set to 1.88 pers/m^2."));
            this.d_rbFlowFromDensity = new guiRadioButton(Intl.intl("Use a Calculated Specific Flow"));
            this.d_rbFlowFromDensity.setToolTipText(Intl.intl("Uses Fs=(1-aD)kD when D is greater than 1.88 pers/m^2."));
            guiLabel dmaxLbl = new guiLabel(Intl.intl("Max Room Density:"));
            dmaxLbl.setToolTipText(Intl.intl("Controls the maximum number of occupants that may occupy a room at a time, ignoring initial loads."));
            new guiButtonGroup(this.d_rbFlowFromDensity, this.d_rbUseMaxFlow);
            guiLabel minVelSFPELbl = new guiLabel(Intl.intl("Minimum Speed Fraction:"));
            minVelSFPELbl.setToolTipText("<html>" + Intl.intl("Sets the minimum speed of occupants as a fraction of their maximum<br>speed for a given egress component."));
            this.d_fldMinVelSFPE = ValueFields.doubleFld(0.15, DoubleVR.between(0.0, 1.0, true, true));
            this.d_rbUseSFPEFundamental = new guiRadioButton(Intl.intl("Use SFPE"));
            this.d_rbUseSFPEFundamental.setToolTipText("<html>" + Intl.intl("Uses the SFPE speed-density relationship."));
            this.d_rbUseProfileFundamental = new guiRadioButton(Intl.intl("Use Value Specified in Occupant Profile"));
            this.d_rbUseProfileFundamental.setToolTipText("<html>" + Intl.intl("Uses the speed-density relationship set in the occupants' profiles."));
            LinkStatus.link((AbstractButton)this.d_rbUseSFPEFundamental, minVelSFPELbl, this.d_fldMinVelSFPE);
            guiUtil.group(new AbstractButton[]{this.d_rbUseSFPEFundamental, this.d_rbUseProfileFundamental});
            TitleSeparator fundamentalLbl = new TitleSeparator(Intl.intl("Speed-Density Profile"));
            fundamentalLbl.setToolTipText(Intl.intl("Controls density/speed relationship"));
            gb = new GridBagHelper(sfpePanel);
            gb.addRow(dmaxLbl, this.d_fldDMax, 0);
            gb.addRow(minVelSFPELbl, this.d_fldMinVelSFPE, 0);
            gb.addFilledRow(new TitleSeparator(Intl.intl("Door Flow Rate")));
            gb.indent();
            gb.addRow(Intl.intl("Boundary Layer:"), this.d_fldDoorBndLayerSFPE, 0);
            gb.addRow(Intl.intl("Flow Rates at High Density:"), 0);
            gb.indent();
            gb.addRow(this.d_rbFlowFromDensity, 0);
            gb.addRow(this.d_rbUseMaxFlow, 0);
            gb.unindent();
            gb.unindent();
            gb.finalizeRows();
            final CardLayout cardLayout = new CardLayout();
            final guiPanel cardPanel = new guiPanel(cardLayout);
            cardPanel.add((Component)reactivePanel, this.OPTS[0]);
            cardPanel.add((Component)sfpePanel, this.OPTS[1]);
            this.setLayout(new GridBagLayout());
            gb = new GridBagHelper(this);
            gb.addBorder();
            gb.addRow(Intl.intl("Behavior Mode:"), this.d_behaviorBox, 0);
            gb.addFilledRow(new guiSeparator());
            gb.addFilledRow(cardPanel);
            gb.finalizeRows();
            this.d_behaviorBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String selItem = (String)d_behaviorBox.getSelectedItem();
                    cardLayout.show(cardPanel, selItem);
                }
            });
            this.d_behaviorBox.setSelectedItem(this.OPTS[0]);
        }

        @Override
        public void load(SimParams sp) {
            if (sp.reactiveSteering) {
                this.d_behaviorBox.setSelectedItem(this.OPTS[0]);
                this.d_ckCollideSteering.setSelected(sp.handleCollisions);
                this.d_ckForcedSeparation.setSelected(sp.forceSeparation);
                this.d_ckLimitFlowrateSteering.setSelected(sp.useDoorQueues);
                this.d_rbFlowFromDensity.setSelected(true);
                this.d_rbUseSFPEFundamental.setSelected(true);
                this.d_fldMinVelSFPE.setValue(0.15);
            } else {
                this.d_behaviorBox.setSelectedItem(this.OPTS[1]);
                this.d_ckCollideSteering.setSelected(true);
                this.d_ckForcedSeparation.setSelected(false);
                this.d_ckLimitFlowrateSteering.setSelected(false);
                this.d_rbFlowFromDensity.setSelected(sp.doorFlowDensityFlag);
                this.d_rbUseMaxFlow.setSelected(!sp.doorFlowDensityFlag);
                this.d_rbUseSFPEFundamental.setSelected(!sp.useProfileFundamental);
                this.d_rbUseProfileFundamental.setSelected(sp.useProfileFundamental);
                this.d_fldMinVelSFPE.setValue(sp.minSFPEVelFrac);
            }
            this.d_fldSpFlowSteering.setValue(sp.specificFlowSteering);
            this.d_fldMinFlowrateFactorSteering.setValue(sp.minFlowrateFactor);
            this.d_fldDoorBndLayerSteering.setValue(sp.doorBoundaryLayer);
            this.d_fldDoorBndLayerSFPE.setValue(sp.doorBoundaryLayer);
            this.d_fldSteerUpdate.setValue(sp.dtSteerUpdate);
            this.d_fldDMax.setValue(sp.densityMax);
        }

        @Override
        public void store(SimParams sp) {
            if (this.d_behaviorBox.getSelectedItem() == this.OPTS[0]) {
                sp.reactiveSteering = true;
                sp.doorFlowDensityFlag = false;
                sp.dtSteerUpdate = (UnitDouble)this.d_fldSteerUpdate.getValue();
                sp.handleCollisions = this.d_ckCollideSteering.isSelected();
                sp.forceSeparation = this.d_ckForcedSeparation.isSelected();
                sp.useDoorQueues = this.d_ckLimitFlowrateSteering.isSelected();
                sp.doorBoundaryLayer = (UnitDouble)this.d_fldDoorBndLayerSteering.getValue();
                sp.specificFlowSteering = (UnitDouble)this.d_fldSpFlowSteering.getValue();
                sp.minFlowrateFactor = (Double)this.d_fldMinFlowrateFactorSteering.getValue();
            } else if (this.d_behaviorBox.getSelectedItem() == this.OPTS[1]) {
                sp.reactiveSteering = false;
                sp.useDoorQueues = true;
                sp.handleCollisions = false;
                sp.densityMax = (UnitDouble)this.d_fldDMax.getValue();
                sp.doorBoundaryLayer = (UnitDouble)this.d_fldDoorBndLayerSFPE.getValue();
                sp.doorFlowDensityFlag = this.d_rbFlowFromDensity.isSelected();
                sp.useProfileFundamental = this.d_rbUseProfileFundamental.isSelected();
                sp.minSFPEVelFrac = (Double)this.d_fldMinVelSFPE.getValue();
            }
        }
    }

    private static class OutputEditor
    extends EditorPanel {
        private guiLabel d_labVisDT = new guiLabel(Intl.intl("3D Output Freq.:"));
        private guiUnitDoubleField d_fldVisDT = new MerlinUDF(1.0, DoubleVR.above(0.0, false), SI.SECOND);
        private guiLabel d_labCSVDT = new guiLabel(Intl.intl("CSV Output Freq.:"));
        private guiUnitDoubleField d_fldCSVDT = new MerlinUDF(1.0, DoubleVR.above(0.0, false), SI.SECOND);
        private guiLabel d_labStatusDT = new guiLabel(Intl.intl("Runtime Output Freq.:"));
        private guiUnitDoubleField d_fldStatusDT = new MerlinUDF(1.0, DoubleVR.above(0.0, false), SI.SECOND);
        private guiUnitDoubleField d_fldSlowSpeed;
        private final guiComboBox<Boolean> d_occCSVOptions;
        private final guiCheckBox d_densityRegionSeekSpeed;
        private final guiCheckBox d_outputOccParamsFile;
        private final guiCheckBox d_socialDistanceEnable;
        private final guiUnitDoubleField d_socialDistanceFld;

        public OutputEditor() {
            guiLabel occCSVLbl = new guiLabel(Intl.intl("Occupant CSV Data:"));
            occCSVLbl.setToolTipText("<html>" + Intl.intl("If \"Print CSV Data\" is turned on per-occupant, this<br>determines how to generate the resulting CSV files."));
            this.d_occCSVOptions = guiUtil.newCombo(Boolean.valueOf(true), Intl.intl("Merge into one file"), false, Intl.intl("Create one file per occupant"));
            this.d_densityRegionSeekSpeed = new guiCheckBox(Intl.intl("Include Seek Speed in Measurement Region Files"));
            this.d_densityRegionSeekSpeed.setToolTipText(Intl.intl("In measurement region CSV files, includes a column that indicates the occupant speed relative to seek direction."));
            guiLabel slowTitle = new guiLabel(Intl.intl("Jam Time Reporting:"));
            guiLabel labSlowSpeed = new guiLabel(Intl.intl("Jam Velocity:"));
            labSlowSpeed.setToolTipText(Intl.intl("Occupants moving this speed or slower are considered jammed."));
            this.d_fldSlowSpeed = new MerlinUDF(1.0, DoubleVR.above(0.0, false), 5);
            this.d_outputOccParamsFile = new guiCheckBox(Intl.intl("Write Occupant Parameter File"));
            this.d_outputOccParamsFile.setToolTipText(Intl.intl("Writes a CSV file containing resolved occupant profile parameters for each occupant."));
            this.d_socialDistanceEnable = new guiCheckBox(Intl.intl("Enable Interpersonal Distance Reporting"));
            guiLabel labSocialDistance = new guiLabel(Intl.intl("Reference Distance:"));
            labSocialDistance.setToolTipText(Intl.intl("Used to measure accumulated contact over time."));
            this.d_socialDistanceFld = new guiUnitDoubleField(new UnitDouble(2.0, SI.METER), UnitDoubleVR.between(0.0, 100.0, SI.METER, false, true));
            LinkStatus.link((AbstractButton)this.d_socialDistanceEnable, labSocialDistance, this.d_socialDistanceFld);
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(this.d_labVisDT, this.d_fldVisDT);
            gb.addRow(this.d_labCSVDT, this.d_fldCSVDT);
            gb.addRow(this.d_labStatusDT, this.d_fldStatusDT);
            gb.addRow(slowTitle, 0, 1.0);
            gb.addIdentRow(labSlowSpeed, this.d_fldSlowSpeed);
            gb.addRow(occCSVLbl, this.d_occCSVOptions);
            gb.addRow(this.d_densityRegionSeekSpeed, 0);
            gb.addRow(this.d_outputOccParamsFile, 0);
            gb.addRow(this.d_socialDistanceEnable, 0);
            gb.addIdentRow(labSocialDistance, this.d_socialDistanceFld);
            gb.finalizeRows();
        }

        @Override
        public void load(SimParams sp) {
            this.d_fldVisDT.setValue(sp.dtVis);
            this.d_fldCSVDT.setValue(sp.dtCSV);
            this.d_fldStatusDT.setValue(sp.dtStatus);
            this.d_fldSlowSpeed.setValue(sp.lowSpeedThreshold);
            this.d_occCSVOptions.setSelectedItem(sp.occCSVFileAsOne);
            this.d_densityRegionSeekSpeed.setSelected(sp.measurementRegionSeekSpeed);
            this.d_outputOccParamsFile.setSelected(sp.writeOccParamsFile);
            this.d_socialDistanceEnable.setSelected(sp.socialDistanceEnable);
            this.d_socialDistanceFld.setValue(sp.socialDistance);
        }

        @Override
        public void store(SimParams sp) {
            sp.dtVis = (UnitDouble)this.d_fldVisDT.getValue();
            sp.dtCSV = (UnitDouble)this.d_fldCSVDT.getValue();
            sp.dtStatus = (UnitDouble)this.d_fldStatusDT.getValue();
            sp.lowSpeedThreshold = (UnitDouble)this.d_fldSlowSpeed.getValue();
            sp.occCSVFileAsOne = this.d_occCSVOptions.getSelectedItem();
            sp.measurementRegionSeekSpeed = this.d_densityRegionSeekSpeed.isSelected();
            sp.writeOccParamsFile = this.d_outputOccParamsFile.isSelected();
            sp.socialDistanceEnable = this.d_socialDistanceEnable.isSelected();
            sp.socialDistance = (UnitDouble)this.d_socialDistanceFld.getValue();
        }
    }

    private static class TimeEditor
    extends EditorPanel {
        private guiCheckBox d_ckMaxTime = new guiCheckBox(Intl.intl("Time Limit:"));
        private guiUnitDoubleField d_fldMaxTime = new MerlinUDF((Unit)SI.SECOND, DoubleVR.above(0.0, false));
        private guiLabel d_labDT;
        private guiUnitDoubleField d_fldDT;

        public TimeEditor() {
            LinkStatus.link((AbstractButton)this.d_ckMaxTime, this.d_fldMaxTime);
            this.d_labDT = new guiLabel(Intl.intl("Time Step Size:"));
            this.d_fldDT = new MerlinUDF(0.025, DoubleVR.above(0.0, false), SI.SECOND);
            this.setLayout(new GridBagLayout());
            int r = 0;
            GridBagUtil.add(this, this.d_ckMaxTime, 0, r, 1, 1, 12, 12, 12, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_fldMaxTime, 1, r, 1, 1, 12, 0, 12, 5, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_labDT, 0, ++r, 1, 1, 0, 12, 12, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_fldDT, 1, r, 1, 1, 0, 0, 12, 5, 0, 0.0, 0.0, 17);
            ++r;
            GridBagUtil.addGlue(this);
        }

        @Override
        public void load(SimParams sp) {
            this.d_fldMaxTime.setValue(sp.runTimeMax);
            this.d_ckMaxTime.setSelected(sp.runTimeMaxFlag);
            this.d_fldDT.setValue(sp.dtSim);
        }

        @Override
        public void store(SimParams sp) {
            sp.runTimeMax = (UnitDouble)this.d_fldMaxTime.getValue();
            sp.runTimeMaxFlag = this.d_ckMaxTime.isSelected();
            sp.dtSim = (UnitDouble)this.d_fldDT.getValue();
        }
    }

    private static abstract class EditorPanel
    extends guiPanel {
        private EditorPanel() {
        }

        public abstract void load(SimParams var1);

        public abstract void store(SimParams var1);
    }
}

