/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Window;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.OccGenerator;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.EgressAgentComp;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.scripting.Behavior;
import merlin.gui.DistributionEditor;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.UrnUtil;

public class EditOccGroupDlg
extends guiDialog {
    private final MerlinData d_data;
    private final DistributionEditor<Behavior> d_behaviorDist;
    private final DistributionEditor<OccProfile> d_profileDist;
    private final guiLabel d_customWarningLbl;
    private Collection<? extends EgressAgentComp> d_groups;
    private Map<EgressAgent, OccProfile> d_savedProfiles = null;

    public EditOccGroupDlg(Window owner, MerlinData md) {
        super(owner, Intl.intl("Edit Group Distributions"), 9);
        this.d_data = md;
        this.d_behaviorDist = new DistributionEditor<Behavior>(md, Intl.intl("Behavior"), md.behaviors, Behavior.class, null);
        this.d_profileDist = new DistributionEditor<OccProfile>(md, Intl.intl("Profile"), md.profiles, OccProfile.class, null);
        this.d_customWarningLbl = new guiLabel("<html>" + Intl.intl("NOTE: Custom occupant parameters will not be affected<br>by changing the profile distribution.") + "</html>");
        this.setResizable(true);
        GridBagHelper gb = new GridBagHelper(this.getDialogPane());
        gb.addRow(Intl.intl("Profile:"), this.d_profileDist, 0, 1.0);
        gb.addRow(Intl.intl("Behavior:"), this.d_behaviorDist, 0, 1.0);
        gb.addFilledRow(this.d_customWarningLbl);
        gb.finalizeRows();
    }

    private static <T> void incCount(Map<T, Integer> map, T key) {
        Integer existingCount = map.get(key);
        if (existingCount == null) {
            map.put(key, 1);
        } else {
            map.put(key, existingCount + 1);
        }
    }

    private static <T> Map<T, Double> convertToDist(Map<T, Integer> countMap, int total) {
        IdentityHashMap<T, Double> dist = new IdentityHashMap<T, Double>();
        for (Map.Entry<T, Integer> entry : countMap.entrySet()) {
            double frac = (double)entry.getValue().intValue() / (double)total;
            dist.put(entry.getKey(), frac);
        }
        return dist;
    }

    public void load(Collection<? extends EgressAgentComp> groups) {
        this.d_groups = groups;
        IdentityHashMap profilesCount = new IdentityHashMap();
        IdentityHashMap behaviorsCount = new IdentityHashMap();
        Collection<EgressAgent> agents = MerlinUtil.flatten(groups, EgressAgent.class);
        int total = agents.size();
        for (EgressAgent agent : agents) {
            OccProfile prof = agent.getProfile().getProfParent();
            Behavior behavior = agent.getBehavior();
            EditOccGroupDlg.incCount(profilesCount, prof);
            EditOccGroupDlg.incCount(behaviorsCount, behavior);
        }
        Map profDist = EditOccGroupDlg.convertToDist(profilesCount, total);
        Map behaviorDist = EditOccGroupDlg.convertToDist(behaviorsCount, total);
        this.d_profileDist.setValue((OccProfile)((Object)UrnUtil.newUrn(profDist)));
        this.d_behaviorDist.setValue((Behavior)((Object)UrnUtil.newUrn(behaviorDist)));
        this.d_profileDist.setModified(false);
        this.d_behaviorDist.setModified(false);
        boolean customParamsSet = false;
        if (this.d_data.profiles.getDeepMembers().size() > 1) {
            for (EgressAgent agent : agents) {
                if (agent.getProfile().getNumLocal() <= 0) continue;
                customParamsSet = true;
                break;
            }
        }
        this.d_customWarningLbl.setVisible(customParamsSet);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (this.d_profileDist.isModified()) {
            Collection<EgressAgent> agents = MerlinUtil.flatten(this.d_groups, EgressAgent.class);
            this.d_savedProfiles = OccGenerator.calcProfileDistribution(this.d_data, agents, (IUrn)this.d_profileDist.getValue(), false);
            if (this.d_savedProfiles == null) {
                if (showWarn) {
                    String msg = Intl.intl("The specified distribution of profiles will cause some occupants\nto be placed in invalid rooms. Would you like to continue?");
                    int choice = JOptionPane.showConfirmDialog(MerlinApp.getApp().getActiveFrame(), msg, Intl.intl("Invalid Profile Distribution"), 0);
                    if (choice != 0) {
                        return false;
                    }
                    this.d_savedProfiles = OccGenerator.calcProfileDistribution(this.d_data, agents, (IUrn)this.d_profileDist.getValue(), true);
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    public void save() {
        Collection<EgressAgent> agents = MerlinUtil.flatten(this.d_groups, EgressAgent.class);
        if (this.d_profileDist.isModified()) {
            assert (this.d_savedProfiles != null);
            Undo.insertUndoEntry_propRestore(this.d_data, agents, OccProfile.PROP_PROF_PARENT);
            for (Map.Entry<EgressAgent, OccProfile> entry : this.d_savedProfiles.entrySet()) {
                entry.getKey().setProfileParent(entry.getValue());
            }
        }
        if (this.d_behaviorDist.isModified()) {
            OccGenerator.distributeBehavior(this.d_data, agents, (IUrn)this.d_behaviorDist.getValue(), true);
        }
    }
}

