/*
 * Decompiled with CFR 0.152.
 */
package merlin.geom;

import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import merlin.data.egress.geom.RoomUtil;
import merlin.geom.Inter2D;
import thunderheadeng.geometry.IParametric2D;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.ShapeUtil;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IPlanarFace;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TriFunction;
import thunderheadeng.util.theUtil;

public class GeomUtil {
    public static double dist(Tuple3d a, Tuple3d b) {
        double dx = b.x - a.x;
        double dy = b.y - a.y;
        double dz = b.z - a.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double dist(Tuple3f a, Tuple3f b) {
        double dx = b.x - a.x;
        double dy = b.y - a.y;
        double dz = b.z - a.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static boolean samePt(Tuple3d pt1, Tuple3d pt2, double tol) {
        return GeomUtil.dist(pt1, pt2) <= tol;
    }

    public static boolean samePt(Tuple3f pt1, Tuple3f pt2, double tol) {
        return GeomUtil.dist(pt1, pt2) <= tol;
    }

    public static Vector2d randomVec(Random rand) {
        double x = 0.0;
        double y = 0.0;
        while (x == 0.0 && y == 0.0) {
            x = rand.nextDouble() - 0.5;
            y = rand.nextDouble() - 0.5;
        }
        return new Vector2d(x, y);
    }

    public static Point2d findPointInPoly(List<? extends IParametric2D> poly, double tol) {
        if (poly.isEmpty()) {
            return null;
        }
        Point2d startPoint = poly.get(0).get(0.5);
        Random rand = new Random(0L);
        for (int m = 0; m < 10; ++m) {
            Vector2d rvec = GeomUtil.randomVec(rand);
            List<double[]> trimmed = Inter2D.trimLineToPoly(poly, startPoint, rvec, tol);
            for (double[] seg : trimmed) {
                if (theUtil.eq(seg[0], seg[1], tol)) continue;
                double midt = (seg[0] + seg[1]) * 0.5;
                return Util2D.linePoint(startPoint, rvec, midt);
            }
        }
        return startPoint;
    }

    public static boolean addToModel(Model model, int groupid, Mesh mesh) {
        boolean result = true;
        switch (mesh.primtype) {
            case 1: {
                int m = 0;
                while (m < mesh.indices.length) {
                    Point3d p1 = mesh.vertices[mesh.indices[m++]];
                    Point3d p2 = mesh.vertices[mesh.indices[m++]];
                    model.addEdge(groupid, new LineSeg3D(p1, p2));
                }
                break;
            }
            case 2: {
                int m = 0;
                while (m < mesh.indices.length) {
                    Point3d p1 = mesh.vertices[mesh.indices[m++]];
                    Point3d p2 = mesh.vertices[mesh.indices[m++]];
                    Point3d p3 = mesh.vertices[mesh.indices[m++]];
                    result &= model.addPolygonFace(groupid, new Plane3d(true, p1, p2, p3), p1, p2, p3);
                }
                break;
            }
            case 3: {
                int m = 0;
                while (m < mesh.indices.length) {
                    Point3d p1 = mesh.vertices[mesh.indices[m++]];
                    Point3d p2 = mesh.vertices[mesh.indices[m++]];
                    Point3d p3 = mesh.vertices[mesh.indices[m++]];
                    Point3d p4 = mesh.vertices[mesh.indices[m++]];
                    result &= model.addPolygonFace(groupid, new Plane3d(true, p1, p2, p3, p4), p1, p2, p3, p4);
                }
                break;
            }
            default: {
                return false;
            }
        }
        return result;
    }

    public static boolean addFaceToModel(Model model, int groupid, Plane3d plane, Collection<? extends IParametric3D> boundary) {
        return model.addFace(groupid, plane, boundary);
    }

    public static boolean addFaceToModel(IFace face, Model model, int groupid, double edgeError, double faceError) {
        return GeomUtil.addFaceToModel(face, true, model, groupid, edgeError, faceError);
    }

    public static boolean addFaceToModel(IFace face, boolean ccw, Model model, int groupid, double edgeError, double faceError) {
        if (face instanceof Triangle) {
            Triangle tri = (Triangle)face;
            Plane3d plane = new Plane3d(ccw, tri.p1, tri.p2, tri.p3);
            if (ccw) {
                return model.addPolygonFace(groupid, plane, tri.p1, tri.p2, tri.p3);
            }
            return model.addPolygonFace(groupid, plane, tri.p3, tri.p2, tri.p1);
        }
        if (face instanceof IPlanarFace) {
            IPolygon poly = ((IPlanarFace)face).toPoly(edgeError);
            Plane3d plane = poly.getPlane(ccw);
            Point3d[][] loops = PolyUtil.getLoops(poly, false);
            ArrayList<LineSeg3D> curves = new ArrayList<LineSeg3D>();
            for (Point3d[] loop : loops) {
                Point3d p22;
                if (loop.length == 0) continue;
                if (ccw) {
                    for (int m = 0; m < loop.length; ++m) {
                        Point3d p12 = loop[m];
                        p22 = loop[(m + 1) % loop.length];
                        if (p12.equals(p22)) continue;
                        curves.add(new LineSeg3D(p12, p22));
                    }
                    continue;
                }
                Point3d p13 = loop[0];
                for (int m = loop.length - 1; m >= 0; --m) {
                    p22 = loop[m];
                    if (!p13.equals(p22)) {
                        curves.add(new LineSeg3D(p13, p22));
                    }
                    p13 = p22;
                }
            }
            return model.addFace(groupid, plane, curves);
        }
        boolean result = true;
        Pair<Mesh, Boolean> triResult = face.triangulate(faceError, ccw);
        Mesh triangles = (Mesh)triResult.v1;
        boolean tccw = (Boolean)triResult.v2;
        TriFunction<Point3d, Point3d, Point3d, Boolean> addTri = tccw ? (p1, p2, p3) -> {
            Plane3d plane = new Plane3d(true, (Point3d)p1, (Point3d)p2, (Point3d)p3);
            return model.addPolygonFace(groupid, plane, (Point3d)p1, (Point3d)p2, (Point3d)p3);
        } : (p3, p2, p1) -> {
            Plane3d plane = new Plane3d(true, (Point3d)p1, (Point3d)p2, (Point3d)p3);
            return model.addPolygonFace(groupid, plane, (Point3d)p1, (Point3d)p2, (Point3d)p3);
        };
        int m = 0;
        while (m < triangles.indices.length) {
            Point3d p14 = triangles.vertices[triangles.indices[m++]];
            Point3d p23 = triangles.vertices[triangles.indices[m++]];
            Point3d p32 = triangles.vertices[triangles.indices[m++]];
            result &= addTri.apply(p14, p23, p32).booleanValue();
        }
        return result;
    }

    public static void addCurveToModel(ICurve curve, Model model, int groupid, double edgeError) {
        if (curve instanceof LineSeg) {
            LineSeg ls = (LineSeg)curve;
            model.addEdge(groupid, new LineSeg3D(ls.p1, ls.p2));
        } else {
            Mesh mesh = curve.getSegments(edgeError);
            int m = 0;
            while (m < mesh.indices.length) {
                Point3d p1 = mesh.vertices[mesh.indices[m++]];
                Point3d p2 = mesh.vertices[mesh.indices[m++]];
                model.addEdge(groupid, new LineSeg3D(p1, p2));
            }
        }
    }

    public static List<IFace> extractFaces(Model model, Integer groupid) {
        ArrayList<IFace> faces = new ArrayList<IFace>();
        for (Face face : model.getFaces()) {
            IFace gface;
            if (groupid != null && !face.partOfGroup(groupid) || (gface = GeomUtil.toGeomFace(face)) == null) continue;
            faces.add(gface);
        }
        return faces;
    }

    public static IFace toGeomFace(Face face) {
        ArrayList<Point3d[]> loops = new ArrayList<Point3d[]>(face.edgeLoops.size());
        for (FaceLoop loop : face.edgeLoops) {
            if (loop.edges.size() < 3) continue;
            Point3d[] points = new Point3d[loop.edges.size()];
            for (int m = 0; m < loop.edges.size(); ++m) {
                EdgeUse eu = loop.edges.get(m);
                points[m] = eu.v1().loc;
            }
            loops.add(points);
        }
        if (loops.isEmpty()) {
            return null;
        }
        return PolyUtil.newPoly((Point3d[][])loops.toArray((T[])new Point3d[loops.size()][]));
    }

    public static ICurve toGeomCurve(EdgeUse eu) {
        return GeomUtil.toGeomCurve(eu.curve());
    }

    public static ICurve toGeomCurve(IParametric3D curve) {
        if (curve.isLinear()) {
            return new LineSeg(curve.get(0.0), curve.get(1.0));
        }
        assert (false);
        return null;
    }

    public static Model transform(Model model, ITransform xform, Matrix4d matrix) {
        Model mclone = (Model)model.clone();
        mclone.transform(xform, matrix);
        RoomUtil.ensureProperFaceOrient(mclone);
        return mclone;
    }

    public static List<? extends IPolygon> toPolys(IFace face, double error) {
        if (face instanceof IPolygon) {
            return Arrays.asList((IPolygon)face);
        }
        return thunderheadeng.geometry.objs.GeomUtil.convertToTriangles(error, face);
    }

    public static Area toArea(Face face) {
        return GeomUtil.toArea(face, face.plane);
    }

    public static Area toArea(Face face, Plane3d projPlane) {
        Matrix4d wlXform = Util.getWorldToLocalXform(projPlane);
        Path2D.Double path = new Path2D.Double(0);
        for (FaceLoop loop : face.edgeLoops) {
            ArrayList<IParametric2D> subPath = new ArrayList<IParametric2D>();
            for (EdgeUse eu : loop.edges) {
                subPath.add(eu.curve().projectToPlane(projPlane, wlXform));
            }
            ShapeUtil.appendAsSubPath(path, subPath);
        }
        return new Area(path);
    }

    public static Vector3d to3d(Vector2d v, boolean normalize) {
        double lsq;
        Vector3d result = new Vector3d(v.x, v.y, 0.0);
        if (normalize && (lsq = result.lengthSquared()) > 0.0) {
            result.scale(1.0 / Math.sqrt(lsq));
        }
        return result;
    }

    public static Vector2d to2d(Vector3d v, boolean normalize) {
        double lsq;
        Vector2d result = new Vector2d(v.x, v.y);
        if (normalize && (lsq = result.lengthSquared()) > 0.0) {
            result.scale(1.0 / Math.sqrt(lsq));
        }
        return result;
    }
}

