/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.value;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import merlin.data.value.IFunction1d;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;

public class PiecewiseFunction1d
implements IFunction1d,
Serializable {
    static final long serialVersionUID = 1L;
    public final Entry[] entries;

    public PiecewiseFunction1d(Entry ... entries) {
        this.entries = entries;
    }

    public static PiecewiseFunction1d newFunction(Unit xType, Unit yType, double ... entries) {
        assert (entries.length % 2 == 0);
        Entry[] oentries = new Entry[entries.length / 2];
        int m = 0;
        while (m < entries.length) {
            int ix = m / 2;
            double x = entries[m++];
            double y = entries[m++];
            oentries[ix] = new Entry(new UnitDouble(x, xType), new UnitDouble(y, yType));
        }
        return new PiecewiseFunction1d(oentries);
    }

    public static PiecewiseFunction1d newFunction(Unit xType, Unit yType, List<Double> entries) {
        assert (entries.size() % 2 == 0);
        Entry[] oentries = new Entry[entries.size() / 2];
        int m = 0;
        while (m < entries.size()) {
            int ix = m / 2;
            double x = entries.get(m++);
            double y = entries.get(m++);
            oentries[ix] = new Entry(new UnitDouble(x, xType), new UnitDouble(y, yType));
        }
        return new PiecewiseFunction1d(oentries);
    }

    public static PiecewiseFunction1d newFunction(UnitDouble ... entries) {
        assert (entries.length % 2 == 0);
        Entry[] oentries = new Entry[entries.length / 2];
        int m = 0;
        while (m < entries.length) {
            int ix = m / 2;
            UnitDouble x = entries[m++];
            UnitDouble y = entries[m++];
            oentries[ix] = new Entry(x, y);
        }
        return new PiecewiseFunction1d(oentries);
    }

    @Override
    public PiecewiseFunction1d toPiecewise(Unit unit) {
        return this;
    }

    public int hashCode() {
        return 0x923498F ^ Arrays.hashCode(this.entries);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof PiecewiseFunction1d && Arrays.equals(((PiecewiseFunction1d)obj).entries, this.entries);
    }

    public static class Entry
    implements Serializable,
    Comparable<Entry> {
        static final long serialVersionUID = 1L;
        public final UnitDouble x;
        public final UnitDouble y;

        public Entry(UnitDouble x, UnitDouble y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Entry && ((Entry)obj).x.equals(this.x) && ((Entry)obj).y.equals(this.y);
        }

        public int hashCode() {
            return 0x73F213A8 ^ Objects.hash(this.x, this.y);
        }

        @Override
        public int compareTo(Entry o) {
            return this.x.compareTo(o.x);
        }
    }
}

