/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Set;
import merlin.Intl;
import merlin.data.AMerlinObj;
import merlin.data.ICompElement;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.scripting.IBehaviorAction;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Sets;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.IDistributedVal;

public class Wait
extends AMerlinObj
implements IBehaviorAction {
    static final long serialVersionUID = -7002352485265400649L;
    public static final Object TIME = "Wait.TIME";
    public static final Set<Object> PROP_TYPES = Sets.fromArrayLHS(NamedMerlinObj.NAME, TIME);
    private Object d_time;

    public Wait(IDistributedVal<UnitDouble> time) {
        this.d_time = time;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_time instanceof UnitDouble) {
            UnitDouble ud = (UnitDouble)this.d_time;
            this.d_time = new ConstantCurve(ud);
        }
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof Wait)) {
            return;
        }
        Wait wait = (Wait)obj;
        this.pauseUpdates();
        this.setWaitTime(wait.getWaitTime());
        this.resumeUpdates();
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public String getName() {
        String time = this.getWaitTime().toString();
        return String.format(Intl.intl("Wait (%s)"), time);
    }

    @Override
    public void setName(String name) {
    }

    public IDistributedVal<UnitDouble> getWaitTime() {
        return (IDistributedVal)this.d_time;
    }

    public void setWaitTime(IDistributedVal<UnitDouble> time) {
        if (!this.d_time.equals(time)) {
            this.d_time = time;
            this.changedEvt(TIME);
        }
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public Object getProperty(Object property) {
        if (property == TIME) {
            return this.getWaitTime();
        }
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        return ICompElement.NOT_SUPPORTED;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == TIME) {
            this.setWaitTime((IDistributedVal)value);
        } else if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        }
    }
}

