/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.SimError;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.IDestination;
import merlin.data.egress.scripting.IDestinationAction;
import merlin.data.egress.scripting.IUnreachable;
import merlin.geom.Geometry;
import merlin.geom.PointGeomFinder;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.LineSegRTreeTest;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.ShapeUtil;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.ShapeGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Sets;

public class GotoWaypoint
extends NamedMerlinObj
implements IBehaviorAction,
IEgressObj,
IDestinationAction {
    static final long serialVersionUID = 1L;
    public static final Object PROP_LOC = "WaypointGoal.LOC";
    public static final Object PROP_ARRIVE_RADIUS = "WaypointGoal.ARRIVE_RADIUS";
    public static final Set<Object> PROP_TYPES = Sets.fromArrayLHS(MerlinData.VISIBILITY, NamedMerlinObj.NAME, PROP_LOC, PROP_ARRIVE_RADIUS);
    private boolean d_visible = true;
    private Point3d d_location;
    private UnitDouble d_arriveRadius;
    private transient IEgressOccupiable d_room;
    private Vector3d d_normal;
    private static final Color BASE_COLOR = Color.RED;

    public GotoWaypoint(String name, Point3d loc, IEgressOccupiable room, Vector3d roomNormal, UnitDouble arriveRad) {
        super(name);
        this.d_location = loc;
        this.d_room = room;
        this.d_normal = roomNormal;
        this.d_arriveRadius = arriveRad;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public String getSetName() {
        return super.getName();
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name == null) {
            name = String.format(Intl.intl("Goto %s"), GotoWaypoint.format(this.d_location));
        }
        return name;
    }

    private static String format(Point3d p) {
        Unit su = Geometry.LENGTH_UNIT;
        Unit du = MerlinApp.getApp().getUnitSystem().getLength();
        return String.format("(%.1f, %.1f, %.1f) %s", UnitDouble.convert(p.x, su, du), UnitDouble.convert(p.y, su, du), UnitDouble.convert(p.z, su, du), du.toString());
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible != visible) {
            this.d_visible = visible;
            this.changedEvt(MerlinData.VISIBILITY);
        }
    }

    @Override
    public Point3d astarGetTestPoint() {
        return this.d_location;
    }

    @Override
    public Point3d astarProject(IEgressObj obj, Point3d p) {
        return this.d_location;
    }

    @Override
    public Point3d astarGetSharedPt(IEgressObj adj) {
        return this.d_location;
    }

    public boolean accept(MerlinData md, Composite<?> group) {
        return group instanceof Behavior;
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.d_room);
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.d_room = (IEgressOccupiable)ois.readObject();
    }

    @Override
    public void connectTo(IEgressObj conn) {
        if (conn instanceof IEgressOccupiable) {
            // empty if block
        }
    }

    @Override
    public void disconnectFrom(IEgressObj conn) {
        if (conn == this.d_room) {
            this.d_room = null;
            this.d_normal = GeomConstants.VEC3D_ZPOS;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public Class<? extends IEgressObj>[] getTopoTypes() {
        return new Class[]{IEgressOccupiable.class};
    }

    @Override
    public Collection<? extends IEgressObj> getConnections() {
        return this.d_room == null ? Collections.EMPTY_LIST : Arrays.asList(this.d_room);
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        return this.d_room == null;
    }

    @Override
    public boolean updateTopo() {
        FindResult room = GotoWaypoint.findRoom((MerlinData)this.getDomain(), new Point3d(this.d_location.x, this.d_location.y, this.d_location.z + 1.0E-6), new Point3d(this.d_location.x, this.d_location.y, this.d_location.z - 1.0E-6), 1);
        if (room != null) {
            this.d_room = room.room;
            this.d_normal = room.faceNormal;
            this.d_location = room.p;
            this.changedEvt(new Object[0]);
        }
        return true;
    }

    @Override
    public IDestination getDestination() {
        return new Destination();
    }

    public static FindResult findRoom(MerlinData md, Point3d loc, int options) {
        FindResult closestResult = null;
        double closestDistSq = Double.MAX_VALUE;
        PointGeomFinder<IEgressOccupiable> test = new PointGeomFinder<IEgressOccupiable>(loc, 1.0E-6, IEgressOccupiable.class);
        md.geomLocation.getLocator().find(test.test, test.result, options);
        for (Map.Entry<IEgressOccupiable, IsectInfo> entry : test.getResults().entrySet()) {
            IGeom geom = entry.getKey().getGeom().flatten().getLocalGeom();
            for (IFace face : GeomUtil.explode(geom, IFace.class)) {
                for (IPolygon iPolygon : GotoWaypoint.getPolys(face, 0.0)) {
                    Point3d nearp = iPolygon.project(loc);
                    double distsq = nearp.distanceSquared(loc);
                    if (!(distsq < closestDistSq) || !iPolygon.classify((Point3d)nearp, (double)1.0E-6).positive) continue;
                    closestDistSq = distsq;
                    closestResult = new FindResult(entry.getKey(), iPolygon.getNormal(true), nearp);
                }
            }
        }
        return closestResult;
    }

    public static FindResult findRoom(MerlinData md, Point3d rayBegin, Point3d rayEnd, int options) {
        FindResult closestResult = null;
        double closestDistSq = Double.MAX_VALUE;
        LineSegRTreeTest test = new LineSegRTreeTest(rayBegin, rayEnd);
        CollResult result = new CollResult(IEgressOccupiable.class);
        md.geomLocation.getLocator().find(test, result, options);
        for (IEgressOccupiable room : result.coll) {
            IGeom geom = room.getGeom().flatten().getLocalGeom();
            for (IFace face : GeomUtil.explode(geom, IFace.class)) {
                for (IPolygon iPolygon : GotoWaypoint.getPolys(face, 0.0)) {
                    double distsq;
                    Point3d isect = GotoWaypoint.getIsect(iPolygon, rayBegin, rayEnd);
                    if (isect == null || !((distsq = isect.distanceSquared(rayBegin)) < closestDistSq)) continue;
                    closestDistSq = distsq;
                    closestResult = new FindResult(room, iPolygon.getNormal(true), isect);
                }
            }
        }
        return closestResult;
    }

    private static Collection<? extends IPolygon> getPolys(IFace face, double faceError) {
        if (face instanceof IPolygon) {
            return Arrays.asList((IPolygon)face);
        }
        return GeomUtil.getTriangles(faceError, face);
    }

    private static Point3d getIsect(IPolygon poly, Point3d p1, Point3d p2) {
        Plane3d plane = poly.getPlane(true);
        Point3d isect = Inter3D.lineSegPlaneIntersection(p1, p2, plane, 1.0E-6);
        if (isect == null) {
            return null;
        }
        return poly.classify((Point3d)isect, (double)1.0E-6).positive ? isect : null;
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof GotoWaypoint)) {
            return;
        }
        GotoWaypoint wg = (GotoWaypoint)obj;
        this.pauseUpdates();
        super.setName(wg.getName());
        this.d_arriveRadius = wg.d_arriveRadius;
        this.d_location = wg.d_location;
        this.d_room = wg.d_room;
        this.d_normal = wg.d_normal;
        this.d_visible = wg.d_visible;
        this.changedEvt(MerlinData.TOPOLOGY);
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public Object getProperty(Object property) {
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (property == MerlinData.VISIBILITY) {
            return this.isVisible();
        }
        if (property == PROP_LOC) {
            return this.getLocation();
        }
        if (property == PROP_ARRIVE_RADIUS) {
            return this.getArriveRadius();
        }
        return ICompElement.NOT_SUPPORTED;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        }
        if (property == MerlinData.VISIBILITY) {
            this.setVisible((Boolean)value);
        }
        if (property == PROP_LOC) {
            this.setLocation((Point3d)value);
        }
        if (property == PROP_ARRIVE_RADIUS) {
            this.setArriveRadius((UnitDouble)value);
        }
    }

    public Point3d getLocation() {
        return this.d_location;
    }

    public void setLocation(Point3d loc) {
        if (!this.d_location.equals(loc)) {
            this.pauseUpdates();
            this.d_location = loc;
            this.changedEvt(MerlinData.TOPOLOGY);
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
    }

    protected void setLocation(IEgressOccupiable room, Vector3d roomNorm, Point3d loc) {
        this.d_location = loc;
        this.d_normal = roomNorm;
        if (room != this.d_room) {
            if (this.getDomain() != null) {
                if (this.d_room != null) {
                    this.d_room.disconnectFrom(this);
                    this.disconnectFrom(this.d_room);
                }
                if (room != null) {
                    room.connectTo(this);
                }
            }
            this.d_room = room;
        }
        this.changedEvt(new Object[0]);
    }

    public IEgressOccupiable getRoom() {
        return this.d_room;
    }

    public Vector3d getRoomNorm() {
        return this.d_normal;
    }

    public UnitDouble getArriveRadius() {
        return this.d_arriveRadius;
    }

    public void setArriveRadius(UnitDouble arriveRad) {
        if (!this.d_arriveRadius.equals(arriveRad)) {
            this.d_arriveRadius = arriveRad;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getWaypointGeom());
    }

    public IGeom getWaypointGeom() {
        return new WaypointGeometry(this.d_room, this.d_normal, this.d_location, this.d_arriveRadius.getValue(Geometry.LENGTH_UNIT));
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof WaypointGeometry) {
            WaypointGeometry wgeom = (WaypointGeometry)geom;
            this.pauseUpdates();
            this.setArriveRadius(new UnitDouble(wgeom.arriveRadius, Geometry.LENGTH_UNIT));
            this.setLocation(wgeom.room, wgeom.normal, wgeom.location);
            this.resumeUpdates();
        } else if (geom instanceof Point) {
            Point p = (Point)geom;
            this.setLocation(p.loc);
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        IGeomNode geom = this.getGeom();
        PropsBuilder gprops = new PropsBuilder();
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Face(BASE_COLOR, null, 0));
        gprops.add(new IPrimProps.Vertex(Color.BLACK, 8.0));
        return new DisplayGeom(geom, gprops);
    }

    public class Destination
    implements IDestination {
        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof Destination && ((Destination)obj).getWaypoint().d_location.equals(GotoWaypoint.this.d_location) && ((Destination)obj).getWaypoint().d_arriveRadius.equals(GotoWaypoint.this.d_arriveRadius) && ((Destination)obj).getWaypoint().d_normal.equals(GotoWaypoint.this.d_normal) && Objects.equals(((Destination)obj).getWaypoint().d_room, GotoWaypoint.this.d_room);
        }

        @Override
        public int hashCode() {
            return 0xFA9832F ^ GotoWaypoint.this.d_location.hashCode() + GotoWaypoint.this.d_arriveRadius.hashCode() + GotoWaypoint.this.d_normal.hashCode() + Objects.hashCode(GotoWaypoint.this.d_room);
        }

        protected GotoWaypoint getWaypoint() {
            return GotoWaypoint.this;
        }

        @Override
        public IUnreachable getUnreachable(IEgressComp source) {
            if (MerlinUtil.isConnected((IEgressObj)source, GotoWaypoint.this)) {
                return null;
            }
            return new IUnreachable(){

                @Override
                public SimError getError(IMerlinObj source) {
                    String name = MerlinUtil.getName(source);
                    return new SimError(SimError.Level.CRITICAL, String.format(Intl.intl("\"%s\" cannot reach the next waypoint."), name), String.format(Intl.intl("Move \"%s,\" move the next waypoint, or connect their rooms."), name), source, GotoWaypoint.this);
                }
            };
        }

        @Override
        public Collection<? extends IEgressComp> getExitComponents() {
            return GotoWaypoint.this.d_room == null ? Collections.EMPTY_LIST : Arrays.asList(GotoWaypoint.this.d_room);
        }
    }

    protected static class WaypointGeometry
    extends GeomGroup {
        public final IEgressOccupiable room;
        public final Vector3d normal;
        public final Point3d location;
        public final double arriveRadius;

        public WaypointGeometry(IEgressOccupiable room, Vector3d normal, Point3d location, double arriveRadius) {
            super(WaypointGeometry.generateGeoms(location, arriveRadius, normal));
            this.room = room;
            this.location = location;
            this.normal = normal;
            this.arriveRadius = arriveRadius;
        }

        private static List<IGeom> generateGeoms(Point3d location, double arriveRadius, Vector3d normal) {
            ShapeGeom cgeom = WaypointGeometry.generateCircle(location, arriveRadius, normal);
            Area area = new Area(cgeom.shape);
            ShapeGeom ageom = new ShapeGeom((Shape)area, cgeom.lwXform);
            Point pgeom = new Point(location);
            return Arrays.asList(cgeom, ageom, pgeom);
        }

        private static ShapeGeom generateCircle(Point3d location, double arriveRadius, Vector3d normal) {
            Plane3d plane = new Plane3d(normal, new Point3d(0.0, 0.0, 0.0));
            Ellipse2D.Double circle = ShapeUtil.newCircle(arriveRadius);
            Matrix4d xform = Util.translateMat(location.x, location.y, location.z);
            xform.mul(Util.getLocalToWorldXform(plane));
            return new ShapeGeom((Shape)circle, xform);
        }

        @Override
        public IGeom transform(TransformInfo ti, int options) {
            if (ti.isIdentity()) {
                return this;
            }
            Matrix4d xform = ti.getMatrix();
            Vector3d scaleVec = Util3D.xform(xform, new Vector3d(this.arriveRadius, 0.0, 0.0));
            double newRadius = scaleVec.length();
            Point3d newLoc = Util3D.xform(xform, this.location);
            FindResult result = GotoWaypoint.findRoom(MerlinApp.getApp().getData(), newLoc, 1);
            if (result == null) {
                return new WaypointGeometry(null, GeomConstants.VEC3D_ZPOS, newLoc, newRadius);
            }
            return new WaypointGeometry(result.room, result.faceNormal, newLoc, newRadius);
        }

        @Override
        public Collection<? extends IHandle> generateManipHandles() {
            return Arrays.asList(new RadiusHandle(this), new LocationHandle(this));
        }

        private static class LocationHandle
        implements IHandle {
            private WaypointGeometry d_geom;

            public LocationHandle(WaypointGeometry geom) {
                this.d_geom = geom;
            }

            public boolean equals(Object obj) {
                return obj == this || obj instanceof LocationHandle;
            }

            @Override
            public IGeomNode getGeom() {
                return GeomNodeUtil.newNode(new Point(this.d_geom.location));
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, new DefaultFilter(IEgressOccupiable.class, GeomType.FACE));
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                return null;
            }

            @Override
            public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WaypointGeometry modify(Point3d newLoc) throws ManipException {
                MerlinData md = MerlinApp.getApp().getData();
                md.beginRead();
                try {
                    FindResult result = GotoWaypoint.findRoom(MerlinApp.getApp().getData(), newLoc, 0);
                    if (result == null) {
                        throw new ManipException();
                    }
                    WaypointGeometry waypointGeometry = this.d_geom = new WaypointGeometry(result.room, result.faceNormal, result.p, this.d_geom.arriveRadius);
                    return waypointGeometry;
                }
                finally {
                    md.endRead();
                }
            }

            @Override
            public WaypointGeometry end() {
                return this.d_geom;
            }
        }

        private static class RadiusHandle
        implements IHandle {
            private WaypointGeometry d_geom;

            public RadiusHandle(WaypointGeometry geom) {
                this.d_geom = geom;
            }

            public boolean equals(Object obj) {
                return obj == this || obj instanceof RadiusHandle;
            }

            @Override
            public IGeomNode getGeom() {
                return GeomNodeUtil.newNode(WaypointGeometry.generateCircle(this.d_geom.location, this.d_geom.arriveRadius, this.d_geom.normal));
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return null;
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                return new PlanarConstraint(new Plane3d(this.d_geom.normal, this.d_geom.location));
            }

            @Override
            public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            }

            @Override
            public WaypointGeometry modify(Point3d newLoc) throws ManipException {
                double newRadius = newLoc.distance(this.d_geom.location);
                this.d_geom = new WaypointGeometry(this.d_geom.room, this.d_geom.normal, this.d_geom.location, newRadius);
                return this.d_geom;
            }

            @Override
            public WaypointGeometry end() {
                return this.d_geom;
            }
        }
    }

    public static class FindResult {
        public final IEgressOccupiable room;
        public final Vector3d faceNormal;
        public final Point3d p;

        public FindResult(IEgressOccupiable room, Vector3d faceNormal, Point3d p) {
            this.room = room;
            this.faceNormal = faceNormal;
            this.p = p;
        }
    }
}

