/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import merlin.Intl;
import merlin.data.ICompElement;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.IBehaviorAction;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.Sets;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.UrnUtil;

public class ChangeBehavior
extends NamedMerlinObj
implements IBehaviorAction {
    private static final long serialVersionUID = 1L;
    public static final IPropertySet.Prop<IUrn<Behavior>> PROP_BEHAVIOR_DIST = new IPropertySet.Prop<Object>("ChangeBehavior.BEHAVIOR_DIST", null);
    public static final Set<Object> PROP_TYPES = Sets.fromArrayLHS(NamedMerlinObj.NAME, PROP_BEHAVIOR_DIST);
    public static final List<IPropertySet.Prop<?>> ALL_PROPS = IPropertySet.getAllDeclaredPublicStaticProps(ChangeBehavior.class);
    private PropertySet d_props = new PropertySet();

    public ChangeBehavior(IUrn<Behavior> behaviorDistribution) {
        this.setProperty(PROP_BEHAVIOR_DIST, behaviorDistribution);
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property instanceof IPropertySet.Prop) {
            this.set((IPropertySet.Prop)property, value);
        } else if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        }
    }

    public <T> void set(IPropertySet.Prop<T> prop, T value) {
        if (!Objects.equals(value, this.d_props.get(prop))) {
            this.d_props.setIfNotDefault(prop, value);
            this.changedEvt(prop);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property instanceof IPropertySet.Prop) {
            return this.get((IPropertySet.Prop)property);
        }
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        return ICompElement.NOT_SUPPORTED;
    }

    public <T> T get(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof ChangeBehavior)) {
            return;
        }
        ChangeBehavior changeBehavior = (ChangeBehavior)obj;
        this.pauseUpdates();
        for (IPropertySet.Prop<?> prop : ALL_PROPS) {
            this.d_props.setIfNotDefault(prop, changeBehavior.d_props.get(prop));
        }
        this.resumeUpdates();
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public Object clone() {
        IUrn<Behavior> behaviors = this.get(PROP_BEHAVIOR_DIST);
        IUrn<Behavior> newBehaviors = null;
        if (behaviors != null) {
            newBehaviors = UrnUtil.newUrn(behaviors.getWeights());
        }
        return new ChangeBehavior(newBehaviors);
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public String getName() {
        Set<Behavior> targetBehaviors = this.getAllTargetBehaviors();
        if (targetBehaviors.size() == 1) {
            return String.format(Intl.intl("Change Behavior <%s>"), targetBehaviors.iterator().next().getName());
        }
        return Intl.intl("Change Behavior");
    }

    @Override
    public void setName(String name) {
    }

    public boolean isAnyTargetBehaviorTerminal() {
        for (Behavior b : this.getAllTargetBehaviors()) {
            if (b.isTerminal()) {
                return true;
            }
            for (ChangeBehavior change : b.flatten(ChangeBehavior.class)) {
                if (!change.isAnyTargetBehaviorTerminal()) continue;
                return true;
            }
        }
        return false;
    }

    public Set<Behavior> getAllTargetBehaviors() {
        IUrn<Behavior> behaviorUrn = this.get(PROP_BEHAVIOR_DIST);
        return behaviorUrn != null ? Collections.unmodifiableSet(behaviorUrn.getWeights().keySet()) : Collections.emptySet();
    }
}

