/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.geom;

import java.io.Serializable;
import java.util.function.Function;
import javax.vecmath.Vector2d;
import merlin.data.egress.geom.EgressDoorDir;
import merlin.data.value.ConstVariant;
import merlin.data.value.DiscreteVariant;
import merlin.data.value.IVariant;
import merlin.data.value.VariantUtil;

public class EgressConnectorState
implements Serializable {
    static final long serialVersionUID = 1L;
    public static EgressConnectorState CONNECTOR_OPEN = new EgressConnectorState(true, false, null);
    public static EgressConnectorState CONNECTOR_CLOSED = new EgressConnectorState(false, true, null);
    public final boolean open;
    public final boolean closed;
    public final Vector2d openDir;

    public EgressConnectorState(boolean open, boolean closed, Vector2d openDir) {
        this.open = open;
        this.closed = closed;
        this.openDir = openDir;
        assert (openDir == null ? open ^ closed : !open && !closed);
    }

    public EgressDoorDir toDoorDir() {
        if (this.open) {
            return EgressDoorDir.ALL;
        }
        if (this.closed) {
            return EgressDoorDir.NONE;
        }
        assert (this.openDir != null);
        return EgressDoorDir.toDir(this.openDir);
    }

    public static IVariant<EgressDoorDir> getDoorDirStateVariant(IVariant<EgressConnectorState> state) {
        if (state instanceof ConstVariant) {
            return new ConstVariant<EgressDoorDir>(((EgressConnectorState)((ConstVariant)state).value).toDoorDir());
        }
        if (state instanceof DiscreteVariant) {
            DiscreteVariant discreteVarState = (DiscreteVariant)state;
            EgressDoorDir initVal = ((EgressConnectorState)discreteVarState.initVal).toDoorDir();
            DiscreteVariant.Entry[] entries = new DiscreteVariant.Entry[discreteVarState.entries.length];
            for (int i = 0; i < discreteVarState.entries.length; ++i) {
                entries[i] = new DiscreteVariant.Entry<EgressDoorDir>(discreteVarState.entries[i].t, ((EgressConnectorState)discreteVarState.entries[i].val).toDoorDir());
            }
            return VariantUtil.newVariant(initVal, entries);
        }
        assert (false);
        return null;
    }

    public static IVariant<EgressConnectorState> getConnectorStateVariant(IVariant<EgressDoorDir> state, Function<EgressDoorDir, Vector2d> adjustForDoor) {
        Function<EgressDoorDir, EgressConnectorState> processDoorDir = doorDir -> {
            switch (doorDir) {
                case ALL: {
                    return CONNECTOR_OPEN;
                }
                case NONE: {
                    return CONNECTOR_CLOSED;
                }
            }
            return new EgressConnectorState(false, false, (Vector2d)adjustForDoor.apply((EgressDoorDir)((Object)doorDir)));
        };
        if (state instanceof ConstVariant) {
            return new ConstVariant<EgressConnectorState>(processDoorDir.apply((EgressDoorDir)((Object)((ConstVariant)state).value)));
        }
        if (state instanceof DiscreteVariant) {
            DiscreteVariant discreteVarState = (DiscreteVariant)state;
            EgressConnectorState initVal = processDoorDir.apply((EgressDoorDir)((Object)discreteVarState.initVal));
            DiscreteVariant.Entry[] entries = new DiscreteVariant.Entry[discreteVarState.entries.length];
            for (int i = 0; i < discreteVarState.entries.length; ++i) {
                entries[i] = new DiscreteVariant.Entry<EgressConnectorState>(discreteVarState.entries[i].t, processDoorDir.apply((EgressDoorDir)((Object)discreteVarState.entries[i].val)));
            }
            return VariantUtil.newVariant(initVal, entries);
        }
        assert (false);
        return null;
    }
}

