/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.agents;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.vecmath.Point3d;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;

public class OccLocation
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    public final IEgressOccupiable room;
    public final boolean overlapsWalls;
    public final boolean failsFilter;
    public final Point3d point;
    private transient Set<EgressAgent> d_overlappingOccs;

    public OccLocation(Point3d point) {
        this(null, Collections.EMPTY_LIST, false, false, point);
    }

    public OccLocation(IEgressOccupiable room, Collection<EgressAgent> overlappingOccs, boolean overlapsWalls, boolean failsFilter, Point3d point) {
        this.room = room;
        this.point = point;
        this.overlapsWalls = overlapsWalls;
        this.failsFilter = failsFilter;
        this.d_overlappingOccs = overlappingOccs.isEmpty() ? Collections.EMPTY_SET : new LinkedIdentityHashSet<EgressAgent>(overlappingOccs);
    }

    public Object clone() {
        try {
            OccLocation clone = (OccLocation)super.clone();
            clone.d_overlappingOccs = new LinkedIdentityHashSet<EgressAgent>((Collection<EgressAgent>)this.d_overlappingOccs);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    public int hashCode() {
        return this.point.hashCode() + this.d_overlappingOccs.hashCode() + theUtil.hashCode(this.overlapsWalls) + theUtil.hashCode(this.failsFilter) + this.room.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OccLocation)) {
            return false;
        }
        OccLocation loc = (OccLocation)obj;
        return theUtil.equal(loc.room, this.room) && loc.point.equals(this.point) && loc.overlapsWalls == this.overlapsWalls && loc.failsFilter == this.failsFilter && loc.d_overlappingOccs.equals(this.d_overlappingOccs);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_overlappingOccs == null) {
            this.d_overlappingOccs = Collections.EMPTY_SET;
        }
    }

    public void writeTopology(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.d_overlappingOccs);
    }

    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0121)) {
            return;
        }
        this.d_overlappingOccs = (Set)ois.readObject();
    }

    public boolean isOverlappingAgents() {
        return !this.d_overlappingOccs.isEmpty();
    }

    public Set<EgressAgent> getOverlappingAgents() {
        return this.d_overlappingOccs;
    }

    public boolean add(EgressAgent agent) {
        if (this.d_overlappingOccs.isEmpty()) {
            this.d_overlappingOccs = new LinkedIdentityHashSet<EgressAgent>();
        }
        return this.d_overlappingOccs.add(agent);
    }

    public boolean remove(EgressAgent agent) {
        if (this.d_overlappingOccs.remove(agent)) {
            if (this.d_overlappingOccs.isEmpty()) {
                this.d_overlappingOccs = Collections.EMPTY_SET;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.point.toString();
    }
}

