/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import merlin.data.IMerlinObj;
import merlin.data.INamed;
import thunderheadeng.util.Warning;

public class SimError
extends Warning {
    public static final int WARNINGINFO_OBJS = 2;
    public final Level level;
    public final String cause;
    public final String fix;
    public final Collection<? extends IMerlinObj> causeObjs;

    public SimError(Level level, String cause, String fix, IMerlinObj ... causeObjs) {
        this(level, cause, fix, Arrays.asList(causeObjs));
    }

    public SimError(Level level, String cause, String fix, Collection<? extends IMerlinObj> causeObjs) {
        super(cause, fix);
        this.level = level;
        this.cause = cause;
        this.fix = fix;
        this.causeObjs = causeObjs;
    }

    @Override
    public Comparable<?> getWarningInfo(int type) {
        if (type == 2) {
            List names = this.causeObjs.stream().map(o -> o instanceof INamed ? ((INamed)((Object)o)).getName() : "").collect(Collectors.toList());
            return String.join((CharSequence)"; ", names);
        }
        return super.getWarningInfo(type);
    }

    public static enum Level implements Comparable<Level>
    {
        MODERATE(5),
        CRITICAL(10);

        public final int severity;

        private Level(int severity) {
            this.severity = severity;
        }
    }
}

