/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import merlin.util.Hierarchy;
import thunderheadeng.util.LinkedIdentityHashSet;

public class MerlinHierarchy
implements Serializable {
    public static final long serialVersionUID = 1L;
    private final Map<Object, Object> d_childParentMap = new IdentityHashMap<Object, Object>();
    private final Map<Object, Set<Object>> d_parentChildMap = new IdentityHashMap<Object, Set<Object>>();

    public boolean addToHierarchy(Object parent, Object child) {
        Set<Object> children;
        Object replaced = this.d_childParentMap.put(child, parent);
        if (replaced == parent) {
            return true;
        }
        if (replaced != null) {
            this.removeFromHierarchy(child);
        }
        if ((children = this.d_parentChildMap.get(parent)) == null) {
            children = new LinkedIdentityHashSet<Object>();
            this.d_parentChildMap.put(parent, children);
        }
        children.add(child);
        return true;
    }

    public boolean addAllToHierarchy(Object parent, Collection<?> children) {
        boolean success = true;
        for (Object child : children) {
            if (this.addToHierarchy(parent, child)) continue;
            success = false;
        }
        return success;
    }

    public boolean removeFromHierarchy(Object child) {
        Object parent = this.d_childParentMap.remove(child);
        if (parent == null) {
            return false;
        }
        Set<Object> children = this.d_parentChildMap.get(parent);
        assert (children != null);
        boolean removed = children.remove(child);
        assert (removed);
        if (children.isEmpty()) {
            this.d_parentChildMap.remove(parent);
        }
        return true;
    }

    public boolean removeAllFromHierarchy(Collection<?> objs) {
        boolean success = true;
        for (Object obj : objs) {
            if (this.removeFromHierarchy(obj)) continue;
            success = false;
        }
        return success;
    }

    public <T> Iterator<T> iterateParents(Class<T> parentType, Object child) {
        return Hierarchy.iterateParents(parentType, child, this::getParent);
    }

    public Object getParent(Object child) {
        return this.d_childParentMap.get(child);
    }

    public Set<Object> getChildren(Object parent) {
        Set children = this.d_parentChildMap.get(parent);
        if (children == null) {
            children = Collections.EMPTY_SET;
        }
        return children;
    }

    public int getNumChildren(Object parent) {
        int numChildren = 0;
        Set<Object> children = this.getChildren(parent);
        for (Object child : children) {
            numChildren += 1 + this.getNumChildren(child);
        }
        return numChildren;
    }

    public Set<Object> getParents(Collection<?> objs) {
        return Hierarchy.getParents(objs, this::getParent);
    }

    public boolean isDescendent(Object parent, Object child) {
        return Hierarchy.isDescendent(parent, child, this::getParent);
    }

    public Object getCommonParent(Collection<?> objs) {
        return Hierarchy.getCommonParent(objs, this::getParent);
    }

    public Object[] getPath(Object child) {
        return Hierarchy.getPath(child, this::getParent);
    }

    public Object[] getPath(Object child, Object stopParent, boolean includeStopParent) {
        return Hierarchy.getPath(child, stopParent, includeStopParent, this::getParent);
    }

    private void getPath(List<Object> path, Object child, Object stopParent, boolean includeStopParent) {
        Hierarchy.getPath(path, child, stopParent, includeStopParent, this::getParent);
    }
}

