/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Set;
import javax.vecmath.Point3d;
import merlin.data.ICompElement;
import merlin.data.IGetJson;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.geom.IMerlinGeomSrc;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Sets;

public class MeasurementRegionObj
extends NamedMerlinObj
implements ICompElement,
Cloneable,
IRestorable,
IMerlinGeomSrc,
IGetJson {
    static final long serialVersionUID = 1L;
    public static final Set<Object> PROP_TYPES = Sets.fromArrayHS(NamedMerlinObj.NAME, MerlinData.VISIBILITY, MerlinData.ENABLED);
    private boolean d_visible = true;
    private boolean d_enabled = true;
    private AABox d_box;
    private String d_json;

    public MeasurementRegionObj(AABox box, String name) {
        super(name);
        this.d_box = box;
        this.constructJson();
    }

    private void constructJson() {
        JSONObject obj1 = new JSONObject();
        obj1.put("min", this.d_box.getMin().toString());
        obj1.put("max", this.d_box.getMax().toString());
        obj1.put("name", this.getName());
        JSONArray list = new JSONArray();
        list.add(obj1);
        JSONObject obj2 = new JSONObject();
        obj2.put("density-regions", list);
        this.setJson(obj2.toJSONString());
    }

    private void setJson(String json) {
        this.d_json = json;
    }

    @Override
    public String getJson() {
        return this.d_json;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.constructJson();
        this.changedEvt(new Object[0]);
    }

    @Override
    public void restoreFrom(Object obj) {
        MeasurementRegionObj c = (MeasurementRegionObj)obj;
        this.d_box = c.d_box;
        this.d_visible = c.d_visible;
        this.d_enabled = c.d_enabled;
        this.setJson(c.d_json);
        this.changedEvt(MerlinData.TOPOLOGY);
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public MeasurementRegionObj clone() {
        return (MeasurementRegionObj)super.clone();
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == NAME) {
            this.setName((String)value);
        } else if (property == MerlinData.VISIBILITY) {
            this.setVisible((Boolean)value);
        } else if (property == MerlinData.ENABLED) {
            this.setEnabled((Boolean)value);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property == NAME) {
            return this.getName();
        }
        if (property == MerlinData.VISIBILITY) {
            return this.isVisible();
        }
        if (property == MerlinData.ENABLED) {
            return this.isEnabled();
        }
        return NOT_SUPPORTED;
    }

    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.d_enabled) {
            this.d_enabled = enabled;
            this.changedEvt(MerlinData.VISIBILITY, MerlinData.ENABLED, EventChannel.EVT_GENERAL);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.d_visible = visible;
        this.changedEvt(MerlinData.VISIBILITY);
    }

    @Override
    public boolean isVisible() {
        return this.d_visible && this.d_enabled;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        PropsBuilder gprops = new PropsBuilder();
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
        Color translucentRed = new Color(255, 0, 0, 120);
        gprops.add(new IPrimProps.Face(translucentRed, null, 0));
        gprops.add(new IPrimProps.Face(translucentRed, null, 0));
        gprops.add(new IPrimProps.Face(translucentRed, null, 0));
        gprops.add(new IPrimProps.Face(translucentRed, null, 0));
        gprops.add(new IPrimProps.Face(translucentRed, null, 0));
        gprops.add(new IPrimProps.Face(translucentRed, null, 0));
        AABoxGeom geom = this.getMeasureAreaGeom();
        Point3d min = geom.min;
        Point3d max = geom.max;
        Point3d p1 = geom.min;
        Point3d p2 = new Point3d(max.x, min.y, min.z);
        Point3d p3 = new Point3d(max.x, max.y, min.z);
        Point3d p4 = new Point3d(min.x, max.y, min.z);
        Point3d p5 = new Point3d(min.x, min.y, max.z);
        Point3d p6 = new Point3d(max.x, min.y, max.z);
        Point3d p7 = geom.max;
        Point3d p8 = new Point3d(min.x, max.y, max.z);
        ArrayList<LineSeg> lss = new ArrayList<LineSeg>();
        lss.add(new LineSeg(p1, p2));
        lss.add(new LineSeg(p2, p3));
        lss.add(new LineSeg(p3, p4));
        lss.add(new LineSeg(p4, p1));
        lss.add(new LineSeg(p1, p5));
        lss.add(new LineSeg(p2, p6));
        lss.add(new LineSeg(p3, p7));
        lss.add(new LineSeg(p4, p8));
        lss.add(new LineSeg(p5, p6));
        lss.add(new LineSeg(p6, p7));
        lss.add(new LineSeg(p7, p8));
        lss.add(new LineSeg(p8, p5));
        ArrayList<IManipulatable> geoms = new ArrayList<IManipulatable>();
        geoms.addAll(lss);
        geoms.add(geom);
        IGeom result = GeomUtil.group(geoms);
        return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(result), gprops);
    }

    @Override
    public void setGeom(IGeomNode node) {
        IGeom geom = node.flatten().getLocalGeom();
        if (!(geom instanceof AABoxGeom)) {
            return;
        }
        Point3d min = ((AABoxGeom)geom).min;
        Point3d max = ((AABoxGeom)geom).max;
        this.d_box = new AABox(min, max);
        this.constructJson();
        this.changedEvt(new Object[0]);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getMeasureAreaGeom());
    }

    private AABoxGeom getMeasureAreaGeom() {
        return new AABoxGeom(this.d_box);
    }
}

