/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Set;
import javax.vecmath.Vector3d;
import merlin.data.ICompElement;
import merlin.data.IOpacity;
import merlin.data.IRestorable;
import merlin.data.ImportType;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.Opacity;
import merlin.geom.IMerlinGeomSrc;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import thunderheadeng.cad.bim.BIMCoveringType;
import thunderheadeng.cad.bim.BIMTransportType;
import thunderheadeng.cad.bim.BIMType;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.ColorPool;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.Sets;
import thunderheadeng.util.theUtil;

public class ImportedGeom
extends NamedMerlinObj
implements IMerlinGeomSrc,
ICompElement,
IRestorable {
    static final long serialVersionUID = 1L;
    @Deprecated
    private static final int OPT_EXCLUDE_FROM_ROOM_EXTRACTION = 1;
    public static final Object PROP_OPTIONS = "OPTIONS";
    public static final Object PROP_MATERIAL = "MATERIAL";
    public static final Object PROP_DISPLAY_PROPS = "DISPLAY_PROPS";
    public static final Object PROP_GEOM = "GEOM";
    public static final IPropertySet.Prop<BIMType> PROP_BIM_TYPE = new IPropertySet.Prop<BIMType>("BIM_TYPE", BIMType.UNKNOWN);
    public static final IPropertySet.Prop<String> PROP_OBJECT_TYPE = new IPropertySet.Prop<String>("OBJECT_TYPE", "");
    public static final IPropertySet.Prop<ImportType> PROP_IMPORTED_TYPE = new IPropertySet.Prop<ImportType>("IMPORTED_TYPE", ImportType.OBSTRUCTION);
    public static final IPropertySet.Prop<UnitDouble> PROP_DOOR_WIDTH = new IPropertySet.Prop<Object>("DOOR_WIDTH", null);
    public static final IPropertySet.Prop<UnitDouble> PROP_DOOR_HEIGHT = new IPropertySet.Prop<Object>("DOOR_HEIGHT", null);
    public static final IPropertySet.Prop<IGeomNode> PROP_DOOR_VOID = new IPropertySet.Prop<Object>("DOOR_VOID", null);
    public static final IPropertySet.Prop<Vector3d> PROP_DOOR_DIR = new IPropertySet.Prop<Object>("DOOR_DIR", null);
    public static final IPropertySet.Prop<BIMCoveringType> PROP_COVERING_TYPE = new IPropertySet.Prop<BIMCoveringType>("PROP_COVERING_TYPE", BIMCoveringType.UNKNOWN);
    public static final IPropertySet.Prop<BIMTransportType> PROP_TRANSPORT_TYPE = new IPropertySet.Prop<BIMTransportType>("PROP_TRANSPORT_TYPE", BIMTransportType.UNKNOWN);
    public static final Set<Object> PROP_TYPES = Sets.fromArrayLHS(MerlinData.VISIBILITY, NamedMerlinObj.NAME, PROP_OPTIONS, PROP_MATERIAL, PROP_GEOM, PROP_BIM_TYPE, PROP_OBJECT_TYPE, PROP_IMPORTED_TYPE, PROP_DOOR_WIDTH, PROP_DOOR_HEIGHT, PROP_DOOR_VOID, PROP_COVERING_TYPE, PROP_TRANSPORT_TYPE, MerlinData.COLOR, MerlinData.OPACITY);
    private Object d_geom;
    private IPropsSrc d_propsSrc;
    private Object d_uv;
    private int d_options;
    private boolean d_visible;
    private BIMType d_bimType;
    private PropertySet d_props;

    public ImportedGeom(String name) {
        this(name, DisplayGeom.EMPTY);
    }

    public ImportedGeom(String name, DisplayGeom dg) {
        this(name, dg.node, dg.props);
    }

    public ImportedGeom(String name, IGeomNode geom, IPropsSrc propsSrc) {
        super(name);
        this.d_geom = geom;
        this.d_propsSrc = propsSrc;
        this.d_visible = true;
        this.d_options = 0;
        this.d_bimType = BIMType.UNKNOWN;
        this.d_props = new PropertySet();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        boolean prior110 = MerlinOIS.isPrior(in, MerlinIO.Version.VER_0110);
        if (this.d_uv == null && prior110) {
            this.d_uv = Elements.NO_UV;
        }
        if (prior110) {
            IElemSource uvSrc = (IElemSource)this.d_uv;
            this.d_uv = null;
            if (this.d_geom instanceof IGeom) {
                this.d_geom = GeomNodeUtil.newNode((IGeom)this.d_geom, Elements.NONE);
            } else assert (this.d_geom instanceof IGeomNode);
            if (uvSrc != Elements.NO_UV) {
                IElemSource uv = uvSrc;
                this.d_geom = ((IGeomNode)this.d_geom).applyUVElements("uvset", (pix, oldUV) -> uv.getPrimSource((int)pix));
            }
            this.d_geom = ((IGeomNode)this.d_geom).prune();
        }
        if (this.d_bimType == null) {
            this.d_bimType = BIMType.UNKNOWN;
        }
        if (this.d_props == null) {
            this.d_props = new PropertySet();
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0133)) {
            if ((this.d_options & 1) == 1) {
                this.setImportedType(ImportType.IGNORED);
                this.d_options &= 0xFFFFFFFE;
            } else {
                this.setImportedType(this.getImportedTypeFromBIMType());
            }
        }
    }

    public ImportType getImportedTypeFromBIMType() {
        switch (this.d_bimType) {
            case Ramp: 
            case RampFlight: {
                return ImportType.RAMP;
            }
            case Slab: {
                return ImportType.FLOOR;
            }
            case Covering: {
                return this.get(PROP_COVERING_TYPE) == BIMCoveringType.FLOORING ? ImportType.FLOOR : ImportType.OBSTRUCTION;
            }
            case Stair: 
            case StairFlight: {
                return ImportType.STAIR;
            }
            case Door: {
                return ImportType.DOOR;
            }
            case TransportElement: {
                switch (this.get(PROP_TRANSPORT_TYPE)) {
                    case ESCALATOR: {
                        return ImportType.ESCALATOR;
                    }
                    case MOVINGWALKWAY: {
                        return ImportType.MOVING_WALKWAY;
                    }
                }
                return ImportType.OBSTRUCTION;
            }
        }
        return this.isA(BIMType.Element) || this.isA(BIMType.UNKNOWN) ? ImportType.OBSTRUCTION : ImportType.IGNORED;
    }

    public void setBIMType(BIMType type) {
        if (this.d_bimType == type) {
            return;
        }
        this.d_bimType = type;
        this.changedEvt(new Object[0]);
    }

    public BIMType getBIMType() {
        return this.d_bimType;
    }

    public ImportType getImportedType() {
        return this.get(PROP_IMPORTED_TYPE);
    }

    public void setImportedType(ImportType type) {
        this.set(PROP_IMPORTED_TYPE, type);
    }

    public <T> void set(IPropertySet.Prop<T> prop, T val) {
        if (prop == PROP_BIM_TYPE) {
            this.setBIMType((BIMType)((Object)val));
            return;
        }
        this.d_props.set(prop, val);
        this.changedEvt(prop);
    }

    public <T> T get(IPropertySet.Prop<T> prop) {
        if (prop == PROP_BIM_TYPE) {
            return (T)((Object)this.getBIMType());
        }
        return this.d_props.get(prop);
    }

    public boolean isA(BIMType type) {
        return type.isAncestorOf(this.getBIMType());
    }

    public boolean isA(ImportType type) {
        return this.getImportedType() == type;
    }

    public boolean isIgnoredInModelGeneration() {
        return this.getImportedType() == ImportType.IGNORED;
    }

    public void setOptions(boolean state, int options) {
        int newOpts;
        int n = newOpts = state ? this.d_options | options : this.d_options & ~options;
        if (newOpts == this.d_options) {
            return;
        }
        this.d_options = newOpts;
        this.changedEvt(new Object[0]);
    }

    public boolean getOptions(int options) {
        return (this.d_options & options) == options;
    }

    @Override
    public Object clone() {
        ImportedGeom clone = (ImportedGeom)super.clone();
        clone.d_props = this.d_props.clone();
        return clone;
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof ImportedGeom)) {
            return;
        }
        ImportedGeom ig = (ImportedGeom)obj;
        this.pauseUpdates();
        this.setName(ig.getName());
        this.d_geom = ig.d_geom;
        this.d_propsSrc = ig.d_propsSrc;
        this.d_visible = ig.d_visible;
        this.d_bimType = ig.d_bimType;
        this.d_props = ig.d_props;
        this.resumeUpdates();
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        return new DisplayGeom((IGeomNode)this.d_geom, this.d_propsSrc);
    }

    public DisplayGeom getDisplayGeom() {
        return this.getDisplayGeom(null);
    }

    public void setDisplayGeom(DisplayGeom dg) {
        this.pauseUpdates();
        this.setGeom(dg.node);
        this.setDisplayProps(dg.props);
        this.resumeUpdates();
    }

    @Override
    public DisplayGeom getPickGeom() {
        return this.getDisplayGeom();
    }

    @Override
    public IGeomNode getGeom() {
        return (IGeomNode)this.d_geom;
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.d_geom = geom;
        this.changedEvt(new Object[0]);
    }

    public void setDisplayProps(IPropsSrc props) {
        this.d_propsSrc = props;
        this.changedEvt(new Object[0]);
    }

    public IPropsSrc getDisplayProps() {
        return this.d_propsSrc;
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.d_visible = visible;
        this.changedEvt(MerlinData.VISIBILITY);
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public Object getProperty(Object property) {
        if (property == MerlinData.VISIBILITY) {
            return this.isVisible();
        }
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (property == PROP_OPTIONS) {
            return this.d_options;
        }
        if (property == PROP_DISPLAY_PROPS) {
            return this.getDisplayProps();
        }
        if (property == PROP_GEOM) {
            return this.getGeom();
        }
        if (property == PROP_MATERIAL) {
            int ucount;
            int numPrims = this.getGeom().getNumPrims(7);
            Object[] mats = new IMaterial[numPrims];
            for (int offset = 0; offset < numPrims; offset += ucount) {
                IMaterial pmat = this.d_propsSrc.get(offset).getMaterial();
                ucount = this.d_propsSrc.getUniformCount(offset, numPrims - offset);
                Arrays.fill(mats, offset, offset + ucount, pmat);
            }
            return mats;
        }
        if (property == MerlinData.COLOR) {
            int numPrims = this.getGeom().getNumPrims(7);
            if (numPrims == 0) {
                return Color.WHITE;
            }
            Color c = null;
            for (int offset = 0; offset < numPrims; offset += this.d_propsSrc.getUniformCount(offset, numPrims - offset)) {
                Color pc = this.d_propsSrc.get(offset).getColor();
                pc = new Color(pc.getRed(), pc.getGreen(), pc.getBlue(), 255);
                if (c == null) {
                    c = pc;
                    continue;
                }
                if (c.equals(pc)) continue;
                return new NonUniformColor(c, this.d_propsSrc);
            }
            return c;
        }
        if (property == MerlinData.OPACITY) {
            int numPrims = this.getGeom().getNumPrims(7);
            if (numPrims == 0) {
                return new Opacity(0.0f);
            }
            Float alpha = null;
            for (int offset = 0; offset < numPrims; offset += this.d_propsSrc.getUniformCount(offset, numPrims - offset)) {
                Color c = this.d_propsSrc.get(offset).getColor();
                float pAlpha = (float)c.getAlpha() / 255.0f;
                if (alpha == null) {
                    alpha = Float.valueOf(pAlpha);
                    continue;
                }
                if (theUtil.eq(alpha.floatValue(), pAlpha, 0.0)) continue;
                return new NonUniformOpacity(this.d_propsSrc);
            }
            return new Opacity(alpha.floatValue());
        }
        if (property instanceof IPropertySet.Prop) {
            return this.get((IPropertySet.Prop)property);
        }
        return NOT_SUPPORTED;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == MerlinData.VISIBILITY) {
            this.setVisible((Boolean)value);
        } else if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        } else if (property == PROP_OPTIONS) {
            int options = (Integer)value;
            if (options != this.d_options) {
                this.d_options = options;
                this.changedEvt(new Object[0]);
            }
        } else if (property == PROP_DISPLAY_PROPS) {
            this.setDisplayProps((IPropsSrc)value);
        } else if (property == PROP_GEOM) {
            this.setGeom((IGeomNode)value);
        } else if (property == PROP_MATERIAL) {
            int ucount;
            int numPrims;
            IMaterial[] mats = (IMaterial[])value;
            PropsBuilder propsBuilder = new PropsBuilder();
            int n = numPrims = mats.length != 1 ? mats.length : this.getGeom().getNumPrims(7);
            assert (numPrims == this.getGeom().getNumPrims(7));
            for (int offset = 0; offset < numPrims; offset += ucount) {
                IPrimProps pprops = this.d_propsSrc.get(offset);
                ucount = this.d_propsSrc.getUniformCount(offset, numPrims - offset);
                if (mats.length == 1) {
                    if (pprops.getMaterial() != mats[0]) {
                        pprops = pprops.setMaterial(mats[0]);
                    }
                    propsBuilder.add(pprops, ucount);
                    continue;
                }
                for (int m = offset; m < ucount; ++m) {
                    IPrimProps newPProps = pprops.getMaterial() != mats[m] ? pprops.setMaterial(mats[m]) : pprops;
                    propsBuilder.add(newPProps);
                }
            }
            this.setDisplayProps(propsBuilder.finalizeProps());
        } else if (property == MerlinData.COLOR) {
            int uniformCount;
            Color c = (Color)value;
            if (c instanceof NonUniformColor) {
                this.setDisplayProps(((NonUniformColor)c).originalProps);
                return;
            }
            PropsBuilder props = new PropsBuilder();
            int numPrims = this.getGeom().getNumPrims(7);
            for (int offset = 0; offset < numPrims; offset += uniformCount) {
                Color newColor;
                IPrimProps pprops = this.d_propsSrc.get(offset);
                uniformCount = this.d_propsSrc.getUniformCount(offset, numPrims - offset);
                Color oldColor = pprops.getColor();
                int alpha = oldColor.getAlpha();
                Color color = newColor = c == null ? new Color(255, 255, 255, alpha) : new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
                if (!newColor.equals(oldColor)) {
                    pprops = pprops.setColor(ColorPool.get(newColor));
                }
                props.add(pprops, uniformCount);
            }
            this.setDisplayProps(props.finalizeProps());
        } else if (property == MerlinData.OPACITY) {
            if (value instanceof NonUniformOpacity) {
                this.setDisplayProps(((NonUniformOpacity)value).originalProps);
            } else {
                int uniformCount;
                float val = ((IOpacity)value).getValue();
                int alpha = (int)(val * 255.0f);
                PropsBuilder props = new PropsBuilder();
                int numPrims = this.getGeom().getNumPrims(7);
                for (int offset = 0; offset < numPrims; offset += uniformCount) {
                    IPrimProps pprops = this.d_propsSrc.get(offset);
                    uniformCount = this.d_propsSrc.getUniformCount(offset, numPrims - offset);
                    Color c = pprops.getColor();
                    if (alpha != c.getAlpha()) {
                        c = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
                        pprops = pprops.setColor(ColorPool.get(c));
                    }
                    props.add(pprops, uniformCount);
                }
                this.setDisplayProps(props.finalizeProps());
            }
        } else if (property instanceof IPropertySet.Prop) {
            this.set((IPropertySet.Prop)property, value);
        }
    }

    private static class NonUniformOpacity
    implements IOpacity {
        public final IPropsSrc originalProps;

        public NonUniformOpacity(IPropsSrc originalProps) {
            this.originalProps = originalProps;
        }

        @Override
        public float getValue() {
            return (float)this.originalProps.get(0).getColor().getAlpha() / 255.0f;
        }
    }

    private static class NonUniformColor
    extends Color {
        public final IPropsSrc originalProps;

        public NonUniformColor(Color subColor, IPropsSrc originalProps) {
            super(subColor.getRed(), subColor.getGreen(), subColor.getBlue(), subColor.getAlpha());
            this.originalProps = originalProps;
        }
    }
}

