/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.util.MerlinUtil;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Sets;
import thunderheadeng.util.theUtil;

public class Composite<DataT extends ICompElement>
extends NamedMerlinObj
implements ICompElement,
IRestorable {
    static final long serialVersionUID = 1L;
    public static final Set<Object> PROP_TYPES = Sets.fromArrayLHS(NamedMerlinObj.NAME);
    private Set<ICompElement> d_members = new LinkedIdentityHashSet<ICompElement>();
    private transient Map<Object, Object> d_cachedProps = null;
    private transient Map<Integer, Set<Object>> d_cachedPropTypes = new HashMap<Integer, Set<Object>>(4);
    private static final Predicate<ICompElement> s_deepEmptyFilter = new Predicate<ICompElement>(){

        @Override
        public boolean test(ICompElement o) {
            return !(o instanceof Composite) || !((Composite)o).getDeepMembers().isEmpty();
        }
    };

    public Composite(String name) {
        super(name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_cachedPropTypes == null) {
            this.d_cachedPropTypes = new HashMap<Integer, Set<Object>>();
        }
    }

    protected void markPropsCacheDirty() {
        this.d_cachedProps = null;
        Object parent = this.getParent();
        if (parent instanceof Composite) {
            ((Composite)parent).markPropsCacheDirty();
        }
    }

    private void markTypesCacheDirty() {
        this.d_cachedPropTypes.clear();
        Object parent = this.getParent();
        if (parent instanceof Composite) {
            ((Composite)parent).markTypesCacheDirty();
        }
    }

    private Map<Object, Object> getCachedProps() {
        if (this.d_cachedProps == null) {
            this.d_cachedProps = new HashMap<Object, Object>();
        }
        return this.d_cachedProps;
    }

    protected boolean getCachingAllowed(Object prop) {
        return true;
    }

    public Composite<?> newGroup(String name) {
        return new Composite<DataT>(name);
    }

    public boolean canAddGroup() {
        return this.newGroup("") != null;
    }

    public String getNewGroupName() {
        return Intl.intl("Group Node");
    }

    @Override
    public void restoreFrom(Object obj) {
        Composite nn = (Composite)obj;
        this.pauseUpdates();
        ArrayList<ICompElement> toRemove = new ArrayList<ICompElement>();
        ArrayList<ICompElement> toAdd = new ArrayList<ICompElement>();
        for (ICompElement o : this.d_members) {
            if (nn.d_members.contains(o)) continue;
            toRemove.add(o);
        }
        for (ICompElement o : nn.d_members) {
            if (this.d_members.contains(o)) continue;
            toAdd.add(o);
        }
        this.removeAll(toRemove);
        this.addAll(toAdd);
        this.resumeUpdates();
    }

    @Override
    public Object getRestoreObj() {
        Composite clone = (Composite)this.clone();
        clone.d_members.addAll(this.d_members);
        return clone;
    }

    @Override
    public Object clone() {
        Composite clone = (Composite)super.clone();
        clone.d_members = new LinkedIdentityHashSet<ICompElement>();
        clone.markPropsCacheDirty();
        clone.markTypesCacheDirty();
        return clone;
    }

    public Predicate<ICompElement> getFilter() {
        return Filters.acceptAll();
    }

    public void reorder(Collection<? extends DataT> newOrder) {
        assert (this.d_members.containsAll(newOrder) && this.d_members.size() == newOrder.size());
        this.d_members.clear();
        this.d_members.addAll(newOrder);
        this.changedEvt(MerlinData.CHILDREN_CHANGED);
    }

    public boolean containsAny(Collection<? extends DataT> objs) {
        for (ICompElement obj : objs) {
            if (!this.d_members.contains(obj)) continue;
            return true;
        }
        return false;
    }

    public void insert(Collection<? extends DataT> objs, int insertPos) {
        if (objs.isEmpty()) {
            return;
        }
        assert (!this.containsAny(objs));
        if (insertPos == this.d_members.size()) {
            this.addAll(objs);
            return;
        }
        ArrayList<ICompElement> newList = new ArrayList<ICompElement>(this.d_members);
        newList.addAll(insertPos, objs);
        this.d_members.clear();
        this.d_members.addAll(newList);
        this.markPropsCacheDirty();
        this.markTypesCacheDirty();
        super.addChildren(objs);
    }

    public void insert(DataT[] objs, int[] insertPositions) {
        if (objs.length == 0) {
            return;
        }
        assert (!this.containsAny(Arrays.asList(objs)));
        assert (objs.length <= insertPositions.length);
        ArrayList<ICompElement> newList = new ArrayList<ICompElement>(this.d_members);
        for (int m = 0; m < objs.length; ++m) {
            newList.add(insertPositions[m], (ICompElement)objs[m]);
        }
        this.d_members.clear();
        this.d_members.addAll(newList);
        this.markPropsCacheDirty();
        this.markTypesCacheDirty();
        super.addChildren(objs);
    }

    public int indexOf(ICompElement obj) {
        Pair<ICompElement, Integer> result = this.indexOf((? super ICompElement o) -> o == obj);
        if (result == null) {
            return -1;
        }
        return (Integer)result.v2;
    }

    public <T extends ICompElement> Pair<T, Integer> indexOf(Class<T> type, Predicate<? super T> test) {
        return this.indexOf((? super ICompElement o) -> type.isInstance(o) && test.test((Object)type.cast(o)));
    }

    public Pair<ICompElement, Integer> indexOf(Predicate<? super ICompElement> test) {
        int ix = 0;
        for (ICompElement child : this.d_members) {
            if (test.test(child)) {
                return new Pair<ICompElement, Integer>(child, ix);
            }
            ++ix;
        }
        return null;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        } else {
            this.pauseUpdates();
            Composite.setProperty(property, value, this.d_members);
            this.markPropsCacheDirty();
            this.changedEvt(property);
            this.resumeUpdates();
        }
    }

    public static <T> void setProperty(Object property, T value, Collection<? extends ICompElement> objs) {
        for (ICompElement iCompElement : objs) {
            iCompElement.setProperty(property, value);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (!this.getCachingAllowed(property)) {
            return Composite.getProperty(property, this.d_members);
        }
        Map<Object, Object> propCache = this.getCachedProps();
        if (propCache.containsKey(property)) {
            return propCache.get(property);
        }
        Object propVal = Composite.getProperty(property, this.d_members);
        propCache.put(property, propVal);
        return propVal;
    }

    public static Object getProperty(Object property, Collection<? extends ICompElement> objs) {
        if (objs.isEmpty()) {
            return NOT_SUPPORTED;
        }
        Object val = NOT_SUPPORTED;
        for (ICompElement iCompElement : objs) {
            Object val2 = iCompElement.getProperty(property);
            if (val2 == NON_UNIFORM) {
                return NON_UNIFORM;
            }
            if (val2 == NOT_SUPPORTED) continue;
            if (val == NOT_SUPPORTED) {
                val = val2;
                continue;
            }
            if (theUtil.equal(val, val2)) continue;
            return NON_UNIFORM;
        }
        return val;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        if (MerlinUtil.test(options, 1)) {
            return PROP_TYPES;
        }
        Set<Object> propTypes = this.d_cachedPropTypes.get(options);
        if (propTypes == null) {
            propTypes = Composite.getPropTypes(options, this.d_members);
            Set<Object> local = this.getPropTypes(1);
            if (!local.isEmpty()) {
                propTypes = new LinkedHashSet<Object>(propTypes);
                propTypes.addAll(local);
            }
            this.d_cachedPropTypes.put(options, propTypes);
        }
        return propTypes;
    }

    public static Set<Object> getPropTypes(int options, ICompElement ... objs) {
        return Composite.getPropTypes(options, Arrays.asList(objs));
    }

    public static Set<Object> getPropTypes(int options, Collection<? extends ICompElement> objs) {
        if (MerlinUtil.test(options, 2)) {
            if (objs.isEmpty()) {
                return Collections.EMPTY_SET;
            }
            LinkedHashSet<Object> groupTypes = new LinkedHashSet<Object>();
            for (Composite composite : theUtil.filter(objs, Composite.class)) {
                groupTypes.addAll(composite.getPropTypes(1));
            }
            LinkedHashSet<Object> types = null;
            for (ICompElement iCompElement : objs) {
                if (iCompElement instanceof Composite && ((Composite)iCompElement).getChildren().isEmpty()) continue;
                if (types == null) {
                    types = new LinkedHashSet<Object>(iCompElement.getPropTypes(options));
                } else {
                    types.retainAll(iCompElement.getPropTypes(options));
                }
                if (!types.isEmpty()) continue;
                return groupTypes;
            }
            if (types == null) {
                return groupTypes;
            }
            types.addAll(groupTypes);
            return types;
        }
        LinkedHashSet<Object> types = new LinkedHashSet<Object>();
        for (ICompElement iCompElement : objs) {
            types.addAll(iCompElement.getPropTypes(options));
        }
        return types;
    }

    public boolean contains(ICompElement obj) {
        return this.d_members.contains(obj);
    }

    public boolean containsDeep(ICompElement obj) {
        if (this.d_members.contains(obj)) {
            return true;
        }
        for (Composite<DataT> comp : this.getComposites()) {
            if (!comp.containsDeep(obj)) continue;
            return true;
        }
        return false;
    }

    public Collection<ICompElement> getMembers() {
        return this.d_members;
    }

    public <T> Collection<T> getMembers(Class<T> type) {
        return theUtil.filter(this.d_members, type);
    }

    public Collection<Composite<DataT>> getComposites() {
        return new ArrayList<Composite<DataT>>(this.getMembers(Composite.class));
    }

    public Collection<ICompElement> getDeepMembers() {
        return this.flatten();
    }

    public Collection<ICompElement> flatten() {
        return this.getDeepMembers(ICompElement.class);
    }

    public <T> Collection<T> getDeepMembers(Class<T> type) {
        return this.flatten(type);
    }

    public <T> Collection<T> flatten(Class<T> type) {
        return MerlinUtil.flatten(this.d_members, type);
    }

    public <T> Collection<T> flatten(Class<T> type, Predicate<? super T> filter) {
        return MerlinUtil.flatten(this.d_members, type, filter);
    }

    public Collection<Composite> getDeepNodes() {
        return this.getDeepMembers(Composite.class);
    }

    public static MerlinData getDomain(Collection<? extends ICompElement> objs) {
        if (objs == null) {
            return null;
        }
        Iterator<? extends ICompElement> iterator = objs.iterator();
        if (iterator.hasNext()) {
            ICompElement ce = iterator.next();
            return (MerlinData)ce.getDomain();
        }
        return null;
    }

    public void clear() {
        this.pauseUpdates();
        ArrayList<ICompElement> members = new ArrayList<ICompElement>(this.d_members);
        this.d_members.clear();
        super.removeChildren(members);
        this.markPropsCacheDirty();
        this.markTypesCacheDirty();
        this.resumeUpdates();
    }

    public boolean isEmpty() {
        return this.d_members.isEmpty();
    }

    public void prune() {
        this.pauseUpdates();
        for (Composite member : new ArrayList<Composite>(this.getMembers(Composite.class))) {
            member.prune();
            if (!member.isEmpty()) continue;
            this.remove(member);
        }
        this.resumeUpdates();
    }

    @Override
    public Collection<? extends IMerlinObj> getChildren() {
        return this.d_members;
    }

    public void add(ICompElement obj) {
        if (!this.getFilter().test(obj)) {
            System.err.println("Adding non-accepted object to group: [group=" + this.getName() + "], [object=" + obj.getName() + "]");
        }
        this.d_members.add(obj);
        this.markPropsCacheDirty();
        this.markTypesCacheDirty();
        super.addChildren((IMerlinObj[])new ICompElement[]{obj});
    }

    public void addAll(Collection<? extends ICompElement> objs) {
        this.pauseUpdates();
        for (ICompElement iCompElement : objs) {
            this.add(iCompElement);
        }
        this.resumeUpdates();
    }

    public boolean remove(ICompElement obj) {
        boolean result = this.d_members.remove(obj);
        if (result) {
            super.removeChild(obj);
            this.markPropsCacheDirty();
            this.markTypesCacheDirty();
        }
        return result;
    }

    public boolean removeAll(Collection<? extends ICompElement> objs) {
        boolean removed = false;
        this.pauseUpdates();
        for (ICompElement iCompElement : objs) {
            removed |= this.remove(iCompElement);
        }
        this.resumeUpdates();
        return removed;
    }

    public boolean removeDeep(ICompElement obj) {
        if (this.d_members.remove(obj)) {
            return true;
        }
        for (Composite<DataT> comp : this.getComposites()) {
            if (!comp.removeDeep(obj)) continue;
            return true;
        }
        return false;
    }

    public static <T extends ICompElement> Composite<T> findParent(Composite<T> root, T searchFor) {
        ArrayDeque search = new ArrayDeque();
        search.addFirst(root);
        while (!search.isEmpty()) {
            Composite container = (Composite)search.removeFirst();
            if (container.contains(searchFor)) {
                return container;
            }
            search.addAll(container.getComposites());
        }
        return null;
    }
}

