/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.Proxy;
import merlin.data.egress.IEgressObj;
import merlin.geom.IMerlinGeomSrc;
import thunderheadeng.gui.ADomainObject;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theUtil;

public abstract class AMerlinObj
extends ADomainObject<MerlinData>
implements IMerlinObj,
Serializable {
    static final long serialVersionUID = 1L;

    @Override
    public Collection<? extends IMerlinObj> getChildren() {
        return new ArrayList(0);
    }

    public Object getParent() {
        return this.getDomain() != null ? ((MerlinData)this.getDomain()).hierarchy.getParent(this) : null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    protected void removeFromDomain(MerlinData domain, IMerlinObj parent) {
        if (this instanceof IEgressObj) {
            domain.topology.remove((IEgressObj)((Object)this));
        }
        if (this instanceof IMerlinGeomSrc) {
            domain.geomLocation.remove((IMerlinGeomSrc)((Object)this));
        }
        for (IMerlinObj iMerlinObj : this.getChildren()) {
            iMerlinObj.setDomain(null, this);
        }
        this.removedEvt((Object)this);
        ((MerlinData)this.getDomain()).hierarchy.removeFromHierarchy(this);
    }

    protected void addToDomain(MerlinData domain, IMerlinObj parent) {
        domain.hierarchy.addToHierarchy(parent, this);
        this.addedEvt((Object)this);
        for (IMerlinObj iMerlinObj : this.getChildren()) {
            iMerlinObj.setDomain(domain, this);
        }
        if (this instanceof IMerlinGeomSrc) {
            domain.geomLocation.add((IMerlinGeomSrc)((Object)this));
        }
        if (this instanceof IEgressObj) {
            domain.topology.add((IEgressObj)((Object)this));
        }
    }

    @Override
    public void setDomain(MerlinData domain, IMerlinObj parent) {
        if (this.getDomain() == domain) {
            return;
        }
        if (this.getDomain() != null) {
            this.pauseUpdates();
            this.removeFromDomain((MerlinData)this.getDomain(), parent);
            this.resumeUpdates();
        }
        super.setDomain(domain);
        if (domain != null) {
            this.pauseUpdates();
            this.addToDomain((MerlinData)this.getDomain(), parent);
            this.resumeUpdates();
        }
    }

    protected <T extends IMerlinObj> void addChild(T child) {
        child.setDomain((MerlinData)this.getDomain(), this);
        this.changedEvt(MerlinData.CHILD_ADDED);
    }

    protected <T extends IMerlinObj> void addChildren(T ... children) {
        this.addChildren((Collection<T>)Arrays.asList(children));
    }

    protected <T extends IMerlinObj> void addChildren(Collection<T> children) {
        this.pauseUpdates();
        for (IMerlinObj child : children) {
            this.addChild(child);
        }
        this.resumeUpdates();
    }

    protected <T extends IMerlinObj> void removeChild(T child) {
        child.setDomain(null, this);
        this.changedEvt(MerlinData.CHILD_REMOVED);
    }

    protected <T extends IMerlinObj> void removeChildren(T ... children) {
        this.removeChildren((Collection<T>)Arrays.asList(children));
    }

    protected <T extends IMerlinObj> void removeChildren(Collection<T> children) {
        this.pauseUpdates();
        for (IMerlinObj child : children) {
            this.removeChild(child);
        }
        this.resumeUpdates();
    }

    protected static boolean changesExclusiveTo(Object[] changeList, Object ... changes) {
        if (changeList.length == 0) {
            return false;
        }
        for (Object c1 : changeList) {
            boolean found = false;
            for (Object c2 : changes) {
                if (c1 != c2) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean changedEvt(Object ... changes) {
        if (!AMerlinObj.changesExclusiveTo(changes, MerlinData.SELECTION_CHANGED)) {
            Collection<Object> proxyParents;
            LinkedIdentityHashSet parents = new LinkedIdentityHashSet();
            parents.add(this.getParent());
            if (this instanceof ICompElement && (proxyParents = Proxy.getProxyParents((ICompElement)((Object)this), true)) != null) {
                parents.addAll(proxyParents);
            }
            for (Object parent : parents) {
                if (!(parent instanceof Composite)) continue;
                ((Composite)parent).changedEvt(new Object[0]);
                ((Composite)parent).markPropsCacheDirty();
            }
        }
        if (this.getDomain() != null) {
            if (this instanceof IMerlinGeomSrc && !AMerlinObj.changesExclusiveTo(changes, MerlinData.SELECTION_CHANGED, MerlinData.VISIBILITY, MerlinData.CONNECTION)) {
                ((MerlinData)this.getDomain()).geomLocation.update((IMerlinGeomSrc)((Object)this));
            }
            if (this instanceof IEgressObj && theUtil.contains(MerlinData.TOPOLOGY, changes)) {
                ((MerlinData)this.getDomain()).topology.changed((IEgressObj)((Object)this));
            }
        }
        return super.changedEvt(changes);
    }
}

