/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import java.awt.Component;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.vecmath.Point2d;
import merlin.builders.PlanarGeomBuilder;
import merlin.builders.WorkingPlane;
import merlin.data.MerlinData;
import merlin.geom.Geometry;

public class PolyBuilder
extends PlanarGeomBuilder {
    public static final Object POINT_ADDED = "PolyBuilder.POINT_ADDED";
    public static final Object POINT_REMOVED = "PolyBuilder.POINT_REMOVED";
    private final Stack<Point2d> d_points = new Stack();
    private int d_numTestPoints = 0;
    private boolean d_isComplete = true;

    public PolyBuilder(MerlinData data, WorkingPlane workingPlane, PlanarGeomBuilder.IGeomBuilder builder) {
        super(data, workingPlane, builder);
        this.reset();
    }

    @Override
    protected void reset() {
        this.d_points.clear();
        this.d_isComplete = false;
        this.d_numTestPoints = 0;
        this.firePropChanged(POINT_REMOVED);
    }

    @Override
    public boolean isReadyToBegin() {
        return this.d_points.size() - this.d_numTestPoints == 0;
    }

    public boolean addTestPoint(Point2d p) {
        this.d_points.push(p);
        ++this.d_numTestPoints;
        this.firePropChanged(POINT_ADDED);
        return true;
    }

    public boolean addPoint(Point2d p) {
        this.pause();
        this.cancelTestPoints();
        this.addTestPoint(p);
        this.commitTestPoints();
        this.resume();
        return false;
    }

    public void cancelTestPoint() {
        if (!this.d_isComplete && this.d_numTestPoints > 0) {
            this.d_points.pop();
            --this.d_numTestPoints;
            this.firePropChanged(POINT_REMOVED);
        }
    }

    public void cancelTestPoints() {
        this.pause();
        for (int m = 0; m < this.d_numTestPoints; ++m) {
            this.cancelTestPoint();
        }
        this.resume();
    }

    public void commitTestPoints() {
        this.d_numTestPoints = 0;
        this.firePropChanged(POINT_ADDED);
    }

    public void closePoly(Component c) {
        if (this.canClosePoly()) {
            this.pause();
            this.cancelTestPoints();
            this.d_isComplete = true;
            this.addGeom(c);
            this.firePropChanged(COMPLETED);
            this.resume();
            this.reset();
        }
    }

    public List<Point2d> getPoints() {
        return Collections.unmodifiableList(this.d_points);
    }

    public boolean isComplete() {
        return this.d_isComplete;
    }

    public boolean canClosePoly() {
        return !this.d_isComplete && this.d_points.size() - this.d_numTestPoints >= 3;
    }

    public boolean canCancelPoly() {
        return !this.d_isComplete && this.d_points.size() - this.d_numTestPoints > 0;
    }

    @Override
    public Shape getShape() {
        Path2D.Double path = Geometry.pointsToPath(this.getPoints());
        if (this.d_isComplete) {
            path.closePath();
        }
        return path;
    }
}

