/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import merlin.data.MerlinData;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.geom.Geometry;
import merlin.geom.PointGeomFinder;
import merlin.geom.StrutUtil;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class CorridorUtil {
    public static final UnitDouble DEF_MAX_EDGE_ANGLE = new UnitDouble(89.0, NonSI.DEGREE_ANGLE);
    private static final Plane3d s_stairPlane = new Plane3d(0.0, 0.0, 1.0, 0.0);
    private static final Matrix4d stairPlaneWLXform = Geometry.getWorldToLocalXform(s_stairPlane);
    private static final Matrix4d stairPlaneLWXform = Geometry.getLocalToWorldXform(s_stairPlane);

    public static EgressCorridor.CorridorGeom findBoundaryCorr(IEgressOccupiable room1, LineSeg edge1, double t1e1, double t2e1, IEgressOccupiable room2, LineSeg edge2, Double door1Width, Double door2Width, double maxWidth, double maxEdgeAngle, boolean slide) {
        return CorridorUtil.findBoundaryCorr(room1, edge1, t1e1, t2e1, room2, edge2, door1Width, door2Width, maxWidth, maxWidth, maxEdgeAngle, slide);
    }

    public static EgressCorridor.CorridorGeom findBoundaryCorr(IEgressOccupiable room1, LineSeg edge1, double t1e1, double t2e1, IEgressOccupiable room2, LineSeg edge2, Double door1Width, Double door2Width, double maxWidth1, double maxWidth2, double maxEdgeAngle, boolean slide) {
        Vector3d edgeDirN2;
        if (room1 instanceof EgressCorridor || room2 instanceof EgressCorridor) {
            return null;
        }
        Vector3d edgeDirN1 = edge1.getTangent(0.0, ICurve.Orient.POSITIVE, true);
        double angle = Util3D.lineAngle(edgeDirN1, edgeDirN2 = edge2.getTangent(0.0, ICurve.Orient.POSITIVE, true));
        if (angle > maxEdgeAngle) {
            return null;
        }
        double[] edge1Seg = Geometry.getEdgeSegment(edge1, t1e1, t2e1, 0.0, 1.0, 0.0, slide);
        if (edge1Seg == null) {
            return null;
        }
        double midt = (edge1Seg[0] + edge1Seg[1]) * 0.5;
        Point3d[] boundary = StrutUtil.calcStrutBoundary(edge1, edge2, midt, maxWidth1, maxWidth2);
        if (boundary == null) {
            return null;
        }
        EgressCorridor.CorridorGeom geom = new EgressCorridor.CorridorGeom(edge1, edge2, door1Width, door2Width, null, boundary);
        return geom.isValid() ? geom : null;
    }

    public static EgressCorridor.CorridorGeom findBoundaryCorr(IEgressOccupiable room1, LineSeg edge1, double t1e1, double t2e1, IEgressOccupiable room2, LineSeg edge2, double t1e2, double t2e2, Double door1Width, Double door2Width, double maxEdgeAngle, boolean slide) {
        Vector3d edgeDirN2;
        if (room1 instanceof EgressCorridor || room2 instanceof EgressCorridor) {
            return null;
        }
        Vector3d edgeDirN1 = edge1.getTangent(0.0, ICurve.Orient.POSITIVE, true);
        double angle = Util3D.lineAngle(edgeDirN1, edgeDirN2 = edge2.getTangent(0.0, ICurve.Orient.POSITIVE, true));
        if (angle > maxEdgeAngle) {
            return null;
        }
        double[] edge1Seg = Geometry.getEdgeSegment(edge1, t1e1, t2e1, 0.0, 1.0, 0.0, slide);
        if (edge1Seg == null) {
            return null;
        }
        double[] edge2Seg = Geometry.getEdgeSegment(edge2, t1e2, t2e2, 0.0, 1.0, 0.0, slide);
        if (edge2Seg == null) {
            return null;
        }
        Point3d[] boundary = StrutUtil.calcStrutBoundaryFull(edge1, edge2, edge1Seg[0], edge1Seg[1], edge2Seg[0], edge2Seg[1]);
        if (boundary == null) {
            return null;
        }
        EgressCorridor.CorridorGeom geom = new EgressCorridor.CorridorGeom(edge1, edge2, door1Width, door2Width, null, boundary);
        return geom.isValid() ? geom : null;
    }

    public static Collection<EdgeLoc> getPotentialEdgeLocs(MerlinData md, Point3d loc, double distTol, double maxEdgeAngle, int options) {
        PointGeomFinder<IEgressOccupiable> finder1 = new PointGeomFinder<IEgressOccupiable>(loc, distTol, IEgressOccupiable.class);
        md.geomLocation.getLocator().find(finder1.test, finder1.result, options);
        return CorridorUtil.getPotentialEdgeLocs(finder1.getResults().keySet(), loc, distTol, maxEdgeAngle);
    }

    public static EdgeLoc getPotentialEdgeLoc(IEgressOccupiable room, Point3d loc, double distTol, double maxEdgeAngle) {
        Collection<EdgeLoc> doorLocs = CorridorUtil.getPotentialEdgeLocs(Arrays.asList(room), loc, distTol, maxEdgeAngle);
        if (doorLocs.isEmpty()) {
            return null;
        }
        return doorLocs.iterator().next();
    }

    private static Collection<EdgeLoc> getPotentialEdgeLocs(Collection<? extends IEgressOccupiable> rooms, Point3d loc, double distTol, double maxEdgeAngle) {
        ArrayList<Pair<Double, EdgeLoc>> locs = new ArrayList<Pair<Double, EdgeLoc>>();
        for (IEgressOccupiable iEgressOccupiable : rooms) {
            IGeom geom = iEgressOccupiable.getGeom().flatten().getLocalGeom();
            for (LineSeg edge : GeomUtil.convertToLineSegs(0.0, geom)) {
                double dist;
                Vector3d edgeDir;
                double zplaneAngle;
                if (edge.p1.epsilonEquals(edge.p2, 1.0E-6) || theUtil.gt(zplaneAngle = Util3D.angleWithPlane(s_stairPlane, edgeDir = edge.getTangent(0.0, ICurve.Orient.POSITIVE, false), 1.0E-6), maxEdgeAngle, 1.0E-6)) continue;
                double t = Inter3D.nearestTOnLine(edge.p1, edgeDir, loc);
                if (Double.isNaN(t = Util.clampTIfValid(t, 0.0, 1.0, 1.0E-6)) || !((dist = Util3D.linePoint(edge.p1, edgeDir, t).distance(loc)) < distTol)) continue;
                locs.add(new Pair<Double, EdgeLoc>(dist, new EdgeLoc(iEgressOccupiable, edge, t)));
            }
        }
        Collections.sort(locs, (o1, o2) -> ((Double)o1.v1).compareTo((Double)o2.v1));
        return theUtil.map(locs, o -> (EdgeLoc)o.v2);
    }

    public static SearchResult findCorr(MerlinData md, Point3d location, UnitDouble maxWidth, double searchTolerance, ITermCriteria termCriteria, IBoundaryGen bndGen, int options) {
        double searchDist = searchTolerance;
        Collection<EdgeLoc> edgeLocs1 = CorridorUtil.getPotentialEdgeLocs(md, location, searchDist, DEF_MAX_EDGE_ANGLE.getValue(SI.RADIAN), options);
        if (edgeLocs1.isEmpty()) {
            return null;
        }
        double mwidth = maxWidth.getValue(Geometry.LENGTH_UNIT);
        for (EdgeLoc edgeLoc1 : edgeLocs1) {
            double t1 = edgeLoc1.t;
            double widtht = mwidth / edgeLoc1.edge.length();
            double t2 = t1 + widtht;
            SearchResult stair = CorridorUtil.findBoundaryCorr(md, edgeLoc1.room, edgeLoc1.edge, t1, t2, termCriteria, bndGen, true, options);
            if (stair == null) continue;
            return stair;
        }
        return null;
    }

    public static SearchResult findCorr(MerlinData md, Point3d p1e1, Point3d p2e1, double searchTolerance, ITermCriteria termCriteria, IBoundaryGen bndGen, int options) {
        Collection<EdgeSeg> startingSegs = CorridorUtil.getValidStartingSegs(md, p1e1, p2e1, searchTolerance, options);
        if (startingSegs.isEmpty()) {
            return null;
        }
        for (EdgeSeg startSeg : startingSegs) {
            SearchResult stair = CorridorUtil.findBoundaryCorr(md, startSeg.room, startSeg.edge, startSeg.t1, startSeg.t2, termCriteria, bndGen, false, options);
            if (stair == null) continue;
            return stair;
        }
        return null;
    }

    public static SearchResult findBoundaryCorr(MerlinData md, IEgressOccupiable room1, LineSeg edge1, double t1e1, double t2e1, ITermCriteria termCriteria, IBoundaryGen bndGen, boolean slide, int options) {
        double centert = (t1e1 + t2e1) * 0.5;
        double width = Math.abs(t1e1 - t2e1) * edge1.length();
        Point3d[] begin = CorridorUtil.getBeginningStairPointsFromMid(edge1, centert, width, slide, 0.0, 1.0);
        if (begin == null) {
            return null;
        }
        Point3d[] termCritPoints = bndGen.getBoundary(edge1, begin[0], begin[1], termCriteria);
        if (termCritPoints == null) {
            return null;
        }
        double closestRoomDist = termCritPoints[0].distanceSquared(termCritPoints[3]);
        IEgressOccupiable otherRoom = null;
        LineSeg edge2 = new LineSeg(termCritPoints[3], termCritPoints[2]);
        Collection<IEgressOccupiable> potRooms = CorridorUtil.getPotentialTouchingRooms(md, termCritPoints, options);
        for (IEgressOccupiable room2 : potRooms) {
            if (room2 == room1) continue;
            for (IFace face : GeomUtil.explode(room2.getGeom().flatten().getLocalGeom(), IFace.class)) {
                List<IPolygon> planarFaces = face instanceof IPolygon ? Arrays.asList((IPolygon)face) : GeomUtil.getTriangles(0.0, face);
                for (IPolygon pg : planarFaces) {
                    double dist;
                    Plane3d plane = pg.getPlane(true);
                    CustomTermCrit termCrit = new CustomTermCrit(plane);
                    Point3d[] stairPoints = bndGen.getBoundary(edge1, begin[0], begin[1], termCrit);
                    if (stairPoints == null) continue;
                    Point3d p1 = stairPoints[0];
                    Point3d p1a = stairPoints[3];
                    Point3d p2a = stairPoints[2];
                    if (!pg.classify((Point3d)p2a, (double)1.0E-6).positive && !pg.classify((Point3d)p1a, (double)1.0E-6).positive || (dist = p1.distanceSquared(p1a)) <= 1.0E-6 || !theUtil.le(dist, closestRoomDist, 1.0E-6)) continue;
                    closestRoomDist = dist;
                    otherRoom = room2;
                    edge2 = new LineSeg(p1a, p2a);
                }
            }
        }
        if (edge2 != null) {
            return new SearchResult(new EgressCorridor.CorridorGeom(edge1, edge2, null, null, null, termCritPoints), room1, otherRoom);
        }
        return null;
    }

    private static Collection<IEgressOccupiable> getPotentialTouchingRooms(MerlinData md, final Point3d[] maxStairPoints, int options) {
        final LinkedIdentityHashSet<IEgressOccupiable> rooms = new LinkedIdentityHashSet<IEgressOccupiable>();
        ITest<AABox> test = new ITest<AABox>(){

            @Override
            public Containment test(AABox bounds) {
                return Inter3D.faceAABoxIsect(1.0E-6, bounds, maxStairPoints) ? Containment.INTERSECTS : Containment.OUTSIDE;
            }
        };
        IResult<IDisplayableGeomSrc> result = new IResult<IDisplayableGeomSrc>(){

            @Override
            public void mark(IDisplayableGeomSrc obj, Containment ctmt) {
                if (obj instanceof IEgressOccupiable && !(obj instanceof EgressCorridor)) {
                    rooms.add((IEgressOccupiable)obj);
                }
            }
        };
        md.geomLocation.getLocator().find(test, (IResult<? super IDisplayableGeomSrc>)result, options);
        return rooms;
    }

    public static Collection<EdgeSeg> getValidStartingSegs(MerlinData md, Point3d p1, Point3d p2, double searchTolerance, int options) {
        double maxEdgeAngle = DEF_MAX_EDGE_ANGLE.getValue(SI.RADIAN);
        Collection<EdgeLoc> edgeLocs1 = CorridorUtil.getPotentialEdgeLocs(md, p1, searchTolerance, maxEdgeAngle, options);
        if (edgeLocs1.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Collection<EdgeLoc> edgeLocs2 = CorridorUtil.getPotentialEdgeLocs(md, p2, searchTolerance, maxEdgeAngle, options);
        if (edgeLocs2.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<EdgeSeg> validStartSegs = new ArrayList<EdgeSeg>();
        for (EdgeLoc loc1 : edgeLocs1) {
            for (EdgeLoc loc2 : edgeLocs2) {
                LineSeg seg1 = loc1.edge;
                LineSeg seg2 = loc2.edge;
                if (loc1.room != loc2.room || !seg1.equals(seg2, false)) continue;
                double t1 = seg1.getT(p1);
                double t2 = seg1.getT(p2);
                validStartSegs.add(new EdgeSeg(loc1.room, loc1.edge, t1, t2));
            }
        }
        return validStartSegs;
    }

    public static SearchResult findCorr(MerlinData md, Point3d p1e1, Point3d p2e1, Point3d p1e2, Point3d p2e2, double maxEdgeAngle, double searchTolerance, int options, Predicate<SearchResult> filter) {
        BiFunction<Point3d, Point3d, Collection> getSegs = (e1, e2) -> CorridorUtil.getValidStartingSegs(md, e1, e2, searchTolerance, options);
        Collection e1Segs = getSegs.apply(p1e1, p2e1);
        if (e1Segs.isEmpty()) {
            return null;
        }
        Collection e2Segs = getSegs.apply(p1e2, p2e2);
        if (e2Segs.isEmpty()) {
            return null;
        }
        TreeSet<SearchResult> corrs = new TreeSet<SearchResult>(CorridorUtil.getCorridorComp4Pt(p1e1, p2e1, p1e2, p2e2));
        for (EdgeSeg e1seg : e1Segs) {
            for (EdgeSeg e2seg : e2Segs) {
                SearchResult sr;
                EgressCorridor.CorridorGeom geom = CorridorUtil.findBoundaryCorr(e1seg.room, e1seg.edge, e1seg.t1, e1seg.t2, e2seg.room, e2seg.edge, e2seg.t1, e2seg.t2, null, null, maxEdgeAngle, true);
                if (geom == null || !filter.test(sr = new SearchResult(geom, e1seg.room, e2seg.room))) continue;
                corrs.add(sr);
            }
        }
        if (corrs.isEmpty()) {
            return null;
        }
        return corrs.first();
    }

    private static Comparator<SearchResult> getCorridorComp4Pt(final Point3d p1e1, final Point3d p2e1, final Point3d p1e2, final Point3d p2e2) {
        final Point3d[] e1 = new Point3d[]{p1e1, p2e1};
        final Point3d[] e2 = new Point3d[]{p1e2, p2e2};
        return new Comparator<SearchResult>(){

            @Override
            public int compare(SearchResult o1, SearchResult o2) {
                boolean sameRoom2;
                int comp = theUtil.compare(this.getError(o1.geom), this.getError(o2.geom), 1.0E-6);
                if (comp != 0) {
                    return comp;
                }
                boolean sameRoom1 = o1.room1 == o1.room2;
                boolean bl = sameRoom2 = o2.room1 == o2.room2;
                if (sameRoom1 && !sameRoom2) {
                    return 1;
                }
                if (!sameRoom1 && sameRoom2) {
                    return -1;
                }
                boolean sameEdge1 = o1.geom.edge1.equals(o1.geom.edge2, true);
                boolean sameEdge2 = o2.geom.edge1.equals(o2.geom.edge2, true);
                if (sameEdge1 && !sameEdge2) {
                    return 1;
                }
                if (!sameEdge1 && sameEdge2) {
                    return -1;
                }
                return 0;
            }

            private double getError(EgressCorridor.CorridorGeom geom) {
                Point3d[] edge1 = null;
                Point3d[] edge2 = null;
                if (Inter3D.distSqToNearestPtOnLine(e1[0], Util3D.vector(e1[0], e1[1]), p1e1) < Inter3D.distSqToNearestPtOnLine(e2[0], Util3D.vector(e2[0], e2[1]), p1e1)) {
                    edge1 = e1;
                    edge2 = e2;
                } else {
                    edge1 = e2;
                    edge2 = e1;
                }
                double error = 0.0;
                error += this.getError(edge1, p1e1, p2e1);
                return error += this.getError(edge2, p1e2, p2e2);
            }

            private double getError(Point3d[] edge, Point3d p1e, Point3d p2e) {
                return Math.min(this.getError(p1e, edge[0]) + this.getError(p2e, edge[1]), this.getError(p1e, edge[1]) + this.getError(p2e, edge[0]));
            }

            private double getError(Point3d p1, Point3d p2) {
                return p1.distance(p2);
            }
        };
    }

    public static SearchResult findCorr(MerlinData md, Point3d p1e1, Point3d p2e1, Point3d pe2, double maxEdgeAngle, double searchTolerance, boolean slide, int options, Predicate<SearchResult> corrTest) {
        Collection<EdgeSeg> startingSegs = CorridorUtil.getValidStartingSegs(md, p1e1, p2e1, searchTolerance, options);
        if (startingSegs.isEmpty()) {
            return null;
        }
        Collection<EdgeLoc> edgeLocs2 = CorridorUtil.getPotentialEdgeLocs(md, pe2, searchTolerance, maxEdgeAngle, options);
        if (edgeLocs2.isEmpty()) {
            return null;
        }
        TreeMap<EgressCorridor.CorridorGeom, SearchResult> stairs = new TreeMap<EgressCorridor.CorridorGeom, SearchResult>(CorridorUtil.getCorridorComp2Pt(p1e1, p2e1, pe2));
        double nMaxWidth = p1e1.distance(p2e1);
        for (EdgeSeg startSeg : startingSegs) {
            for (EdgeLoc edgeLoc2 : edgeLocs2) {
                SearchResult sr;
                EgressCorridor.CorridorGeom stair = CorridorUtil.findBoundaryCorr(startSeg.room, startSeg.edge, startSeg.t1, startSeg.t2, edgeLoc2.room, edgeLoc2.edge, null, null, nMaxWidth, maxEdgeAngle, slide);
                if (stair == null || !corrTest.test(sr = new SearchResult(stair, startSeg.room, edgeLoc2.room))) continue;
                stairs.put(stair, sr);
            }
        }
        if (stairs.isEmpty()) {
            return null;
        }
        return (SearchResult)stairs.firstEntry().getValue();
    }

    private static Comparator<EgressCorridor.CorridorGeom> getCorridorComp2Pt(final Point3d p1e1, final Point3d p2e1, final Point3d pe2) {
        return new Comparator<EgressCorridor.CorridorGeom>(){

            @Override
            public int compare(EgressCorridor.CorridorGeom o1, EgressCorridor.CorridorGeom o2) {
                return Double.compare(this.getError(o1), this.getError(o2));
            }

            private double getError(EgressCorridor.CorridorGeom geom) {
                LineSeg completeEdge = null;
                LineSeg incompleteEdge = null;
                if (Inter3D.distSqToNearestPtOnLineSeg(geom.edge1.p1, geom.edge1.p2, p1e1) < Inter3D.distSqToNearestPtOnLineSeg(geom.edge2.p1, geom.edge2.p2, p1e1)) {
                    completeEdge = geom.edge1;
                    incompleteEdge = geom.edge2;
                } else {
                    completeEdge = geom.edge2;
                    incompleteEdge = geom.edge1;
                }
                double error = Math.min(this.getError(p1e1, completeEdge.p1) + this.getError(p2e1, completeEdge.p2), this.getError(p1e1, completeEdge.p2) + this.getError(p2e1, completeEdge.p1));
                error += Math.sqrt(Inter3D.distSqToNearestPtOnLineSeg(incompleteEdge.p1, incompleteEdge.p2, pe2));
                return error += Math.abs(completeEdge.length() - incompleteEdge.length());
            }

            private double getError(Point3d p1, Point3d p2) {
                return p1.distance(p2);
            }
        };
    }

    public static SearchResult findCorr(MerlinData md, Point3d loc1, Point3d loc2, UnitDouble maxWidth, double maxEdgeAngle, double searchTolerance, boolean slide, int options, Predicate<SearchResult> corrTest) {
        double searchDist = searchTolerance;
        Collection<EdgeLoc> edgeLocs1 = CorridorUtil.getPotentialEdgeLocs(md, loc1, searchDist, maxEdgeAngle, options);
        if (edgeLocs1.isEmpty()) {
            return null;
        }
        Collection<EdgeLoc> edgeLocs2 = CorridorUtil.getPotentialEdgeLocs(md, loc2, searchDist, maxEdgeAngle, options);
        if (edgeLocs2.isEmpty()) {
            return null;
        }
        double nMaxWidth = maxWidth.getValue(Geometry.LENGTH_UNIT);
        for (EdgeLoc edgeLoc1 : edgeLocs1) {
            for (EdgeLoc edgeLoc2 : edgeLocs2) {
                SearchResult sr;
                double t1 = edgeLoc1.t;
                double widtht = nMaxWidth / edgeLoc1.edge.length();
                double t2 = t1 + widtht;
                EgressCorridor.CorridorGeom stair = CorridorUtil.findBoundaryCorr(edgeLoc1.room, edgeLoc1.edge, t1, t2, edgeLoc2.room, edgeLoc2.edge, null, null, nMaxWidth, maxEdgeAngle, slide);
                if (stair == null || !corrTest.test(sr = new SearchResult(stair, edgeLoc1.room, edgeLoc2.room))) continue;
                return sr;
            }
        }
        return null;
    }

    public static Point3d[] getBeginningStairPointsFromMid(LineSeg edge1, double edgeT, double width, boolean slide, double minEdgeT, double maxEdgeT) {
        double halfWidT = width * 0.5 / edge1.length();
        double t1 = edgeT - halfWidT;
        double t2 = edgeT + halfWidT;
        double[] ts = Geometry.getEdgeSegment(edge1, t1, t2, minEdgeT, maxEdgeT, 0.0, slide);
        return CorridorUtil.getPoints(edge1, ts);
    }

    private static Point3d[] getBeginningStairPointsFromSide(LineSeg edge1, double edgeT, double width, boolean slide) {
        double widtht = width / edge1.length();
        double t1 = edgeT;
        double t2 = edgeT + widtht;
        double[] ts = Geometry.getEdgeSegment(edge1, t1, t2, 0.0, 1.0, 0.0, slide);
        return CorridorUtil.getPoints(edge1, ts);
    }

    private static Point3d[] getPoints(LineSeg edge, double[] ts) {
        if (ts == null) {
            return null;
        }
        Point3d[] points = new Point3d[ts.length];
        for (int m = 0; m < ts.length; ++m) {
            points[m] = edge.evaluate(ts[m]);
        }
        return points;
    }

    public static Point3d[] getBeginningPointsFromSide(MerlinData md, Point3d p, double width, boolean slide, int options) {
        double maxEdgeAngle = DEF_MAX_EDGE_ANGLE.getValue(SI.RADIAN);
        Collection<EdgeLoc> locs = CorridorUtil.getPotentialEdgeLocs(md, p, 1.0E-6, maxEdgeAngle, options);
        for (EdgeLoc loc : locs) {
            Point3d[] points = CorridorUtil.getBeginningStairPointsFromSide(loc.edge, loc.t, width, slide);
            if (points == null) continue;
            return points;
        }
        return null;
    }

    public static IBoundaryGen getSlopedBoundaryGenDeg(UnitDouble angle) {
        double angleRad = angle.getValue(SI.RADIAN);
        double slope = Math.tan(angleRad);
        return new SlopedBoundaryGen(slope);
    }

    public static class CustomTermCrit
    implements ITermCriteria {
        public final Plane3d d_plane;

        public CustomTermCrit(Plane3d plane) {
            this.d_plane = plane;
        }

        public boolean equals(Object obj) {
            return obj instanceof CustomTermCrit && this.d_plane.equals(((CustomTermCrit)obj).d_plane);
        }

        @Override
        public Plane3d getTermPlane(Point3d p1, Point3d p2, Vector3d stairDir) {
            return this.d_plane;
        }
    }

    public static class LengthTermCrit
    implements ITermCriteria {
        public final double d_maxLength;

        public LengthTermCrit(double maxLength) {
            assert (maxLength > 0.0);
            this.d_maxLength = maxLength;
        }

        public boolean equals(Object obj) {
            return obj instanceof LengthTermCrit && this.d_maxLength == ((LengthTermCrit)obj).d_maxLength;
        }

        @Override
        public Plane3d getTermPlane(Point3d p1, Point3d p2, Vector3d stairDir) {
            Vector3d stairDirN = new Vector3d(stairDir);
            stairDirN.normalize();
            Vector3d planeOffset = Util3D.scale(stairDirN, this.d_maxLength);
            Point3d pOnPlane = Util3D.add(p1, (Tuple3d)planeOffset);
            return new Plane3d(stairDirN, pOnPlane);
        }
    }

    public static class RunTermCrit
    implements ITermCriteria {
        public final double d_maxRun;

        public RunTermCrit(double maxRun) {
            assert (maxRun > 0.0);
            this.d_maxRun = maxRun;
        }

        public boolean equals(Object obj) {
            return obj instanceof RunTermCrit && this.d_maxRun == ((RunTermCrit)obj).d_maxRun;
        }

        @Override
        public Plane3d getTermPlane(Point3d p1, Point3d p2, Vector3d stairDir) {
            Vector3d planeDirN = new Vector3d(stairDir.x, stairDir.y, 0.0);
            planeDirN.normalize();
            Vector3d planeOffset = Util3D.scale(planeDirN, this.d_maxRun);
            Point3d pOnPlane = Util3D.add(p1, (Tuple3d)planeOffset);
            return new Plane3d(planeDirN, pOnPlane);
        }
    }

    public static class RiseTermCrit
    implements ITermCriteria {
        public final double d_rise;

        public RiseTermCrit(double maxRise) {
            assert (maxRise > 0.0);
            this.d_rise = maxRise;
        }

        public boolean equals(Object obj) {
            return obj instanceof RiseTermCrit && this.d_rise == ((RiseTermCrit)obj).d_rise;
        }

        @Override
        public Plane3d getTermPlane(Point3d p1, Point3d p2, Vector3d stairDir) {
            double endZ = stairDir.z < 0.0 ? p1.z - this.d_rise : p1.z + this.d_rise;
            return new Plane3d(0.0, 0.0, 1.0, -endZ);
        }
    }

    public static interface ITermCriteria {
        public Plane3d getTermPlane(Point3d var1, Point3d var2, Vector3d var3);
    }

    public static class SlopedBoundaryGen
    implements IBoundaryGen {
        private final double d_slope;

        public SlopedBoundaryGen(double slope) {
            this.d_slope = slope;
        }

        @Override
        public Point3d[] getBoundary(LineSeg edge1, Point3d e1p1, Point3d e1p2, ITermCriteria termCriteria) {
            Vector3d stairDir = this.getDir(edge1);
            Plane3d termPlane = termCriteria.getTermPlane(e1p1, e1p2, stairDir);
            if (!Util3D.areParallel(termPlane, Util3D.vector(edge1.p1, edge1.p2), 1.0E-6)) {
                return null;
            }
            Point3d p1a = Inter3D.rayPlaneIntersection(e1p1, stairDir, termPlane, 1.0E-6);
            Point3d p2a = Inter3D.rayPlaneIntersection(e1p2, stairDir, termPlane, 1.0E-6);
            if (p1a == null || p2a == null) {
                return null;
            }
            return new Point3d[]{e1p2, e1p1, p1a, p2a};
        }

        private Vector3d getDir(LineSeg edge1) {
            Vector3d edgeDir = Util3D.vector(edge1.p1, edge1.p2);
            Vector3d stairDir = new Vector3d(edgeDir.y, -edgeDir.x, 0.0);
            stairDir.normalize();
            stairDir.z = this.d_slope;
            return stairDir;
        }
    }

    public static interface IBoundaryGen {
        public Point3d[] getBoundary(LineSeg var1, Point3d var2, Point3d var3, ITermCriteria var4);
    }

    public static class SearchResult {
        public final EgressCorridor.CorridorGeom geom;
        public final IEgressOccupiable room1;
        public final IEgressOccupiable room2;

        public SearchResult(EgressCorridor.CorridorGeom geom, IEgressOccupiable room1, IEgressOccupiable room2) {
            this.geom = geom;
            this.room1 = room1;
            this.room2 = room2;
        }
    }

    public static class EdgeSeg {
        public final IEgressOccupiable room;
        public final LineSeg edge;
        public final double t1;
        public final double t2;

        public EdgeSeg(IEgressOccupiable room, LineSeg edge, double t1, double t2) {
            this.room = room;
            this.edge = edge;
            this.t1 = t1;
            this.t2 = t2;
        }
    }

    public static class EdgeLoc {
        public final IEgressOccupiable room;
        public final LineSeg edge;
        public final double t;

        public EdgeLoc(IEgressOccupiable room, LineSeg edge, double t) {
            this.room = room;
            this.edge = edge;
            this.t = t;
        }
    }
}

