/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import merlin.MerlinApp;
import merlin.builders.ABehaviorActionBuilder;
import merlin.data.AssistedEvacTeam;
import merlin.data.MerlinData;
import merlin.data.egress.scripting.AssistOccupants;
import merlin.data.egress.scripting.DetachAssistants;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.WaitForAssistance;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.RProp;
import thunderheadeng.util.RWProp;

public class AssistedEvacActionBuilder
extends ABehaviorActionBuilder
implements IEventObserver {
    public static final RWProp<Type> TYPE = new RWProp<Type>((Object)"AssistedEvacActionBuilder.TYPE", Type.ASSIST);
    public static final RProp<Boolean> VALID = new RProp<Boolean>((Object)"AssistedEvacActionBuilder.VALID", false);
    public static final Prop<Set<AssistedEvacTeam>> TEAMS = new Prop(Type.WAIT_FOR_ASSISTANCE, (Object)"AssistedEvacActionBuilder.TEAMS", Collections.emptySet());
    public static final Prop<AssistedEvacTeam> TEAM = new Prop<AssistedEvacTeam>(Type.ASSIST, (Object)"AssistedEvacActionBuilder.TEAM", AssistedEvacTeam.class);
    private PropertySet d_props = new PropertySet();

    public AssistedEvacActionBuilder(MerlinData md, Type initialType) {
        super(md);
        MerlinApp.getApp().getData().getEvents().addObserver(this);
        this.set(TYPE, (Object)((Object)initialType));
        this.reset();
    }

    public <T> void set(RWProp<T> prop, T value) {
        if (!this.lock()) {
            return;
        }
        try {
            this.setLocked(prop, value);
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void setLocked(RWProp<T> prop, T value) {
        this.pause();
        try {
            if (prop instanceof Prop) {
                Prop p = (Prop)prop;
                this.setLocked(TYPE, p.type);
            }
            if (Objects.equals(this.get(prop), value)) {
                return;
            }
            this.d_props.setIfNotDefault(prop, value);
            this.firePropChanged(prop);
            this.firePropChanged(VALID);
            this.firePropChanged(VALIDITY);
        }
        finally {
            this.resume();
        }
    }

    public <T> T get(RProp<T> prop) {
        if (prop == VALID) {
            return (T)Boolean.valueOf(this.isValid());
        }
        return this.d_props.get(prop);
    }

    @Override
    public boolean isValid() {
        switch (this.get(TYPE)) {
            case ASSIST: {
                return this.get(TEAM) != null;
            }
            case WAIT_FOR_ASSISTANCE: {
                return true;
            }
            case DETACH_ASSISTANTS: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected IBehaviorAction create() {
        switch (this.get(TYPE)) {
            case WAIT_FOR_ASSISTANCE: {
                return new WaitForAssistance(this.get(TEAMS));
            }
            case DETACH_ASSISTANTS: {
                return new DetachAssistants();
            }
            case ASSIST: {
                return new AssistOccupants(this.get(TEAM));
            }
        }
        return null;
    }

    @Override
    public void reset() {
        Collection<AssistedEvacTeam> teams;
        if (this.get(TYPE) == Type.ASSIST && this.get(TEAM) == null && !(teams = MerlinApp.getApp().getData().assistedEvacTeams.flatten(AssistedEvacTeam.class)).isEmpty()) {
            this.set(TEAM, (T)teams.iterator().next());
        }
    }

    @Override
    public void update(Events events) {
        super.update(events);
        Set<AssistedEvacTeam> teams = this.get(TEAMS);
        for (EventChannel<AssistedEvacTeam> channel : events.getAffectedChannels(AssistedEvacTeam.class, new Class[0])) {
            for (AssistedEvacTeam team : channel.getRemovedObjs()) {
                if (this.get(TEAM) == team) {
                    this.set(TEAM, (T)null);
                    this.reset();
                }
                teams.remove(team);
            }
        }
    }

    public static class Prop<T>
    extends RWProp<T> {
        public final Type type;

        public Prop(Type type, Object key, T defVal) {
            super(key, defVal);
            this.type = type;
        }

        public Prop(Type type, Object key, Class<T> clazz) {
            super(key, clazz);
            this.type = type;
        }
    }

    public static enum Type {
        WAIT_FOR_ASSISTANCE,
        DETACH_ASSISTANTS,
        ASSIST;

    }
}

