/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import java.awt.Component;
import java.util.Iterator;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.AddObject;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.util.MerlinProps;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public abstract class ABehaviorActionBuilder
extends MerlinProps
implements IEventObserver {
    public static final Object BEHAVIOR_CHANGED = "ABehaviorActionBuilder.BEHAVIOR_CHANGED";
    public static final Object COMMITTED = "ABehaviorActionBuilder.COMMITTED";
    public static final Object CANCELLED = "ABehaviorActionBuilder.CANCELLED";
    public static final Object VALIDITY = "ABehaviorActionBuilder.VALID";
    private final MerlinData d_data;
    private Behavior d_currentBehavior;
    private IBehaviorAction d_insertAfterAction;

    public ABehaviorActionBuilder(MerlinData md) {
        this.d_data = md;
        SelectionObserver.add(this, Behavior.class, IBehaviorAction.class);
    }

    protected abstract IBehaviorAction create();

    protected abstract void reset();

    @Override
    public void update(Events events) {
        Behavior behavior = null;
        IBehaviorAction action = null;
        if (this.d_data.selection.isExclusive(Behavior.class)) {
            behavior = (Behavior)this.d_data.selection.getSelected(Behavior.class).iterator().next();
        } else if (this.d_data.selection.isExclusive(IBehaviorAction.class)) {
            action = (IBehaviorAction)this.d_data.selection.getSelected(IBehaviorAction.class).iterator().next();
            behavior = (Behavior)this.d_data.hierarchy.getParent(action);
        }
        this.setCurrentBehavior(behavior, action);
    }

    protected void setCurrentBehavior(Behavior behavior, IBehaviorAction insertAfterAction) {
        if (!this.lock()) {
            return;
        }
        this.d_currentBehavior = behavior;
        this.d_insertAfterAction = insertAfterAction;
        this.firePropChanged(BEHAVIOR_CHANGED);
        this.release();
    }

    public Behavior getCurrentBehavior() {
        return this.d_currentBehavior;
    }

    public IBehaviorAction getInsertAfterAction() {
        return this.d_insertAfterAction;
    }

    public void cancel() {
        this.reset();
        this.firePropChanged(CANCELLED);
    }

    public abstract boolean isValid();

    public void commit(Component c) {
        assert (this.d_currentBehavior != null);
        if (!this.isValid()) {
            return;
        }
        final IBehaviorAction newAction = this.create();
        AMerlinOp op = new AMerlinOp(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(MerlinApp app, MerlinData md) {
                md.beginWrite();
                try {
                    Undo.begin(Intl.intl("Add Action"));
                    IBehaviorAction insertAfter = ABehaviorActionBuilder.this.d_insertAfterAction;
                    if (newAction.isTerminal()) {
                        Iterator<IBehaviorAction> iterator = ABehaviorActionBuilder.this.d_currentBehavior.flatten(IBehaviorAction.class).iterator();
                        while (iterator.hasNext()) {
                            IBehaviorAction ba;
                            insertAfter = ba = iterator.next();
                        }
                    }
                    int ix = 0;
                    for (IBehaviorAction ba : ABehaviorActionBuilder.this.d_currentBehavior.getMembers(IBehaviorAction.class)) {
                        if (ba.isTerminal()) break;
                        ++ix;
                        if (ba != insertAfter) continue;
                        break;
                    }
                    AddObject.add((MerlinData)md, (Composite)ABehaviorActionBuilder.this.d_currentBehavior, (int)ix, (ICompElement[])new IBehaviorAction[]{newAction});
                    Undo.end(md);
                }
                finally {
                    md.endWrite();
                }
                ABehaviorActionBuilder.this.reset();
            }
        };
        UIHook.run(c, "ABehaviorActionBuilder.commit", op, 4);
        this.firePropChanged(COMMITTED);
    }
}

