/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.geomops;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import merlin.Intl;
import merlin.actions.ConvertToRoom;
import merlin.actions.UIHook;
import merlin.actions.geomops.ANewGeomBoolOp;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.geom.Geometry;
import thunderheadeng.util.LinkedIdentityHashSet;

public class MergeGeom
extends ANewGeomBoolOp {
    public static final UIHook UI_HOOK = new UIHook(new MergeGeom(), Intl.intl("&Merge,M,Merge Selected Rooms,Merge the selected, touching rooms into one."));

    @Override
    protected String getOpName() {
        return Intl.intl("Merge");
    }

    @Override
    protected boolean performOp(Set<? extends IEgressOccupiable> selGeom, Collection<IEgressComp> resultToAdd, Collection<IEgressOccupiable> resultToRemove, Consumer<EgressRoom> toClean) {
        LinkedIdentityHashSet open = new LinkedIdentityHashSet();
        for (IEgressOccupiable iEgressOccupiable : selGeom) {
            ConvertToRoom.ConvertedRoom cr = ConvertToRoom.convertToRoom(iEgressOccupiable, true, selGeom);
            if (cr == null) continue;
            open.add(cr);
        }
        if (open.size() <= 1) {
            return false;
        }
        boolean overallModified = false;
        while (!open.isEmpty()) {
            ConvertToRoom.ConvertedRoom convertedRoom = (ConvertToRoom.ConvertedRoom)open.iterator().next();
            open.remove(convertedRoom);
            LinkedIdentityHashSet<ConvertToRoom.ConvertedRoom> merged = new LinkedIdentityHashSet<ConvertToRoom.ConvertedRoom>();
            merged.add(convertedRoom);
            boolean modified = true;
            while (modified) {
                modified = false;
                Iterator mergeIt = open.iterator();
                while (mergeIt.hasNext()) {
                    ConvertToRoom.ConvertedRoom nextMergeRoom = (ConvertToRoom.ConvertedRoom)mergeIt.next();
                    if (!convertedRoom.room.getModificationsAllowed() || !convertedRoom.room.add(nextMergeRoom.room)) continue;
                    modified = true;
                    mergeIt.remove();
                    merged.add(nextMergeRoom);
                }
            }
            if (merged.size() <= 1) continue;
            overallModified = true;
            MergeGeom.applyProps(convertedRoom.room, merged);
            resultToAdd.add(convertedRoom.room);
            toClean.accept(convertedRoom.room);
            for (ConvertToRoom.ConvertedRoom mergedRoom : merged) {
                resultToRemove.add(mergedRoom.source);
                resultToAdd.addAll(mergedRoom.doors);
            }
        }
        return overallModified;
    }

    private static void applyProps(IEgressOccupiable room, Collection<ConvertToRoom.ConvertedRoom> merged) {
        IEgressOccupiable baseGeom = MergeGeom.getBaseGeom(merged);
        room.setName(baseGeom.getName());
        room.setColor(baseGeom.getColor());
        room.setOpacity(baseGeom.getOpacity());
        room.setVisible(baseGeom.isVisible());
    }

    private static IEgressOccupiable getBaseGeom(Collection<ConvertToRoom.ConvertedRoom> mergedGeoms) {
        IEgressOccupiable largest = null;
        double maxArea = -1.7976931348623157E308;
        for (ConvertToRoom.ConvertedRoom cr : mergedGeoms) {
            double area;
            if (!(cr.source instanceof EgressRoom) || !((area = ((EgressRoom)cr.source).getArea().getValue(Geometry.AREA_UNIT)) > maxArea)) continue;
            maxArea = area;
            largest = cr.source;
        }
        if (largest != null) {
            return largest;
        }
        return mergedGeoms.iterator().next().source;
    }
}

