/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.copypaste;

import inferno.data2.ElevatorLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import merlin.EntryPoint;
import merlin.EntryPointFactory;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.INamed;
import merlin.data.MerlinData;
import merlin.data.OccGroupObj;
import merlin.data.egress.FloorComposite;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.elevators.ElevatorGroup;
import merlin.data.egress.elevators.ElevatorRoot;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.IBehaviorAction;
import thunderheadeng.gui.IDomainObject;

public class PasteHandlerUtil {
    public static boolean isGeomRoot(String mdRootClassName) {
        return GeomComposite.class.getName().equals(mdRootClassName) || FloorComposite.class.getName().equals(mdRootClassName) || ElevatorRoot.class.getName().equals(mdRootClassName);
    }

    public static Composite<ICompElement> getGeomRoot(MerlinData md, String mdRootClassName) {
        ElevatorRoot root;
        if (GeomComposite.class.getName().equals(mdRootClassName)) {
            root = md.sceneGeom;
        } else if (FloorComposite.class.getName().equals(mdRootClassName)) {
            root = md.floors;
        } else if (ElevatorRoot.class.getName().equals(mdRootClassName)) {
            root = md.elevators;
        } else {
            throw new IllegalArgumentException("No root for " + mdRootClassName);
        }
        return root;
    }

    public static Composite<ICompElement> getDefaultRoot(MerlinData md, Map.Entry<IDomainObject, String> pasteEntry) {
        IDomainObject pasteObj = pasteEntry.getKey();
        String mdRootClassName = pasteEntry.getValue();
        if (PasteHandlerUtil.isGeomRoot(mdRootClassName)) {
            return PasteHandlerUtil.getGeomRoot(md, mdRootClassName);
        }
        EntryPoint<IDomainObject> ep = EntryPointFactory.get(pasteObj);
        return ep.getRootComposite(md, pasteEntry.getKey());
    }

    public static void pasteInto(MerlinData md, Composite dest, Map.Entry<IDomainObject, String> pasteEntry) {
        Undo.AddOp op = new Undo.AddOp(dest, Arrays.asList(pasteEntry.getKey()));
        Undo.insertEntry(md, op.perform(md.selection));
    }

    public static boolean compositeCanContain(Composite comp, IDomainObject obj) {
        if (OccGroupObj.class.isAssignableFrom(comp.getClass())) {
            return false;
        }
        if (ElevatorGroup.class.isAssignableFrom(obj.getClass()) && !ElevatorRoot.class.isAssignableFrom(comp.getClass())) {
            return false;
        }
        if (ElevatorGroup.class.isAssignableFrom(comp.getClass()) && !Elevator.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        HashMap<Class, Class> exclusiveParentChildMap = new HashMap<Class, Class>();
        exclusiveParentChildMap.put(Behavior.class, IBehaviorAction.class);
        exclusiveParentChildMap.put(Elevator.class, ElevatorLevel.class);
        for (Map.Entry entry : exclusiveParentChildMap.entrySet()) {
            Class parentClass = (Class)entry.getKey();
            Class childClass = (Class)entry.getValue();
            if (parentClass.isAssignableFrom(comp.getClass()) && !childClass.isAssignableFrom(obj.getClass())) {
                return false;
            }
            if (!childClass.isAssignableFrom(obj.getClass()) || parentClass.isAssignableFrom(comp.getClass())) continue;
            return false;
        }
        return true;
    }

    private static Composite getDeepestComposite(IDomainObject pasteObj, Object[] path) {
        Composite deepest = null;
        for (Object obj : path) {
            if (!(obj instanceof Composite) || !PasteHandlerUtil.compositeCanContain((Composite)obj, pasteObj)) continue;
            deepest = (Composite)obj;
        }
        return deepest;
    }

    public static Composite getBestPasteTarget(MerlinData md, IDomainObject pasteObj, Composite defaultRoot, Collection<Composite<ICompElement>> selectedComposites, Collection<IMerlinObj> selectedLeaves) {
        HashSet<IMerlinObj> potentialTargets = new HashSet<IMerlinObj>();
        potentialTargets.add(defaultRoot);
        potentialTargets.addAll(selectedComposites);
        potentialTargets.addAll(selectedLeaves);
        HashMap<Composite, Object[]> compatTargets = new HashMap<Composite, Object[]>();
        for (Object e : potentialTargets) {
            Composite deepestComp;
            Object[] path = md.hierarchy.getPath(e);
            if (path == null || path.length <= 1 || path[1] != defaultRoot || (deepestComp = PasteHandlerUtil.getDeepestComposite(pasteObj, path)) == null) continue;
            compatTargets.put(deepestComp, md.hierarchy.getPath(deepestComp));
        }
        ArrayList sortedTargets = new ArrayList(compatTargets.keySet());
        Collections.sort(sortedTargets, (a, b) -> {
            Object[] pathToA = (Object[])compatTargets.get(a);
            Object[] pathToB = (Object[])compatTargets.get(b);
            return Integer.compare(pathToB.length, pathToA.length);
        });
        return compatTargets.isEmpty() ? null : (Composite)sortedTargets.get(0);
    }

    public static void renamePasteObj(Collection<INamed> siblingsToBe, IDomainObject pasteObj) {
        if (pasteObj instanceof INamed) {
            HashSet<String> inUseNames = new HashSet<String>();
            for (INamed siblingToBe : siblingsToBe) {
                inUseNames.add(siblingToBe.getName());
            }
            String srcName = ((INamed)((Object)pasteObj)).getName();
            String dstName = srcName;
            if (inUseNames.contains(dstName)) {
                dstName = String.format("%s - Copy", srcName);
            }
            int n = 2;
            while (inUseNames.contains(dstName)) {
                dstName = String.format("%s - Copy (%d)", srcName, n);
                ++n;
            }
            ((INamed)((Object)pasteObj)).setName(dstName);
        }
    }
}

