/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions.copypaste;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.TransformAction;
import merlin.actions.Undo;
import merlin.actions.copypaste.PasteHandler;
import merlin.actions.copypaste.PasteHandlerUtil;
import merlin.actions.copypaste.PasteHints;
import merlin.actions.importgeom.ImportUtil;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.egress.elevators.ElevatorRoot;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.material.Material;
import merlin.geom.IMerlinGeomSrc;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.gui.IDomainObject;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Warning;

public class GeomPasteHandler
implements PasteHandler {
    @Override
    public boolean isHandlerFor(IDomainObject obj, String mdRootClassName) {
        return GeomComposite.class.getName().equals(mdRootClassName) || ElevatorRoot.class.getName().equals(mdRootClassName);
    }

    @Override
    public PasteHints getPasteHints(MerlinData md, Map<IDomainObject, String> pasteObjMap, IDomainObject pasteObj) {
        PasteHints hints = new PasteHints();
        AABoxTest test = new AABoxTest(GeomPasteHandler.getBounds(pasteObj), 1.0E-6);
        final ArrayList hitComps = new ArrayList();
        IResult<IDisplayableGeomSrc> result = new IResult<IDisplayableGeomSrc>(){

            @Override
            public void mark(IDisplayableGeomSrc src, Containment ctmt) {
                if (src instanceof IEgressComp) {
                    hitComps.add((IEgressComp)src);
                }
            }
        };
        md.geomLocation.getLocator().find(test, (IResult<? super IDisplayableGeomSrc>)result, 3);
        hints.geomTransformShouldPrompt = !hitComps.isEmpty();
        return hints;
    }

    private static AABox getBounds(IDomainObject<MerlinData> obj) {
        Collection<IMerlinGeomSrc> elems = GeomPasteHandler.flattenToType(obj, IMerlinGeomSrc.class);
        AABox bounds = new AABox();
        for (IMerlinGeomSrc elem : elems) {
            bounds.add(elem.getBounds());
        }
        return bounds;
    }

    private static <T> Collection<T> flattenToType(IDomainObject<MerlinData> obj, Class<T> type) {
        if (obj instanceof Composite) {
            return ((Composite)obj).flatten(type);
        }
        if (obj != null && type.isAssignableFrom(obj.getClass())) {
            return Arrays.asList(obj);
        }
        assert (false) : "Unknown geom element: " + obj.getClass();
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pasteApply(MerlinData md, MerlinApp app, Map<IDomainObject, String> pasteObjMap, Map.Entry<IDomainObject, String> pasteEntry, PasteHints hints, Collection<IDomainObject> selectAccum, Collection<Composite<ICompElement>> selectedComposites, Collection<IMerlinObj> selectedLeaves, Collection<Warning> warnings) {
        Composite<ICompElement> defaultRoot;
        IDomainObject pasteObj = pasteEntry.getKey();
        Composite insertRoot = PasteHandlerUtil.getBestPasteTarget(md, pasteObj, defaultRoot = PasteHandlerUtil.getDefaultRoot(md, pasteEntry), selectedComposites, selectedLeaves);
        if (insertRoot == null) {
            System.err.printf("[WARN] [%s] unable to find valid insert location: %s%n", this.getClass().getName(), pasteObj);
            return;
        }
        Collection<IMerlinObj> geomObjs = GeomPasteHandler.flattenToType(pasteObj, IMerlinObj.class);
        IdentityHashSet<Material> usedMats = new IdentityHashSet<Material>();
        ImportUtil.getUsedMaterials(geomObjs, usedMats);
        md.beginWrite();
        try {
            Undo.begin(Intl.intl("Set Offset"));
            for (Material mat : usedMats) {
                if (md.materials.isLocal(mat)) continue;
                md.materials.add(mat);
            }
            PasteHandlerUtil.pasteInto(md, insertRoot, pasteEntry);
            ArrayList toClean = new ArrayList();
            TransformAction.transform(app, md, toClean::add, geomObjs, 0, hints.geomTransform);
            EgressRoom.cleanup(md, toClean);
            selectAccum.add(pasteObj);
            Undo.end(md);
        }
        finally {
            md.endWrite();
        }
    }
}

