/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.Set;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.geom.IEgressOccupiable;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.LinkedIdentityHashSet;

public class SelectOccupants
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new SelectOccupants(), Intl.intl("Select Occupants"));

    public SelectOccupants() {
        SelectionObserver.add(this, IEgressOccupiable.class);
        this.update(null);
    }

    @Override
    public void run(MerlinApp app, MerlinData md) {
        Set<IEgressOccupiable> ieComps = md.selection.getDeepSelected(IEgressOccupiable.class);
        Set<EgressAgent> occs = SelectOccupants.getOccupantsInNodes(md, ieComps);
        md.selection.clear();
        md.selection.selectAll(occs);
    }

    public static Set<EgressAgent> getOccupantsInNodes(MerlinData md, Set<IEgressOccupiable> nodes) {
        LinkedIdentityHashSet<EgressAgent> occs = new LinkedIdentityHashSet<EgressAgent>();
        for (IEgressOccupiable room : nodes) {
            occs.addAll(room.getOccupants());
        }
        return occs;
    }

    @Override
    public void update(Events events) {
        MerlinApp app = MerlinApp.getApp();
        MerlinData data = app.getData();
        MerlinSelectionModel sel = data.selection;
        this.setEnabled(!sel.isDeepEmpty(IEgressOccupiable.class));
    }
}

