/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Dimension;
import java.awt.Window;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.AddOccupants;
import merlin.actions.OccGenerator;
import merlin.actions.SelectOccupants;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccLocation;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.gui.guiUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Pair;

public class RandomizeOccPositions
extends AMerlinOp
implements IEventObserver {
    public static final UIHook UI_HOOK = new UIHook(new RandomizeOccPositions(), Intl.intl("Randomize Occupants' Positions..."));
    private Random d_rgen = new Random(0L);
    private static PlacementDialog s_placementDialog;

    public RandomizeOccPositions() {
        SelectionObserver.add(this, IEgressOccupiable.class);
        this.update(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        PlacementDialog dlg = RandomizeOccPositions.getPlacementDialog(app.getActiveFrame());
        if (dlg.doModal() == 1) {
            Set<IEgressOccupiable> ieComps = md.selection.getDeepSelected(IEgressOccupiable.class);
            Set<EgressAgent> allOccs = SelectOccupants.getOccupantsInNodes(md, ieComps);
            LinkedHashSet<OccProfile> profiles = new LinkedHashSet<OccProfile>();
            LinkedHashMap<EgressAgent, OccLocation> locMap = new LinkedHashMap<EgressAgent, OccLocation>();
            LinkedHashMap<EgressAgent, Long> orientSeedMap = new LinkedHashMap<EgressAgent, Long>();
            for (EgressAgent occ : allOccs) {
                profiles.add(occ.getProfile().getProfParent());
                locMap.put(occ, occ.getLocInfo());
                orientSeedMap.put(occ, occ.getOrientSeed());
            }
            md.beginWrite();
            try {
                BiFunction<Set, Set, Boolean> randomize = (comps, occs) -> {
                    OccGenerator occGenerator = new OccGenerator(md, this.d_rgen, OccGenerator.getModels(comps), OccGenerator.getMaxDiam(profiles), AddOccupants.searchTimeout, 400, null, null);
                    boolean success = occGenerator.generate(occs.size(), dlg.getSpacing(), 2, (Collection<EgressAgent>)occs);
                    return success;
                };
                Undo.begin(Intl.intl("Randomize Occupants' Positions"));
                Undo.insertUndoEntry_restore(md, allOccs);
                boolean success = true;
                if (dlg.stayInRooms()) {
                    for (IEgressOccupiable room : ieComps) {
                        if (!(success &= randomize.apply(Collections.singleton(room), room.getOccupants()).booleanValue())) break;
                    }
                } else {
                    success &= randomize.apply(ieComps, allOccs).booleanValue();
                }
                if (!success) {
                    SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(app.getMainFrame(), Intl.intl("Pathfinder was unable to randomize occupants' positions without overlap."), Intl.intl("Failed to Randomize Occupants' Positions"), 2));
                    for (EgressAgent occ : allOccs) {
                        occ.setLocation((OccLocation)locMap.get(occ));
                        occ.setOrientSeed((Long)orientSeedMap.get(occ));
                    }
                    Undo.clearCurrentOp();
                }
                Undo.end(md);
            }
            finally {
                md.endWrite();
            }
        }
    }

    @Override
    public void update(Events events) {
        MerlinApp app = MerlinApp.getApp();
        MerlinData data = app.getData();
        MerlinSelectionModel sel = data.selection;
        IFilteredCollection<IEgressOccupiable> rooms = sel.flatten(IEgressOccupiable.class, r -> !r.getOccupants().isEmpty());
        this.setEnabled(!rooms.isEmpty());
    }

    public static PlacementDialog getPlacementDialog(Window owner) {
        if (s_placementDialog == null) {
            s_placementDialog = new PlacementDialog(owner);
        }
        return s_placementDialog;
    }

    private static class PlacementDialog
    extends guiDialog {
        private final guiRadioButton rbUniform;
        private final guiRadioButton rbRandom;
        private final guiRadioButton rbCurrentRoom;
        private final guiRadioButton rbAnyRoom;

        public PlacementDialog(Window owner) {
            super(owner, Intl.intl("Randomize Occupants' Positions"), 9);
            Pair<guiRadioButton, guiRadioButton> placementBtns = guiUtil.createPlacementButtons();
            this.rbUniform = (guiRadioButton)placementBtns.v1;
            this.rbRandom = (guiRadioButton)placementBtns.v2;
            Dimension d = this.rbRandom.getPreferredSize();
            d.width = (int)((double)d.width * 1.2);
            this.rbRandom.setPreferredSize(d);
            this.rbCurrentRoom = new guiRadioButton(Intl.intl("Reposition within Current Room"), true);
            this.rbAnyRoom = new guiRadioButton(Intl.intl("Reposition within Any Selected Room"), false);
            new guiButtonGroup(this.rbCurrentRoom, this.rbAnyRoom);
            GridBagHelper gb = new GridBagHelper(this.getDialogPane());
            gb.addRow(Intl.intl("Occupant Room:"));
            gb.addIdentRow(this.rbCurrentRoom);
            gb.addIdentRow(this.rbAnyRoom);
            gb.addRow(Intl.intl("Occupant Position:"));
            gb.addIdentRow(this.rbRandom);
            gb.addIdentRow(this.rbUniform);
            gb.finalizeRows();
        }

        public int getSpacing() {
            return this.rbUniform.isSelected() ? 0 : 1;
        }

        public boolean stayInRooms() {
            return this.rbCurrentRoom.isSelected();
        }
    }
}

