/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.util.Set;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.MerlinOp;
import merlin.actions.SelectionObserver;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.camera.Camera;
import merlin.data.camera.CameraList;
import merlin.mv.ModelView;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class NewViewFromCamera
extends AMerlinOp
implements IEventObserver {
    public static final UIHook MENU_HOOK = new UIHook((MerlinOp)new NewViewFromCamera(true), Intl.intl("New View,-,Add a view initialized to the current perspective view."), EntryPointFactory.cameraIcon);
    public static final UIHook CONTEXT_HOOK = new UIHook((MerlinOp)new NewViewFromCamera(false), Intl.intl("New View,-,Add a view initialized to the current perspective view."), EntryPointFactory.cameraIcon);
    private final boolean d_mainMenu;

    public NewViewFromCamera(boolean mainMenu) {
        this.d_mainMenu = mainMenu;
        if (!this.d_mainMenu) {
            SelectionObserver.add(this, CameraList.class);
            this.update(null);
        }
    }

    @Override
    public void update(Events events) {
        MerlinData md = MerlinApp.getApp().getData();
        this.setEnabled(md.selection.isExclusive(CameraList.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        CameraRecord state = md.ui(() -> {
            ModelView mv = app.getModelView();
            thunderheadeng.scene3d.nativebuffered.Camera mvcam = mv.getPredefCamera(3);
            return mvcam.capture();
        });
        md.beginWrite();
        Undo.begin(Intl.intl("Add View"));
        try {
            Set selCamGroups;
            CameraList group = null;
            if (!this.d_mainMenu && !(selCamGroups = md.selection.getSelected(CameraList.class)).isEmpty()) {
                group = (CameraList)selCamGroups.iterator().next();
            }
            if (group == null) {
                group = md.cameras;
            }
            Camera newCamera = new Camera(md.cameraNameGen.getCurrentName());
            md.cameraNameGen.nextName();
            newCamera.setCameraState(state);
            Undo.insertUndoEntry_delete(md, group, newCamera);
            group.add(newCamera);
            md.selection.set(newCamera);
        }
        finally {
            Undo.end(md);
            md.endWrite();
        }
    }
}

