/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import javax.swing.Icon;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.MerlinOp;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.unitsystem.EnglishUS;
import merlin.unitsystem.SIUS;

public class New
extends AMerlinOp {
    public static final Icon ICON = UIHook.loadIcon("thunderheadeng/gui/graphics/New16.gif");
    public static final UIHook UI_HOOK = new UIHook((MerlinOp)new New(), Intl.intl("&New,N,New Model,Create a new model"), ICON);

    @Override
    public void run(MerlinApp app, MerlinData md) {
        if (!app.promptSaveIfModified()) {
            return;
        }
        New.newModel(app, md);
    }

    public static boolean newModel(MerlinApp app, MerlinData md) {
        app.getModelView().getRenderComp().pauseRender();
        md.beginWrite();
        try {
            Undo.insertEntry_breakChain(md);
            String unitSystemPref = MerlinPrefs.getString(MerlinPrefs.KEY_UNITSYSTEM_PROP);
            if (unitSystemPref != null && unitSystemPref.equals(EnglishUS.getInstance().getSystemName())) {
                app.getData().setUnitSystem(EnglishUS.getInstance());
            } else {
                app.getData().setUnitSystem(SIUS.getInstance());
            }
            md.reset();
        }
        finally {
            md.endWrite();
        }
        app.getModelView().reset();
        app.getModelView().getRenderComp().resumeRender(true);
        return true;
    }
}

