/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.data.MerlinData;
import merlin.data.SimParams;
import merlin.gui.EditSimParamsDlg;
import thunderheadeng.units.UnitDouble;

public class EditSimParams
extends AMerlinOp {
    public static final UIHook UI_HOOK = new UIHook(new EditSimParams(), Intl.intl("Simulation &Parameters...,-,Edit Simulation Parameters"));
    private EditSimParamsDlg d_dlg = null;

    @Override
    public void run(MerlinApp app, MerlinData md) {
        if (this.d_dlg == null) {
            this.d_dlg = new EditSimParamsDlg(app.getMainFrame());
        }
        SimParams p = md.simParams;
        this.d_dlg.load(p);
        if (this.d_dlg.doModal() == 1 && this.d_dlg.isModified()) {
            boolean meAngleChanged;
            boolean oldMaxEdgeFlag = p.maxEdgeLengthFlag;
            UnitDouble oldMaxEdgeLen = p.maxEdgeLength;
            double oldMinAngle = p.minAngle;
            md.beginWrite();
            this.d_dlg.store(p);
            md.endWrite();
            md.pauseUpdates();
            md.getEvents().changed(md, MerlinData.SIM_PARAMS_CHANGED);
            boolean meFlagChanged = p.maxEdgeLengthFlag != oldMaxEdgeFlag;
            boolean meLenChanged = !p.maxEdgeLength.equals(oldMaxEdgeLen);
            boolean bl = meAngleChanged = p.minAngle != oldMinAngle;
            if (meFlagChanged || p.maxEdgeLengthFlag && (meLenChanged || meAngleChanged)) {
                md.getEvents().changed(md, MerlinData.MESH_CHANGED);
            }
            md.resumeUpdates();
        }
    }
}

