/*
 * Decompiled with CFR 0.152.
 */
package merlin.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.image.BGImage;
import merlin.data.image.ImageGroup;
import merlin.data.image.RasterImage;
import merlin.geom.Geometry;
import merlin.gui.guiUtil;
import merlin.mv.MerlinColors;
import thunderheadeng.geometry.objs.BGImageXform;
import thunderheadeng.image.IImage;
import thunderheadeng.image.Image;
import thunderheadeng.image.ImageManager;
import thunderheadeng.scene3d.IntermediateGraphicsXfer;
import thunderheadeng.scene3d.gui.BGImageDlg;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;

public class AddBGImage
extends AMerlinOp {
    public static final UIHook UI_HOOK = new UIHook(new AddBGImage(), Intl.intl("Add a Background Image..."));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(MerlinApp app, MerlinData md) {
        IntermediateGraphicsXfer igx = new IntermediateGraphicsXfer();
        try {
            UnitDouble defZ = md.activeFloor().getWorkingZ();
            BGImageDlg.ImageInfo info = md.ui(() -> AddBGImage.newBGImage(app.getMainFrame(), defZ, igx));
            if (info == null) {
                return;
            }
            BGImage newImg = new BGImage(info.image.getFilename(), info.image);
            AddBGImage.applyBGInfo(newImg, info);
            md.beginWrite();
            try {
                Undo.begin(Intl.intl("New Image"));
                AddBGImage.addBGImage(md, newImg);
                Undo.end(md);
            }
            finally {
                md.endWrite();
            }
        }
        finally {
            igx.release();
        }
    }

    public static BGImageDlg.ImageInfo newBGImage(Window parent, UnitDouble defZ, IntermediateGraphicsXfer<String> igx) {
        return AddBGImage.showBGImageDlg(parent, null, igx, defZ);
    }

    public static BGImageDlg.ImageInfo editBGImage(Window parent, BGImage img, IntermediateGraphicsXfer<String> igx) {
        double defZ = img.getAnchorModel().z();
        return AddBGImage.showBGImageDlg(parent, img, igx, new UnitDouble(defZ, Geometry.LENGTH_UNIT));
    }

    private static BGImageDlg.ImageInfo showBGImageDlg(Window parent, BGImage img, IntermediateGraphicsXfer<String> igx, UnitDouble defZ) {
        MerlinApp app = MerlinApp.getApp();
        HashMap<BGImageDlg.Colors, IPropertySet.Prop<Color>> colorMap = new HashMap<BGImageDlg.Colors, IPropertySet.Prop<Color>>();
        colorMap.put(BGImageDlg.Colors.AXIS, MerlinColors.AXIS_COLOR);
        colorMap.put(BGImageDlg.Colors.AXIS_BOX, MerlinColors.AXIS_BOX_COLOR);
        colorMap.put(BGImageDlg.Colors.AXIS_TEXT, MerlinColors.AXIS_TEXT_COLOR);
        colorMap.put(BGImageDlg.Colors.BACKGROUND, MerlinColors.BACKGROUND_COLOR);
        colorMap.put(BGImageDlg.Colors.ORIGIN, MerlinColors.ORIGIN2D_COLOR);
        ImageLoader imgLoader = new ImageLoader(defZ);
        BGImageDlg.ImageInfo existing = null;
        if (img != null) {
            existing = new BGImageDlg.ImageInfo(img.getImage(), img.getTransformInfo(), img.getOpacity());
        }
        return BGImageDlg.editImage(parent, app.getModelView().getRenderComp(), app.getColorManager(), colorMap, imgLoader, app.getUnitSystem().getLength(), igx, existing);
    }

    public static void applyBGInfo(BGImage img, BGImageDlg.ImageInfo info) {
        img.setImage(info.image);
        img.setFilename(info.image.getFilename());
        img.setTransformInfo(info.xform.anchorImage, new UnitPoint3D(info.xform.anchorModel, Geometry.LENGTH_UNIT), info.xform.aImage, info.xform.bImage, new UnitDouble(info.xform.distABModel, Geometry.LENGTH_UNIT), new UnitDouble(info.xform.abAngle, Geometry.ANGLE_UNIT));
        img.setOpacity(info.opacity);
    }

    public static void addBGImage(MerlinData md, RasterImage image) {
        ImageGroup ig = AddBGImage.getBGGroup(md);
        Undo.insertUndoEntry_delete(md, ig, image);
        ig.add(image);
        md.selection.set(image);
    }

    private static ImageGroup getBGGroup(MerlinData md) {
        Collection<ImageGroup> igroups = md.sceneGeom.getMembers(ImageGroup.class);
        if (!igroups.isEmpty()) {
            return igroups.iterator().next();
        }
        ImageGroup ig = new ImageGroup();
        Undo.insertUndoEntry_delete(md, md.sceneGeom, ig);
        md.sceneGeom.insert(Arrays.asList(ig), 0);
        return ig;
    }

    private static class ImageLoader
    implements BGImageDlg.IImageLoader {
        private static final String[] FILTERS = new String[]{"bmp", Intl.intl("BMP Files"), "gif", Intl.intl("GIF Files"), "jpg", Intl.intl("JPEG Files"), "jpeg", Intl.intl("JPEG Files"), "jif", Intl.intl("JPEG Files"), "jpe", Intl.intl("JPEG Files"), "png", Intl.intl("PNG Files"), "tif", Intl.intl("TIF Files"), "tga", Intl.intl("TARGA Files"), "targa", Intl.intl("TARGA Files")};
        public final UnitDouble d_defZ;

        public ImageLoader(UnitDouble defZ) {
            this.d_defZ = defZ;
        }

        @Override
        public File choose(Component parent, File currFile) {
            return guiUtil.getOpenFile(parent, Optional.ofNullable(currFile).map(f -> f.getAbsolutePath()), MerlinPrefs.OPEN_DIR_PREF, FILTERS);
        }

        @Override
        public Pair<Image, BGImageXform> load(File file) throws IOException {
            String filename = file.getAbsolutePath();
            IImage img = ImageManager.getImage(filename);
            if (img == null) {
                throw new IOException(Intl.intl("Could not load image."));
            }
            BGImageXform xform = new BGImageXform(null, new Point3d(0.0, 0.0, this.d_defZ.getValue(Geometry.LENGTH_UNIT)), null, null, Double.NaN, 0.0);
            return new Pair<Image, BGImageXform>((Image)img, xform);
        }
    }
}

