/*
 * Decompiled with CFR 0.152.
 */
package merlin;

import java.util.Collection;
import java.util.Set;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.INameGenerator;
import merlin.data.MerlinData;
import merlin.treeview.TVEntryPoint;

public class EntryPoint<T> {
    public final Class<T> clazz;
    public final TVEntryPoint<T> tvEntryPoint;
    private final Getter<T, Collection<? extends IMerlinObj>> getOtherDeleteObjs;
    private final Action<T, Boolean, Object> delete;
    private final Action<T, Exception, Set<? extends IMerlinObj>> checkDelete;
    private final Getter<T, Boolean> isAutoDeleteGroup;
    private final Getter<T, Boolean> isVisible;
    private final Setter<T, Boolean> setVisible;
    private final Getter<T, Composite<? extends ICompElement>> getRootComposite;
    private final Getter<T, INameGenerator> getNameGenerator;

    public EntryPoint(Class<T> clazz, TVEntryPoint<T> tvEntryPoint, Action<T, Exception, Set<? extends IMerlinObj>> checkDelete, Getter<T, Collection<? extends IMerlinObj>> getOtherDeleteObjs, Action<T, Boolean, Object> delete, Getter<T, Boolean> isAutoDeleteGroup, Getter<T, Boolean> isVisible, Setter<T, Boolean> setVisible, Getter<T, Composite<? extends ICompElement>> getRootComposite, Getter<T, INameGenerator> getNameGenerator) {
        this.clazz = clazz;
        this.tvEntryPoint = tvEntryPoint;
        this.checkDelete = checkDelete;
        this.getOtherDeleteObjs = getOtherDeleteObjs;
        this.delete = delete;
        this.isAutoDeleteGroup = isAutoDeleteGroup;
        this.isVisible = isVisible;
        this.setVisible = setVisible;
        this.getRootComposite = getRootComposite;
        this.getNameGenerator = getNameGenerator;
    }

    public void checkDelete(MerlinData md, T obj, Set<? extends IMerlinObj> delObjs) throws Exception {
        Exception exp = this.checkDelete.perform(md, obj, delObjs);
        if (exp != null) {
            throw exp;
        }
    }

    public void getOtherDeleteObjs(MerlinData md, Set<IMerlinObj> otherObjs, T obj) {
        Collection<? extends IMerlinObj> others = this.getOtherDeleteObjs.get(md, obj);
        otherObjs.addAll(others);
    }

    public boolean delete(MerlinData md, T obj) {
        return this.delete.perform(md, obj, null);
    }

    public boolean isAutoDeleteGroup(MerlinData md, T obj) {
        return this.isAutoDeleteGroup.get(md, obj);
    }

    public boolean isVisible(MerlinData md, T obj) {
        return this.isVisible.get(md, obj);
    }

    public void setVisible(MerlinData md, T obj, boolean visible) {
        this.setVisible.set(md, obj, visible);
    }

    public Composite<? extends ICompElement> getRootComposite(MerlinData md, T obj) {
        return this.getRootComposite.get(md, obj);
    }

    public INameGenerator getNameGenerator(MerlinData md, T obj) {
        return this.getNameGenerator.get(md, obj);
    }

    public static interface Setter<T, ArgT>
    extends Func<T> {
        public void set(MerlinData var1, T var2, ArgT var3);
    }

    public static interface Action<T, ReturnT, ArgT>
    extends Func<T> {
        public ReturnT perform(MerlinData var1, T var2, ArgT var3);
    }

    public static interface Getter<T, ReturnT>
    extends Func<T> {
        public ReturnT get(MerlinData var1, T var2);
    }

    public static interface Func<T> {
    }
}

