/*
 * Decompiled with CFR 0.152.
 */
package inferno.util;

import inferno.data2.ANode;
import inferno.data2.ElevatorLevel;
import inferno.data2.ITimeEstimate;
import inferno.data2.WingedEdge;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;

public class ElevatorUtil {
    public static void processLevelForPickup(ElevatorLevel elevatorLevel, int nominalLoad) {
        for (WingedEdge we : elevatorLevel.pickupNode.getDoorEdges()) {
            ITimeEstimate.VariableOccSize nextOpenEst = new ITimeEstimate.VariableOccSize(elevatorLevel.pickupNode, nominalLoad, we.getDoorQueue());
            we.data.node.setClosed(nextOpenEst);
        }
    }

    public static Vector3d getTeleportVector(ANode a, ANode b) {
        AABox aBounds = a.getGeometryBounds();
        AABox bBounds = b.getGeometryBounds();
        Vector3d v = new Vector3d(bBounds.getMin());
        v.sub(aBounds.getMin());
        return v;
    }

    public static ITimeEstimate getDefaultTimeEstimate(ElevatorLevel elevLvl, ElevatorLevel dischargeLevel) {
        ITimeEstimate.Specific beforeAvail = new ITimeEstimate.Specific(elevLvl.tFirstAvailable);
        ITimeEstimate.FutureFixed openAtFloor = new ITimeEstimate.FutureFixed(beforeAvail, elevLvl.getPickupTimeTot(dischargeLevel));
        return openAtFloor;
    }
}

