/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering.inverse;

import common.geom.Trig;
import inferno.data2.IAgentBodyShape;
import inferno.data2.PolygonShape;
import inferno.geom.Inter;
import inferno.geom.Util;
import inferno.geom.WallSlider;
import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.sim.KnownFuncs;
import inferno.sim.OccAgent;
import inferno.sim.path.PathChange;
import inferno.sim.steering.inverse.InvSteerUtil;
import inferno.sim.steering.inverse.OccInfo;
import inferno.sim.steering.inverse.SeekInfo;
import inferno.sim.steering.inverse.Senses;
import java.io.Serializable;
import java.util.HashMap;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.util.theUtil;

public class AvoidWalls
implements Serializable {
    static final long serialVersionUID = 1L;
    private static final double COLLISION_RESPONSE_TIME = 2.0;
    private static final boolean USE_ACCURATE_COST = System.getProperty("AvoidWalls.ACCURATE_COST") != null;
    private static final boolean USE_SWENSON = System.getProperty("AvoidWalls.SWENSON") != null;
    private KB d_kb;
    private HashMap<Vector3d, Vector3d> goalOrients = new HashMap();
    private boolean isVehicle;

    public AvoidWalls(KB kb, OccInfo oi, Senses senses, SeekInfo seekInfo) {
        this.d_kb = kb;
        this.isVehicle = oi.oa.hasVehicle();
    }

    public static Vector3d adjustDir(KB kb, OccAgent agent, Senses senses, Vector3d dir) {
        WallSlider slideWalls = senses.getWallSlider();
        boolean normalize = !(agent.getOcc().bodyShape instanceof PolygonShape);
        Vector3d adjusted = slideWalls.slide(dir, normalize);
        Util.projectAlongZEq(agent.getOcc().tri.plane, adjusted);
        return adjusted;
    }

    public double[] getCost(KB kb, OccInfo oi, Senses senses, SeekInfo seekInfo, boolean separating, Vector3d dir, boolean isPreferredDir) {
        Senses.WallHit wallHit;
        if (isPreferredDir && dir != null && !(oi.oa.getOcc().bodyShape instanceof PolygonShape) && !oi.oa.hasTightGeomRepresentation()) {
            return new double[]{0.0, oi.cache.maxVel};
        }
        OccAgent oa = oi.oa;
        Point3d goal = seekInfo.seekCurve.get(1.0);
        double distToGoal = oa.getPos().distance(goal);
        if (dir != null && seekInfo.seekDir != null && !separating) {
            double dot = Math.abs(dir.dot(seekInfo.seekDir));
            distToGoal = theUtil.eq0(dot, 0.0) ? Double.POSITIVE_INFINITY : distToGoal / dot;
        }
        double sensingRadius = AvoidWalls.getSensingRadius(kb, oi, oa.getOcc().boundaryLayer);
        double maxT = Math.min(distToGoal, sensingRadius);
        Predicate<PathChange> pathFilter = seekInfo.transientPathFilter;
        IAgentBodyShape shape = oi.shapeGeom;
        double angle = 0.0;
        if (this.isVehicle && !oi.oa.getVehicle().getFreePass()) {
            if (dir == null) {
                return new double[]{0.0, oi.cache.maxVel};
            }
            Vector3d ref = oa.getDirFacing();
            angle = Inter.angleAbs(ref, dir);
            if (angle >= 1.5707963267948966 && (this.findRotationCollision(oa, dir, 0.0, maxT) || this.findRotationCollision(oa, dir, 1.0, maxT))) {
                Vector3d goalOrient = new Vector3d(dir);
                goalOrient.negate();
                this.goalOrients.put(dir, goalOrient);
            }
            if (angle < 1.5707963267948966 && this.findRotationCollision(oa, dir, 0.0, maxT)) {
                return new double[]{1.0, oi.cache.maxVel};
            }
            shape = oa.getVehicle().rotateShape((PolygonShape)shape, dir);
        }
        if ((wallHit = senses.senseNearestWallHit(kb, oa.getLoc(), dir, maxT, pathFilter, shape, oi.shapeGeomDefault)) == null || isPreferredDir && dir != null && wallHit.wall.isDoor() && wallHit.wall.data.node.isClosed(kb, oa)) {
            return new double[]{0.0, oi.cache.maxVel};
        }
        if (distToGoal < wallHit.dist) {
            return new double[]{0.0, oi.cache.maxVel};
        }
        if (sensingRadius < wallHit.dist) {
            return new double[]{0.0, oi.cache.maxVel};
        }
        if (!USE_ACCURATE_COST) {
            double vel = oi.cache.currVel;
            double minHitDist = AvoidWalls.getMinHitDist(kb, oi.oa, vel, false, oa.getOcc().boundaryLayer);
            double maxHitDist = !USE_SWENSON ? minHitDist + AvoidWalls.getMaxHitDist(kb, oi) : AvoidWalls.getMaxHitDistSwenson(kb, oi);
            double cost = InvSteerUtil.clampCost(KnownFuncs.linInterp(minHitDist, 1.0, maxHitDist, 0.0, wallHit.dist));
            if (this.isVehicle && dir != null && angle >= 1.5707963267948966) {
                cost = InvSteerUtil.clampCost(KnownFuncs.linInterp(minHitDist, 1.0, maxHitDist, 0.0, wallHit.dist));
                return new double[]{cost, oi.cache.maxVel};
            }
            double travelDist = Math.max(0.0, wallHit.dist - minHitDist);
            double speed = InvSteerUtil.getMaxVelToStop(kb, oi, travelDist);
            if (theUtil.le0(speed, 1.0E-6)) {
                if (this.isVehicle && oi.oa.getVehicle().getFreePass()) {
                    return new double[]{cost, oi.cache.maxVel};
                }
                return new double[]{1.0, 0.0};
            }
            if (!separating && seekInfo.seekDir != null && wallHit.wall != null && !this.isVehicle) {
                WallSlider slider = new WallSlider(wallHit.loc.p, seekInfo.transientPathFilter, wallHit.wall);
                Vector3d slideDir = slider.slide(dir, true);
                if (theUtil.le0(slideDir.dot(seekInfo.seekDir), 1.0E-6)) {
                    cost = 1.0;
                } else {
                    double dot = slideDir.dot(dir);
                    cost *= 1.0 - dot;
                }
            }
            return new double[]{cost, speed};
        }
        double hitDist = Math.max(0.0, wallHit.dist - (double)oa.getOcc().boundaryLayer);
        double[] cost = InvSteerUtil.getCost(kb, oi, hitDist);
        if (this.isVehicle && dir != null && angle >= 1.5707963267948966) {
            return new double[]{cost[0], oi.cache.maxVel};
        }
        if (theUtil.le0(cost[1], 1.0E-6)) {
            if (this.isVehicle && oi.oa.getVehicle().getFreePass()) {
                return new double[]{cost[0], oi.cache.maxVel};
            }
            return new double[]{1.0, 0.0};
        }
        if (!separating && seekInfo.seekDir != null && wallHit.wall != null && !this.isVehicle) {
            WallSlider slider = new WallSlider(wallHit.loc.p, seekInfo.transientPathFilter, wallHit.wall);
            Vector3d slideDir = slider.slide(dir, true);
            if (theUtil.le0(slideDir.dot(seekInfo.seekDir), 1.0E-6)) {
                cost[0] = 1.0;
            } else {
                double dot = slideDir.dot(dir);
                cost[0] = cost[0] * (1.0 - dot);
            }
        }
        return cost;
    }

    private boolean findRotationCollision(OccAgent agent, Vector3d dir, double speed, double maxT) {
        Engine.TIME_ACCUM.begin("findRotColWalls");
        Vector3d ref = new Vector3d(agent.getDirFacing());
        if (ref == null || dir == null) {
            Engine.TIME_ACCUM.end("findRotColWalls");
            return false;
        }
        double angle = Trig.angle(ref, dir);
        PolygonShape testShape = agent.getVehicle().rotateShape(ref);
        double rotAngle = 0.10471975511965977;
        rotAngle = angle > 0.0 ? rotAngle : -rotAngle;
        Vector3d shiftDir = new Vector3d(dir);
        shiftDir.scale(speed);
        double dist = 0.0;
        while (Math.abs(angle) > 1.0E-6 && Math.abs(angle) >= Math.abs(rotAngle) && dist < maxT) {
            Point3d newCenter = new Point3d(testShape.getCenter());
            newCenter.add(shiftDir);
            dist += newCenter.distance(testShape.getCenter());
            testShape = testShape.translateToAndRotate(newCenter, rotAngle);
            ref = testShape.getDir();
            angle = Trig.angle(ref, dir);
            if (Math.abs(angle) < Math.abs(rotAngle)) {
                rotAngle = angle;
            }
            if (!testShape.testCollisionWalls(this.d_kb, 0.0)) continue;
            Engine.TIME_ACCUM.end("findRotColWalls");
            return true;
        }
        Engine.TIME_ACCUM.end("findRotColWalls");
        return false;
    }

    public static double getSensingRadius(KB kb, OccInfo oi, double sepDist) {
        if (!USE_SWENSON) {
            return oi.shapeGeom.getEnclosingRadius() + AvoidWalls.getMinHitDist(kb, oi.oa, oi.cache.currVel, false, sepDist) + AvoidWalls.getMaxHitDist(kb, oi);
        }
        return oi.shapeGeom.getEnclosingRadius() + AvoidWalls.getMaxHitDistSwenson(kb, oi);
    }

    private static double getMinHitDist(KB kb, OccAgent oa, double vel, boolean separate, double sepDist) {
        double minHitDist = separate ? sepDist : 0.0;
        return minHitDist += OccAgent.calcStopDist(vel, oa.getMaxStopAccel(kb));
    }

    private static double getMaxHitDist(KB kb, OccInfo oi) {
        return Math.max(OccAgent.calcStopDist(oi.cache.maxVel, oi.oa.getMaxStopAccel(kb)), oi.cache.currVel * 2.0);
    }

    private static double getMaxHitDistSwenson(KB kb, OccInfo oi) {
        return Math.max(OccAgent.calcStopDist(oi.cache.maxVel, oi.oa.getMaxStopAccel(kb)), OccAgent.calcTravelDist(oi.cache.currVel, oi.cache.maxVel, oi.oa.getMaxStartAccel(kb), 2.0));
    }

    public Vector3d getGoalOrient(Vector3d key) {
        return this.goalOrients.get(key);
    }
}

