/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering;

import inferno.data2.ANode;
import inferno.data2.Mesh;
import inferno.data2.Occupant;
import inferno.data2.Tri;
import inferno.data2.TriEdge;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.data2.ai.ExitGoal;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.ExitSeek;
import inferno.sim.path.IPath;
import inferno.sim.path.IPathSeek;
import inferno.sim.path.Path;
import inferno.sim.path.PathChange;
import inferno.sim.path.PathGen;
import inferno.sim.path.WaypointSeek;
import inferno.sim.steering.IPathPlanner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Pair;

public class Shortest
implements Serializable,
IPathPlanner {
    static long serialVersionUID = 1L;
    private final List<? extends PathGen.IPathGoal> d_goals;
    private boolean d_firstGen = false;
    private Predicate<WingedEdge> d_edgeFilter;

    public Shortest(List<? extends PathGen.IPathGoal> goals) {
        this.d_goals = goals;
        this.d_edgeFilter = Filters.acceptAll();
    }

    public Shortest(PathGen.IPathGoal goal) {
        this(Arrays.asList(goal));
    }

    @Override
    public IPathPlanner.IStatus getStatus(KB kb, OccAgent agent) {
        return null;
    }

    @Override
    public void doorCrossed(double t, OccAgent agent, DoorQueue queue) {
    }

    public static List<PathGen.EdgeGoal> getExitGoals(KB kb, ExitGoal exit) {
        Mesh navMesh = kb.getMesh();
        ArrayList<WingedEdge> exitEdges = new ArrayList<WingedEdge>();
        if (exit.nodes != null) {
            for (ANode n : exit.nodes) {
                exitEdges.addAll(navMesh.getGoalEdges(n));
            }
        } else {
            exitEdges.addAll(navMesh.getGoalEdges(null));
        }
        ArrayList<PathGen.EdgeGoal> goals = new ArrayList<PathGen.EdgeGoal>(exitEdges.size());
        for (WingedEdge goalEdge : exitEdges) {
            goals.add(new PathGen.EdgeGoal(goalEdge));
        }
        return goals;
    }

    @Override
    public boolean update(KB kb, OccAgent oa, boolean forceNewPath) {
        return forceNewPath || !this.d_firstGen;
    }

    @Override
    public IPath getPath(KB kb, OccAgent oa, boolean forceNewPath) {
        TriPoint loc = oa.getLoc();
        double minDistToWall = oa.getGeometryRadius();
        double minD = Double.MAX_VALUE;
        IPath minPath = null;
        List minEdgePath = null;
        ArrayList<? extends PathGen.IPathGoal> sorted = new ArrayList<PathGen.IPathGoal>(this.d_goals);
        Collections.sort(sorted, new IncreasingDist(kb.getMesh(), oa.getGeometryRadius(), loc.p));
        Predicate<PathChange> pathFilter = oa.generatePathFilter(kb, Filters.acceptAll(Tri.class), EdgeFilters.acceptAll(), OccAgent.PathFilterType.LOCAL);
        for (PathGen.IPathGoal iPathGoal : sorted) {
            double len;
            Pair<IPath, List<TriEdge>> rawPath = Shortest.createPath(kb, oa, iPathGoal, minDistToWall, minD, pathFilter);
            if (rawPath == null || !((len = ((IPath)rawPath.v1).length(true)) < minD)) continue;
            minD = len;
            minPath = (IPath)rawPath.v1;
            minEdgePath = (List)rawPath.v2;
        }
        this.d_firstGen = true;
        if (minPath == null || minPath.getNumPoints(false) < 2) {
            return null;
        }
        assert (minEdgePath != null);
        this.d_edgeFilter = Shortest.createEdgeFilter(kb, oa, minEdgePath);
        return minPath;
    }

    @Override
    public Predicate<WingedEdge> getTransientEdgeFilter(KB kb, OccAgent agent) {
        return this.d_edgeFilter;
    }

    public static Predicate<PathChange> getPathFilter(KB kb, OccAgent agent) {
        return agent.generatePathFilter(kb, Filters.acceptAll(Tri.class), EdgeFilters.acceptAll(), OccAgent.PathFilterType.LOCAL);
    }

    public static Pair<IPath, List<TriEdge>> createPath(KB kb, OccAgent agent, PathGen.IPathGoal goal, double minDistToWall, double abortDist, Predicate<PathChange> pathFilter) {
        Occupant occ = agent.getOcc();
        Pair<List<TriPoint>, List<TriEdge>> pathGenRes = PathGen.getPath(kb.getMesh(), occ.tri, null, null, occ.loc, goal, minDistToWall, abortDist, pathFilter);
        if (pathGenRes == null || pathGenRes.v1 == null) {
            return null;
        }
        List pathPoints = (List)pathGenRes.v1;
        assert (!pathPoints.isEmpty());
        if (goal instanceof PathGen.PointGoal) {
            ArrayList<IPathSeek> seekPts = new ArrayList<IPathSeek>(pathPoints.size() + 1);
            for (int m = 0; m < pathPoints.size(); ++m) {
                seekPts.add(new WaypointSeek((TriPoint)pathPoints.get(m), EdgeFilters.acceptAll()));
            }
            seekPts.add(new WaypointSeek(((PathGen.PointGoal)goal).getTriPoint(), EdgeFilters.acceptAll()));
            return new Pair<IPath, List<TriEdge>>(new Path(seekPts), (List<TriEdge>)pathGenRes.v2);
        }
        if (goal instanceof PathGen.EdgeGoal) {
            PathGen.EdgeGoal eg = (PathGen.EdgeGoal)goal;
            ArrayList<IPathSeek> path = new ArrayList<IPathSeek>(pathPoints.size());
            for (int m = 0; m < pathPoints.size() - 1; ++m) {
                path.add(new WaypointSeek((TriPoint)pathPoints.get(m), EdgeFilters.acceptAll()));
            }
            path.add(new ExitSeek(kb.getMesh(), eg.edge, (TriPoint)pathPoints.get(pathPoints.size() - 1), agent.getGeometryRadius(), EdgeFilters.acceptAll()));
            return new Pair<IPath, List<TriEdge>>(new Path(path), (List<TriEdge>)pathGenRes.v2);
        }
        assert (false);
        return null;
    }

    public static Predicate<WingedEdge> createEdgeFilter(KB kb, OccAgent oa, List<TriEdge> edgePath) {
        IdentityHashSet allowedDoors = new IdentityHashSet(edgePath.size());
        for (TriEdge tedge : edgePath) {
            if (!tedge.edge.isDoor()) continue;
            allowedDoors.add(tedge.edge);
        }
        return EdgeFilters.filterDangerous(Filters.accept(allowedDoors), oa.getOcc().obeyOnewayDoors);
    }

    private static class IncreasingDist
    implements Comparator<PathGen.IPathGoal> {
        private final Mesh.SplitEdge[] d_sedges;
        private Point3d d_pt;

        public IncreasingDist(Mesh mesh, double radius, Point3d pt) {
            this.d_pt = pt;
            this.d_sedges = mesh.getShortenedEdges(radius);
        }

        @Override
        public int compare(PathGen.IPathGoal g1, PathGen.IPathGoal g2) {
            double d1 = g1.getMinDistance(this.d_sedges, this.d_pt);
            double d2 = g2.getMinDistance(this.d_sedges, this.d_pt);
            return Double.compare(d1, d2);
        }
    }
}

