/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.scripting;

import inferno.data2.ANode;
import inferno.data2.ITimeEstimate;
import inferno.data2.Region;
import inferno.sim.KB;
import inferno.sim.scripting.ScriptingUtil;
import java.io.Serializable;
import java.util.List;

public class GeomApi {
    public final ApiV1 v1;
    private KB d_kb;

    public GeomApi(KB kb) {
        this.d_kb = kb;
        this.v1 = new ApiV1();
    }

    public class ApiV1 {
        public Serializable find(String name) {
            return ScriptingUtil.find(name, obj -> {
                if (obj instanceof ANode) {
                    return ((ANode)obj).name;
                }
                if (obj instanceof Region) {
                    return ((Region)obj).name;
                }
                throw new IllegalArgumentException(obj.getClass().getName());
            }, GeomApi.this.d_kb.getNodes(), GeomApi.this.d_kb.getDensityRegions());
        }

        public List<Serializable> findAll(String regexName) {
            return ScriptingUtil.findAll(regexName, obj -> {
                if (obj instanceof ANode) {
                    return ((ANode)obj).name;
                }
                if (obj instanceof Region) {
                    return ((Region)obj).name;
                }
                throw new IllegalArgumentException(obj.getClass().getName());
            }, GeomApi.this.d_kb.getNodes(), GeomApi.this.d_kb.getDensityRegions());
        }

        public void open(ANode door) {
            door.setClosed(null);
        }

        public void close(ANode door) {
            door.setClosed(new ITimeEstimate.Offset(60.0));
        }
    }
}

