/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.path;

import inferno.data2.ANode;
import inferno.data2.Mesh;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.sim.path.IPathSeek;
import java.io.Serializable;
import java.util.function.Predicate;
import javax.vecmath.Vector3d;

public class WaypointSeek
implements IPathSeek,
Serializable {
    static final long serialVersionUID = 1L;
    private final TriPoint pt;
    private final Predicate<WingedEdge> edgeFilter;
    private double obstDist = Double.POSITIVE_INFINITY;
    private WingedEdge virtualDoor;

    public WaypointSeek(TriPoint pt, Predicate<WingedEdge> edgeFilter) {
        this(pt, edgeFilter, null);
    }

    public WaypointSeek(TriPoint pt, Predicate<WingedEdge> edgeFilter, WingedEdge virtualDoor) {
        this.pt = pt;
        this.edgeFilter = edgeFilter;
        this.virtualDoor = virtualDoor;
    }

    @Override
    public WaypointSeek clone() {
        try {
            WaypointSeek seek = (WaypointSeek)super.clone();
            return seek;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public TriPoint updateSeekPt(TriPoint currLoc, double radius, Mesh mesh) {
        return this.pt;
    }

    @Override
    public TriPoint getSeekPt() {
        return this.pt;
    }

    @Override
    public boolean updateVisibility(TriPoint currLoc, double radius, Mesh mesh) {
        this.obstDist = mesh.getPathObstructionDist(currLoc, this.pt, radius, this.edgeFilter);
        return this.isVisible();
    }

    @Override
    public double getObstructionDist() {
        return this.obstDist;
    }

    @Override
    public Vector3d getPredictDir() {
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[PathFollow$WaypointSeek: ");
        sb.append("isVisible=" + this.isVisible());
        sb.append(", pt=" + this.pt.p);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean isVirtual(ANode node) {
        if (this.virtualDoor == null) {
            return false;
        }
        return !node.getDoorEdges().contains(this.virtualDoor);
    }
}

