/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.path;

import inferno.data2.ANode;
import inferno.data2.Mesh;
import inferno.data2.SpeedModifier;
import inferno.data2.Tri;
import inferno.data2.TriEdge;
import inferno.data2.TriPoint;
import inferno.data2.Vertex;
import inferno.data2.WingedEdge;
import inferno.data2.WingedEdgeUse;
import inferno.geom.Inter;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.IPath;
import inferno.sim.path.IPathSeek;
import inferno.sim.path.Path;
import inferno.sim.path.PathChange;
import inferno.sim.steering.ITpSource;
import inferno.util.IdSet;
import inferno.util.Util;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector2d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.APredicate;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class PathGen
implements Serializable {
    static final long serialVersionUID = 1L;

    private PathGen() {
    }

    private static Point2d p2d(IPathSeek seek) {
        TriPoint tp = seek.getSeekPt();
        return new Point2d(tp.p.x, tp.p.y);
    }

    public static int prunePoints(KB kb, IPath path, int fromIx, boolean pruneDoors) {
        int startIx;
        WingedEdge edge;
        IPathSeek currSeek;
        Point2d curr;
        int nextIx;
        int ptCount = path.getNumPoints(false);
        if (ptCount == 0) {
            return -1;
        }
        if (fromIx >= ptCount - 2) {
            return ptCount - 1;
        }
        IPathSeek seek = path.pointAt(fromIx);
        Point2d from = PathGen.p2d(seek);
        WingedEdge e = Inter.getEdgeForTriPoint(seek.getSeekPt());
        boolean fromTransportDoor = e != null && e.isTransportDoor();
        for (nextIx = fromIx + 1; !(nextIx >= ptCount || !from.epsilonEquals(curr = PathGen.p2d(currSeek = path.pointAt(nextIx)), 1.0E-12) || fromTransportDoor && (edge = Inter.getEdgeForTriPoint(currSeek.getSeekPt())) != null && edge.isTransportDoor()); ++nextIx) {
        }
        if (nextIx == ptCount - 1) {
            return nextIx;
        }
        if (nextIx >= ptCount) {
            return ptCount - 1;
        }
        Point2d next = PathGen.p2d(path.pointAt(nextIx));
        Vector2d dir = Util2D.vector(from, next);
        double prevt = 1.0;
        for (int m = startIx = pruneDoors ? nextIx + 1 : nextIx; m < ptCount; ++m) {
            WingedEdge edge2;
            IPathSeek currSeek2 = path.pointAt(m);
            if (!pruneDoors && (edge2 = Inter.getEdgeForTriPoint(currSeek2.getSeekPt())) != null && edge2.isDoor()) {
                return m;
            }
            Point2d curr2 = PathGen.p2d(currSeek2);
            double t = Inter2D.nearestTOnLine(from, dir, curr2);
            if (theUtil.lt(t, prevt, 1.0E-9) || curr2.distanceSquared(Util2D.linePoint(from, dir, t)) > 1.0E-12) {
                return m - 1;
            }
            prevt = t;
        }
        return ptCount - 1;
    }

    public static IPath getPrunedPath(KB kb, IPath path, boolean pruneDoors) {
        int ptCount = path.getNumPoints(false);
        if (ptCount == 0) {
            return null;
        }
        ArrayList<IPathSeek> newPath = new ArrayList<IPathSeek>();
        newPath.add(path.pointAt(0));
        int fromix = 0;
        while (fromix < ptCount - 1) {
            int nextix = PathGen.prunePoints(kb, path, fromix, pruneDoors);
            if (nextix != fromix) {
                newPath.add(path.pointAt(nextix));
            }
            fromix = nextix;
        }
        if (newPath.size() < 2) {
            return null;
        }
        return new Path(newPath);
    }

    public static IPathGoal newEdgeGoal(WingedEdge ... edges) {
        return edges.length == 1 ? new EdgeGoal(edges[0]) : new MultiEdgeGoal(edges);
    }

    public static IPathGoal newEdgeGoal(Collection<WingedEdge> edges) {
        return edges.size() == 1 ? new EdgeGoal(edges.iterator().next()) : new MultiEdgeGoal(edges);
    }

    private static boolean isTravellable(Mesh.SplitEdge[] sedges, WingedEdge edge) {
        Mesh.SplitEdge sedge = sedges[edge.id];
        return sedge == null || sedge.isTravellable();
    }

    public static Pair<List<TriPoint>, List<TriEdge>> getPath(Mesh mesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startingPt, IPathGoal goal, double radius, double abortDist, Predicate<PathChange> triFilter) {
        IAStarResult result = PathGen.getPathAStarDetailed(mesh, startTri, startEdge, startVertex, startingPt, goal, radius, abortDist, triFilter);
        if (result instanceof AStarSuccess) {
            return PathGen.getPath(mesh, startTri, startingPt, goal, radius, (AStarSuccess)result);
        }
        return null;
    }

    public static Pair<List<TriPoint>, List<TriEdge>> getPath(Mesh mesh, Tri startTri, Point3d startingPt, IPathGoal goal, double radius, AStarSuccess astar) {
        TriPoint startPoint;
        if (astar == null) {
            return null;
        }
        ArrayList<TriEdge> pathEdges = PathGen.getPathEdgePoints(astar.node);
        List<TriPoint> pathPoints = PathGen.stringPullFixedEndPoints(mesh, pathEdges, astar.goalReached, startPoint = new TriPoint(startTri, startingPt), goal, radius);
        if (pathPoints == null) {
            return null;
        }
        return new Pair<List<TriPoint>, List<TriEdge>>(pathPoints, pathEdges);
    }

    public static double getPathLength(MTSearchNode pathEnd) {
        return pathEnd.g;
    }

    public static double getPathLength(List<TriPoint> pts) {
        double dist = 0.0;
        TriPoint ptLast = null;
        for (TriPoint pt : pts) {
            if (ptLast != null) {
                dist += ptLast.p.distance(pt.p);
            }
            ptLast = pt;
        }
        return dist;
    }

    public static ArrayList<TriEdge> getPathEdgePoints(MTSearchNode goalNode) {
        ArrayList<TriEdge> path = new ArrayList<TriEdge>();
        PathGen.getPathEdgePoints(goalNode, path);
        return path;
    }

    private static void getPathEdgePoints(MTSearchNode goalNode, List<TriEdge> path) {
        while (goalNode != null) {
            goalNode.prependCrossedEdges(path);
            goalNode = goalNode.parent;
        }
    }

    private static Point3d[] getClosestPointsLineSegLineSeg(Point3d p1a, Point3d p2a, Point3d p1b, Point3d p2b) {
        Point3d[] point3dArray;
        double smallestDistSq = Double.POSITIVE_INFINITY;
        Point3d pa = null;
        Point3d pb = null;
        block8: for (int m = 0; m < 4; ++m) {
            Point3d l2;
            Point3d l1;
            Point3d tp;
            switch (m) {
                case 0: {
                    tp = p1a;
                    l1 = p1b;
                    l2 = p2b;
                    break;
                }
                case 1: {
                    tp = p2a;
                    l1 = p1b;
                    l2 = p2b;
                    break;
                }
                case 2: {
                    tp = p1b;
                    l1 = p1a;
                    l2 = p2a;
                    break;
                }
                default: {
                    tp = p2b;
                    l1 = p1a;
                    l2 = p2a;
                }
            }
            Point3d nearp = Inter3D.nearestPointOnLineSeg(l1, l2, tp);
            double distsq = tp.distanceSquared(nearp);
            if (!(distsq < smallestDistSq)) continue;
            smallestDistSq = distsq;
            switch (m) {
                case 0: 
                case 1: {
                    pa = tp;
                    pb = nearp;
                    continue block8;
                }
                default: {
                    pa = nearp;
                    pb = tp;
                }
            }
        }
        if (pa == null) {
            point3dArray = null;
        } else {
            Point3d[] point3dArray2 = new Point3d[2];
            point3dArray2[0] = pa;
            point3dArray = point3dArray2;
            point3dArray2[1] = pb;
        }
        return point3dArray;
    }

    public static List<TriPoint> stringPullSlidingEndPoints(Mesh mesh, List<TriEdge> edges, IPathGoal goal, GoalDest goalReached, double radius, double abortDist) {
        ArrayList<TriPoint> points;
        TriPoint endPoint;
        assert (edges.size() >= 1);
        if (edges.isEmpty()) {
            return null;
        }
        assert (goalReached != null);
        Mesh.SplitEdge[] shortenedEdges = mesh.getShortenedEdges(radius);
        TriEdge startEdge = edges.get(0);
        TriEdge endEdge = edges.get(edges.size() - 1);
        List<TriEdge> pullEdges = new ReverseList<TriEdge>(edges);
        Tri endTri = endEdge.getValidTri();
        if (goalReached.point != null) {
            endPoint = goalReached.point;
            assert (endPoint != null);
            if (endPoint.tri != endTri) {
                endPoint = new TriPoint(endTri, endPoint.p);
            }
        } else {
            assert (goalReached.edge == endEdge.edge);
            Point3d[] initEndPoints = PathGen.getClosestPointsLineSegLineSeg(startEdge.edge.base.n1.p, startEdge.edge.base.n2.p, endEdge.edge.base.n1.p, endEdge.edge.base.n2.p);
            endPoint = PathGen.getWalkablePointOnEdge(shortenedEdges, endEdge.edge, new TriPoint(endTri, initEndPoints[1]));
            if (endPoint == null) {
                System.err.println("endPoint is null");
                return null;
            }
            if (edges.size() < 2) {
                return Arrays.asList(endPoint);
            }
            if (goalReached.edge == endEdge.edge) {
                pullEdges = pullEdges.subList(1, edges.size());
            }
        }
        if ((points = PathGen.stringPullImpl(shortenedEdges, pullEdges, goalReached, endPoint, new EdgeGoal(startEdge.edge))) == null || points.isEmpty()) {
            return null;
        }
        TriPoint startPoint = (TriPoint)points.get(points.size() - 1);
        pullEdges = edges.subList(1, edges.size());
        points = PathGen.stringPullImpl(shortenedEdges, pullEdges, goalReached, startPoint, goal);
        if (points == null || points.isEmpty()) {
            return null;
        }
        return points;
    }

    public static List<TriPoint> stringPullFixedEndPoints(Mesh mesh, List<TriEdge> edges, GoalDest goalReached, TriPoint startPoint, IPathGoal goal, double radius) {
        Mesh.SplitEdge[] shortenedEdges = mesh.getShortenedEdges(radius);
        if (edges.isEmpty()) {
            TriPoint endPoint = goal.project(goalReached, shortenedEdges, startPoint.p);
            if (endPoint == null) {
                return null;
            }
            if (!startPoint.p.epsilonEquals(endPoint.p, 1.0E-6)) {
                return Arrays.asList(startPoint, endPoint);
            }
            return Arrays.asList(startPoint);
        }
        return PathGen.stringPullImpl(shortenedEdges, edges, goalReached, startPoint, goal);
    }

    private static ArrayList<TriPoint> stringPullImpl(Mesh.SplitEdge[] shortenedEdges, List<TriEdge> edges, GoalDest goalReached, TriPoint startPoint, IPathGoal goal) {
        int endIx = edges.size() - 1;
        if (!edges.isEmpty() && goal instanceof EdgeGoal && ((EdgeGoal)goal).edge == edges.get((int)(edges.size() - 1)).edge) {
            --endIx;
        }
        ArrayList<TriPoint> points = new ArrayList<TriPoint>();
        points.add(startPoint);
        ArrayList<TriPoint> revPoints = new ArrayList<TriPoint>();
        TriPoint previous = startPoint;
        for (int m = 0; m <= endIx + 1; ++m) {
            TriPoint endPoint = goal.project(goalReached, shortenedEdges, previous.p);
            if (endPoint == null) {
                return null;
            }
            if ((m = PathGen.stringPullNext(edges, m, endIx, previous, endPoint, shortenedEdges, revPoints)) == -1) {
                return null;
            }
            for (int n = revPoints.size() - 1; n >= 0; --n) {
                TriPoint nextPoint = (TriPoint)revPoints.get(n);
                if (nextPoint.p.epsilonEquals(previous.p, 1.0E-6)) continue;
                points.add(nextPoint);
                previous = nextPoint;
            }
        }
        return points;
    }

    private static boolean eq2d(Point3d p1, Point3d p2, double tol) {
        return Math.max(Math.abs(p1.x - p2.x), Math.abs(p1.y - p2.y)) <= tol;
    }

    private static int stringPullNext(List<TriEdge> edges, int edgesBeginIx, int edgesEndIx, TriPoint startPoint, TriPoint endPoint, Mesh.SplitEdge[] shortenedEdges, final List<TriPoint> revPoints) {
        Mesh.SplitEdge.ILocResolver resolver = new Mesh.SplitEdge.ILocResolver(){

            @Override
            public double resolve(Mesh.SplitEdge sedge, double t1, double t2, double t) {
                double distsq2;
                assert (!revPoints.isEmpty());
                Point3d pathEnd = ((TriPoint)revPoints.get((int)(revPoints.size() - 1))).p;
                Point3d p1 = sedge.get(t1);
                Point3d p2 = sedge.get(t2);
                double distsq1 = p1.distanceSquared(pathEnd);
                return distsq1 <= (distsq2 = p2.distanceSquared(pathEnd)) ? t1 : t2;
            }
        };
        double[] st = new double[2];
        TriPoint pnext = endPoint;
        revPoints.clear();
        revPoints.add(pnext);
        int nextBendIx = edgesEndIx + 1;
        for (int m = edgesEndIx; m >= edgesBeginIx; --m) {
            TriEdge triEdge = edges.get(m);
            WingedEdge edge = triEdge.edge;
            Pair<Boolean, Point3d> cresult = PathGen.classifySPEdge(startPoint.p, pnext.p, edge, shortenedEdges, resolver, st);
            if (cresult == null) {
                return -1;
            }
            TriPoint epoint = new TriPoint(triEdge.getValidTri(), (Point3d)cresult.v2);
            if (((Boolean)cresult.v1).booleanValue()) {
                nextBendIx = m;
                revPoints.clear();
                pnext = epoint;
            }
            revPoints.add(epoint);
            if (startPoint.p.equals(epoint.p)) break;
        }
        return nextBendIx;
    }

    private static Inter3D.LinesegClassify getNearestT(Point3d l1, Point3d l2, WingedEdge edge, double[] st) {
        double tol = 1.0E-9;
        Point3d e1 = edge.base.n1.p;
        Point3d e2 = edge.base.n2.p;
        if (PathGen.eq2d(l1, l2, 1.0E-9) || PathGen.eq2d(e1, e2, 1.0E-9)) {
            return Inter3D.getNearestTLinesegLineSeg(l1, l2, e1, e2, tol, st);
        }
        return Inter3D.getNearestTLinesegLineSeg(l1.x, l1.y, 0.0, l2.x, l2.y, 0.0, e1.x, e1.y, 0.0, e2.x, e2.y, 0.0, tol, st);
    }

    private static Pair<Boolean, Point3d> classifySPEdge(Point3d startPoint, Point3d endPoint, WingedEdge edge, Mesh.SplitEdge[] sedges, double[] st) {
        return PathGen.classifySPEdge(startPoint, endPoint, edge, sedges, Mesh.SplitEdge.DEF_RESOLVER, st);
    }

    private static Pair<Boolean, Point3d> classifySPEdge(Point3d startPoint, Point3d endPoint, WingedEdge edge, Mesh.SplitEdge[] sedges, Mesh.SplitEdge.ILocResolver resolver, double[] st) {
        double t;
        Inter3D.LinesegClassify lsc = PathGen.getNearestT(startPoint, endPoint, edge, st);
        Mesh.SplitEdge sedge = sedges[edge.id];
        double d = t = sedge != null ? sedge.findClosest(st[1], resolver) : st[1];
        if (Double.isNaN(t)) {
            return null;
        }
        Point3d p = edge.get(t);
        boolean corner = lsc == Inter3D.LinesegClassify.NO_INTERSECT || !theUtil.eq(t, st[1], 1.0E-9);
        Boolean bcorner = corner ? Boolean.TRUE : Boolean.FALSE;
        return new Pair<Boolean, Point3d>(bcorner, p);
    }

    private static Point2d p2d(Point3d p) {
        return new Point2d(p.x, p.y);
    }

    private static boolean eq2d(Point3d p1, Point3d p2) {
        return theUtil.eq(p1.x, p2.x, 1.0E-9) && theUtil.eq(p1.y, p2.y, 1.0E-9);
    }

    private static TriPoint getWalkablePointOnEdge(Mesh.SplitEdge[] shortenedEdges, WingedEdge edge, TriPoint tp) {
        Mesh.SplitEdge sedge = shortenedEdges[edge.id];
        return sedge == null ? tp : sedge.findClosest(tp);
    }

    private static Point3d getWalkablePointOnEdge(Mesh.SplitEdge[] shortenedEdges, WingedEdge edge, Point3d p) {
        Mesh.SplitEdge sedge = shortenedEdges[edge.id];
        return sedge == null ? p : sedge.findClosest(p);
    }

    private static TriPoint getWalkablePointOnEdge(Mesh.SplitEdge[] shortenedEdges, WingedEdge edge, Tri tri, double t) {
        if (Double.isNaN(t = PathGen.getWalkableTOnEdge(shortenedEdges, edge, t, Mesh.SplitEdge.DEF_RESOLVER))) {
            return null;
        }
        return new TriPoint(tri, Util3D.linesegPoint(edge.base.n1.p, edge.base.n2.p, t));
    }

    private static double getWalkableTOnEdge(Mesh.SplitEdge[] shortenedEdges, WingedEdge edge, double t, Mesh.SplitEdge.ILocResolver resolver) {
        Mesh.SplitEdge sedge = shortenedEdges[edge.id];
        if (sedge != null) {
            t = sedge.findClosest(t, resolver);
        }
        return t;
    }

    public static int getStartNodes(Mesh.SplitEdge[] sedges, int startid, Point3d startPt, Tri startTri, WingedEdge startEdge, Vertex startVertex, IPathGoal goal, Predicate<PathChange> pathFilter, Collection<MTSearchNode> open, Set<WingedEdge> closed) {
        TriEdge[] edges = Mesh.getTouchingEdges(startTri, startEdge, startVertex, startPt);
        if (edges.length == 0) {
            if (pathFilter.test(new PathChange(startTri, null))) {
                open.add(PathGen.getStartNode(sedges, startid++, goal, startTri, null, startPt));
            }
        } else {
            PathChange pc = new PathChange();
            for (TriEdge edge : edges) {
                Tri dstTri = edge.tri;
                if (!pathFilter.test(pc.set(dstTri, edge.edge))) {
                    if (!pathFilter.test(pc.set(null, edge.edge))) continue;
                    dstTri = null;
                }
                if (sedges[edge.edge.id] != null && !sedges[edge.edge.id].isTravellable()) continue;
                closed.add(edge.edge);
                open.add(PathGen.getStartNode(sedges, startid++, goal, dstTri, edge.edge, startPt));
            }
        }
        return startid;
    }

    public static MTSearchNode getPathAStar(Mesh navMesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter) {
        IAStarResult result = PathGen.getPathAStarDetailed(navMesh, startTri, startEdge, startVertex, startPt, goal, radius, abortDist, pathFilter);
        if (result instanceof AStarSuccess) {
            return ((AStarSuccess)result).node;
        }
        return null;
    }

    private static <T> void printNodeData(MTSearchNode node, Function<MTSearchNode, T> mapper) {
        while (node != null) {
            System.out.println(mapper.apply(node));
            node = node.parent;
        }
    }

    private static void printPoints(MTSearchNode node) {
        PathGen.printNodeData(node, n -> mTSearchNode.destpt);
    }

    private static void printEdges(MTSearchNode node) {
        PathGen.printNodeData(node, n -> mTSearchNode.edge);
    }

    private static void printGs(MTSearchNode node) {
        PathGen.printNodeData(node, n -> mTSearchNode.g);
    }

    private static void printFs(MTSearchNode node) {
        PathGen.printNodeData(node, n -> mTSearchNode.f);
    }

    public static IAStarResult getPathAStarDetailed(Mesh navMesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter) {
        if (startTri == null) {
            return new AStarFailure(8);
        }
        Mesh.SplitEdge[] sedges = navMesh.getShortenedEdges(radius);
        double minStartDist = goal.getMinDistance(sedges, startPt);
        if (Double.isInfinite(minStartDist)) {
            return new AStarFailure(2);
        }
        if (minStartDist > abortDist) {
            return new AStarFailure(8);
        }
        TreeSet<MTSearchNode> open = new TreeSet<MTSearchNode>();
        IdSet<WingedEdge> closed = new IdSet<WingedEdge>();
        LinkedIdentityHashMap<WingedEdge, MTSearchNode> edgeNodes = new LinkedIdentityHashMap<WingedEdge, MTSearchNode>();
        int failures = 0;
        MTSearchNode goalNode = null;
        GoalDest reachResult = null;
        int nodeid = 0;
        nodeid = PathGen.getStartNodes(sedges, nodeid, startPt, startTri, startEdge, startVertex, goal, pathFilter, open, closed);
        PathChange pc = new PathChange();
        while (!open.isEmpty()) {
            WingedEdge crossedEdge;
            MTSearchNode node = open.pollFirst();
            Tri destTri = node.destTri();
            GoalDest result = goal.testReached(pc.set(destTri, crossedEdge = node.destEdge(), node));
            if (result != null) {
                if (destTri == null && !crossedEdge.isExit()) {
                    Tri triBefore = node.parent != null ? node.parent.dstTri : startTri;
                    node.dstTri = crossedEdge.getAdjTri(triBefore);
                }
                goalNode = node;
                reachResult = result;
                break;
            }
            if (destTri == null) continue;
            if (crossedEdge != null) {
                closed.add(crossedEdge);
                edgeNodes.remove(crossedEdge);
            }
            for (SearchConnection connection : node.dstTri.searchConnections) {
                MTSearchNode existingNode;
                WingedEdge edge;
                if (!node.edgeFilter.test(connection) || (edge = connection.eu.wedge) == crossedEdge || closed.contains(edge)) continue;
                if (edge.isBoundary()) {
                    failures |= 1;
                    continue;
                }
                Mesh.SplitEdge sedge = sedges[edge.id];
                if (sedge != null && sedge.splits.length == 0) {
                    failures |= 2;
                    continue;
                }
                Tri adjTri = connection.tri;
                if (!pathFilter.test(pc.set(adjTri, edge, node))) {
                    if (adjTri == null || !pathFilter.test(pc.set(null, edge, node))) {
                        failures |= 4;
                        continue;
                    }
                    adjTri = null;
                }
                MTSearchNode tentativeNode = PathGen.getNextNode(navMesh, sedges, new TriPoint(startTri, startPt), goal, radius, nodeid, node, adjTri, edge);
                if (tentativeNode.f > abortDist || (existingNode = (MTSearchNode)edgeNodes.get(edge)) != null && !(tentativeNode.g < existingNode.g)) continue;
                if (existingNode != null) {
                    open.remove(existingNode);
                }
                open.add(tentativeNode);
                edgeNodes.put(edge, tentativeNode);
                ++nodeid;
            }
        }
        if (goalNode != null) {
            return new AStarSuccess(goalNode, reachResult);
        }
        return new AStarFailure(failures);
    }

    private static double getModifiedDistToDest(Tri crossedTri, double distToDest) {
        if (crossedTri != null && crossedTri.terrain != null && crossedTri.getSpeedModifier().type == SpeedModifier.Type.FACTOR) {
            return distToDest / crossedTri.getSpeedModifier().value;
        }
        return distToDest;
    }

    private static MTSearchNode getNextNode(Mesh mesh, Mesh.SplitEdge[] sedges, TriPoint startPt, IPathGoal goal, double radius, int id, MTSearchNode parent, Tri dstTri, WingedEdge edge) {
        Pair<CornerNode, Point3d> spresult = PathGen.stringPullQuickAndDirty(mesh, sedges, goal, parent, edge);
        CornerNode corner = (CornerNode)spresult.v1;
        Point3d dstPt = (Point3d)spresult.v2;
        double g = PathGen.calcG(sedges, parent, dstPt, corner);
        double h = goal.getDistance(sedges, corner.nearestGoal, dstPt);
        MTSearchNode node = new MTSearchNode(id, parent, dstTri, edge, dstPt, corner, g, h);
        PathGen.applyEdgeFilter(node, dstTri, edge);
        return node;
    }

    private static Pair<CornerNode, Point3d> stringPullQuickAndDirty(Mesh mesh, Mesh.SplitEdge[] sedges, IPathGoal goal, MTSearchNode parent, WingedEdge edge) {
        MTSearchNode testNode = new MTSearchNode(-1, parent, null, edge, GeomConstants.PNT3D_ORIGIN, parent.corner, 0.0, 0.0);
        CornerNode corner = testNode.parent.corner;
        while (corner.edge != testNode.edge) {
            NextCorner nextCorner = PathGen.findNextCorner(mesh, sedges, corner, goal, testNode);
            if (nextCorner == null) {
                Point3d dstPt = PathGen.getClosestPointOnEdge(testNode.edge, sedges[testNode.edge.id], corner.nearestGoalPt.p);
                return new Pair<CornerNode, Point3d>(corner, dstPt);
            }
            WingedEdge nextCornerEdge = nextCorner.edge;
            Point3d nextCornerPt = nextCorner.edgePt;
            if (nextCornerEdge == testNode.edge) {
                return new Pair<CornerNode, Point3d>(corner, nextCornerPt);
            }
            Pair<GoalDest, TriPoint> projected = goal.project(sedges, nextCornerPt);
            assert (projected != null);
            MTSearchNode cornerNode = parent;
            while (cornerNode != null && cornerNode.edge != nextCornerEdge) {
                cornerNode = cornerNode.parent;
            }
            assert (cornerNode != null);
            double cornerG = cornerNode != null ? PathGen.calcG(sedges, cornerNode, nextCornerPt, corner) : corner.g + corner.loc.distance(nextCornerPt);
            corner = new CornerNode(nextCornerEdge, nextCornerPt, cornerG, (GoalDest)projected.v1, (TriPoint)projected.v2);
        }
        assert (false);
        return new Pair<CornerNode, Point3d>(corner, corner.loc);
    }

    private static NextCorner findNextCorner(Mesh mesh, Mesh.SplitEdge[] sedges, CornerNode prevCorner, IPathGoal goal, MTSearchNode nextNode) {
        Point3d endPt = prevCorner.nearestGoalPt.p;
        WingedEdge cornerEdge = prevCorner.edge;
        MTSearchNode node = nextNode;
        double[] st = new double[2];
        while (node != null && node.edge != null && node.edge != prevCorner.edge) {
            Pair<Boolean, Point3d> cresult = PathGen.classifySPEdge(prevCorner.loc, endPt, node.edge, sedges, st);
            assert (cresult != null);
            if (!((Boolean)cresult.v1).booleanValue()) {
                if (cornerEdge != prevCorner.edge) break;
                Point3d testEdgePt = nextNode == node ? (Point3d)cresult.v2 : PathGen.getClosestPointOnEdge(nextNode.edge, sedges[nextNode.edge.id], endPt);
                return new NextCorner(nextNode.edge, testEdgePt, false);
            }
            endPt = (Point3d)cresult.v2;
            cornerEdge = node.edge;
            node = node.parent;
        }
        if (cornerEdge != prevCorner.edge) {
            return new NextCorner(cornerEdge, endPt, true);
        }
        return null;
    }

    private static double calcG(Mesh.SplitEdge[] sedges, MTSearchNode node, Point3d endPt, CornerNode startCorner) {
        double[] st = new double[2];
        SpeedModifier speedModifier = PathGen.getModifier(node.dstTri);
        double totDist = 0.0;
        while (node.edge != null && node.edge != startCorner.edge && node.parent != null) {
            Tri crossedTri = node.parent.dstTri;
            SpeedModifier triMod = PathGen.getModifier(crossedTri);
            if (!theUtil.equal(triMod, speedModifier)) {
                Pair<Boolean, Point3d> cresult = PathGen.classifySPEdge(startCorner.loc, endPt, node.edge, sedges, st);
                Point3d isectPt = (Point3d)cresult.v2;
                double segmentDist = isectPt.distance(endPt);
                totDist += segmentDist / PathGen.getModFactor(speedModifier);
                speedModifier = triMod;
                endPt = isectPt;
            }
            node = node.parent;
        }
        double finalDist = startCorner.loc.distance(endPt);
        return startCorner.g + (totDist += finalDist / PathGen.getModFactor(speedModifier));
    }

    private static SpeedModifier getModifier(Tri tri) {
        if (tri != null && tri.terrain != null && tri.getSpeedModifier().type == SpeedModifier.Type.FACTOR) {
            return tri.getSpeedModifier();
        }
        return null;
    }

    private static double getModFactor(SpeedModifier modifier) {
        return modifier != null ? modifier.value : 1.0;
    }

    private static Point3d getClosestPointOnEdge(WingedEdge edge, Mesh.SplitEdge sedge, Point3d p) {
        double neart = Inter3D.nearestTOnLineSeg(edge.base.n1.p, edge.base.n2.p, p);
        if (sedge == null) {
            return Util3D.linesegPoint(edge.base.n1.p, edge.base.n2.p, neart);
        }
        double sedget = sedge.findClosest(neart);
        assert (!Double.isNaN(sedget));
        return sedge.get(sedget);
    }

    private static MTSearchNode getStartNode(Mesh.SplitEdge[] sedges, int id, IPathGoal goal, Tri startTri, WingedEdge startEdge, Point3d startPt) {
        Pair<GoalDest, TriPoint> projected = goal.project(sedges, startPt);
        assert (projected != null);
        MTSearchNode node = new MTSearchNode(id, null, startTri, startEdge, startPt, new CornerNode(startEdge, startPt, 0.0, (GoalDest)projected.v1, (TriPoint)projected.v2), 0.0, goal.getDistance(sedges, (GoalDest)projected.v1, startPt));
        PathGen.applyEdgeFilter(node, startTri, startEdge);
        return node;
    }

    private static void applyEdgeFilter(MTSearchNode node, Tri tri, WingedEdge edge) {
        if (tri != null && tri.node != null && tri.node.isTransportNode() && edge != null && edge.isTransportDoor()) {
            node.edgeFilter = PathGen.rejectAllConnectedDoors(tri.node);
        }
    }

    public static Predicate<SearchConnection> rejectAllConnectedDoors(final ANode node) {
        return new APredicate<SearchConnection>(){

            @Override
            public boolean test(SearchConnection t) {
                return !node.getDoorEdges().contains(t.eu.wedge);
            }
        };
    }

    private static class NextCorner {
        public final WingedEdge edge;
        public final Point3d edgePt;
        public final boolean isCorner;

        public NextCorner(WingedEdge edge, Point3d edgePt, boolean isCorner) {
            this.edge = edge;
            this.edgePt = edgePt;
            this.isCorner = isCorner;
        }
    }

    public static class AStarFailure
    implements IAStarResult {
        public static final int BOUNDARY = 1;
        public static final int PATH_TOO_NARROW = 2;
        public static final int EDGE_FILTERED = 4;
        public static final int TOO_FAR = 8;
        public final int types;

        public AStarFailure(int types) {
            this.types = types;
        }

        public boolean test(int type) {
            return (this.types & type) == type;
        }

        public boolean testBoundary() {
            return this.test(1);
        }

        public boolean testPathTooNarrow() {
            return this.test(2);
        }

        public boolean testEdgeFiltered() {
            return this.test(4);
        }

        public boolean testTooFar() {
            return this.test(8);
        }
    }

    public static class AStarSuccess
    implements IAStarResult {
        public final MTSearchNode node;
        public final GoalDest goalReached;

        public AStarSuccess(MTSearchNode node, GoalDest goalReached) {
            this.node = node;
            this.goalReached = goalReached;
        }
    }

    public static interface IAStarResult {
    }

    private static class ReverseList<T>
    extends AbstractList<T> {
        private final List<T> d_baseList;

        public ReverseList(List<T> baseList) {
            this.d_baseList = baseList;
        }

        @Override
        public T get(int index) {
            return this.d_baseList.get(this.d_baseList.size() - index - 1);
        }

        @Override
        public int size() {
            return this.d_baseList.size();
        }
    }

    public static class MTSearchNode
    implements Comparable<MTSearchNode>,
    Serializable {
        static final long serialVersionUID = 1L;
        public final int id;
        public final MTSearchNode parent;
        public final double g;
        public final double f;
        public final WingedEdge edge;
        public Tri dstTri;
        public final Point3d destpt;
        public final CornerNode corner;
        public Predicate<SearchConnection> edgeFilter;

        public MTSearchNode(int id, MTSearchNode parent, Tri dstTri, WingedEdge edge, Point3d dstPt, CornerNode corner, double g, double h) {
            this.id = id;
            this.parent = parent;
            this.edge = edge;
            this.dstTri = dstTri;
            this.destpt = dstPt;
            this.corner = corner;
            this.g = g;
            this.f = g + h;
            this.edgeFilter = parent != null ? parent.edgeFilter : Predicates.alwaysTrue();
        }

        public void prependCrossedEdges(List<TriEdge> edges) {
            if (this.edge == null || edges.size() > 0 && this.edge.equals(edges.get((int)0).edge)) {
                return;
            }
            edges.add(0, new TriEdge(this.dstTri, this.edge));
        }

        public Tri destTri() {
            return this.dstTri;
        }

        public WingedEdge destEdge() {
            return this.edge;
        }

        public Point3d destPt() {
            return this.destpt;
        }

        public double distToDest() {
            return this.parent != null ? this.parent.destpt.distance(this.destpt) : 0.0;
        }

        public int getPathCount() {
            int count = 1;
            MTSearchNode node = this.parent;
            while (node != null) {
                ++count;
                node = node.parent;
            }
            return count;
        }

        @Override
        public int compareTo(MTSearchNode o) {
            int result = Double.compare(this.f, o.f);
            if (result == 0) {
                if (this.equals(o)) {
                    return 0;
                }
                int count1 = this.getPathCount();
                int count2 = o.getPathCount();
                assert (this.id != o.id);
                return count1 == count2 ? Integer.signum(this.id - o.id) : Integer.signum(count1 - count2);
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MTSearchNode)) {
                return false;
            }
            MTSearchNode node = (MTSearchNode)obj;
            boolean result = this.g == node.g && this.f == node.f && theUtil.equal(this.dstTri, node.dstTri) && theUtil.equal(this.edge, node.edge) && this.destpt.equals(node.destpt);
            theUtil.equal(this.parent, node.parent);
            return result;
        }

        public String toString() {
            if (this.parent == null) {
                return "Node[f=" + this.s(this.f) + " pt=" + this.destPt().toString() + "]";
            }
            return "...Node[f=" + this.s(this.f) + " pt=" + this.destPt().toString() + "]";
        }

        private double s(double d) {
            int i = (int)(d * 100.0);
            return (double)i / 100.0;
        }
    }

    public static class CornerNode
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final WingedEdge edge;
        public final Point3d loc;
        public final double g;
        public final GoalDest nearestGoal;
        public final TriPoint nearestGoalPt;

        public CornerNode(WingedEdge edge, Point3d loc, double g, GoalDest nearestGoal, TriPoint nearestGoalPt) {
            this.edge = edge;
            this.loc = loc;
            this.g = g;
            this.nearestGoal = nearestGoal;
            this.nearestGoalPt = nearestGoalPt;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof CornerNode && ((CornerNode)obj).edge == this.edge && ((CornerNode)obj).g == this.g && ((CornerNode)obj).loc.equals(this.loc);
        }
    }

    public static class MultiEdgeGoal
    implements IPathGoal,
    Serializable {
        static final long serialVersionUID = 1L;
        public final Set<WingedEdge> edges;
        private transient WingedEdge[] d_edgeList;
        private transient Integer d_hashCode;

        public MultiEdgeGoal(WingedEdge ... edges) {
            this(Arrays.asList(edges));
        }

        public MultiEdgeGoal(Collection<? extends WingedEdge> edges) {
            assert (Util.isOrdered(edges));
            this.edges = edges instanceof Set ? (Set<Object>)edges : new LinkedIdentityHashSet<WingedEdge>(edges);
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof MultiEdgeGoal && ((MultiEdgeGoal)obj).edges.equals(this.edges);
        }

        @Override
        public int hashCode() {
            if (this.d_hashCode == null) {
                this.d_hashCode = 0x6238FEE ^ this.edges.hashCode();
            }
            return this.d_hashCode;
        }

        @Override
        public boolean isStatic(KB kb) {
            return true;
        }

        private WingedEdge[] getEdgeList() {
            if (this.d_edgeList == null) {
                this.d_edgeList = theUtil.toArray(this.edges, WingedEdge.class);
            }
            return this.d_edgeList;
        }

        @Override
        public boolean isValid(Mesh.SplitEdge[] sedges, double radius) {
            for (WingedEdge edge : this.getEdgeList()) {
                if (!PathGen.isTravellable(sedges, edge)) continue;
                return true;
            }
            return false;
        }

        @Override
        public double getMinDistance(Mesh.SplitEdge[] sedges, Point3d p) {
            double minDistSq = Double.POSITIVE_INFINITY;
            for (WingedEdge edge : this.getEdgeList()) {
                double distSq;
                if (!PathGen.isTravellable(sedges, edge) || !((distSq = Inter3D.distSqToNearestPtOnLineSeg(edge.base.n1.p, edge.base.n2.p, p)) < minDistSq)) continue;
                minDistSq = distSq;
            }
            return minDistSq == Double.POSITIVE_INFINITY ? minDistSq : Math.sqrt(minDistSq);
        }

        @Override
        public double getDistance(Mesh.SplitEdge[] sedges, GoalDest goalReached, Point3d p) {
            assert (goalReached.edge != null);
            WingedEdge edge = goalReached.edge;
            assert (PathGen.isTravellable(sedges, edge));
            double distsq = Inter3D.distSqToNearestPtOnLineSeg(edge.base.n1.p, edge.base.n2.p, p);
            return Math.sqrt(distsq);
        }

        public WingedEdge getClosest(Mesh.SplitEdge[] sedges, Point3d p) {
            double minDistSq = Double.MAX_VALUE;
            WingedEdge closestEdge = null;
            for (WingedEdge edge : this.getEdgeList()) {
                double distSq;
                if (!PathGen.isTravellable(sedges, edge) || !((distSq = Inter3D.distSqToNearestPtOnLineSeg(edge.base.n1.p, edge.base.n2.p, p)) < minDistSq)) continue;
                minDistSq = distSq;
                closestEdge = edge;
            }
            return closestEdge;
        }

        @Override
        public GoalDest testReached(PathChange pc) {
            if (pc.edge != null && this.edges.contains(pc.edge)) {
                return new GoalDest(pc.edge);
            }
            return null;
        }

        @Override
        public Pair<GoalDest, TriPoint> project(Mesh.SplitEdge[] shortenedEdges, Point3d p) {
            WingedEdge closestEdge = this.getClosest(shortenedEdges, p);
            if (closestEdge == null) {
                return null;
            }
            return new Pair<GoalDest, TriPoint>(new GoalDest(closestEdge), this.project(closestEdge, shortenedEdges, p));
        }

        @Override
        public TriPoint project(GoalDest reachResult, Mesh.SplitEdge[] shortenedEdges, Point3d p) {
            return this.project(reachResult != null ? reachResult.edge : null, shortenedEdges, p);
        }

        public TriPoint project(WingedEdge edge, Mesh.SplitEdge[] shortenedEdges, Point3d p) {
            if (edge == null && (edge = this.getClosest(shortenedEdges, p)) == null) {
                return null;
            }
            p = Inter3D.nearestPointOnLineSeg(edge.base.n1.p, edge.base.n2.p, p);
            if ((p = PathGen.getWalkablePointOnEdge(shortenedEdges, edge, p)) == null) {
                return null;
            }
            Tri tri = edge.t1 != null ? edge.t1 : edge.t2;
            return new TriPoint(tri, p);
        }
    }

    public static class EdgeGoal
    implements IPathGoal,
    Serializable {
        static final long serialVersionUID = 1L;
        public final WingedEdge edge;

        public EdgeGoal(WingedEdge edge) {
            this.edge = edge;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof EdgeGoal && ((EdgeGoal)obj).edge.id == this.edge.id;
        }

        @Override
        public int hashCode() {
            return 0x1982F32B ^ this.edge.id;
        }

        @Override
        public boolean isStatic(KB kb) {
            return true;
        }

        @Override
        public boolean isValid(Mesh.SplitEdge[] sedges, double radius) {
            return PathGen.isTravellable(sedges, this.edge);
        }

        @Override
        public double getMinDistance(Mesh.SplitEdge[] sedges, Point3d p) {
            if (!PathGen.isTravellable(sedges, this.edge)) {
                return Double.POSITIVE_INFINITY;
            }
            double distsq = Inter3D.distSqToNearestPtOnLineSeg(this.edge.base.n1.p, this.edge.base.n2.p, p);
            return Math.sqrt(distsq);
        }

        @Override
        public double getDistance(Mesh.SplitEdge[] sedges, GoalDest goalReached, Point3d p) {
            return this.getMinDistance(sedges, p);
        }

        @Override
        public GoalDest testReached(PathChange pc) {
            if (pc.edge != null && pc.edge.id == this.edge.id) {
                return new GoalDest(this.edge);
            }
            return null;
        }

        @Override
        public Pair<GoalDest, TriPoint> project(Mesh.SplitEdge[] shortenedEdges, Point3d p) {
            TriPoint tp = this.project(this.edge, shortenedEdges, p);
            if (tp == null) {
                return null;
            }
            return new Pair<GoalDest, TriPoint>(new GoalDest(this.edge), tp);
        }

        @Override
        public TriPoint project(GoalDest o, Mesh.SplitEdge[] shortenedEdges, Point3d p) {
            return this.project(o != null ? o.edge : null, shortenedEdges, p);
        }

        public TriPoint project(WingedEdge o, Mesh.SplitEdge[] shortenedEdges, Point3d p) {
            p = Inter3D.nearestPointOnLineSeg(this.edge.base.n1.p, this.edge.base.n2.p, p);
            if ((p = PathGen.getWalkablePointOnEdge(shortenedEdges, this.edge, p)) == null) {
                return null;
            }
            Tri tri = this.edge.t1 != null ? this.edge.t1 : this.edge.t2;
            return new TriPoint(tri, p);
        }
    }

    public static class SearchConnection
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final WingedEdgeUse eu;
        public final Tri tri;
        public final boolean isVirtual;

        public SearchConnection(WingedEdgeUse eu, Tri tri, boolean isVirtual) {
            this.eu = eu;
            this.tri = tri;
            this.isVirtual = isVirtual;
        }
    }

    public static class PointGoal
    implements IPathGoal,
    Serializable {
        static final long serialVersionUID = 1L;
        private ITpSource d_ptSrc;

        @Override
        public boolean isValid(Mesh.SplitEdge[] sedges, double radius) {
            return true;
        }

        public PointGoal(TriPoint pt) {
            this(new ITpSource.ConstTpSource(pt));
        }

        public PointGoal(OccAgent agent) {
            this(new ITpSource.AgentTpSource(agent));
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof PointGoal && ((PointGoal)obj).d_ptSrc.getTriPoint().equals(this.d_ptSrc.getTriPoint());
        }

        @Override
        public int hashCode() {
            return 0x23FA3BE ^ this.d_ptSrc.getTriPoint().hashCode();
        }

        @Override
        public boolean isStatic(KB kb) {
            return this.d_ptSrc.isStatic();
        }

        public PointGoal(ITpSource ptSrc) {
            this.d_ptSrc = ptSrc;
        }

        @Override
        public double getMinDistance(Mesh.SplitEdge[] sedges, Point3d p) {
            return p.distance(this.d_ptSrc.getTriPoint().p);
        }

        @Override
        public double getDistance(Mesh.SplitEdge[] sedges, GoalDest goalReached, Point3d p) {
            return this.getMinDistance(sedges, p);
        }

        public double getMinDistance(WingedEdge edge, Mesh.SplitEdge[] sedges) {
            Point3d p = this.d_ptSrc.getTriPoint().p;
            double neart = Inter3D.nearestTOnLineSeg(edge.base.n1.p, edge.base.n2.p, p);
            Mesh.SplitEdge sedge = sedges[edge.id];
            if (sedge != null) {
                neart = sedge.findClosest(neart);
            }
            Point3d edgep = Util3D.linesegPoint(edge.base.n1.p, edge.base.n2.p, neart);
            return p.distance(edgep);
        }

        public boolean test(PathChange o) {
            return o.tri == this.d_ptSrc.getTriPoint().tri;
        }

        @Override
        public GoalDest testReached(PathChange pc) {
            if (pc.tri == this.d_ptSrc.getTriPoint().tri) {
                return new GoalDest(this.d_ptSrc.getTriPoint());
            }
            return null;
        }

        @Override
        public TriPoint project(GoalDest o, Mesh.SplitEdge[] shortenedEdges, Point3d p) {
            return this.getTriPoint();
        }

        @Override
        public Pair<GoalDest, TriPoint> project(Mesh.SplitEdge[] shortenedEdges, Point3d p) {
            TriPoint result = this.getTriPoint();
            return new Pair<GoalDest, TriPoint>(new GoalDest(result), result);
        }

        public TriPoint getTriPoint() {
            return this.d_ptSrc.getTriPoint();
        }
    }

    public static class GoalDest {
        public final TriPoint point;
        public final WingedEdge edge;

        public GoalDest(TriPoint point) {
            this.point = point;
            this.edge = null;
        }

        public GoalDest(WingedEdge edge) {
            this.edge = edge;
            this.point = null;
        }
    }

    public static interface IPathGoal {
        public boolean isStatic(KB var1);

        public boolean isValid(Mesh.SplitEdge[] var1, double var2);

        public double getMinDistance(Mesh.SplitEdge[] var1, Point3d var2);

        public double getDistance(Mesh.SplitEdge[] var1, GoalDest var2, Point3d var3);

        public GoalDest testReached(PathChange var1);

        public TriPoint project(GoalDest var1, Mesh.SplitEdge[] var2, Point3d var3);

        public Pair<GoalDest, TriPoint> project(Mesh.SplitEdge[] var1, Point3d var2);

        public int hashCode();

        public boolean equals(Object var1);
    }
}

