/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.path;

import inferno.data2.DoorDir;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.geom.Inter;
import inferno.sim.path.DoorSeek;
import inferno.sim.path.ExitSeek;
import inferno.sim.path.IPath;
import inferno.sim.path.IPathSeek;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Pair;

public class Path
implements IPath,
Serializable {
    static final long serialVersionUID = 1L;
    private ArrayList<IPathSeek> d_path;
    private double[] d_tForPt;
    private Double memoLength = null;

    public Path(ArrayList<IPathSeek> pts) {
        assert (pts.size() >= 2);
        this.d_path = pts;
    }

    public IPathSeek getGoal() {
        return this.d_path.get(this.d_path.size() - 1);
    }

    private double[] getTForPt() {
        if (this.d_tForPt == null) {
            this.d_tForPt = new double[this.d_path.size()];
            double length = this.length(true);
            if (length == 0.0) {
                Arrays.fill(this.d_tForPt, 0.0);
            } else {
                double lenAccum = 0.0;
                for (int i = 0; i < this.d_path.size(); ++i) {
                    if (i == 0) {
                        this.d_tForPt[i] = 0.0;
                        continue;
                    }
                    double lenSegI = this.length(i - 1);
                    this.d_tForPt[i] = (lenAccum + lenSegI) / length;
                    lenAccum += lenSegI;
                }
            }
        }
        return this.d_tForPt;
    }

    @Override
    public Pair<WingedEdge, DoorDir> getTargetDoor() {
        IPathSeek goal = this.getGoal();
        if (goal == null) {
            return null;
        }
        WingedEdge currDoor = null;
        DoorDir dir = null;
        if (goal instanceof DoorSeek) {
            currDoor = ((DoorSeek)goal).door;
            dir = ((DoorSeek)goal).dir;
        } else if (goal instanceof ExitSeek) {
            currDoor = ((ExitSeek)goal).edge;
            dir = DoorDir.getExitDir(currDoor.data.node);
        }
        return currDoor != null ? new Pair<WingedEdge, DoorDir>(currDoor, dir) : null;
    }

    @Override
    public IPathSeek pointAt(int ix) {
        return this.d_path.get(ix);
    }

    @Override
    public int getNumPoints(boolean fuzzy) {
        return this.d_path.size();
    }

    public ArrayList<IPathSeek> getPoints() {
        return this.d_path;
    }

    @Override
    public double length(boolean fuzzy) {
        if (this.memoLength == null) {
            double dTotal = 0.0;
            for (int i = 0; i < this.d_path.size() - 1; ++i) {
                dTotal += this.length(i);
            }
            this.memoLength = dTotal;
        }
        return this.memoLength;
    }

    @Override
    public double fuzzyLength() {
        return 0.0;
    }

    public final double length(int ixSeg) {
        Point3d ptA = this.d_path.get((int)ixSeg).getSeekPt().p;
        Point3d ptB = this.d_path.get((int)(ixSeg + 1)).getSeekPt().p;
        return ptA.distance(ptB);
    }

    public Vector3d dirAt(double t) {
        Point3d ptA = this.pointAt(t);
        Point3d ptB = this.pointAt(t + 0.01);
        Vector3d dir = new Vector3d(ptB);
        dir.sub(ptA);
        dir.normalize();
        return dir;
    }

    private Point3d pointAlong(TriPoint a, TriPoint b, double len) {
        Vector3d v = new Vector3d(b.p);
        v.sub(a.p);
        v.normalize();
        v.scale(len);
        v.add(a.p);
        return new Point3d(v);
    }

    public TriPoint triPointAt(double t) {
        double[] tForPt = this.getTForPt();
        int result = Arrays.binarySearch(tForPt, t);
        if (result >= 0) {
            return this.d_path.get(result).getSeekPt();
        }
        int ixRoot = Math.max(-result - 2, 0);
        if (ixRoot == tForPt.length - 1) {
            return this.d_path.get(tForPt.length - 1).getSeekPt();
        }
        TriPoint p1 = this.d_path.get(ixRoot).getSeekPt();
        TriPoint p2 = this.d_path.get(ixRoot + 1).getSeekPt();
        double t2 = tForPt[ixRoot + 1];
        double t1 = tForPt[ixRoot];
        if (t2 == t1) {
            return p1;
        }
        double lt = (t - t1) / (t2 - t1);
        Point3d ptBetween = Util3D.linesegPoint(p1.p, p2.p, lt);
        return new TriPoint(p1.tri, ptBetween);
    }

    public Point3d pointAt(double t) {
        return this.triPointAt((double)t).p;
    }

    public double project(double t, double dist) {
        return t + dist / this.length(true);
    }

    public double nearPt(Point3d pt, Point3d dest) {
        assert (!Double.isNaN(pt.x));
        if (this.length(true) == 0.0) {
            if (dest != null) {
                dest.set(pt);
            }
            return 1.0;
        }
        int maxIx = -1;
        Point3d ptNear = null;
        double dMin = Double.MAX_VALUE;
        for (int i = 0; i < this.d_path.size() - 1; ++i) {
            Point3d a = this.d_path.get((int)i).getSeekPt().p;
            Point3d b = this.d_path.get((int)(i + 1)).getSeekPt().p;
            Point3d ptLocalNear = Inter.nearPointOnLineSeg(pt, a, b);
            double d = pt.distanceSquared(ptLocalNear);
            if (!(d < dMin)) continue;
            maxIx = i;
            ptNear = ptLocalNear;
            dMin = d;
        }
        double tCur = Double.NaN;
        if (ptNear != null) {
            double totDist = 0.0;
            for (int ixSeg = 0; ixSeg < maxIx; ++ixSeg) {
                totDist += this.length(ixSeg);
            }
            tCur = (totDist += this.d_path.get((int)maxIx).getSeekPt().p.distance(ptNear)) / this.length(true);
            if (dest != null) {
                dest.set(ptNear);
            }
        }
        return tCur;
    }

    public String toString() {
        return String.format("Path[length=%.2f, points=%d, end=%s]", this.length(false), this.getNumPoints(false), this.pointAt(1.0));
    }

    public double findMaxTrue(Test t, double initMin, double initMax, double tol) {
        double min = initMin;
        double max = initMax;
        while (max - min > tol) {
            double tPt = (min + max) / 2.0;
            if (t.test(this, tPt)) {
                min = tPt;
                continue;
            }
            max = tPt;
        }
        return min;
    }

    public static interface Test {
        public boolean test(Path var1, double var2);
    }
}

