/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.path;

import inferno.data2.ANode;
import inferno.data2.Mesh;
import inferno.data2.Tri;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.data2.WingedEdgeUse;
import inferno.sim.path.IPathSeek;
import java.io.Serializable;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;

public class ExitSeek
implements IPathSeek,
Serializable {
    private static final long serialVersionUID = 1L;
    public final WingedEdge edge;
    private final TriPoint backupPt;
    private final double radius;
    private final Predicate<WingedEdge> edgeFilter;
    private TriPoint currEdgeSeek;
    private double obstDist;
    private Vector3d seekDir;

    public ExitSeek(Mesh mesh, WingedEdge edge, TriPoint backupPt, double radius, Predicate<WingedEdge> edgeFilter) {
        this.edge = edge;
        this.backupPt = backupPt;
        this.radius = radius;
        this.edgeFilter = edgeFilter;
        this.obstDist = Double.POSITIVE_INFINITY;
        this.currEdgeSeek = backupPt;
    }

    @Override
    public ExitSeek clone() {
        try {
            ExitSeek es = (ExitSeek)super.clone();
            return es;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public TriPoint updateSeekPt(TriPoint currLoc, double radius, Mesh mesh) {
        this.currEdgeSeek = null;
        Point3d nearpt = Inter3D.nearestPointOnLineSeg(this.edge.base.n1.p, this.edge.base.n2.p, currLoc.p);
        Tri tri = this.edge.t1 != null ? this.edge.t1 : this.edge.t2;
        this.currEdgeSeek = mesh.getUnobstructedPointOnEdge(this.radius, new TriPoint(tri, nearpt), this.edge);
        assert (this.currEdgeSeek != null);
        return this.currEdgeSeek;
    }

    @Override
    public TriPoint getSeekPt() {
        return this.currEdgeSeek;
    }

    @Override
    public boolean updateVisibility(TriPoint currLoc, double radius, Mesh mesh) {
        this.obstDist = mesh.getPathObstructionDist(currLoc, this.currEdgeSeek, radius, this.edgeFilter);
        if (!this.isVisible()) {
            this.currEdgeSeek = this.backupPt;
            this.obstDist = mesh.getPathObstructionDist(currLoc, this.currEdgeSeek, radius, this.edgeFilter);
        }
        return this.isVisible();
    }

    @Override
    public double getObstructionDist() {
        return this.obstDist;
    }

    @Override
    public Vector3d getPredictDir() {
        if (this.seekDir == null) {
            Tri prevTri = this.edge.t1 != null ? this.edge.t1 : this.edge.t2;
            for (WingedEdgeUse eu : prevTri.eu) {
                if (eu.wedge != this.edge) continue;
                Vector3d triNorm = prevTri.normal;
                Vector3d edgeDir = eu.edgeDir();
                this.seekDir = Util3D.cross(edgeDir, triNorm);
                this.seekDir.normalize();
                break;
            }
        }
        return this.seekDir;
    }

    @Override
    public boolean isVirtual(ANode node) {
        return false;
    }
}

