/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.ai;

import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.ISeekGoalInstance;
import inferno.data2.ai.PointGoal;
import inferno.sim.OccAgent;
import inferno.sim.ai.DefaultAiCore;
import inferno.sim.ai.EmptyAiCore;
import inferno.sim.ai.IAiCore;
import inferno.sim.ai.IGoalAiCore;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.TypeFilter;

public class AiUtil {
    private static final Predicate<IGoalInstance> s_seekFilter = new TypeFilter<IGoalInstance>(ISeekGoalInstance.class);

    public static IAiCore newCore(OccAgent agent) {
        return agent.getOcc().behavior.isEmpty() ? new EmptyAiCore() : new DefaultAiCore();
    }

    public static ISeekGoalInstance getCurrentSeek(OccAgent agent) {
        return AiUtil.getGoal(agent, s_seekFilter, 0, () -> AiUtil.getDefaultCurrGoal(agent));
    }

    public static ISeekGoalInstance getDefaultCurrGoal(OccAgent agent) {
        return new PointGoal(agent.getLoc(), 0.5).begin(null, agent);
    }

    public static ISeekGoalInstance getPreviousSeek(OccAgent agent) {
        return AiUtil.getGoal(agent, s_seekFilter, 1, () -> AiUtil.getDefaultInitGoal(agent));
    }

    public static IGoalInstance getCurrentGoal(OccAgent agent) {
        return AiUtil.getGoal(agent, Predicates.alwaysTrue(), 0, () -> AiUtil.getDefaultCurrGoal(agent));
    }

    public static IGoalInstance getPreviousGoal(OccAgent agent) {
        return AiUtil.getGoal(agent, Predicates.alwaysTrue(), 1, () -> AiUtil.getDefaultInitGoal(agent));
    }

    public static IGoalInstance getPreviousGoal(OccAgent agent, IGoalInstance after) {
        IAiCore ai = agent.getAiCore();
        if (ai instanceof IGoalAiCore) {
            Collection<IGoalInstance> goals = ((IGoalAiCore)ai).getGoalHistory();
            Iterator<IGoalInstance> it = goals.iterator();
            while (it.hasNext()) {
                IGoalInstance goal = it.next();
                if (goal != after) continue;
                return it.hasNext() ? it.next() : null;
            }
        }
        return null;
    }

    public static <T extends IGoalInstance> T findGoal(OccAgent agent, Predicate<IGoalInstance> filter) {
        return (T)AiUtil.getGoal(agent, filter, 0, () -> null);
    }

    private static <T extends IGoalInstance> T getGoal(OccAgent agent, Predicate<IGoalInstance> filter, int skipCount, Supplier<T> def) {
        IAiCore ai = agent.getAiCore();
        if (ai instanceof IGoalAiCore) {
            Stream<IGoalInstance> goals = ((IGoalAiCore)ai).getGoalHistory().stream();
            return (T)goals.filter(filter).skip(skipCount).findFirst().orElseGet(def);
        }
        return (T)((IGoalInstance)def.get());
    }

    public static ISeekGoalInstance getDefaultInitGoal(OccAgent agent) {
        return new PointGoal(agent.getOcc().initLoc, 0.5).begin(null, agent);
    }
}

