/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.ai;

import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.ISeekGoalInstance;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.ai.AiUtil;
import inferno.sim.ai.IGoalAiCore;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collection;

public abstract class AGoalAiCore
implements IGoalAiCore,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_SEEK_GOALS = 2;
    private final ArrayDeque<IGoalInstance> d_goals = new ArrayDeque();
    private int d_seekCount = 0;
    private int d_nonseekCount = 0;
    private boolean d_seeking;

    protected void updateSeeking(KB kb, OccAgent agent) {
        this.d_seeking = this.getCurrentGoalInstance(agent).isSeeking(kb, agent);
    }

    @Override
    public boolean isSeeking(KB kb, OccAgent agent) {
        return this.d_seeking;
    }

    protected void recordGoal(KB kb, OccAgent agent, IGoalInstance goal) {
        this.d_goals.addFirst(goal);
        if (goal instanceof ISeekGoalInstance) {
            if (this.d_seekCount == 2) {
                while (!(this.d_goals.peekLast() instanceof ISeekGoalInstance)) {
                    this.d_goals.removeLast();
                }
                this.d_goals.removeLast();
            } else {
                ++this.d_seekCount;
            }
        }
        this.updateSeeking(kb, agent);
    }

    @Override
    public Collection<IGoalInstance> getGoalHistory() {
        return this.d_goals;
    }

    @Override
    public IGoalInstance getCurrentGoalInstance(OccAgent agent) {
        return !this.d_goals.isEmpty() ? this.d_goals.peekFirst() : AiUtil.getDefaultCurrGoal(agent);
    }
}

