/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.TriEdge;
import inferno.data2.TriPoint;
import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccGroupType;
import inferno.sim.OccProfileSim;
import inferno.sim.path.PathGen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.mtproc.MTListProcessor;
import thunderheadeng.util.mtproc.MTProcessor;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.LogNormCurve;
import thunderheadeng.util.stat.StdNormCurve;
import thunderheadeng.util.stat.UniformCurve;

public class SizeConstrainedKMeans {
    private final Algorithm algorithm;
    private final DistanceMetric distanceMetric;
    private static final int ITERATION_LIMIT = 100;
    private static final int PARALLEL_ALL_OCCS_LIST_SIZE = 1000;
    private static final int PARALLEL_CLUSTER_COUNT = 300;
    private static final double ASTAR_MAX_DIST_LIMIT = Double.MAX_VALUE;
    private static final double ASTAR_MAX_DIST = Double.POSITIVE_INFINITY;
    private static final int PRINT_SIZE_LIMIT = 100;
    private final boolean shouldPrint;
    private KB kb;
    private List<OccAgent> agents;
    private List<OccAgent> initCenters;
    private Random rnd;
    private ICurve minNumberOfMembers;
    private ICurve prefNumberOfMembers;
    private boolean allowSmallerGroups;
    private Set<Cluster> clusters;
    private List<DataPoint> dataPoints;
    private Set<OccAgent> unclusteredOccupants = new LinkedHashSet<OccAgent>();
    private Map<SearchPair, Double> distanceCache = new HashMap<SearchPair, Double>();
    private final boolean useExactCalc;
    private final double heightMultiplier;
    private final boolean useProfileDist;
    private final Map<OccProfileSim, OccGroupType.GroupCreationData> profileMap;
    private final Function<DataPoint, Double> distFn = dataPoint -> {
        double minDist = Double.MAX_VALUE;
        double maxDist = -1.7976931348623157E308;
        for (Cluster c : this.clusters) {
            double dist;
            if (!c.canJoin((DataPoint)dataPoint) || (dist = this.distance((DataPoint)dataPoint, c.center)) == Double.POSITIVE_INFINITY) continue;
            if (dist < minDist) {
                minDist = dist;
            }
            if (!(dist > maxDist)) continue;
            maxDist = dist;
        }
        return minDist - maxDist;
    };
    private final Function<DataPoint, Double> currDeltaFn = dataPoint -> {
        double bestAlternateDist = Double.MAX_VALUE;
        Cluster current = ((DataPoint)dataPoint).currentCluster.cluster;
        double currentDist = ((DataPoint)dataPoint).currentCluster.distance;
        for (Cluster c : this.clusters) {
            double dist;
            if (c == current || (dist = this.distance((DataPoint)dataPoint, c.center)) == Double.POSITIVE_INFINITY || !(dist < bestAlternateDist)) continue;
            bestAlternateDist = dist;
        }
        return bestAlternateDist - currentDist;
    };
    private final BiFunction<SearchPair, Double, Double> getAStarDistance = (searchPair, radius) -> {
        double maxDist = Double.MAX_VALUE;
        PathGen.PointGoal goal = new PathGen.PointGoal(((SearchPair)searchPair).t2);
        Pair<List<TriPoint>, List<TriEdge>> path = PathGen.getPath(this.kb.getMesh(), ((SearchPair)searchPair).t1.tri, null, null, ((SearchPair)searchPair).t1.p, goal, radius, maxDist, p -> true);
        return path != null ? PathGen.getPathLength((List)path.v1) : Double.POSITIVE_INFINITY;
    };
    private final Comparator<DataPoint> initComparator = (dp1, dp2) -> (int)Math.signum(this.distFn.apply((DataPoint)dp1) - this.distFn.apply((DataPoint)dp2));
    private final Comparator<DataPoint> currDeltaComparator = (dp1, dp2) -> (int)Math.signum(this.currDeltaFn.apply((DataPoint)dp1) - this.currDeltaFn.apply((DataPoint)dp2));

    public SizeConstrainedKMeans(KB kb, List<OccAgent> agents, ICurve minNumberOfMembers, ICurve prefNumberOfMembers, boolean allowSmallerGroups, boolean useExactCalc, double heightMultiplier, Random rnd, boolean useProfileDist, Map<OccProfileSim, OccGroupType.GroupCreationData> profileMap) {
        this.kb = kb;
        this.allowSmallerGroups = allowSmallerGroups;
        this.useExactCalc = useExactCalc;
        this.heightMultiplier = heightMultiplier;
        this.useProfileDist = useProfileDist;
        this.profileMap = this.discretizeCurves(profileMap);
        this.agents = new ArrayList<OccAgent>(agents);
        this.initCenters = new ArrayList<OccAgent>(agents);
        this.minNumberOfMembers = SizeConstrainedKMeans.discretizeCurve(minNumberOfMembers);
        this.prefNumberOfMembers = SizeConstrainedKMeans.discretizeCurve(prefNumberOfMembers);
        this.rnd = rnd;
        boolean bl = this.shouldPrint = System.getProperty("debug-grouping") != null;
        if (useExactCalc) {
            this.algorithm = Algorithm.K_MEDOIDS;
            this.distanceMetric = DistanceMetric.ASTAR;
        } else {
            this.algorithm = Algorithm.K_MEANS;
            this.distanceMetric = heightMultiplier != 0.0 ? DistanceMetric.EUCLIDEAN_PENALIZED_HEIGHT : DistanceMetric.EUCLIDEAN;
        }
    }

    public ClusteringResult cluster() {
        if (this.agents.size() > 100) {
            System.out.println("Clustering " + this.agents.size() + " occupants...");
        }
        this.initialize();
        boolean change = true;
        int i = 0;
        while (change && i++ < 100) {
            change = this.iteration();
            if (!this.shouldPrint) continue;
            System.out.println("Iteration " + i + " finished");
        }
        if (this.shouldPrint) {
            System.out.println("Verifying clusters...");
        }
        this.verifyClusters();
        if (this.shouldPrint) {
            System.out.println(this.kb.getCurrentSimTime() + ": Clustering output:");
        }
        this.printState(i);
        ClusteringResult result = new ClusteringResult(this.clusters, this.unclusteredOccupants);
        return result;
    }

    private boolean iteration() {
        LinkedHashSet<Cluster> invalidClusters = null;
        for (Cluster c : this.clusters) {
            c.updateCenter();
            if (c.center != null) continue;
            if (invalidClusters == null) {
                invalidClusters = new LinkedHashSet<Cluster>();
            }
            invalidClusters.add(c);
        }
        if (invalidClusters != null) {
            this.clusters.removeAll(invalidClusters);
        }
        if (this.dataPoints.size() > 1000 && this.distanceMetric.equals((Object)DistanceMetric.ASTAR)) {
            this.updateDistancesParallel();
        } else {
            for (DataPoint d : this.dataPoints) {
                d.updateDistances();
            }
        }
        this.dataPoints.sort(this.currDeltaComparator);
        boolean change = false;
        for (DataPoint dataPoint : this.dataPoints) {
            block3: for (ClusterView cv : dataPoint.clusterViews) {
                if (cv == dataPoint.currentCluster || cv.distance == Double.POSITIVE_INFINITY) continue;
                double gain = dataPoint.gain(cv);
                for (DataPoint other : cv.cluster.willLeave) {
                    if (!(gain + other.gain(other.getClusterView(dataPoint.currentCluster.cluster)) > 0.0) || !cv.cluster.canSwap(dataPoint, other) || !other.currentCluster.cluster.canSwap(other, dataPoint)) continue;
                    this.swap(dataPoint, other);
                    change = true;
                    continue block3;
                }
                if (gain > 0.0 && cv.cluster.canJoin(dataPoint) && dataPoint.currentCluster.cluster.canLeave(dataPoint)) {
                    dataPoint.currentCluster.cluster.removeDataPoint(dataPoint);
                    dataPoint.currentCluster = dataPoint.getClusterView(cv.cluster);
                    cv.cluster.addDataPoint(dataPoint);
                    change = true;
                    continue;
                }
                if (dataPoint.currentCluster.cluster == ((ClusterView)dataPoint.clusterViews.get(0)).cluster || dataPoint.currentCluster.cluster.willLeave.contains(dataPoint)) continue;
                dataPoint.currentCluster.cluster.willLeave.add(dataPoint);
            }
        }
        return change;
    }

    private void swap(DataPoint dp1, DataPoint dp2) {
        ClusterView cv1 = dp1.currentCluster;
        ClusterView cv2 = dp2.currentCluster;
        dp1.currentCluster = dp1.getClusterView(cv2.cluster);
        dp2.currentCluster = dp2.getClusterView(cv1.cluster);
        cv1.cluster.removeDataPoint(dp1);
        cv2.cluster.removeDataPoint(dp2);
        cv1.cluster.addDataPoint(dp2);
        cv2.cluster.addDataPoint(dp1);
        cv1.cluster.willLeave.remove(dp1);
        cv2.cluster.willLeave.remove(dp2);
    }

    private void initialize() {
        this.clusters = new LinkedHashSet<Cluster>();
        HashMap<OccAgent, Cluster> agentToClusterMap = new HashMap<OccAgent, Cluster>();
        if (!this.useProfileDist) {
            int numAgents;
            int prefSize;
            for (int remaining = numAgents = this.agents.size(); remaining > 0; remaining -= prefSize) {
                prefSize = (int)Math.round(this.prefNumberOfMembers.getValue(this.rnd).get(Unit.ONE));
                int minSize = this.allowSmallerGroups ? (int)Math.round(this.minNumberOfMembers.getValue(this.rnd).get(Unit.ONE)) : prefSize;
                Cluster c = new Cluster(minSize, prefSize, null, this);
                this.clusters.add(c);
                agentToClusterMap.put(c.center.initCentroid, c);
            }
        } else {
            LinkedHashMap remainingProfs = new LinkedHashMap();
            for (OccAgent a : this.agents) {
                remainingProfs.compute(a.getOcc().parentProfile, (prof, oldVal) -> {
                    if (oldVal == null) {
                        return 1;
                    }
                    return oldVal + 1;
                });
            }
            boolean profilesAvailable = true;
            int originalProfileCount = remainingProfs.size();
            while (profilesAvailable && !this.initCenters.isEmpty()) {
                LinkedHashMap<OccProfileSim, ClusterProfileData> clusterProfileMap = null;
                assert (this.profileMap != null);
                clusterProfileMap = new LinkedHashMap<OccProfileSim, ClusterProfileData>();
                int minSize = 0;
                int prefSize = 0;
                for (OccProfileSim prof2 : this.profileMap.keySet()) {
                    ClusterProfileData data = new ClusterProfileData(this.profileMap.get(prof2), this.rnd, prof2, remainingProfs);
                    minSize += data.getMinSafe().intValue();
                    remainingProfs.computeIfPresent(prof2, (p, oldVal) -> {
                        if (oldVal > clusterProfileData.prefNumberOfMembers) {
                            return oldVal - clusterProfileData.prefNumberOfMembers;
                        }
                        return null;
                    });
                    prefSize += data.prefNumberOfMembers;
                    clusterProfileMap.put(prof2, data);
                }
                boolean bl = profilesAvailable = remainingProfs.size() == originalProfileCount;
                if (prefSize <= 0) continue;
                Cluster c = new Cluster(minSize, prefSize, clusterProfileMap, this);
                this.clusters.add(c);
                agentToClusterMap.put(c.center.initCentroid, c);
            }
        }
        this.dataPoints = new ArrayList<DataPoint>();
        for (OccAgent agent : this.agents) {
            DataPoint d = new DataPoint(agent, this);
            this.dataPoints.add(d);
            if (!agentToClusterMap.containsKey(agent)) continue;
            ((Cluster)((Cluster)agentToClusterMap.get((Object)agent))).center.dataPoint = d;
        }
        if (this.dataPoints.size() > 1000 && this.distanceMetric.equals((Object)DistanceMetric.ASTAR)) {
            this.precomputeCache();
        }
        ArrayList<DataPoint> remainingData = new ArrayList<DataPoint>(this.dataPoints);
        while (!remainingData.isEmpty()) {
            remainingData.sort(this.initComparator);
            ArrayList<DataPoint> toRemove = new ArrayList<DataPoint>();
            for (DataPoint dataPoint : remainingData) {
                Cluster c = this.getNearestCluster(dataPoint);
                if (c == null) {
                    this.unclusteredOccupants.add(dataPoint.agent);
                    toRemove.add(dataPoint);
                    this.dataPoints.remove(dataPoint);
                    continue;
                }
                if (!c.addDataPoint(dataPoint)) continue;
                dataPoint.currentCluster = dataPoint.getClusterView(c);
                toRemove.add(dataPoint);
            }
            remainingData.removeAll(toRemove);
        }
    }

    private void precomputeCache() {
        MTListProcessor<DataPoint> processor = new MTListProcessor<DataPoint>(Engine.getNumProcThreads(), MTProcessor.Schedule.DYNAMIC, this.kb.getThreadPool());
        processor.setList(this.dataPoints);
        try {
            processor.process(new MTProcessor.IProc<DataPoint>(){

                @Override
                public void process(DataPoint dataPoint, int threadNum, int ix) {
                    for (Cluster c : SizeConstrainedKMeans.this.clusters) {
                        SearchPair pair = new SearchPair(dataPoint.agent.getLoc(), ((Cluster)c).center.dataPoint.agent.getLoc());
                        if (SizeConstrainedKMeans.this.distanceCache.containsKey(pair)) continue;
                        double rad = Math.max(dataPoint.agent.getGeometryRadius(), ((Cluster)c).center.dataPoint.agent.getGeometryRadius());
                        double d = (Double)SizeConstrainedKMeans.this.getAStarDistance.apply(pair, rad);
                        SizeConstrainedKMeans.this.distanceCache.put(pair, d);
                    }
                }
            });
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private void updateDistancesParallel() {
        MTListProcessor<DataPoint> processor = new MTListProcessor<DataPoint>(Engine.getNumProcThreads(), MTProcessor.Schedule.DYNAMIC, this.kb.getThreadPool());
        processor.setList(this.dataPoints);
        try {
            processor.process(new MTProcessor.IProc<DataPoint>(){

                @Override
                public void process(DataPoint dataPoint, int threadNum, int ix) {
                    dataPoint.updateDistances();
                }
            });
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private void verifyClusters() {
        final Function<Cluster, Boolean> verifyCluster = c -> {
            if (((Cluster)c).center.dataPoint == null) {
                ((Cluster)c).center.dataPoint = (DataPoint)((Cluster)c).members.iterator().next();
            }
            ClusterCenter medoid = ((Cluster)c).center;
            assert (medoid.dataPoint != null);
            ArrayList<DataPoint> toRemove = null;
            for (DataPoint d : ((Cluster)c).members) {
                double dist;
                if (d == medoid.dataPoint || (dist = this.distance(d, ((Cluster)c).center, DistanceMetric.ASTAR)) != Double.POSITIVE_INFINITY) continue;
                if (toRemove == null) {
                    toRemove = new ArrayList<DataPoint>();
                }
                toRemove.add(d);
                this.unclusteredOccupants.add(d.agent);
            }
            if (toRemove != null) {
                ((Cluster)c).members.removeAll(toRemove);
            }
            if (((Cluster)c).members.size() < ((Cluster)c).minSize) {
                for (DataPoint d : ((Cluster)c).members) {
                    this.unclusteredOccupants.add(d.agent);
                }
                return false;
            }
            if (c.profileMap != null) {
                for (OccProfileSim prof : c.profileMap.keySet()) {
                    int used;
                    Integer minSize = c.profileMap.get(prof).getMinSafe();
                    if (minSize == null || (used = ((Cluster)c).usedProfiles.getOrDefault(prof, 0).intValue()) >= minSize) continue;
                    for (DataPoint d : ((Cluster)c).members) {
                        this.unclusteredOccupants.add(d.agent);
                    }
                    return false;
                }
            }
            return true;
        };
        final HashSet<Cluster> toRemove = new HashSet<Cluster>();
        if (this.clusters.size() < 300) {
            for (Cluster c2 : this.clusters) {
                if (verifyCluster.apply(c2).booleanValue()) continue;
                toRemove.add(c2);
            }
        } else {
            MTListProcessor<Cluster> processor = new MTListProcessor<Cluster>(Engine.getNumProcThreads(), MTProcessor.Schedule.DYNAMIC, this.kb.getThreadPool());
            processor.setList(new ArrayList<Cluster>(this.clusters));
            try {
                processor.process(new MTProcessor.IProc<Cluster>(){

                    @Override
                    public void process(Cluster c, int threadNum, int ix) {
                        if (!((Boolean)verifyCluster.apply(c)).booleanValue()) {
                            toRemove.add(c);
                        }
                    }
                });
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        this.clusters.removeAll(toRemove);
    }

    private Cluster getNearestCluster(DataPoint dataPoint) {
        double minDist = Double.MAX_VALUE;
        Cluster closest = null;
        for (Cluster c : this.clusters) {
            double dist;
            if (!c.canJoin(dataPoint) || (dist = this.distance(dataPoint, c.center)) == Double.POSITIVE_INFINITY || !(dist < minDist)) continue;
            minDist = dist;
            closest = c;
        }
        return closest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double distance(DataPoint point, ClusterCenter center, DistanceMetric distanceMetric) {
        switch (distanceMetric) {
            case EUCLIDEAN_PENALIZED_HEIGHT: {
                Point3d b2 = new Point3d(center.position);
                double deltaZ = center.position.z - ((DataPoint)point).agent.getPos().z;
                b2.z += (this.heightMultiplier - 1.0) * deltaZ;
                return point.agent.getPos().distance(b2);
            }
            case ASTAR: {
                SearchPair pair = new SearchPair(point.agent.getLoc(), center.dataPoint.agent.getLoc());
                Map<SearchPair, Double> deltaZ = this.distanceCache;
                synchronized (deltaZ) {
                    if (!this.distanceCache.containsKey(pair)) {
                        double rad = Math.max(point.agent.getGeometryRadius(), center.dataPoint.agent.getGeometryRadius());
                        double d = this.getAStarDistance.apply(pair, rad);
                        this.distanceCache.put(pair, d);
                    }
                }
                double dist = this.distanceCache.get(pair);
                return dist;
            }
        }
        return point.agent.getPos().distance(center.position);
    }

    private double distance(DataPoint dataPoint, ClusterCenter center) {
        return this.distance(dataPoint, center, this.distanceMetric);
    }

    private void printState(int iteration) {
        if (!this.shouldPrint) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(iteration).append(": ");
        for (Cluster c : this.clusters) {
            sb.append("[");
            boolean first = true;
            for (DataPoint d : c.members) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(d.toString());
            }
            sb.append("] ");
        }
        sb.append("\n Unclustered occupants:\n");
        for (OccAgent a : this.unclusteredOccupants) {
            sb.append(a.getName() + ", ");
        }
        System.out.println(sb.toString());
    }

    private static ICurve discretizeCurve(ICurve curve) {
        if (curve == null) {
            return null;
        }
        if (curve instanceof ConstantCurve) {
            return curve;
        }
        Unit unit = curve.getAvg().getUnit();
        double min = curve.getMin().get(unit);
        double max = curve.getMax().get(unit);
        min = min == Math.floor(min) ? min - 0.5 : Math.floor(min) + 0.5;
        max = Math.floor(max) + 0.5;
        UnitDouble minUD = new UnitDouble(min, unit);
        UnitDouble maxUD = new UnitDouble(max, unit);
        if (curve instanceof UniformCurve) {
            return new UniformCurve(minUD, maxUD);
        }
        if (curve instanceof StdNormCurve) {
            return new StdNormCurve(minUD, maxUD, curve.getAvg(), ((StdNormCurve)curve).getStdDev());
        }
        if (curve instanceof LogNormCurve) {
            return new LogNormCurve(minUD, maxUD, curve.getAvg(), ((LogNormCurve)curve).getStdDev());
        }
        assert (false);
        return null;
    }

    private Map<OccProfileSim, OccGroupType.GroupCreationData> discretizeCurves(Map<OccProfileSim, OccGroupType.GroupCreationData> map) {
        if (map == null) {
            return null;
        }
        LinkedHashMap<OccProfileSim, OccGroupType.GroupCreationData> newMap = new LinkedHashMap<OccProfileSim, OccGroupType.GroupCreationData>();
        for (OccProfileSim prof : map.keySet()) {
            OccGroupType.GroupCreationData data = map.get(prof);
            ICurve prefNumberOfMembers = SizeConstrainedKMeans.discretizeCurve(data.prefNumberOfMembers);
            ICurve minNumberOfMembers = SizeConstrainedKMeans.discretizeCurve(data.minNumberOfMembers);
            OccGroupType.GroupCreationData newData = new OccGroupType.GroupCreationData(prefNumberOfMembers, data.allowSmallerGroups, minNumberOfMembers);
            newMap.put(prof, newData);
        }
        return newMap;
    }

    private static enum DistanceMetric {
        EUCLIDEAN,
        EUCLIDEAN_PENALIZED_HEIGHT,
        ASTAR;

    }

    private static enum Algorithm {
        K_MEANS,
        K_MEDOIDS;

    }

    public static class ClusterProfileData {
        public final int prefNumberOfMembers;
        public final boolean allowSmallerGroups;
        public final Integer minNumberOfMembers;

        public ClusterProfileData(OccGroupType.GroupCreationData groupCreationData, Random rnd, OccProfileSim prof, Map<OccProfileSim, Integer> remainingProfs) {
            int pref;
            this.prefNumberOfMembers = pref = (int)groupCreationData.prefNumberOfMembers.getValue(rnd).getValue(Unit.ONE);
            this.allowSmallerGroups = groupCreationData.allowSmallerGroups;
            this.minNumberOfMembers = this.allowSmallerGroups ? Integer.valueOf((int)groupCreationData.minNumberOfMembers.getValue(rnd).getValue(Unit.ONE)) : null;
        }

        public Integer getMinSafe() {
            return this.minNumberOfMembers != null ? this.minNumberOfMembers : this.prefNumberOfMembers;
        }
    }

    public static class ClusteringResult {
        public final Set<Cluster> clusters;
        public final Set<OccAgent> unClusteredOccs;

        public ClusteringResult(Set<Cluster> clusters, Set<OccAgent> unClusteredOccs) {
            this.clusters = clusters;
            this.unClusteredOccs = unClusteredOccs;
        }
    }

    private static class SearchPair {
        private final TriPoint t1;
        private final TriPoint t2;

        public SearchPair(TriPoint t1, TriPoint t2) {
            this.t1 = t1;
            this.t2 = t2;
        }

        public int hashCode() {
            return this.t1.hashCode() + this.t2.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof SearchPair)) {
                return false;
            }
            SearchPair otherPair = (SearchPair)other;
            return this.t1.equals(otherPair.t1) && this.t2.equals(otherPair.t2) || this.t1.equals(otherPair.t2) && this.t2.equals(otherPair.t1);
        }
    }

    private static class ClusterView {
        public double distance;
        private final Cluster cluster;

        public ClusterView(Cluster c) {
            this.cluster = c;
        }
    }

    public static class DataPoint {
        private final OccAgent agent;
        private final SizeConstrainedKMeans kmeans;
        private final List<ClusterView> clusterViews;
        private final Map<Cluster, ClusterView> clusterMap;
        private ClusterView currentCluster;

        public DataPoint(OccAgent agent, SizeConstrainedKMeans kmeans) {
            assert (agent != null);
            this.agent = agent;
            this.kmeans = kmeans;
            this.clusterViews = new ArrayList<ClusterView>();
            HashMap<Cluster, ClusterView> clusterMap = new HashMap<Cluster, ClusterView>();
            for (Cluster c : kmeans.clusters) {
                ClusterView cv = new ClusterView(c);
                this.clusterViews.add(cv);
                clusterMap.put(c, cv);
            }
            this.clusterMap = Collections.unmodifiableMap(clusterMap);
        }

        public ClusterView getClusterView(Cluster cluster) {
            return this.clusterMap.get(cluster);
        }

        public double gain(ClusterView cv) {
            double curDist = this.currentCluster.distance;
            double alternateDist = cv.distance;
            return curDist - alternateDist;
        }

        public void updateDistances() {
            for (ClusterView cv : this.clusterViews) {
                cv.distance = cv.cluster.center != null ? this.kmeans.distance(this, cv.cluster.center) : Double.MAX_VALUE;
            }
            this.clusterViews.sort((c1, c2) -> Double.compare(c1.distance, c2.distance));
        }

        public String toString() {
            return this.agent.getName();
        }
    }

    private static class ClusterCenter {
        public TriPoint triPoint;
        public Point3d position;
        public DataPoint dataPoint;
        private OccAgent initCentroid;

        public ClusterCenter(DataPoint d) {
            this.triPoint = d.agent.getLoc();
            this.position = d.agent.getPos();
            this.dataPoint = d;
        }

        public ClusterCenter(Point3d position) {
            this.position = position;
        }

        public ClusterCenter(OccAgent centroid) {
            this.initCentroid = centroid;
            this.position = centroid.getPos();
            this.triPoint = centroid.getLoc();
        }
    }

    public static class Cluster {
        private int minSize;
        private int prefSize;
        private SizeConstrainedKMeans kmeans;
        private Set<DataPoint> members;
        private Set<DataPoint> willLeave;
        private ClusterCenter center;
        public final Map<OccProfileSim, ClusterProfileData> profileMap;
        private Map<OccProfileSim, Integer> usedProfiles;

        public Cluster(int minSize, int prefSize, Map<OccProfileSim, ClusterProfileData> clusterProfileMap, SizeConstrainedKMeans kMeans) {
            this.minSize = minSize;
            this.prefSize = prefSize;
            this.profileMap = clusterProfileMap;
            this.usedProfiles = clusterProfileMap != null ? new LinkedHashMap() : null;
            this.kmeans = kMeans;
            this.members = new LinkedHashSet<DataPoint>();
            this.willLeave = new LinkedHashSet<DataPoint>();
            this.initCenter();
        }

        public int getSize() {
            return this.members.size();
        }

        public void updateCenter() {
            switch (this.kmeans.algorithm) {
                case K_MEANS: {
                    this.updateCenterMean();
                    break;
                }
                case K_MEDOIDS: {
                    this.updateCenterMedoid();
                }
            }
        }

        private void updateCenterMean() {
            Point3d center = new Point3d();
            for (DataPoint d : this.members) {
                center.add(d.agent.getPos());
            }
            center.scale(1.0 / (double)this.members.size());
            this.center = new ClusterCenter(center);
        }

        private void updateCenterMedoid() {
            double minDist = Double.MAX_VALUE;
            ClusterCenter newCenter = null;
            for (DataPoint d : this.members) {
                ClusterCenter c = new ClusterCenter(d);
                double totalDist = this.getInClusterDistance(c);
                if (!(totalDist < minDist)) continue;
                minDist = totalDist;
                newCenter = c;
            }
            if (newCenter == null) {
                if (this.members.isEmpty()) {
                    this.center = null;
                    return;
                }
                this.center = new ClusterCenter(this.members.iterator().next());
            } else {
                this.center = newCenter;
            }
        }

        private double getInClusterDistance(ClusterCenter medoid) {
            double totalDist = 0.0;
            for (DataPoint d : this.members) {
                if (d == medoid.dataPoint) continue;
                totalDist += this.kmeans.distance(d, medoid);
            }
            return totalDist;
        }

        public boolean canJoin(DataPoint datapoint) {
            if (this.profileMap == null) {
                return this.members.size() < this.prefSize;
            }
            OccProfileSim agentProf = ((DataPoint)datapoint).agent.getOcc().parentProfile;
            if (!this.profileMap.containsKey(agentProf)) {
                return false;
            }
            return this.profileMap.get((Object)agentProf).prefNumberOfMembers - this.usedProfiles.getOrDefault(agentProf, 0) > 0;
        }

        public boolean canLeave(DataPoint datapoint) {
            if (this.profileMap == null) {
                return this.members.size() > this.minSize;
            }
            OccProfileSim agentProf = ((DataPoint)datapoint).agent.getOcc().parentProfile;
            ClusterProfileData clusterProfileData = this.profileMap.get(agentProf);
            int minSize = clusterProfileData.allowSmallerGroups ? clusterProfileData.minNumberOfMembers : clusterProfileData.prefNumberOfMembers;
            return this.usedProfiles.getOrDefault(agentProf, 0) > minSize;
        }

        public boolean canSwap(DataPoint currentMeber, DataPoint newMember) {
            boolean newCanFit;
            if (this.profileMap == null) {
                return true;
            }
            OccProfileSim curProfile = ((DataPoint)currentMeber).agent.getOcc().parentProfile;
            OccProfileSim newProfile = ((DataPoint)newMember).agent.getOcc().parentProfile;
            if (curProfile.equals(newProfile)) {
                return true;
            }
            boolean bl = newCanFit = this.profileMap.get((Object)newProfile).prefNumberOfMembers - this.usedProfiles.getOrDefault(newProfile, 0) > 0;
            if (!newCanFit) {
                return false;
            }
            ClusterProfileData curClusterProfileData = this.profileMap.get(curProfile);
            int minSize = curClusterProfileData.allowSmallerGroups ? curClusterProfileData.minNumberOfMembers : curClusterProfileData.prefNumberOfMembers;
            return this.usedProfiles.getOrDefault(curProfile, 0) > minSize;
        }

        public boolean addDataPoint(DataPoint dataPoint) {
            if (!this.canJoin(dataPoint)) {
                return false;
            }
            this.members.add(dataPoint);
            if (this.usedProfiles != null) {
                this.usedProfiles.compute(((DataPoint)dataPoint).agent.getOcc().parentProfile, (prof, oldVal) -> oldVal != null ? oldVal + 1 : 1);
            }
            return true;
        }

        public void removeDataPoint(DataPoint dataPoint) {
            this.members.remove(dataPoint);
            if (this.usedProfiles != null) {
                this.usedProfiles.compute(((DataPoint)dataPoint).agent.getOcc().parentProfile, (prof, oldVal) -> oldVal - 1);
            }
        }

        private void initCenter() {
            OccAgent centroid = (OccAgent)this.kmeans.initCenters.remove(this.kmeans.rnd.nextInt(this.kmeans.initCenters.size()));
            this.center = new ClusterCenter(centroid);
        }

        public List<OccAgent> getMembers() {
            ArrayList<OccAgent> ret = new ArrayList<OccAgent>();
            for (DataPoint d : this.members) {
                ret.add(d.agent);
            }
            return ret;
        }

        public int getMinSize() {
            return this.minSize;
        }

        public int getPrefSize() {
            return this.prefSize;
        }
    }
}

