/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.IAgentBodyShape;
import inferno.data2.Occupant;
import inferno.io.CSVWriter;
import inferno.io.SerializedOutputStream;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccProfileSim;
import inferno.sim.Output;
import inferno.sim.Param;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class OccParamsWriter
implements Serializable,
Closeable {
    static final long serialVersionUID = 1L;
    public static final OccProfileSim.IOccProp<?>[] SKIP_PROPS = new OccProfileSim.IOccProp[]{OccProfileSim.PROP_MAXVEL, OccProfileSim.PROP_SHAPE};
    public static final List<OccProfileSim.IOccProp<?>> OUTPUT_PROPS;
    private final KB d_kb;
    private final SerializedOutputStream d_stream;
    private final CSVWriter d_out;

    public static String format(Object o) {
        if (o instanceof IAgentBodyShape) {
            o = ((IAgentBodyShape)o).getName();
        }
        return CSVWriter.format(o);
    }

    public OccParamsWriter(KB kb) {
        this.d_kb = kb;
        this.d_stream = new SerializedOutputStream(kb.getParams().out_occ_params);
        this.d_out = new CSVWriter();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void open(Param p) throws FileNotFoundException {
        this.d_out.open(Output.openTxtStream(this.d_stream));
    }

    @Override
    public void close() {
        this.d_out.close();
    }

    private static String getColumnHeader(String name, Unit unit) {
        return unit != null && !unit.equals(Unit.ONE) ? String.format("%s(%s)", name, unit) : name;
    }

    public void writeHeader() {
        for (Header h : Header.values()) {
            String name = OccParamsWriter.getColumnHeader(h.val, h.unit);
            this.d_out.add(name);
        }
        String OCCPROFSTR = "OccProfile.";
        for (OccProfileSim.IOccProp<?> prop : OUTPUT_PROPS) {
            String propName = prop.getName();
            if (propName.startsWith("OccProfile.")) {
                propName = propName.substring("OccProfile.".length());
            }
            propName = OccParamsWriter.getColumnHeader(propName, prop.getDisplayUnit());
            this.d_out.add(propName);
        }
        this.d_out.nextRow();
        this.d_out.flush();
    }

    public void init(double t) {
        Collection<OccAgent> agents = this.d_kb.getActiveAgents();
        for (OccAgent agent : agents) {
            this.writeFrame(t, agent);
        }
        this.d_out.flush();
    }

    public void addOccs(double t, Collection<OccAgent> agents) {
        for (OccAgent agent : agents) {
            this.writeFrame(t, agent);
        }
        this.d_out.flush();
    }

    private void writeFrame(double t, OccAgent agent) {
        Occupant occ = agent.getOcc();
        for (Header h : Header.values()) {
            String sval = h.formatter.apply(this.d_kb, occ);
            this.d_out.addAsIs(sval);
        }
        for (OccProfileSim.IOccProp iOccProp : OUTPUT_PROPS) {
            Object val = iOccProp.getValue(this.d_kb, occ);
            if (iOccProp == OccProfileSim.PROP_OCCMODEL && val instanceof String) {
                val = FilenameManager.splitFilename(new File((String)val).getName())[0];
            } else if (val instanceof UnitDouble && iOccProp.getDisplayUnit() != null) {
                val = ((UnitDouble)val).get(iOccProp.getDisplayUnit());
            }
            this.d_out.addAsIs(OccParamsWriter.format(val));
        }
        this.d_out.nextRow();
    }

    static {
        Predicate<OccProfileSim.IOccProp<?>> filter = Predicates.and(p -> !p.testOption(OccProfileSim.PropOption.SKIP_PARAM), Filters.reject(SKIP_PROPS));
        OUTPUT_PROPS = new ArrayList(theUtil.filter(OccProfileSim.ALL_OCC_PROPS, filter));
    }

    public static enum Header {
        id("id", null, (kb, occ) -> OccParamsWriter.format(occ.id)),
        name("name", null, (kb, occ) -> OccParamsWriter.format(occ.name)),
        tstart("start time", SI.SECOND, (kb, occ) -> OccParamsWriter.format(kb.getCurrentSimTime())),
        profile("profile", null, (kb, occ) -> OccParamsWriter.format(occ.parentProfile.getName())),
        behavior("behavior", null, (kb, occ) -> OccParamsWriter.format(occ.behavior.name)),
        maxVel("maxVel", OccProfileSim.SPEED_UNIT, (kb, occ) -> OccParamsWriter.format(Float.valueOf(occ.maxVel))),
        shapeType("shape", null, (kb, occ) -> OccParamsWriter.format(occ.bodyShape)),
        occupantRadius("occupantRadius", SI.METER, (kb, occ) -> OccParamsWriter.format(occ.bodyShape.getOccRadius())),
        geometryRadius("geometryRadius", SI.METER, (kb, occ) -> OccParamsWriter.format(occ.bodyShape.getGeomRadius())),
        height("height", SI.METER, (kb, occ) -> OccParamsWriter.format(occ.bodyShape.getHeight())),
        room("room", null, (kb, occ) -> OccParamsWriter.format(occ.curNode.name)),
        x("x", SI.METER, (kb, occ) -> OccParamsWriter.format(occ.loc.x)),
        y("y", SI.METER, (kb, occ) -> OccParamsWriter.format(occ.loc.y)),
        z("z", SI.METER, (kb, occ) -> OccParamsWriter.format(occ.loc.z));

        public final String val;
        public final Unit unit;
        public final BiFunction<KB, Occupant, String> formatter;

        private Header(String val, Unit unit, BiFunction<KB, Occupant, String> formatter) {
            this.val = val;
            this.unit = unit;
            this.formatter = formatter;
        }

        public String toString() {
            return this.val;
        }
    }
}

