/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;

public class ObjectTracker<T>
implements Serializable {
    static final long serialVersionUID = 1L;
    private final Set<T> d_objs;
    private final boolean d_identitySets;

    public ObjectTracker() {
        this(true);
    }

    public ObjectTracker(boolean identitySets) {
        this.d_objs = identitySets ? new LinkedIdentityHashSet() : new LinkedHashSet();
        this.d_identitySets = identitySets;
    }

    public void beginUpdate(Collection<? extends T> currentActiveObjs, Collection<T> added, Collection<T> removed) {
        this.beginUpdate(currentActiveObjs, added, removed, null, new DefRemovalFilter<T>(currentActiveObjs, this.d_identitySets), Predicates.alwaysFalse());
    }

    protected void beginUpdate(Collection<? extends T> currentActiveObjs, Collection<T> added, Collection<T> removed, Collection<T> changed, Predicate<T> removalFilter, Predicate<T> changedFilter) {
        for (Object obj : this.d_objs) {
            if (!removalFilter.test(obj)) continue;
            removed.add(obj);
        }
        for (Object obj : currentActiveObjs) {
            if (this.d_objs.contains(obj)) continue;
            added.add(obj);
            this.d_objs.add(obj);
        }
        if (!Predicates.alwaysFalse(changedFilter)) {
            for (Object obj : this.d_objs) {
                if (!changedFilter.test(obj)) continue;
                changed.add(obj);
            }
        }
    }

    public void endUpdate(Collection<? extends T> removedObjs) {
        this.d_objs.removeAll(removedObjs);
    }

    public Set<T> getObjs() {
        return this.d_objs;
    }

    protected static class DefRemovalFilter<T>
    implements Predicate<T> {
        private final Set<T> d_currentActiveObjs;

        public DefRemovalFilter(Collection<T> currentActiveObjs) {
            this(currentActiveObjs, true);
        }

        public DefRemovalFilter(Collection<T> currentActiveObjs, boolean identitySets) {
            this.d_currentActiveObjs = currentActiveObjs instanceof Set ? (Set<Object>)currentActiveObjs : (identitySets ? new IdentityHashSet<T>(currentActiveObjs) : new HashSet<T>(currentActiveObjs));
        }

        @Override
        public boolean test(T o) {
            return !this.d_currentActiveObjs.contains(o);
        }
    }
}

