/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.ANode;
import inferno.data2.Tri;
import inferno.geom.VorDensityField;
import inferno.io.SerializedOutputStream;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.Output;
import inferno.sim.Param;
import inferno.sim.WriterIntl;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.util.LinkedIdentityHashSet;

public class MeasurementRegionWriter
implements Serializable,
Closeable {
    static final long serialVersionUID = 1L;
    private static final int MIN_LEN_HEADER = 8;
    private SerializedOutputStream d_stream;
    private transient PrintStream d_out;
    private LinkedHashMap<String, AABox> d_regions;
    private Map<String, ANode> d_doors;
    private Map<ANode, Integer> d_doorLastUsage;
    private Map<String, Integer> d_regionHeaderWidth;
    private boolean d_seekSpeed;
    private double d_tLast;

    public MeasurementRegionWriter(Param p) {
        String fn = String.format("%s_measurement-regions.csv", p.out_snapshot_base);
        this.d_stream = new SerializedOutputStream(fn);
        this.d_out = null;
        this.d_seekSpeed = p.measurement_region_seekspeed;
        this.d_regions = new LinkedHashMap();
        this.d_doors = new HashMap<String, ANode>();
        this.d_doorLastUsage = new HashMap<ANode, Integer>();
        this.d_regionHeaderWidth = new HashMap<String, Integer>();
        this.d_tLast = 0.0;
    }

    public void addRegion(String name, AABox bounds, ANode door) {
        this.d_regions.put(name, bounds);
        if (door != null) {
            this.d_doors.put(name, door);
            this.d_doorLastUsage.put(door, 0);
        }
    }

    public void open() throws FileNotFoundException {
        this.d_out = Output.openTxtStream(this.d_stream);
    }

    @Override
    public void close() {
        Output.close(this.d_out);
    }

    private void writeHeaderLabel(PrintStream out, String header, int minLength) {
        String headerStr = '\"' + header + '\"';
        int fldLen = Math.max(minLength, headerStr.length());
        this.d_regionHeaderWidth.put(header, fldLen);
        out.printf(Locale.ENGLISH, "%s,", headerStr);
    }

    public void writeHeader() {
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column(Header.TIME));
        this.d_regions.forEach((k, v) -> {
            for (Header h : Header.values()) {
                if (h == Header.SEEKVEL && !this.d_seekSpeed || h.name != null) continue;
                columns.add(new Column((String)k, h));
            }
        });
        for (Column c : columns) {
            this.writeHeaderLabel(this.d_out, c.name, 8);
        }
        this.d_out.println();
        for (Column c : columns) {
            this.writeHeaderLabel(this.d_out, c.header.desc.fileStr, this.d_regionHeaderWidth.get(c.name));
        }
        this.d_out.println();
        for (Column c : columns) {
            this.writeHeaderLabel(this.d_out, c.header.unit.fileStr, this.d_regionHeaderWidth.get(c.name));
        }
        this.d_out.println();
        this.d_out.flush();
    }

    private double getClassicalDensity(KB kb, final AABox bounds) {
        final ArrayList occs = new ArrayList();
        kb.findOccs((ITest<AABox>)bounds, true, new IResult<OccAgent>(){

            @Override
            public void mark(OccAgent oa, Containment ctmt) {
                if (bounds.contains(oa.getPos())) {
                    occs.add(oa);
                }
            }
        });
        double areaOfBox = bounds.getWidth() * bounds.getDepth();
        double density = (double)occs.size() / areaOfBox;
        return density;
    }

    public void getNodes(KB kb, Set<? super ANode> nodes) {
        for (Map.Entry<String, AABox> entry : this.d_regions.entrySet()) {
            AABox bounds = entry.getValue();
            List<Tri> tris = kb.getMesh().findTris(bounds);
            if (tris.isEmpty()) continue;
            for (Tri tri : tris) {
                nodes.add(tri.node);
            }
        }
    }

    private double getVoronoiDensity(KB kb, AABox bounds, double[] vals, ToDoubleFunction<OccAgent> ... valFuncs) {
        assert (vals.length == valFuncs.length);
        Arrays.fill(vals, 0.0);
        List<Tri> tris = kb.getMesh().findTris(bounds);
        if (tris.isEmpty()) {
            return 0.0;
        }
        LinkedIdentityHashSet nodes = new LinkedIdentityHashSet();
        for (Tri tri : tris) {
            if (!(tri.node.getDensityField() instanceof VorDensityField)) continue;
            nodes.add(tri.node);
        }
        if (nodes.isEmpty()) {
            return 0.0;
        }
        double boundsArea = bounds.getWidth() * bounds.getDepth();
        double density = 0.0;
        Point3d[] boundsPts = new Point3d[]{new Point3d(bounds.getMinX(), bounds.getMinY(), 0.0), new Point3d(bounds.getMinX(), bounds.getMaxY(), 0.0), new Point3d(bounds.getMaxX(), bounds.getMaxY(), 0.0), new Point3d(bounds.getMaxX(), bounds.getMinY(), 0.0)};
        Plane3d boundsPlane = new Plane3d(0.0, 0.0, -1.0, 0.0);
        double root2 = Math.sqrt(2.0);
        AABox expandedBounds = new AABox(new Point3d(bounds.getMinX() - root2, bounds.getMinY() - root2, bounds.getMinZ()), new Point3d(bounds.getMaxX() + root2, bounds.getMaxY() + root2, bounds.getMaxZ()));
        AABox bounds2d = new AABox(bounds.getMinX(), bounds.getMinY(), 0.0, bounds.getMaxX(), bounds.getMaxY(), 0.0);
        for (ANode node : nodes) {
            VorDensityField densityField = (VorDensityField)node.getDensityField();
            for (Map.Entry<OccAgent, Face> entry : densityField.getOccAreas().entrySet()) {
                OccAgent agent = entry.getKey();
                Face f = entry.getValue();
                if (!expandedBounds.contains(agent.getPos()) || !bounds2d.intersects(f.getBounds())) continue;
                Model polyPolyInterArea = new Model();
                polyPolyInterArea.addPolygonFace(0, boundsPlane, boundsPts);
                polyPolyInterArea.addFace(f, 1);
                Predicate<Face> bothGroupsFilter = face -> face.partOfGroup(0) && face.partOfGroup(1);
                Collection<Face> inBounds = polyPolyInterArea.getFaces(bothGroupsFilter);
                double faceDensity = 1.0 / Math.min(100.0, f.getArea());
                for (Face fragment : inBounds) {
                    double fraction = fragment.getArea() / boundsArea;
                    density += fraction * faceDensity;
                    for (int m = 0; m < vals.length; ++m) {
                        int n = m;
                        vals[n] = vals[n] + fraction * valFuncs[m].applyAsDouble(agent);
                    }
                }
            }
        }
        return density;
    }

    public void writeFrame(KB kb, double t) {
        int fldLenTime = this.d_regionHeaderWidth.get("Time");
        this.d_out.printf(Locale.ENGLISH, "%" + fldLenTime + ".2f, ", t);
        double[] vals = new double[]{0.0, 0.0};
        for (Map.Entry<String, AABox> entry : this.d_regions.entrySet()) {
            String name = entry.getKey();
            AABox r = entry.getValue();
            ToDoubleFunction<OccAgent> instSpeed = a -> a.getVel().length();
            ToDoubleFunction<OccAgent> dirSpeed = a -> {
                Vector3d vel = a.getVel();
                IParametric3D scurve = a.getSeekCurve();
                a.getSeekDir();
                if (scurve == null) {
                    return vel.length();
                }
                Vector3d seekDir = scurve.getTangent(0.0);
                Util3D.safeNormalize(seekDir, 0.0);
                return Math.max(0.0, vel.dot(seekDir));
            };
            double vd = this.getVoronoiDensity(kb, r, vals, instSpeed, dirSpeed);
            ArrayDeque agentsCenterInside = new ArrayDeque();
            kb.findOccs((ITest<AABox>)r, true, (occ, ctmt) -> {
                if (r.contains(occ.getPos())) {
                    agentsCenterInside.add(occ);
                }
            });
            int count = agentsCenterInside.size();
            int fldLen = this.d_regionHeaderWidth.get(name);
            this.d_out.printf(Locale.ENGLISH, "%" + fldLen + ".2f, ", vd);
            this.d_out.printf(Locale.ENGLISH, "%" + fldLen + ".2f, ", vals[0]);
            if (this.d_seekSpeed) {
                this.d_out.printf(Locale.ENGLISH, "%" + fldLen + ".2f, ", vals[1]);
            }
            this.d_out.printf(Locale.ENGLISH, "%" + fldLen + "d, ", count);
            ANode door = this.d_doors.get(name);
            if (door == null) continue;
            this.d_doorLastUsage.put(door, door.getTotalUsage());
        }
        this.d_out.println();
        this.d_out.flush();
        this.d_tLast = t;
    }

    private static class Column {
        public final String name;
        public final Header header;

        public Column(String name, Header header) {
            this.name = name;
            this.header = header;
        }

        public Column(Header header) {
            this(header.name.fileStr, header);
        }
    }

    public static enum Header {
        TIME(WriterIntl.intl("Time"), WriterIntl.intl("Time"), WriterIntl.intl("s")),
        DENSITY(null, WriterIntl.intl("Density"), WriterIntl.intl("pers/m2")),
        VELOCITY(null, WriterIntl.intl("Velocity"), WriterIntl.intl("m/s")),
        SEEKVEL(null, WriterIntl.intl("SeekVelocity"), WriterIntl.intl("m/s")),
        COUNT(null, WriterIntl.intl("Count"), WriterIntl.intl("pers"));

        public final WriterIntl.ColHeader name;
        public final WriterIntl.ColHeader desc;
        public final WriterIntl.ColHeader unit;

        private Header(WriterIntl.ColHeader name, WriterIntl.ColHeader desc, WriterIntl.ColHeader unit) {
            this.name = name;
            this.desc = desc;
            this.unit = unit;
        }

        public String toString() {
            return this.name.toString();
        }
    }
}

