/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.io.SerializedOutputStream;
import inferno.sim.KB;
import inferno.sim.OccGroup;
import inferno.sim.Output;
import inferno.sim.Param;
import inferno.sim.WriterIntl;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class GroupInfoWriter
implements Serializable,
Closeable {
    static final long serialVersionUID = 1L;
    private KB d_kb;
    private Set<OccGroup> d_written;
    private final SerializedOutputStream d_strmOut;
    private transient PrintStream d_out;

    public GroupInfoWriter(KB kb) {
        this.d_kb = kb;
        this.d_written = new HashSet<OccGroup>();
        this.d_strmOut = new SerializedOutputStream(kb.getParams().out_group_info);
    }

    public void open(Param params) throws FileNotFoundException {
        this.d_out = Output.openTxtStream(this.d_strmOut);
    }

    @Override
    public void close() throws IOException {
        if (this.d_out != null) {
            Output.close(this.d_out);
        }
    }

    public void writeHeader() {
        String quotedJoined = Arrays.stream(Header.values()).map(h -> "\"" + h.get() + "\"").collect(Collectors.joining(", "));
        this.d_out.println(quotedJoined);
        this.d_out.flush();
    }

    public void writeFrame(double t) {
        for (OccGroup group : this.d_kb.getOccupantGroups()) {
            if (this.d_written.contains(group) || !group.isReady()) continue;
            this.d_written.add(group);
            ArrayList<String> values = new ArrayList<String>();
            String groupId = "" + group.getID();
            String groupName = group.groupName;
            String groupType = "";
            if (group.type != null) {
                groupType = group.type.groupTypeName;
            }
            List groupMemberIdList = group.getMembers().stream().map(agent -> Integer.toString(agent.getOcc().getId())).collect(Collectors.toList());
            String groupMemberIds = String.join((CharSequence)" ", groupMemberIdList);
            values.add(String.format("%s", groupId));
            values.add(String.format("\"%s\"", groupMemberIds));
            values.add(String.format("\"%s\"", groupName));
            values.add(String.format("\"%s\"", groupType));
            String rowStr = String.join((CharSequence)", ", values);
            this.d_out.println(rowStr);
        }
        this.d_out.flush();
    }

    public static enum Header implements Supplier<WriterIntl.ColHeader>
    {
        GROUP_ID(WriterIntl.intl("Group ID")),
        OCC_IDS(WriterIntl.intl("Member IDs")),
        GROUP_NAME(WriterIntl.intl("Group Name")),
        GROUP_TYPE(WriterIntl.intl("Template Name"));

        public final WriterIntl.ColHeader val;

        private Header(WriterIntl.ColHeader val) {
            this.val = val;
        }

        public String toString() {
            return this.val.toString();
        }

        @Override
        public WriterIntl.ColHeader get() {
            return this.val;
        }
    }
}

