/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import common.PathfinderLM;
import common.io.pfr.PFRWriter;
import inferno.InfernoPrefs;
import inferno.data2.ANode;
import inferno.data2.NullProps;
import inferno.data2.Occupant;
import inferno.data2.PredefTag;
import inferno.data2.Props;
import inferno.data2.Region;
import inferno.data2.Tag;
import inferno.data2.ai.AssistedEvacTeam;
import inferno.data2.ai.IProgressNote;
import inferno.geom.IDensityField;
import inferno.io.SnapshotWriter;
import inferno.sim.CameraAgent;
import inferno.sim.CycleBreaker;
import inferno.sim.DoorUsageWriter;
import inferno.sim.EngineOp;
import inferno.sim.GeomVisWriter;
import inferno.sim.GroupInfoWriter;
import inferno.sim.IAgent;
import inferno.sim.IOccDataWriter;
import inferno.sim.KB;
import inferno.sim.MeasurementRegionWriter;
import inferno.sim.OccAgent;
import inferno.sim.OccDataCumulativeWriter;
import inferno.sim.OccDataWriterMultiple;
import inferno.sim.OccDataWriterSingle;
import inferno.sim.OccGroup;
import inferno.sim.OccGroupType;
import inferno.sim.OccParamsWriter;
import inferno.sim.OccSource;
import inferno.sim.OccStats;
import inferno.sim.OccVisWriter;
import inferno.sim.Output;
import inferno.sim.Param;
import inferno.sim.RoomUsageWriter;
import inferno.sim.SocialDistanceAccumulatedWriter;
import inferno.sim.SocialDistanceTransientWriter;
import inferno.sim.TsvOutput;
import inferno.sim.profiling.TimeAccum;
import inferno.sim.scripting.ScriptHandler;
import inferno.vis.GLWindow;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import merlin.Intl;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.SystemProps;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.mtproc.MTListProcessor;
import thunderheadeng.util.mtproc.MTProcessor;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;

public class Engine
extends Observable
implements Serializable {
    static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(Engine.class.getName());
    public static final String THREAD_NAME = "Engine";
    public static final IPropertySet.Prop<Long> META_TIME_TS = new IPropertySet.Prop<Long>("ts", 0L);
    public static final IPropertySet.Prop<Double> META_TIME_SIM = new IPropertySet.Prop<Double>("simulation_time", 0.0);
    public static final IPropertySet.Prop<Double> META_TIME_WALL = new IPropertySet.Prop<Double>("wall_clock_time", 0.0);
    public static final IPropertySet.Prop<Double> META_TIME_DT = new IPropertySet.Prop<Double>("dt", 0.0);
    public static final IPropertySet.Prop<Integer> META_OCCS_REM = new IPropertySet.Prop<Integer>("occupants_remaining", 0);
    public static final IPropertySet.Prop<Integer> META_OCCS_TOTAL = new IPropertySet.Prop<Integer>("occupants_total", 0);
    public static final IPropertySet.Prop<Double> META_DTG_MAX = new IPropertySet.Prop<Double>("distance_to_goal_max", 0.0);
    public static final IPropertySet.Prop<Double> META_DTG_AVG = new IPropertySet.Prop<Double>("distance_to_goal_avg", 0.0);
    public static final IPropertySet.Prop<Double> META_DTG_MIN = new IPropertySet.Prop<Double>("distance_to_goal_min", 0.0);
    public static final IPropertySet.Prop<Boolean> META_STUCK_STATUS = new IPropertySet.Prop<Boolean>("stuck_status", false);
    public static final IPropertySet.Prop<State> META_STATE = new IPropertySet.Prop<State>("state", State.RUNNING);
    private static final boolean isDev = System.getProperty("dev") != null;
    private final TeciProps d_prefs;
    private final KB d_kb;
    private final List<OccAgent> d_occAgents;
    private final List<CameraAgent> d_camAgents;
    private final Param d_param;
    private final TimeAccum d_ticks;
    private long d_ts;
    private BigDecimal d_dt;
    private double d_wallDt;
    private BigDecimal d_simTime;
    private OccVisWriter d_occHistWriter;
    private GeomVisWriter d_geomHistWriter;
    private RoomUsageWriter d_roomUsageWriter;
    private DoorUsageWriter d_doorUsageWriter;
    private IOccDataWriter d_occDataWriters;
    private OccParamsWriter d_occParamsWriter;
    private transient List<OccAgent> d_addedAgents;
    private Deque<MeasurementRegionWriter> d_densityWriters;
    private SnapshotWriter d_snapshotWriter;
    private SocialDistanceTransientWriter d_sdTransWriter;
    private SocialDistanceAccumulatedWriter d_sdAccumWriter;
    private GroupInfoWriter d_groupInfoWriter;
    private transient PathfinderLM d_license;
    private transient GLWindow d_glView;
    private transient int d_paused;
    private transient boolean d_enginePaused;
    private transient AtomicBoolean d_cancel;
    private transient AtomicBoolean d_writeSnapshot;
    private transient AtomicBoolean d_finished;
    private Throwable[] d_caughtException = new Throwable[]{null};
    public static TimeAccum TIME_ACCUM;
    private transient Runnable d_timedCallback;
    private transient double d_timedCallbackInterval;
    private transient double d_timedCallbackLastInvoked;
    private transient AtomicBoolean d_notifyCallback;
    private List<EngineOp> d_opQueue;
    private double d_nextPlotTime;
    private double d_nextCSVPlotTime;
    private double d_nextSnapshotTime;
    private double d_nextCbTime;
    private double d_cbUpdateInterval;
    private transient ScriptHandler d_scripting;

    public static boolean isDev() {
        return isDev;
    }

    public Engine(TeciProps prefs, KB kb, Param p, TimeAccum ticks) throws FileNotFoundException {
        this.d_prefs = prefs;
        this.d_license = new PathfinderLM();
        this.d_kb = kb;
        this.d_param = p;
        TIME_ACCUM = this.d_ticks = ticks != null ? ticks : new TimeAccum();
        this.d_ticks.begin("STARTUP");
        this.d_occAgents = this.d_kb.getAgents();
        this.d_camAgents = this.d_kb.getCameraAgents();
        this.d_simTime = BigDecimal.ZERO;
        this.d_dt = BigDecimal.valueOf(this.d_param.dt_init);
        this.d_paused = 0;
        this.d_enginePaused = false;
        this.d_cancel = new AtomicBoolean(false);
        this.d_writeSnapshot = new AtomicBoolean(false);
        this.d_finished = new AtomicBoolean(false);
        this.d_occHistWriter = new OccVisWriter(this.d_param.out_occ_time_history, kb);
        this.d_geomHistWriter = new GeomVisWriter(this.d_param.out_geom_time_history);
        this.d_roomUsageWriter = new RoomUsageWriter(kb);
        this.d_doorUsageWriter = new DoorUsageWriter(kb);
        this.d_groupInfoWriter = new GroupInfoWriter(kb);
        if (kb.getParams().social_distance_csv_output) {
            double sd = kb.getParams().social_distance_value;
            this.d_kb.getMesh().shrinkInternalEdgesFromBoundary(Arrays.asList(0.1));
            this.d_sdTransWriter = new SocialDistanceTransientWriter(kb, 3.0);
            this.d_sdAccumWriter = new SocialDistanceAccumulatedWriter(kb, sd);
        }
        this.d_snapshotWriter = new SnapshotWriter(this.d_param.out_snapshot_base + ".snapshot");
        this.d_occDataWriters = kb.getParams().occ_csv_file_as_one ? new OccDataWriterSingle(kb) : new OccDataWriterMultiple(kb);
        this.d_occParamsWriter = kb.getParams().write_occ_params_file ? new OccParamsWriter(kb) : null;
        this.d_densityWriters = new ArrayDeque<MeasurementRegionWriter>();
        this.addDensityWriters();
        this.d_addedAgents = new ArrayList<OccAgent>();
        this.d_nextPlotTime = this.d_param.dt_vis > 0.0 ? this.d_param.dt_vis : Double.POSITIVE_INFINITY;
        this.d_nextCSVPlotTime = this.d_param.dt_csv_data > 0.0 ? this.d_param.dt_csv_data : Double.POSITIVE_INFINITY;
        this.d_nextSnapshotTime = this.d_param.dt_snapshot > 0.0 ? this.d_param.dt_snapshot : Double.POSITIVE_INFINITY;
        this.d_cbUpdateInterval = CycleBreaker.getUpdateInterval(this.d_occAgents, this.d_kb.getOccSources());
        double d = this.d_nextCbTime = this.d_cbUpdateInterval > 0.0 ? this.d_cbUpdateInterval : Double.POSITIVE_INFINITY;
        if (p.show_vis) {
            this.createVis();
            this.pause();
        }
        this.setTimedCallback(Double.POSITIVE_INFINITY, null);
        this.d_notifyCallback = new AtomicBoolean(false);
        this.d_opQueue = Collections.synchronizedList(new ArrayList());
        this.d_ts = 0L;
        this.d_scripting = new ScriptHandler(this, this.d_kb);
    }

    private void writeResultsFile() {
        try {
            Param p = this.d_kb.getParams();
            PFRWriter.createResultsFiles(p.dir, p.input, p.out_results, p.out_occ_time_history, p.out_geom_time_history, p.imported_geom, p.views);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.d_license = new PathfinderLM();
        this.d_paused = 0;
        this.d_enginePaused = false;
        this.d_cancel = new AtomicBoolean(false);
        this.d_writeSnapshot = new AtomicBoolean(false);
        this.d_finished = new AtomicBoolean(false);
        if (this.d_param.show_vis) {
            this.createVis();
        }
        this.d_notifyCallback = new AtomicBoolean(false);
        this.d_addedAgents = new ArrayList<OccAgent>();
        this.d_scripting = new ScriptHandler(this, this.d_kb);
        TIME_ACCUM = this.d_ticks;
    }

    public void addDensityWriters() {
        if (!this.d_kb.getDensityRegions().isEmpty()) {
            MeasurementRegionWriter dw = new MeasurementRegionWriter(this.d_param);
            for (Region r : this.d_kb.getDensityRegions()) {
                dw.addRegion(r.name, r.area, null);
            }
            this.d_densityWriters.add(dw);
        }
    }

    public void agentAdded(OccAgent oa) {
        if (0 < oa.getOcc().outputTimeHistory || this.d_occParamsWriter != null) {
            this.d_addedAgents.add(oa);
        }
    }

    public boolean hasDensityFields() {
        return System.getProperty("smooth_voronoi") != null || !this.d_densityWriters.isEmpty();
    }

    public void setTimedCallback(double dt, Runnable callback) {
        this.d_timedCallback = callback;
        this.d_timedCallbackInterval = dt;
        this.d_timedCallbackLastInvoked = this.t();
    }

    private void checkTimedCallback() {
        if (this.t() >= this.d_timedCallbackLastInvoked + this.d_timedCallbackInterval) {
            this.d_notifyCallback.set(true);
            this.notifyTimedCallback();
        }
    }

    private void notifyTimedCallback() {
        if (this.d_timedCallback != null && this.d_notifyCallback.get()) {
            this.d_timedCallback.run();
            this.d_timedCallbackLastInvoked = this.t();
            this.d_notifyCallback.set(false);
        }
    }

    private void forceCallback() {
        this.d_notifyCallback.set(true);
        this.notifyTimedCallback();
    }

    public void scheduleSnapshot() {
        this.d_writeSnapshot.set(true);
    }

    public GLWindow getGLView() {
        return this.d_glView;
    }

    private void createVis() {
        this.d_kb.setProps(new Props());
        this.d_glView = new GLWindow("Debug", this);
        this.d_glView.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosed(WindowEvent e) {
                Engine engine = Engine.this;
                synchronized (engine) {
                    Engine.this.d_glView = null;
                    ((Engine)Engine.this).d_param.show_vis = false;
                }
                Engine.this.pushOp(new EngineOp(){

                    @Override
                    public void run(Engine e) {
                        Engine.this.d_kb.setProps(new NullProps());
                    }
                });
            }
        });
        this.d_param.show_vis = true;
        this.updateVis();
    }

    public synchronized void showVis() {
        if (this.d_param.show_vis) {
            return;
        }
        this.createVis();
        this.d_glView.setVisible(true);
    }

    public Param getParam() {
        return this.d_param;
    }

    public int getAgentCount() {
        return this.d_kb.getOccs().size();
    }

    public void cancel() {
        this.d_cancel.set(true);
        this.resume();
    }

    public void checkCancel() throws CanceledException {
        if (this.d_cancel.get()) {
            this.checkSnapshot();
            throw new CanceledException();
        }
    }

    public void pause() {
        this.pause(false);
    }

    public synchronized void pause(boolean wait) {
        ++this.d_paused;
        if (wait && this.d_paused > 0 && !this.d_enginePaused) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void resume() {
        --this.d_paused;
    }

    public synchronized boolean isPaused() {
        return this.d_paused > 0;
    }

    public void scheduleCallbackNotification() {
        this.d_notifyCallback.set(true);
    }

    private synchronized void checkPause(Runnable onPause, Runnable onResume) {
        if (this.d_paused > 0) {
            LOGGER.info("paused");
            this.d_ticks.end("SIMULATION");
            this.d_enginePaused = true;
            onPause.run();
            this.notifyAll();
            while (this.d_paused > 0) {
                this.processOpQueue();
                this.notifyTimedCallback();
                try {
                    this.wait(100L);
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
            }
            this.d_enginePaused = false;
            this.d_ticks.begin("SIMULATION");
            LOGGER.info("resume");
            onResume.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOpQueue() {
        this.getKB().getPathEstimates().pauseWorkers();
        List<EngineOp> list = this.d_opQueue;
        synchronized (list) {
            for (EngineOp op : this.d_opQueue) {
                op.run(this);
                EngineOp engineOp = op;
                synchronized (engineOp) {
                    op.notifyAll();
                }
            }
            this.d_opQueue.clear();
        }
        this.getKB().getPathEstimates().resumeWorkers();
    }

    public void pushOp(EngineOp op) {
        this.pushOp(op, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushOp(EngineOp op, boolean waitForOp) {
        if (!waitForOp) {
            this.d_opQueue.add(op);
        } else {
            List<EngineOp> list = this.d_opQueue;
            synchronized (list) {
                this.d_opQueue.add(op);
                EngineOp engineOp = op;
                synchronized (engineOp) {
                    try {
                        op.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void processTimeBasedEvents() {
        NavigableMap<Double, EngineOp> events = this.d_kb.getEvents();
        NavigableMap<Double, EngineOp> passedEvts = events.headMap(this.t(), true);
        this.d_opQueue.addAll(passedEvts.values());
        passedEvts.clear();
    }

    public boolean hasFutureTimeBasedEvents() {
        return !this.d_kb.getEvents().isEmpty();
    }

    private boolean startLicenseServerWithRetry(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            if (PathfinderLM.startFromPrefs(this.d_license, this.d_prefs)) {
                return true;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(150 - new Random().nextInt(100));
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void run() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Throwable[] throwableArray = Engine.this.d_caughtException;
                synchronized (throwableArray) {
                    ((Engine)Engine.this).d_caughtException[0] = null;
                }
                MetaUpdator metaUpdator = new MetaUpdator();
                try {
                    boolean started = Engine.this.startLicenseServerWithRetry(3);
                    LOGGER.config(Engine.this.d_license.getDescription());
                    if (!started) {
                        LOGGER.log(Level.WARNING, Engine.this.d_license.getLastError());
                        throw new RuntimeException("Unable to start license manager.");
                    }
                    if (!Engine.this.d_license.isAuthorized()) {
                        throw new RuntimeException("Unable to authorize license manager.");
                    }
                    Engine.this.runSingleThread(metaUpdator);
                }
                catch (CanceledException e) {
                    LOGGER.log(Level.SEVERE, "canceled");
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
                catch (ExecutionException e) {
                    Throwable[] throwableArray2 = Engine.this.d_caughtException;
                    synchronized (throwableArray2) {
                        ((Engine)Engine.this).d_caughtException[0] = e.getCause();
                    }
                    return;
                }
                catch (Throwable e) {
                    Throwable[] t = Engine.this.d_caughtException;
                    synchronized (t) {
                        ((Engine)Engine.this).d_caughtException[0] = e;
                    }
                    return;
                }
                finally {
                    Engine.this.d_finished.set(true);
                    try {
                        Engine.this.forceCallback();
                        metaUpdator.post(Engine.this);
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.SEVERE, t.toString(), t);
                    }
                    Engine.this.d_license.closeLM();
                }
            }
        }, THREAD_NAME).start();
    }

    public KB getKB() {
        return this.d_kb;
    }

    public boolean isFinished() {
        return this.d_finished.get();
    }

    public void waitUntilFinished(long pollFreq) throws ExecutionException, FileNotFoundException {
        while (!this.isFinished()) {
            try {
                Thread.sleep(pollFreq);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
        this.throwCaughtExceptionIfPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throwCaughtExceptionIfPresent() throws ExecutionException, FileNotFoundException {
        Throwable[] throwableArray = this.d_caughtException;
        synchronized (this.d_caughtException) {
            Throwable t = this.d_caughtException[0];
            if (t instanceof FileNotFoundException) {
                throw (FileNotFoundException)this.d_caughtException[0];
            }
            if (t instanceof ExecutionException) {
                throw (ExecutionException)t;
            }
            if (t != null) {
                throw new ExecutionException(t);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void postMessage(IPropertySet engineMeta) {
        this.setChanged();
        this.notifyObservers(engineMeta);
    }

    public synchronized double t() {
        return this.d_simTime.doubleValue();
    }

    private synchronized void updateTime(BigDecimal dt) {
        this.d_simTime = this.d_simTime.add(dt);
        this.d_kb.setCurrentSimTime(this.d_simTime.doubleValue());
    }

    private double getInitTime(double dt) {
        if (dt == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double t = Math.ceil(this.t() / dt) * dt;
        if (theUtil.eq(t, this.t(), 0.0)) {
            t += dt;
        }
        return t;
    }

    public long getCurrentTimeStep() {
        return this.d_ts;
    }

    public double getCurrentDt() {
        return this.d_kb.getDt();
    }

    public double getPreviousWallDt() {
        return this.d_wallDt;
    }

    public static int getNumProcThreads() {
        String nThreadsDef = Integer.toString(Runtime.getRuntime().availableProcessors());
        String nThreadsStr = System.getProperty("nthreads", nThreadsDef);
        int nThreads = Integer.parseInt(nThreadsDef);
        try {
            nThreads = Integer.parseInt(nThreadsStr);
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
        }
        return nThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSingleThread(MetaUpdator metaUpdator) throws CanceledException, FileNotFoundException, ExecutionException {
        if (!this.d_license.isAuthorized()) {
            throw new RuntimeException("no license");
        }
        assert (this.d_kb.isValid());
        this.d_dt = BigDecimal.valueOf(this.d_param.dt_init);
        this.d_kb.setDt(this.d_dt.doubleValue());
        double initWallTime = 0.0;
        double beginTime = this.t();
        double realtimeError = 0.0;
        double nextDoorQueueUpdate = Double.NEGATIVE_INFINITY;
        double nextWallUpdate = this.d_param.dt_wall_meta;
        double endTime = this.d_param.max_time == 0.0 ? Double.POSITIVE_INFINITY : this.d_param.max_time;
        ArrayList<Closeable> ioToCleanUp = new ArrayList<Closeable>();
        try {
            ioToCleanUp.add(this.d_occHistWriter);
            ioToCleanUp.add(this.d_geomHistWriter);
            this.d_roomUsageWriter.open(this.d_param);
            ioToCleanUp.add(this.d_roomUsageWriter);
            this.d_doorUsageWriter.open(this.d_param);
            ioToCleanUp.add(this.d_doorUsageWriter);
            this.d_occDataWriters.open(this.d_param);
            ioToCleanUp.add(this.d_occDataWriters);
            this.d_groupInfoWriter.open(this.d_param);
            ioToCleanUp.add(this.d_groupInfoWriter);
            if (this.d_sdTransWriter != null) {
                this.d_sdTransWriter.open(this.d_param);
                ioToCleanUp.add(this.d_sdTransWriter);
            }
            if (this.d_sdAccumWriter != null) {
                this.d_sdAccumWriter.open(this.d_param);
                ioToCleanUp.add(this.d_sdAccumWriter);
            }
            if (this.d_occParamsWriter != null) {
                this.d_occParamsWriter.open(this.d_param);
                ioToCleanUp.add(this.d_occParamsWriter);
            }
            for (MeasurementRegionWriter writer : this.d_densityWriters) {
                writer.open();
                ioToCleanUp.add(writer);
            }
        }
        catch (FileNotFoundException e) {
            for (Closeable stream : ioToCleanUp) {
                Output.close(stream);
            }
            throw e;
        }
        MTListProcessor<OccAgent> occAgentProc = new MTListProcessor<OccAgent>(Engine.getNumProcThreads(), MTProcessor.Schedule.DYNAMIC, this.d_kb.getThreadPool());
        occAgentProc.setList(this.d_occAgents);
        InitProc initProc = new InitProc(this);
        AiUpdateProc aiUpdateProc = new AiUpdateProc(this);
        PreMoveProc premoveProc = new PreMoveProc(this);
        UpdateProc updateProc = new UpdateProc(this);
        PreMoveAssistedEvacClientsProc premoveAEClientsProc = this.d_kb.getAssistedEvacTeams() != null && !this.d_kb.getAssistedEvacTeams().isEmpty() ? new PreMoveAssistedEvacClientsProc(this) : null;
        theTimer wallTimer = new theTimer();
        MTListProcessor<ANode> nodeProc = new MTListProcessor<ANode>(Engine.getNumProcThreads(), MTProcessor.Schedule.DYNAMIC, this.d_kb.getThreadPool());
        Supplier<MTProcessor.IProc> getNodeUpdate = () -> (node, threadNum, ix) -> node.updateOccupantCounts(this.d_kb);
        List dwriterNodes = Collections.emptyList();
        MTProcessor genericProc = new MTProcessor(Engine.getNumProcThreads(), MTProcessor.Schedule.DYNAMIC, this.d_kb.getThreadPool());
        MTProcessor.IProc<AssistedEvacTeam> aeTeamUpdator = (val, threadNum, ix) -> val.update(this.d_kb);
        MTProcessor.IProc<ANode> densityFieldUpdateProc = new MTProcessor.IProc<ANode>(){

            @Override
            public void process(ANode val, int threadNum, int ix) {
                val.updateDensityField(Engine.this.d_kb);
            }
        };
        boolean updateAllDensityFields = System.getProperty("smooth_voronoi") != null;
        try {
            OutputStream stream;
            boolean finished;
            this.d_ticks.end("STARTUP");
            this.d_ticks.begin("SIMULATION");
            if (this.d_ts == 0L) {
                List<Occupant> invalidOccs;
                wallTimer.reset();
                boolean abort = false;
                if (this.d_kb.hasQueueingDoors()) {
                    Iterator<Object> invalidNodes = new ArrayList();
                    for (ANode aNode : this.d_kb.getQueuingDoors()) {
                        if (!(aNode.getArea() > 0.0)) continue;
                        invalidNodes.add(aNode);
                        abort = true;
                    }
                    if (!invalidNodes.isEmpty()) {
                        LOGGER.log(Level.WARNING, "Fatal Error - Thick Doors");
                        Iterator<ANode> iterator = invalidNodes.iterator();
                        while (iterator.hasNext()) {
                            ANode aNode = iterator.next();
                            LOGGER.log(Level.FINER, aNode.name);
                        }
                        abort = true;
                    }
                }
                if (abort) {
                    LOGGER.log(Level.WARNING, "Simulation Aborted");
                    return;
                }
                this.d_ticks.begin("SHRINK INTERNAL EDGES");
                this.d_kb.trimMeshes(this.d_param.max_trim_error);
                this.d_ticks.end("SHRINK INTERNAL EDGES");
                this.d_ticks.begin("SCRIPT");
                this.processTimeBasedEvents();
                this.processOpQueue();
                for (String script : this.d_kb.getScripts()) {
                    this.d_scripting.init(script);
                }
                this.d_ticks.end("SCRIPT");
                this.d_ticks.begin("INIT");
                this.d_kb.getPathEstimates().init();
                for (OccGroup occGroup : this.d_kb.getOccupantGroups()) {
                    occGroup.update(this.d_kb);
                }
                this.d_kb.getPathEstimates().pauseWorkers();
                occAgentProc.process(initProc);
                this.d_kb.getPathEstimates().resumeWorkers();
                this.d_kb.invalidateAgents(initProc.failed);
                for (CameraAgent camAgent : this.d_camAgents) {
                    camAgent.init(this.d_kb, this.d_param);
                }
                if (this.d_param.handle_collisions && this.d_param.reactive_steering && (invalidOccs = this.d_kb.getInvalidOccs(this.d_kb.getOccs(), true)).size() > 0) {
                    LOGGER.warning(String.format("%d Overlapping Occupants%n", invalidOccs.size()));
                    ArrayList names = new ArrayList();
                    for (Occupant occ : invalidOccs) {
                        names.add(occ.name);
                        if (7 >= names.size()) continue;
                        LOGGER.log(Level.FINER, ((Object)names).toString());
                        names.clear();
                    }
                    LOGGER.log(Level.FINER, ((Object)names).toString());
                }
                this.d_ticks.end("INIT");
                this.d_ticks.begin("UPDATE NODES");
                nodeProc.process(this.d_kb.getNodes(), getNodeUpdate.get());
                this.d_ticks.end("UPDATE NODES");
                this.d_nextPlotTime = 0.0;
                this.writeResultsFile();
                if (!this.d_densityWriters.isEmpty()) {
                    Iterator<MeasurementRegionWriter> dwriterNodesSet = new LinkedIdentityHashSet();
                    for (MeasurementRegionWriter measurementRegionWriter : this.d_densityWriters) {
                        measurementRegionWriter.getNodes(this.d_kb, (Set<? super ANode>)((Object)dwriterNodesSet));
                    }
                    dwriterNodes = new ArrayList(dwriterNodesSet);
                }
                if (updateAllDensityFields) {
                    nodeProc.setList(this.d_kb.getNodes());
                } else {
                    nodeProc.setList(dwriterNodes);
                }
                this.d_ticks.begin("UPDATE DENSITY FIELD");
                nodeProc.process(densityFieldUpdateProc);
                this.d_ticks.end("UPDATE DENSITY FIELD");
                this.d_ticks.begin("WRITE OUTPUT");
                this.d_occHistWriter.writeHeader(this.d_kb);
                this.d_geomHistWriter.writeHeader(this.d_kb);
                this.d_roomUsageWriter.writeHeader();
                this.d_doorUsageWriter.writeHeader();
                this.d_occDataWriters.writeHeader();
                this.d_groupInfoWriter.writeHeader();
                if (this.d_sdTransWriter != null) {
                    this.d_sdTransWriter.writeHeader();
                }
                if (this.d_sdAccumWriter != null) {
                    this.d_sdAccumWriter.writeHeader();
                }
                if (this.d_occParamsWriter != null) {
                    this.d_occParamsWriter.writeHeader();
                }
                for (MeasurementRegionWriter writer : this.d_densityWriters) {
                    writer.writeHeader();
                }
                this.d_occHistWriter.writeFrame(this.d_kb, this.t(), this.d_occAgents);
                this.d_geomHistWriter.writeFrame(this.d_kb, this.t());
                this.d_roomUsageWriter.writeFrame(this.t());
                if (this.d_sdTransWriter != null) {
                    this.d_sdTransWriter.writeFrame(this.t());
                }
                this.d_doorUsageWriter.writeFrame(this.t());
                this.d_occDataWriters.writeFrame(this.t(), false);
                this.d_groupInfoWriter.writeFrame(this.t());
                if (this.d_occParamsWriter != null) {
                    this.d_occParamsWriter.init(this.t());
                }
                for (MeasurementRegionWriter writer : this.d_densityWriters) {
                    writer.writeFrame(this.d_kb, this.t());
                }
                this.d_kb.getOccEnvData().update(this.d_kb, this.t());
                this.d_ticks.end("WRITE OUTPUT");
                initWallTime = wallTimer.curr();
                metaUpdator.addWallTime(initWallTime);
            }
            this.d_kb.setCurrentSimTime(this.t());
            if (this.d_param.show_vis) {
                this.d_glView.setVisible(true);
            }
            this.updateVis();
            String printMsg = this.d_ts == 0L ? "SIMULATION BEGIN" : String.format("SIMULATION RESUME from t=%g", this.t());
            LOGGER.log(Level.FINE, printMsg);
            this.d_ticks.begin("CALLBACK");
            this.checkTimedCallback();
            this.d_ticks.end("CALLBACK");
            Runnable onPauseResume = () -> {
                this.forceCallback();
                metaUpdator.post(this);
            };
            if (System.getProperty("ex_print_occupant_params") != null) {
                this.pushOp(new EngineOp.DumpAgentsTsv());
            }
            boolean bl = finished = this.d_occAgents.isEmpty() && this.d_kb.checkOccSourcesFinished() || this.t() > endTime;
            while (!finished) {
                double totWallTime;
                ++this.d_ts;
                this.checkPause(onPauseResume, onPauseResume);
                this.checkCancel();
                if (this.d_param.slower > 0) {
                    try {
                        Thread.sleep(this.d_param.slower);
                    }
                    catch (Throwable throwable) {
                        LOGGER.log(Level.SEVERE, throwable.toString(), throwable);
                    }
                }
                wallTimer.reset();
                this.d_kb.clearPerTimeStepCaches();
                double d = this.d_kb.getDt();
                this.d_ticks.begin("UPDATE OCC SOURCES");
                for (OccSource occSource : this.d_kb.getOccSources()) {
                    occSource.update(this, d);
                }
                this.d_ticks.end("UPDATE OCC SOURCES");
                this.d_ticks.begin("UPDATE OCC GROUPS");
                for (OccGroupType occGroupType : this.d_kb.getOccupantGroupTypes()) {
                    occGroupType.update(this.d_kb);
                }
                for (OccGroup throwable : this.d_kb.getOccupantGroups()) {
                    throwable.update(this.d_kb);
                }
                this.d_ticks.end("UPDATE OCC GROUPS");
                this.d_ticks.begin("SCRIPT");
                this.processTimeBasedEvents();
                this.processOpQueue();
                this.d_scripting.invokeCallbacks("onUpdate");
                this.d_ticks.end("SCRIPT");
                this.d_ticks.begin("UPDATE AE TEAMS");
                genericProc.process(this.d_kb.getAssistedEvacTeams(), aeTeamUpdator);
                this.d_ticks.end("UPDATE AE TEAMS");
                if (this.d_param.handle_collisions) {
                    this.d_ticks.begin("UPDATE OCC FINDER");
                    this.d_kb.updateOccFinder(d);
                    this.d_ticks.end("UPDATE OCC FINDER");
                }
                if (theUtil.le(nextDoorQueueUpdate, this.t(), 1.0E-6)) {
                    this.d_kb.getPathEstimates().updateDoorQueues();
                    nextDoorQueueUpdate = this.t() + this.d_param.door_queue_update_interval;
                }
                int addedAgentsCount1 = this.d_addedAgents.size();
                if (!this.d_addedAgents.isEmpty() && this.d_occParamsWriter != null) {
                    this.d_ticks.begin("WRITE OUTPUT");
                    this.d_occParamsWriter.addOccs(this.t(), this.d_addedAgents);
                    this.d_ticks.end("WRITE OUTPUT");
                }
                this.d_ticks.begin("STEERING CALC");
                this.d_kb.getPathEstimates().pauseWorkers();
                occAgentProc.process(premoveProc);
                if (premoveAEClientsProc != null) {
                    occAgentProc.process(premoveAEClientsProc);
                }
                this.d_kb.getPathEstimates().resumeWorkers();
                for (CameraAgent camAgent : this.d_camAgents) {
                    camAgent.preMove(this.d_kb, this.d_param, d);
                }
                this.d_ticks.end("STEERING CALC");
                this.d_ticks.begin("UPDATE LOCATION");
                updateProc.prepare(this);
                occAgentProc.process(updateProc);
                for (CameraAgent camAgent : this.d_camAgents) {
                    camAgent.update(this.d_kb, this.d_param, d);
                }
                this.d_ticks.end("UPDATE LOCATION");
                this.d_ticks.begin("UPDATE NODES");
                nodeProc.process(this.d_kb.getNodes(), getNodeUpdate.get());
                this.d_ticks.end("UPDATE NODES");
                this.d_ticks.begin("UPDATE DOORS");
                this.d_kb.updateDoors(d);
                this.d_ticks.end("UPDATE DOORS");
                this.d_ticks.begin("UPDATE ELEVATORS");
                this.d_kb.getElevatorModel().update(this.d_kb);
                this.d_ticks.end("UPDATE ELEVATORS");
                this.d_ticks.begin("UPDATE SUBUNITS");
                this.d_kb.updateSubunits(d);
                this.d_ticks.end("UPDATE SUBUNITS");
                if (this.d_nextCbTime <= this.t()) {
                    this.d_ticks.begin("CYCLE BREAKER");
                    this.d_kb.getCycleBreaker().update(this.d_kb, d, this.d_occAgents);
                    this.d_ticks.end("CYCLE BREAKER");
                    this.d_nextCbTime += this.d_cbUpdateInterval;
                }
                this.d_ticks.begin("UPDATE AI");
                occAgentProc.process(aiUpdateProc);
                this.d_ticks.end("UPDATE AI");
                this.updateTime(this.d_dt);
                finished |= this.d_param.shutdown_empty && this.d_occAgents.isEmpty() && this.d_kb.checkOccSourcesFinished();
                finished |= endTime < this.t();
                this.d_ticks.begin("CALLBACK");
                this.checkTimedCallback();
                this.d_ticks.end("CALLBACK");
                this.d_kb.getOccEnvData().update(this.d_kb, this.t());
                if (this.d_param.handle_collisions) {
                    this.d_ticks.begin("UPDATE OCC FINDER");
                    for (OccAgent agent : this.d_occAgents) {
                        if (!agent.isDone()) continue;
                        this.d_kb.getOccFinder().remove(agent);
                    }
                    this.d_ticks.end("UPDATE OCC FINDER");
                }
                this.updateVis();
                this.d_ticks.begin("WRITE OUTPUT");
                if (this.d_sdAccumWriter != null) {
                    this.d_sdAccumWriter.update(false);
                }
                if (this.t() >= this.d_nextPlotTime || finished) {
                    this.d_occHistWriter.writeFrame(this.d_kb, this.t(), this.d_occAgents);
                    this.d_nextPlotTime += this.d_param.dt_vis;
                    this.d_kb.pruneFinishedAgents();
                    this.d_geomHistWriter.writeFrame(this.d_kb, this.t());
                }
                if (updateAllDensityFields) {
                    nodeProc.setList(this.d_kb.getNodes());
                } else if (this.t() >= this.d_nextCSVPlotTime) {
                    nodeProc.setList(dwriterNodes);
                } else {
                    nodeProc.setList(Collections.emptyList());
                }
                this.d_ticks.begin("UPDATE DENSITY FIELD");
                nodeProc.process(densityFieldUpdateProc);
                this.d_ticks.end("UPDATE DENSITY FIELD");
                if (this.t() >= this.d_nextCSVPlotTime) {
                    this.d_roomUsageWriter.writeFrame(this.t());
                    this.d_doorUsageWriter.writeFrame(this.t());
                    if (this.d_sdTransWriter != null) {
                        this.d_sdTransWriter.writeFrame(this.t());
                    }
                    this.d_occDataWriters.writeFrame(this.t(), true);
                    this.d_groupInfoWriter.writeFrame(this.t());
                    for (MeasurementRegionWriter writer : this.d_densityWriters) {
                        writer.writeFrame(this.d_kb, this.t());
                    }
                    this.d_nextCSVPlotTime += this.d_param.dt_csv_data;
                }
                this.d_occDataWriters.addAgents(this.t(), this.d_addedAgents);
                int n = this.d_addedAgents.size();
                assert (n == addedAgentsCount1);
                if (n != addedAgentsCount1) {
                    LOGGER.log(Level.WARNING, () -> String.format("%d agents were added after recording parameters and will be missing from params file.", addedAgentsCount2 - addedAgentsCount1));
                }
                this.d_addedAgents.clear();
                this.d_ticks.end("WRITE OUTPUT");
                if (SystemProps.get(InfernoPrefs.INCLUDE_SNAPSHOT).booleanValue()) {
                    this.d_ticks.begin("WRITE SNAPSHOT");
                    if (this.t() >= this.d_nextSnapshotTime) {
                        this.d_writeSnapshot.set(true);
                        do {
                            this.d_nextSnapshotTime += this.d_param.dt_snapshot;
                        } while (this.d_nextSnapshotTime < this.t());
                    }
                    this.checkSnapshot();
                    this.d_ticks.end("WRITE SNAPSHOT");
                }
                if ((totWallTime = metaUpdator.totTime[0] + wallTimer.curr()) >= nextWallUpdate || finished) {
                    this.postMessage(metaUpdator.mkMetaMap(this, wallTimer.curr()));
                    nextWallUpdate = totWallTime + this.d_param.dt_wall_meta;
                }
                if (this.d_param.realtime) {
                    double wallDT;
                    double thisRunSimTime = this.t() - beginTime + realtimeError;
                    this.d_wallDt = wallDT = wallTimer.curr();
                    double thisRunWallTime = metaUpdator.totTime[0] - initWallTime + wallDT;
                    int comp = theUtil.compare(thisRunWallTime, thisRunSimTime, 1.0E-6);
                    if (comp < 0) {
                        double waitTimeSec = thisRunSimTime - thisRunWallTime;
                        WaitTime waitTime = this.split(waitTimeSec);
                        this.d_ticks.begin("REALTIME CORRECTION");
                        Engine engine = this;
                        synchronized (engine) {
                            try {
                                this.wait(waitTime.millis, waitTime.nanos);
                            }
                            catch (InterruptedException e) {
                                LOGGER.log(Level.SEVERE, e.toString(), e);
                            }
                        }
                        this.d_ticks.end("REALTIME CORRECTION");
                        double newdt = Math.max(this.d_param.dt_init, wallDT);
                        this.d_dt = BigDecimal.valueOf(newdt);
                    } else if (comp > 0) {
                        double newdt = Math.min(0.2, wallDT);
                        if (wallDT > this.d_dt.doubleValue()) {
                            realtimeError += wallDT - this.d_dt.doubleValue();
                        }
                        this.d_dt = BigDecimal.valueOf(newdt);
                    }
                    this.d_kb.setDt(this.d_dt.doubleValue());
                }
                metaUpdator.addWallTime(wallTimer.curr());
            }
            LOGGER.fine("SIMULATION END");
            this.d_ticks.begin("SCRIPT");
            this.d_scripting.invokeCallbacks("onExit");
            this.d_ticks.end("SCRIPT");
            this.d_ticks.begin("WRITE OUTPUT");
            this.d_roomUsageWriter.writeFrame(this.t());
            this.d_doorUsageWriter.writeFrame(this.t());
            this.d_groupInfoWriter.writeFrame(this.t());
            if (this.d_sdTransWriter != null) {
                this.d_sdTransWriter.writeFrame(this.t());
            }
            if (this.d_sdAccumWriter != null) {
                this.d_sdAccumWriter.update(true);
                this.d_sdAccumWriter.writeOuptut();
            }
            this.d_occDataWriters.writeFrame(this.t(), false);
            for (MeasurementRegionWriter writer : this.d_densityWriters) {
                writer.writeFrame(this.d_kb, this.t());
            }
            ArrayList<FileNotFoundException> arrayList = new ArrayList<FileNotFoundException>();
            try {
                stream = Output.openTxtStream(this.d_param.out_summary);
                Throwable addedAgentsCount1 = null;
                try {
                    this.printSummary((PrintStream)stream, this.d_kb, true);
                }
                catch (Throwable throwable) {
                    addedAgentsCount1 = throwable;
                    throw throwable;
                }
                finally {
                    if (stream != null) {
                        if (addedAgentsCount1 != null) {
                            try {
                                ((PrintStream)stream).close();
                            }
                            catch (Throwable throwable) {
                                addedAgentsCount1.addSuppressed(throwable);
                            }
                        } else {
                            ((PrintStream)stream).close();
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                arrayList.add(e);
            }
            try {
                stream = new ByteArrayOutputStream();
                Throwable addedAgentsCount1 = null;
                try {
                    String string = "UTF-8";
                    PrintStream pstream = new PrintStream(stream, false, string);
                    this.printSummary(pstream, this.d_kb, false);
                    pstream.flush();
                    LOGGER.info(new String(((ByteArrayOutputStream)stream).toByteArray(), string));
                }
                catch (Throwable throwable) {
                    addedAgentsCount1 = throwable;
                    throw throwable;
                }
                finally {
                    if (stream != null) {
                        if (addedAgentsCount1 != null) {
                            try {
                                ((ByteArrayOutputStream)stream).close();
                            }
                            catch (Throwable throwable) {
                                addedAgentsCount1.addSuppressed(throwable);
                            }
                        } else {
                            ((ByteArrayOutputStream)stream).close();
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                arrayList.add(e);
            }
            try (PrintStream strmSummary = Output.openTxtStream(this.d_param.out_summary_json);){
                this.printSummaryJson(strmSummary, this.d_kb);
            }
            catch (FileNotFoundException e) {
                arrayList.add(e);
            }
            try (PrintStream strmOccDataCumulative = OccDataCumulativeWriter.open(this.d_param);){
                OccDataCumulativeWriter.write(strmOccDataCumulative, this.d_kb, this.d_kb.getOccStats());
            }
            catch (FileNotFoundException e) {
                arrayList.add(e);
            }
            this.d_ticks.end("WRITE OUTPUT");
            this.d_ticks.end("SIMULATION");
            if (SystemProps.get(InfernoPrefs.INCLUDE_POUT).booleanValue()) {
                try {
                    stream = Output.openTxtStream(this.d_param.out_performance);
                    Throwable addedAgentsCount1 = null;
                    try {
                        this.printPerformance((PrintStream)stream);
                    }
                    catch (Throwable throwable) {
                        addedAgentsCount1 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (stream != null) {
                            if (addedAgentsCount1 != null) {
                                try {
                                    ((PrintStream)stream).close();
                                }
                                catch (Throwable throwable) {
                                    addedAgentsCount1.addSuppressed(throwable);
                                }
                            } else {
                                ((PrintStream)stream).close();
                            }
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    arrayList.add(e);
                }
            }
            if (!arrayList.isEmpty()) {
                this.d_param.out.flush();
                for (int i = 0; i < arrayList.size() - 1; ++i) {
                    Exception e = (Exception)arrayList.get(i);
                    LOGGER.log(Level.SEVERE, e.toString(), e);
                }
                throw (FileNotFoundException)arrayList.get(arrayList.size() - 1);
            }
        }
        catch (CanceledException e) {
            throw e;
        }
        catch (IOException e1) {
            LOGGER.log(Level.SEVERE, e1.toString(), e1);
        }
        finally {
            for (Closeable stream : ioToCleanUp) {
                Output.close(stream);
            }
            ioToCleanUp.clear();
            this.d_kb.getThreadPool().stopAndClearThreads();
        }
    }

    private WaitTime split(double time) {
        long nanos = (long)(time * 1.0E9);
        if (nanos > 999999L) {
            long millis = nanos / 1000000L;
            return new WaitTime(millis, (int)(nanos -= millis * 1000000L));
        }
        return new WaitTime(0L, (int)nanos);
    }

    private void printPerformance(PrintStream stream) {
        this.d_ticks.printSummary(stream, "SIMULATION", new String[0]);
    }

    private void checkSnapshot() {
        if (!this.d_writeSnapshot.getAndSet(false)) {
            return;
        }
        KB kb = this.d_kb;
        Param param = kb.getParams();
        String filename = this.d_snapshotWriter.getFilename();
        param.out.printf("Writing snapshot, %s...%n", new File(filename).getName());
        try {
            this.d_snapshotWriter.write(this);
            param.out.println("Snapshot written.");
        }
        catch (IOException e) {
            param.err.println(String.format("Error writing snapshot: %s->%s%n", e, e.getLocalizedMessage()));
            LOGGER.log(Level.SEVERE, e.toString(), e);
        }
    }

    private void printSummaryJson(PrintStream strm, KB kb) {
        int usage;
        JSONObject obj = new JSONObject();
        obj.put("simulation", this.getBaseName());
        obj.put("version", "2020.4.0902");
        obj.put("mode", this.getModeDesc());
        obj.put("total_occupants", kb.getOccs().size());
        obj.put("components_all", kb.getNodes().size());
        obj.put("components_doors", kb.getDoorNodes().size());
        obj.put("triangles", kb.getMesh().getTris().length);
        obj.put("startup_time", String.format("%1.1f", this.d_ticks.getTime("STARTUP")));
        obj.put("cpu_time", String.format("%1.1f", this.d_ticks.getTime("SIMULATION")));
        Tag rrTag = kb.getPredefTag(PredefTag.REPORT_REFUGE_REACHED);
        Tag exitedTag = kb.getPredefTag(PredefTag.EXITED);
        DecimalFormat formatter = new DecimalFormat("#0.00");
        Function<OccAgent, String> printAgent = a -> a != null ? a.getName() : "";
        List<OccAgent> completedAgents = kb.getAllAgentsEver().stream().filter(oa -> Double.isFinite(tag.getInfo((OccAgent)oa).tLastTagged) || Double.isFinite(tag2.getInfo((OccAgent)oa).tLastTagged)).collect(Collectors.toList());
        if (completedAgents.size() < kb.getAllAgentsEver().size()) {
            int completed = completedAgents.size();
            int didNotComplete = kb.getAllAgentsEver().size() - completed;
            obj.put("Completed", completed);
            obj.put("Did not Complete", didNotComplete);
        }
        OccStats.ValueFunction<OccAgent> compTime = oa -> Double.isFinite(tag.getInfo((OccAgent)oa).tLastTagged) ? tag.getInfo((OccAgent)oa).tLastTagged : tag2.getInfo((OccAgent)oa).tLastTagged;
        OccStats.QuantityStats<OccAgent> compTimes = OccStats.QuantityStats.getStats(completedAgents, compTime);
        JSONObject completeTime = new JSONObject();
        JSONObject completeTimeItems = new JSONObject();
        JSONObject min = new JSONObject();
        JSONObject minItems = new JSONObject();
        minItems.put("time", formatter.format(compTimes.min));
        minItems.put("name", printAgent.apply((OccAgent)compTimes.minElement));
        min.put("min", minItems);
        completeTimeItems.putAll(min);
        JSONObject max = new JSONObject();
        JSONObject maxItems = new JSONObject();
        maxItems.put("time", formatter.format(compTimes.max));
        maxItems.put("name", printAgent.apply((OccAgent)compTimes.maxElement));
        max.put("max", maxItems);
        completeTimeItems.putAll(max);
        completeTimeItems.put("average", formatter.format(compTimes.avg));
        completeTimeItems.put("stdDev", formatter.format(compTimes.stddev));
        completeTime.put("completion_times_all", completeTimeItems);
        obj.putAll(completeTime);
        JSONObject completeTimeBehavior = new JSONObject();
        JSONArray BehaviorArray = new JSONArray();
        Function<OccAgent, String> groupByBehavior = oa -> oa.getOcc().behavior.name;
        Map<String, List<OccAgent>> groupsB = Engine.getReportingGroups(completedAgents, groupByBehavior, Intl.intl("*all behaviors*"));
        for (Map.Entry<String, List<OccAgent>> entry : groupsB.entrySet()) {
            OccStats.QuantityStats<OccAgent> result = OccStats.QuantityStats.getStats((Collection)entry.getValue(), compTime);
            JSONObject completeTimeBehaviorItems = new JSONObject();
            completeTimeBehaviorItems.put("behavior", entry.getKey());
            completeTimeBehaviorItems.put("count", entry.getValue().size());
            completeTimeBehaviorItems.putAll(min);
            completeTimeBehaviorItems.putAll(max);
            completeTimeBehaviorItems.put("avg", formatter.format(result.avg));
            completeTimeBehaviorItems.put("stdDev", formatter.format(result.stddev));
            BehaviorArray.add(completeTimeBehaviorItems);
        }
        completeTimeBehavior.put("completion_times_behavior", BehaviorArray);
        obj.putAll(completeTimeBehavior);
        JSONObject completeTimeProfile = new JSONObject();
        JSONArray ProfileArray = new JSONArray();
        Function<OccAgent, String> groupByProfile = oa -> oa.getOcc().parentProfile.getName();
        Map<String, List<OccAgent>> groupsP = Engine.getReportingGroups(completedAgents, groupByProfile, Intl.intl("*all profiles*"));
        for (Map.Entry<String, List<OccAgent>> entry : groupsP.entrySet()) {
            OccStats.QuantityStats<OccAgent> result = OccStats.QuantityStats.getStats((Collection)entry.getValue(), compTime);
            JSONObject completeTimeProfileItems = new JSONObject();
            completeTimeProfileItems.put("profile", entry.getKey());
            completeTimeProfileItems.put("count", entry.getValue().size());
            completeTimeProfileItems.putAll(min);
            completeTimeProfileItems.putAll(max);
            completeTimeProfileItems.put("avg", formatter.format(result.avg));
            completeTimeProfileItems.put("stdDev", formatter.format(result.stddev));
            ProfileArray.add(completeTimeProfileItems);
        }
        completeTimeProfile.put("completion_times_profile", ProfileArray);
        obj.putAll(completeTimeProfile);
        OccStats stats = kb.getOccStats();
        OccStats.QuantityStats<OccAgent> travelDistances = stats.getTravelDistanceStats(kb);
        JSONObject moveDistance = new JSONObject();
        JSONObject moveDistanceItems = new JSONObject();
        JSONObject movemin = new JSONObject();
        JSONObject moveminItems = new JSONObject();
        moveminItems.put("distance", formatter.format(travelDistances.min));
        moveminItems.put("name", printAgent.apply((OccAgent)travelDistances.minElement));
        movemin.put("min", moveminItems);
        moveDistanceItems.putAll(movemin);
        JSONObject movemax = new JSONObject();
        JSONObject movemaxItems = new JSONObject();
        movemaxItems.put("distance", formatter.format(travelDistances.max));
        movemaxItems.put("name", printAgent.apply((OccAgent)travelDistances.maxElement));
        movemax.put("max", movemaxItems);
        moveDistanceItems.putAll(movemax);
        moveDistanceItems.put("average", formatter.format(travelDistances.avg));
        moveDistanceItems.put("stdDev", formatter.format(travelDistances.stddev));
        moveDistance.put("movement_distances_all", moveDistanceItems);
        obj.putAll(moveDistance);
        OccStats.ValueFunction<OccAgent> travelDist = oa -> oa.getOcc().totalDistanceMeters;
        JSONObject travelDistanceBehavior = new JSONObject();
        JSONArray tdBehaviorArray = new JSONArray();
        for (Map.Entry<String, List<OccAgent>> entry : groupsB.entrySet()) {
            OccStats.QuantityStats<OccAgent> result = OccStats.QuantityStats.getStats((Collection)entry.getValue(), travelDist);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("behavior", entry.getKey());
            jSONObject.put("count", entry.getValue().size());
            jSONObject.putAll(movemin);
            jSONObject.putAll(movemax);
            jSONObject.put("avg", formatter.format(result.avg));
            jSONObject.put("stdDev", formatter.format(result.stddev));
            tdBehaviorArray.add(jSONObject);
        }
        travelDistanceBehavior.put("movement_distances_behavior", tdBehaviorArray);
        obj.putAll(travelDistanceBehavior);
        JSONObject travelDistanceProfile = new JSONObject();
        JSONArray tdProfileArray = new JSONArray();
        for (Map.Entry entry : groupsP.entrySet()) {
            OccStats.QuantityStats<OccAgent> result = OccStats.QuantityStats.getStats((Collection)entry.getValue(), travelDist);
            JSONObject travelDistanceProfileItems = new JSONObject();
            travelDistanceProfileItems.put("profile", entry.getKey());
            travelDistanceProfileItems.put("count", ((List)entry.getValue()).size());
            travelDistanceProfileItems.putAll(movemin);
            travelDistanceProfileItems.putAll(movemax);
            travelDistanceProfileItems.put("avg", formatter.format(result.avg));
            travelDistanceProfileItems.put("stdDev", formatter.format(result.stddev));
            tdProfileArray.add(travelDistanceProfileItems);
        }
        travelDistanceProfile.put("movement_distance_profile", tdProfileArray);
        obj.putAll(travelDistanceProfile);
        JSONArray dfrArray = new JSONArray();
        for (ANode n : kb.getDoorNodes()) {
            double tFirst = n.getTimeFirstPersonEntered();
            double tLast = n.getTimeLastPersonExited();
            String nLast = n.getNameLastPersonExited();
            usage = n.getTotalUsage();
            String flow = "";
            if (1.0 < tLast - tFirst) {
                flow = formatter.format((double)usage / (tLast - tFirst));
            }
            JSONObject doorFlowRateItems = new JSONObject();
            doorFlowRateItems.put("door", n.name);
            doorFlowRateItems.put("first_in", formatter.format(tFirst));
            doorFlowRateItems.put("last_out", formatter.format(tLast));
            doorFlowRateItems.put("last_out_name", nLast != null ? nLast : "");
            doorFlowRateItems.put("total_use", usage);
            doorFlowRateItems.put("flow_avg", flow);
            dfrArray.add(doorFlowRateItems);
        }
        obj.put("door_flow_rates", dfrArray);
        JSONArray jSONArray = new JSONArray();
        for (ANode n : kb.getNodes()) {
            if (n.isDoor()) continue;
            double tFirst = n.getTimeFirstPersonEntered();
            double tLast = n.getTimeLastPersonExited();
            usage = n.getTotalUsage();
            String nLast = n.getNameLastPersonExited();
            JSONObject roomUsageItems = new JSONObject();
            roomUsageItems.put("room", n.name);
            roomUsageItems.put("first_in", formatter.format(tFirst));
            roomUsageItems.put("last_out", formatter.format(tLast));
            roomUsageItems.put("last_out_name", nLast != null ? nLast : "     ");
            roomUsageItems.put("total_use", usage);
            jSONArray.add(roomUsageItems);
        }
        obj.put("room_usage", jSONArray);
        strm.println(obj);
    }

    private void printSummary(PrintStream strm, KB kb, boolean longform) {
        int usage;
        OccStats stats = kb.getOccStats();
        Function<OccAgent, String> printAgent = a -> a != null ? "\"" + a.getName() + "\"" : "";
        strm.println();
        strm.println(Intl.intl("***SUMMARY***SUMMARY***SUMMARY***SUMMARY***SUMMARY***"));
        strm.println();
        strm.printf(Intl.intl("Simulation:         %s%n"), this.getBaseName());
        strm.printf(Intl.intl("Version:            %s%n"), "2020.4.0902");
        strm.printf(Intl.intl("Mode:               %s%n"), this.getModeDesc());
        strm.printf(Intl.intl("Total Occupants:    %d%n"), kb.getOccs().size());
        strm.println();
        Tag rrTag = kb.getPredefTag(PredefTag.REPORT_REFUGE_REACHED);
        Tag exitedTag = kb.getPredefTag(PredefTag.EXITED);
        List<OccAgent> completedAgents = kb.getAllAgentsEver().stream().filter(oa -> Double.isFinite(tag.getInfo((OccAgent)oa).tLastTagged) || Double.isFinite(tag2.getInfo((OccAgent)oa).tLastTagged)).collect(Collectors.toList());
        if (completedAgents.size() < kb.getAllAgentsEver().size()) {
            int completed = completedAgents.size();
            int didNotComplete = kb.getAllAgentsEver().size() - completed;
            strm.printf(Intl.intl("  Completed:          %d%n"), completed);
            strm.printf(Intl.intl("  Did not Complete:   %d (excluded from summary tables)%n"), didNotComplete);
        }
        strm.println();
        OccStats.ValueFunction<OccAgent> compTime = oa -> Double.isFinite(tag.getInfo((OccAgent)oa).tLastTagged) ? tag.getInfo((OccAgent)oa).tLastTagged : tag2.getInfo((OccAgent)oa).tLastTagged;
        OccStats.QuantityStats<OccAgent> compTimes = OccStats.QuantityStats.getStats(completedAgents, compTime);
        strm.printf(Intl.intl("Completion Times for All Occupants (s):%n"), new Object[0]);
        strm.printf(Intl.intl("  Min:              %5.1f\t%s%n"), compTimes.min, printAgent.apply((OccAgent)compTimes.minElement));
        strm.printf(Intl.intl("  Max:              %5.1f\t%s%n"), compTimes.max, printAgent.apply((OccAgent)compTimes.maxElement));
        strm.printf(Intl.intl("  Average:          %5.1f%n"), compTimes.avg);
        strm.printf(Intl.intl("  StdDev:           %5.1f%n"), compTimes.stddev);
        strm.println();
        Function<OccAgent, String> groupByBehavior = oa -> oa.getOcc().behavior.name;
        Function<OccAgent, String> groupByProfile = oa -> oa.getOcc().parentProfile.getName();
        strm.println(Intl.intl("Completion Times by Behavior (s):"));
        Engine.printTsvReport(strm, completedAgents, compTime, groupByBehavior, Intl.intl("Behavior"), Intl.intl("*all behaviors*"));
        strm.println(Intl.intl("Completion Times by Profile (s):"));
        Engine.printTsvReport(strm, completedAgents, compTime, groupByProfile, Intl.intl("Profile"), Intl.intl("*all profiles*"));
        OccStats.QuantityStats<OccAgent> travelDistances = stats.getTravelDistanceStats(kb);
        strm.printf(Intl.intl("Travel Distances for All Occupants (m):%n"), new Object[0]);
        strm.printf(Intl.intl("  Min:              %5.1f\t%s%n"), travelDistances.min, printAgent.apply((OccAgent)travelDistances.minElement));
        strm.printf(Intl.intl("  Max:              %5.1f\t%s%n"), travelDistances.max, printAgent.apply((OccAgent)travelDistances.maxElement));
        strm.printf(Intl.intl("  Average:          %5.1f%n"), travelDistances.avg);
        strm.printf(Intl.intl("  StdDev:           %5.1f%n"), travelDistances.stddev);
        strm.println();
        OccStats.ValueFunction<OccAgent> travelDist = oa -> oa.getOcc().totalDistanceMeters;
        strm.printf(Intl.intl("Movement Distance by Behavior (m):%n"), new Object[0]);
        Engine.printTsvReport(strm, completedAgents, travelDist, groupByBehavior, Intl.intl("Behavior"), Intl.intl("*all behaviors*"));
        strm.printf(Intl.intl("Movement Distance by Profile (m):%n"), new Object[0]);
        Engine.printTsvReport(strm, completedAgents, travelDist, groupByProfile, Intl.intl("Profile"), Intl.intl("*all profiles*"));
        if (!longform) {
            return;
        }
        double startup_time = this.d_ticks.getTime("STARTUP");
        double cpu_time = this.d_ticks.getTime("SIMULATION");
        strm.printf(Intl.intl("[Components] All:   %d%n"), kb.getNodes().size());
        strm.printf(Intl.intl("[Components] Doors: %d%n"), kb.getDoorNodes().size());
        strm.printf(Intl.intl("Triangles:          %d%n"), kb.getMesh().getTris().length);
        if (SystemProps.get(InfernoPrefs.INCLUDE_TOUT).booleanValue()) {
            strm.printf(Intl.intl("Startup Time:       %1.1fs%n"), startup_time);
            strm.printf(Intl.intl("CPU Time:           %1.1fs%n"), cpu_time);
        }
        strm.println();
        strm.println(Intl.intl("Door Flow Rates:"));
        TsvOutput doorFlowRates = new TsvOutput();
        doorFlowRates.addRow(new String[]{Intl.intl("Door"), Intl.intl("First_In"), Intl.intl("Last_Out"), Intl.intl("Last_Out_Name"), Intl.intl("Total_Use"), Intl.intl("Flow_Avg")});
        doorFlowRates.addRow(new String[]{"", "(s)", "(s)", "", "(pers)", "(pers/s)"});
        for (ANode n : kb.getDoorNodes()) {
            double tFirst = n.getTimeFirstPersonEntered();
            double tLast = n.getTimeLastPersonExited();
            String nLast = n.getNameLastPersonExited();
            usage = n.getTotalUsage();
            String flow = "         ";
            if (1.0 < tLast - tFirst) {
                flow = String.format("%9.2f", (double)usage / (tLast - tFirst));
            }
            doorFlowRates.addRow(new String[]{n.name, String.format("%.1f", tFirst), String.format("%.1f", tLast), nLast != null ? nLast : "     ", Integer.toString(usage), flow});
        }
        strm.println(doorFlowRates.toString());
        strm.println(Intl.intl("Room Usage:"));
        TsvOutput roomUsage = new TsvOutput();
        roomUsage.addRow(new String[]{Intl.intl("Room"), Intl.intl("First_In"), Intl.intl("Last_Out"), Intl.intl("Last_Out_Name"), Intl.intl("Total_Use")});
        roomUsage.addRow(new String[]{"", "(s)", "(s)", "", "(pers)"});
        for (ANode n : kb.getNodes()) {
            if (n.isDoor()) continue;
            double tFirst = n.getTimeFirstPersonEntered();
            double tLast = n.getTimeLastPersonExited();
            usage = n.getTotalUsage();
            String nLast = n.getNameLastPersonExited();
            roomUsage.addRow(new String[]{n.name, String.format("%.1f", tFirst), String.format("%.1f", tLast), nLast != null ? nLast : "     ", Integer.toString(usage)});
        }
        strm.println(roomUsage.toString());
    }

    private static void printTsvReport(PrintStream strm, List<OccAgent> completedAgents, OccStats.ValueFunction<OccAgent> valueFunc, Function<OccAgent, String> groupFunc, String typeName, String allName) {
        Function<OccAgent, String> quoteAgent = a -> a != null ? "\"" + a.getName() + "\"" : "";
        String[] statCols = new String[]{typeName, Intl.intl("Count"), Intl.intl("Min"), Intl.intl("Min_Name"), Intl.intl("Max"), Intl.intl("Max_Name"), Intl.intl("Avg"), Intl.intl("StdDev")};
        Map<String, List<OccAgent>> groups = Engine.getReportingGroups(completedAgents, groupFunc, allName);
        TsvOutput tsv = new TsvOutput();
        tsv.addRow(statCols);
        for (Map.Entry<String, List<OccAgent>> entry : groups.entrySet()) {
            OccStats.QuantityStats<OccAgent> result = OccStats.QuantityStats.getStats((Collection)entry.getValue(), valueFunc);
            tsv.addRow(new String[]{entry.getKey(), Integer.toString(entry.getValue().size()), String.format("%.1f", result.min), quoteAgent.apply((OccAgent)result.minElement), String.format("%.1f", result.max), quoteAgent.apply((OccAgent)result.maxElement), String.format("%.1f", result.avg), String.format("%.1f", result.stddev)});
            if (result.min != 0.0) continue;
            LOGGER.log(Level.INFO, "...");
        }
        strm.println(tsv.toString());
    }

    private static Map<String, List<OccAgent>> getReportingGroups(List<OccAgent> completedAgents, Function<OccAgent, String> groupFunc, String allName) {
        HashMap<String, List> groups = new HashMap<String, List>();
        for (OccAgent oa : completedAgents) {
            String name = groupFunc.apply(oa);
            groups.computeIfAbsent(name, key -> new ArrayList()).add(oa);
        }
        ArrayList names = new ArrayList(groups.keySet());
        Collections.sort(names);
        LinkedHashMap<String, List<OccAgent>> sortedGroups = new LinkedHashMap<String, List<OccAgent>>();
        for (String name : names) {
            sortedGroups.put(name, (List<OccAgent>)groups.remove(name));
        }
        assert (groups.isEmpty());
        sortedGroups.put(allName, completedAgents);
        return sortedGroups;
    }

    private String getBaseName() {
        String name = this.d_param.out_snapshot_base;
        name = name.substring(name.lastIndexOf(System.getProperty("file.separator")) + 1);
        return name;
    }

    private String getModeDesc() {
        if (this.d_param.reactive_steering) {
            if (this.d_kb.getQueuingDoors().size() == this.d_kb.getDoorNodes().size()) {
                return Intl.intl("Steering (Flow-limited)");
            }
            return Intl.intl("Steering");
        }
        return this.d_param.handle_collisions ? Intl.intl("SFPE (Prevent Collisions)") : Intl.intl("SFPE (Basic)");
    }

    @Override
    public synchronized void addObserver(Observer o) {
        super.addObserver(o);
    }

    private void updateVis() {
        this.d_ticks.begin("RENDERER");
        if (this.d_param.show_vis) {
            ArrayList<Serializable> allRender = new ArrayList<Serializable>();
            allRender.addAll(Arrays.asList(this.d_kb.getMesh().getVerts()));
            allRender.addAll(Arrays.asList(this.d_kb.getMesh().getEdges()));
            allRender.addAll(Arrays.asList(this.d_kb.getMesh().getTris()));
            allRender.addAll(this.d_kb.getNodes());
            allRender.addAll(this.d_kb.getOccSources());
            allRender.addAll(this.d_occAgents);
            for (ANode node : this.d_kb.getNodes()) {
                IDensityField df = node.getDensityField();
                allRender.add(df);
            }
            try {
                final Consumer<GLWindow> render = glView -> {
                    Engine engine = this;
                    synchronized (engine) {
                        if (this.d_glView != null) {
                            this.d_glView.render(allRender);
                        }
                    }
                };
                if (!EventQueue.isDispatchThread()) {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            render.accept(Engine.this.d_glView);
                        }
                    });
                } else {
                    render.accept(this.d_glView);
                }
            }
            catch (InvocationTargetException e1) {
                LOGGER.log(Level.SEVERE, e1.toString(), e1);
            }
            catch (InterruptedException e2) {
                LOGGER.log(Level.SEVERE, e2.toString(), e2);
            }
        }
        this.d_ticks.end("RENDERER");
    }

    private static class StuckChecker {
        private static final double T_STUCK_CHECK = 10.0;
        private Map<Object, IProgressNote> d_progress = null;
        private double d_lastCheckTime = Double.NaN;
        private boolean d_stuck = false;

        private StuckChecker() {
        }

        private void update(Engine engine) {
            if (this.d_progress == null) {
                this.d_progress = this.getCurrentProgress(engine.getKB());
            }
            double simTime = engine.t();
            if (Double.isNaN(this.d_lastCheckTime)) {
                this.d_lastCheckTime = simTime;
            }
            if (simTime - this.d_lastCheckTime > 10.0) {
                Map<Object, IProgressNote> currProgress = this.getCurrentProgress(engine.getKB());
                this.d_stuck = this.checkStuck(engine, simTime, currProgress);
                this.d_lastCheckTime = simTime;
                this.d_progress = currProgress;
            }
        }

        private Map<Object, IProgressNote> getCurrentProgress(KB kb) {
            IdentityHashMap<Object, IProgressNote> currProgress = new IdentityHashMap<Object, IProgressNote>();
            for (OccAgent occ : kb.getActiveAgents()) {
                currProgress.put(occ, occ.getProgress(kb));
            }
            for (OccSource source : kb.getActiveOccSources()) {
                currProgress.put(source, source.getProgress(kb));
            }
            return currProgress;
        }

        private boolean checkStuck(Engine engine, double simTime, Map<Object, IProgressNote> currProgress) {
            if (currProgress.size() == 0 || this.d_progress.size() != currProgress.size()) {
                return false;
            }
            boolean makingProgress = true;
            HashSet<Object> allSources = new HashSet<Object>(currProgress.keySet());
            allSources.addAll(this.d_progress.keySet());
            for (Object e : allSources) {
                IProgressNote oldProgress = this.d_progress.get(e);
                IProgressNote newProgress = currProgress.get(e);
                if (oldProgress == null) {
                    return false;
                }
                if (newProgress == null) continue;
                if (newProgress.isMakingProgress(engine.getKB(), e, oldProgress)) {
                    return false;
                }
                makingProgress = false;
            }
            return !makingProgress;
        }

        public boolean isStuck(Engine engine) {
            this.update(engine);
            return this.d_stuck;
        }
    }

    private static class MetaUpdator {
        private final double[] totTime = new double[]{0.0};
        private final StuckChecker stuckChecker = new StuckChecker();

        private MetaUpdator() {
        }

        public void post(Engine engine) {
            this.post(engine, 0.0);
        }

        public void post(Engine engine, double partialWallTime) {
            engine.postMessage(this.mkMetaMap(engine, partialWallTime));
        }

        public IPropertySet mkMetaMap(Engine engine, double partialWallTime) {
            PropertySet meta = new PropertySet();
            MetaUpdator.safeSet(meta, META_STATE, () -> {
                if (engine.isFinished()) {
                    return State.FINISHED;
                }
                if (engine.isPaused()) {
                    return State.PAUSED;
                }
                return State.RUNNING;
            });
            meta.set(META_TIME_TS, engine.d_ts);
            MetaUpdator.safeSet(meta, META_TIME_SIM, () -> engine.t());
            meta.set(META_TIME_WALL, this.totTime[0] + partialWallTime);
            MetaUpdator.safeSet(meta, META_TIME_DT, () -> engine.d_dt.doubleValue());
            MetaUpdator.safeSet(meta, META_OCCS_REM, () -> engine.d_kb.getActiveAgents().size());
            MetaUpdator.safeSet(meta, META_OCCS_TOTAL, () -> engine.d_kb.getAllAgentsEver().size());
            try {
                double[] DTGs = MetaUpdator.getAllDTGs(engine.d_occAgents);
                meta.set(META_DTG_MIN, DTGs[0]);
                meta.set(META_DTG_MAX, DTGs[1]);
                meta.set(META_DTG_AVG, DTGs[2]);
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, t.toString(), t);
            }
            MetaUpdator.safeSet(meta, META_STUCK_STATUS, () -> this.stuckChecker.isStuck(engine));
            return meta;
        }

        private static <T> void safeSet(IPropertySet meta, IPropertySet.Prop<T> prop, Supplier<T> getter) {
            try {
                meta.set(prop, getter.get());
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, t.toString(), t);
            }
        }

        public void addWallTime(double time) {
            this.totTime[0] = this.totTime[0] + time;
        }

        private static double[] getAllDTGs(List<OccAgent> oas) {
            if (oas.isEmpty()) {
                return new double[]{0.0, 0.0, 0.0};
            }
            double min = Double.MAX_VALUE;
            double max = -1.7976931348623157E308;
            double avg = 0.0;
            int count = 0;
            for (OccAgent oa : oas) {
                if (oa.getPathFollow() == null) continue;
                ++count;
                double d = oa.getRemainingDistance();
                if (!Double.isFinite(d)) continue;
                min = Math.min(d, min);
                max = Math.max(d, max);
                avg += d;
            }
            if (count == 0) {
                return new double[]{0.0, 0.0, 0.0};
            }
            return new double[]{min, max, avg /= (double)count};
        }
    }

    private static class WaitTime {
        public final long millis;
        public final int nanos;

        public WaitTime(long millis, int nanos) {
            this.millis = millis;
            this.nanos = nanos;
        }
    }

    private static class PreMoveAssistedEvacClientsProc<T extends IAgent>
    extends AAgentProc<T> {
        public PreMoveAssistedEvacClientsProc(Engine engine) {
            super(engine);
        }

        @Override
        protected void process(Engine engine, T agent, int threadNum, int ix) {
            if (agent instanceof OccAgent) {
                ((OccAgent)agent).getAssistedEvacClientModule().ifPresent(m -> m.preMoveAssistedEvacClients(engine.d_kb));
            }
        }
    }

    private static class AiUpdateProc
    extends AAgentProc<OccAgent> {
        public AiUpdateProc(Engine e) {
            super(e);
        }

        @Override
        protected void process(Engine engine, OccAgent agent, int threadNum, int ix) {
            agent.getAiCore().update(engine, engine.d_kb, agent);
        }
    }

    private static class InitProc<T extends IAgent>
    extends AAgentProc<T> {
        public final Set<T> failed = Collections.synchronizedSet(new LinkedHashSet());

        public InitProc(Engine engine) {
            super(engine);
        }

        @Override
        protected void process(Engine engine, T agent, int threadNum, int ix) {
            if (!agent.init(engine.d_kb, engine.d_kb.getParams())) {
                this.failed.add(agent);
            }
        }
    }

    private static class UpdateProc<T extends IAgent>
    extends AAgentProc<T> {
        public UpdateProc(Engine engine) {
            super(engine);
        }

        public void prepare(Engine engine) {
        }

        @Override
        protected void process(Engine engine, T agent, int threadNum, int ix) {
            agent.update(engine.d_kb, engine.d_kb.getParams(), engine.d_kb.getDt());
        }
    }

    private static class PreMoveProc<T extends IAgent>
    extends AAgentProc<T> {
        public PreMoveProc(Engine engine) {
            super(engine);
        }

        @Override
        protected void process(Engine engine, T agent, int threadNum, int ix) {
            agent.preMove(engine.d_kb, engine.d_kb.getParams(), engine.d_kb.getDt());
        }
    }

    private static abstract class AAgentProc<T extends IAgent>
    implements MTProcessor.IProc<T> {
        private final Engine d_engine;

        public AAgentProc(Engine engine) {
            this.d_engine = engine;
        }

        @Override
        public void process(T val, int threadNum, int ix) {
            if (!val.isDone()) {
                this.process(this.d_engine, val, threadNum, ix);
            }
        }

        protected abstract void process(Engine var1, T var2, int var3, int var4);
    }

    private class CanceledException
    extends Exception {
        private static final long serialVersionUID = -7950819412021714212L;

        private CanceledException() {
        }
    }

    public static enum State {
        RUNNING,
        PAUSED,
        FINISHED;

    }
}

