/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.InfernoPrefs;
import inferno.io.SerializedOutputStream;
import inferno.sim.KB;
import inferno.sim.Output;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import thunderheadeng.util.SystemProps;

public abstract class AVisWriter
implements Serializable,
Closeable {
    static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(AVisWriter.class.getName());
    private static final int MAX_FRAME_IX_BLOCK = 30720;
    private final int d_version;
    private final int d_flags;
    private final SerializedOutputStream d_stream;
    private transient DataOutputStream d_dataStream;
    private long d_sessionIdLoc = -1L;
    private final InterleavedBlockWriter d_frameIxBlockWriter;

    public AVisWriter(String filename, int version, int flags) throws FileNotFoundException {
        this.d_version = version;
        this.d_flags = flags;
        this.d_stream = new SerializedOutputStream(filename);
        this.d_dataStream = Output.openBinStream(this.d_stream);
        this.d_frameIxBlockWriter = new InterleavedBlockWriter(this, 30720);
        this.d_frameIxBlockWriter.setWriteInSingleBlock(true);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.d_dataStream = Output.openBinStream(this.d_stream);
        long currpos = this.getPos();
        this.setPos(this.d_sessionIdLoc);
        this.writeSessionId(this.d_dataStream);
        this.setPos(currpos);
        this.d_frameIxBlockWriter.deserialize();
    }

    protected DataOutputStream getStream() {
        return this.d_dataStream;
    }

    @Override
    public void close() {
        Output.close(this.d_dataStream);
    }

    protected abstract void writeCustomHeaderData(KB var1, DataOutputStream var2) throws IOException;

    public void writeHeader(KB kb) {
        DataOutputStream oos = this.d_dataStream;
        try {
            oos.writeInt(this.d_version);
            oos.writeInt(this.d_flags);
            this.d_sessionIdLoc = this.getPos();
            this.writeSessionId(oos);
            this.writeCustomHeaderData(kb, this.d_dataStream);
            this.d_frameIxBlockWriter.init();
            oos.flush();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
        }
    }

    protected void writeSessionId(DataOutputStream oos) throws IOException {
        long sessionid = Calendar.getInstance().getTimeInMillis();
        if (SystemProps.isDefined(InfernoPrefs.SID_OVERRIDE)) {
            sessionid = SystemProps.get(InfernoPrefs.SID_OVERRIDE);
        }
        oos.writeLong(sessionid);
    }

    protected long getPos() throws IOException {
        this.d_dataStream.flush();
        return this.d_stream.getChannel().position();
    }

    protected void setPos(long pos) throws IOException {
        this.d_dataStream.flush();
        this.d_stream.getChannel().position(pos);
    }

    protected void writeFrameIx(double t, long frameix) throws IOException {
        byte numBytesForLoc = AVisWriter.numBytesToWriteVal(frameix);
        int numBytes = numBytesForLoc + 1 + 4;
        ByteArrayOutputStream os = new ByteArrayOutputStream(numBytes);
        DataOutputStream ds = new DataOutputStream(os);
        ds.writeByte(numBytesForLoc);
        for (byte m = 0; m < numBytesForLoc; m = (byte)(m + 1)) {
            ds.writeByte((byte)(frameix >>> m * 8 & 0xFFL));
        }
        ds.writeFloat((float)t);
        this.d_frameIxBlockWriter.beginWrite();
        this.d_frameIxBlockWriter.write(os.toByteArray());
        this.d_frameIxBlockWriter.endWrite();
        this.d_dataStream.flush();
    }

    private static byte numBytesToWriteVal(long val) {
        int numBits = 64 - Long.numberOfLeadingZeros(val);
        byte numBytes = (byte)(numBits / 8);
        return numBits % 8 == 0 ? numBytes : (byte)(numBytes + 1);
    }

    protected static class InterleavedBlockWriter
    extends OutputStream
    implements Serializable {
        static final long serialVersionUID = 1L;
        private final AVisWriter d_writer;
        private final List<Long> d_blockPositions = new ArrayList<Long>();
        private final long d_blockSize;
        private int d_currBlock = 0;
        private long d_nextWritePos = -1L;
        private long d_newBlockPos = -1L;
        private boolean d_fitWritesInSingleBlock = false;

        public InterleavedBlockWriter(AVisWriter writer, int blockSize) {
            this.d_writer = writer;
            this.d_blockSize = blockSize;
        }

        public void setWriteInSingleBlock(boolean status) {
            this.d_fitWritesInSingleBlock = status;
        }

        public void init() throws IOException {
            this.d_writer.d_dataStream.writeInt((int)this.d_blockSize);
            this.d_newBlockPos = this.d_writer.getPos();
            this.d_currBlock = -1;
            this.nextBlock();
            this.d_writer.setPos(this.d_blockPositions.get(this.d_currBlock) + this.d_blockSize);
        }

        private void nextBlock() throws IOException {
            ++this.d_currBlock;
            if (this.d_currBlock < this.d_blockPositions.size()) {
                long currBlockPos = this.d_blockPositions.get(this.d_currBlock);
                this.d_nextWritePos = currBlockPos + 8L;
                this.d_writer.setPos(this.d_nextWritePos);
            } else {
                assert (this.d_currBlock == this.d_blockPositions.size());
                long currBlockPos = this.d_newBlockPos;
                this.d_blockPositions.add(currBlockPos);
                if (this.d_currBlock > 0) {
                    this.d_writer.setPos(this.d_blockPositions.get(this.d_currBlock - 1));
                    this.d_writer.d_dataStream.writeLong(currBlockPos);
                }
                this.d_nextWritePos = currBlockPos + 8L;
                this.d_newBlockPos = currBlockPos + this.d_blockSize;
                LOGGER.log(Level.FINER, "writing new block " + currBlockPos);
                this.d_writer.setPos(currBlockPos);
                DataOutputStream oos = this.d_writer.d_dataStream;
                oos.writeLong(-1L);
                long numBytesLeft = this.d_blockSize - 8L;
                for (long m = 0L; m < numBytesLeft; ++m) {
                    oos.writeByte(0);
                }
                this.d_writer.setPos(this.d_nextWritePos);
            }
        }

        public void deserialize() throws IOException {
            long pos = this.d_writer.getPos();
            assert (this.d_currBlock == this.d_blockPositions.size() - 1);
            long currBlockPos = this.d_blockPositions.get(this.d_currBlock);
            long numBytesLeft = this.d_blockSize - (this.d_nextWritePos - currBlockPos);
            this.d_writer.setPos(currBlockPos);
            this.d_writer.d_dataStream.writeLong(-1L);
            this.d_writer.setPos(this.d_nextWritePos);
            for (long m = 0L; m < numBytesLeft; ++m) {
                this.d_writer.d_dataStream.writeByte(0);
            }
            this.d_writer.setPos(pos);
        }

        public void beginWrite() throws IOException {
            this.d_newBlockPos = this.d_writer.getPos();
            this.d_writer.setPos(this.d_nextWritePos);
        }

        public void endWrite() throws IOException {
            this.d_writer.setPos(this.d_newBlockPos);
        }

        public long getPos() {
            return this.d_nextWritePos;
        }

        public void setPos(long pos) throws IOException {
            int i = Collections.binarySearch(this.d_blockPositions, pos);
            if (i < 0) {
                i = Math.max(0, -i - 2);
            }
            this.d_currBlock = i;
            this.d_nextWritePos = pos;
            this.d_writer.setPos(this.d_nextWritePos);
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            boolean fitInSingleBlock = this.d_fitWritesInSingleBlock && (long)len < this.d_blockSize - 8L;
            long currBlockPos = this.d_blockPositions.get(this.d_currBlock);
            int remaining = len;
            while (remaining > 0) {
                long blockRemaining = currBlockPos + this.d_blockSize - this.d_nextWritePos;
                int toWrite = (int)Math.min(blockRemaining, (long)remaining);
                if (toWrite == 0 || fitInSingleBlock && blockRemaining < (long)remaining) {
                    this.nextBlock();
                    currBlockPos = this.d_blockPositions.get(this.d_currBlock);
                    continue;
                }
                this.d_writer.d_dataStream.write(b, off, toWrite);
                off += toWrite;
                remaining -= toWrite;
                this.d_nextWritePos += (long)toWrite;
            }
        }
    }
}

