/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.ANode;
import inferno.data2.Tag;
import inferno.data2.Tri;
import inferno.data2.ai.ChangeTagGoal;
import inferno.io.CSVWriter;
import inferno.sim.BehaviorSim;
import inferno.sim.IOccDataWriter;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccEnvData;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.vecmath.Point3d;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.theUtil;

public abstract class AOccDataWriter
implements IOccDataWriter {
    private static final long serialVersionUID = 1L;
    private static int s_col = 0;
    private static final int T = s_col++;
    private static final int ID = s_col++;
    private static final int NAME = s_col++;
    private static final int ACTIVE = s_col++;
    private static final int X = s_col++;
    private static final int Y = s_col++;
    private static final int Z = s_col++;
    private static final int V = s_col++;
    private static final int DIST = s_col++;
    private static final int LOC = s_col++;
    private static final int LOC_TYPE = s_col++;
    private static final int s_numCols = s_col;

    protected static boolean testOutput(OccAgent agent) {
        return agent.getOcc().outputTimeHistory > 0;
    }

    protected static Collection<OccAgent> filterAgents(Collection<OccAgent> agents) {
        return theUtil.filter(agents, AOccDataWriter::testOutput);
    }

    protected static void writeHeader(PrintStream d_out, KB d_kb, List<Tag> d_tags) {
        List<String> h1 = AOccDataWriter.initList(s_numCols, "");
        List<String> h2 = AOccDataWriter.initList(s_numCols, "");
        TriConsumer<Integer, String, String> add = (col, name, unit) -> {
            h1.set((int)col, (String)name);
            h2.set((int)col, (String)unit);
        };
        add.accept(T, "t", "s");
        add.accept(ID, "id", "");
        add.accept(NAME, "name", "");
        add.accept(ACTIVE, "active", "");
        add.accept(X, "x", "m");
        add.accept(Y, "y", "m");
        add.accept(Z, "z", "m");
        add.accept(V, "v", "m/s");
        add.accept(DIST, "distance", "m");
        add.accept(LOC, "location", "");
        add.accept(LOC_TYPE, "terrain type", "");
        for (Tag tag : d_tags) {
            h1.add(tag.name);
            h2.add("");
        }
        OccEnvData occEnv = d_kb.getOccEnvData();
        Map<String, OccEnvData.QInfo> quantities = occEnv.getSupportedQuantities();
        for (OccEnvData.QInfo qi : quantities.values()) {
            h1.add(qi.fdsName);
            h2.add(qi.unit);
        }
        UnaryOperator quoter = CSVWriter::escape;
        h1.replaceAll(quoter);
        h2.replaceAll(quoter);
        String h1Str = String.join((CharSequence)",", h1);
        String h2Str = String.join((CharSequence)",", h2);
        d_out.println(h1Str);
        d_out.println(h2Str);
        d_out.flush();
    }

    protected static <T> List<T> initList(int size, T initVal) {
        ArrayList<T> items = new ArrayList<T>(size);
        for (int m = 0; m < size; ++m) {
            items.add(initVal);
        }
        return items;
    }

    protected static void calcPossibleTags(KB kb, Collection<OccAgent> occs, Set<Tag> tags) {
        tags.addAll(kb.getRoomTags());
        for (OccAgent oa : occs) {
            AOccDataWriter.getPossibleTags(oa.getOcc().behavior, tags);
        }
    }

    protected static void getPossibleTags(BehaviorSim behavior, Set<Tag> tags) {
        for (ChangeTagGoal goal : behavior.deepFlatten(ChangeTagGoal.class)) {
            if (goal.operator != ChangeTagGoal.Op.TAG) continue;
            tags.addAll(goal.tags);
        }
    }

    protected static void writeFrame(PrintStream d_out, KB d_kb, double t, OccAgent d_oa, List<Tag> d_tags) {
        String name = d_oa.getOcc().name;
        ANode node = d_oa.getOcc().curNode;
        String location = node == null ? "" : node.name;
        String locationType = Tri.Terrain.OPEN.description;
        if (node != null) {
            locationType = node.getTerrain().description;
        }
        List<Object> data = AOccDataWriter.initList(s_numCols, null);
        BiConsumer<Integer, Object> set = (col, val) -> data.set((int)col, CSVWriter.format(val));
        Consumer<Object> add = val -> data.add(CSVWriter.format(val));
        set.accept(T, t);
        set.accept(ID, d_oa.getId());
        set.accept(NAME, name);
        set.accept(ACTIVE, d_oa.isActive());
        Point3d displayPos = d_oa.getOcc().getDisplayLoc();
        set.accept(X, displayPos.x);
        set.accept(Y, displayPos.y);
        set.accept(Z, displayPos.z);
        set.accept(V, d_oa.getVel().length());
        set.accept(DIST, d_oa.getOcc().totalDistanceMeters);
        set.accept(LOC, location);
        set.accept(LOC_TYPE, locationType);
        assert (AOccDataWriter.getUnexpectedTag(d_kb, d_oa, d_tags) == null) : "The agent was tagged with an unexpected tag: " + AOccDataWriter.getUnexpectedTag(d_kb, d_oa, d_tags);
        for (Tag tag : d_tags) {
            add.accept(tag.isTagged(d_oa));
        }
        OccEnvData occEnv = d_kb.getOccEnvData();
        Map<String, OccEnvData.QInfo> quantities = occEnv.getSupportedQuantities();
        Map<OccEnvData.QInfo, Double> envValues = occEnv.getValues(d_oa.getOcc());
        for (OccEnvData.QInfo qi : quantities.values()) {
            if (t < d_kb.getFdsOutputData().getEndTime()) {
                add.accept(envValues.get(qi));
                continue;
            }
            add.accept(null);
        }
        String dataStr = String.join((CharSequence)",", data);
        d_out.println(dataStr);
    }

    protected static Tag getUnexpectedTag(KB d_kb, OccAgent d_oa, List<Tag> d_tags) {
        for (Tag tag : d_kb.getTags()) {
            if (tag.predefined || !tag.isTagged(d_oa) || d_tags.contains(tag)) continue;
            return tag;
        }
        return null;
    }
}

