/*
 * Decompiled with CFR 0.152.
 */
package inferno.parse2;

import common.data.EscalatorPreference;
import inferno.data2.ANode;
import inferno.data2.Blockage;
import inferno.data2.Camera;
import inferno.data2.Counter;
import inferno.data2.CylinderShape;
import inferno.data2.DoorDir;
import inferno.data2.ElevatorLevel;
import inferno.data2.EvacElevator;
import inferno.data2.IElevator;
import inferno.data2.ITimeEstimate;
import inferno.data2.Material;
import inferno.data2.Mesh;
import inferno.data2.MeshBuilder;
import inferno.data2.OccPriority;
import inferno.data2.Occupant;
import inferno.data2.PredefTag;
import inferno.data2.QOccLineQueue;
import inferno.data2.QServicePoint;
import inferno.data2.QSubUnit;
import inferno.data2.QSuperUnit;
import inferno.data2.Region;
import inferno.data2.SlopeSpeed;
import inferno.data2.SpeedModifier;
import inferno.data2.Tag;
import inferno.data2.Tri;
import inferno.data2.TriPoint;
import inferno.data2.ai.AssistOccupantsGoal;
import inferno.data2.ai.AssistedEvacTeam;
import inferno.data2.ai.ChangeBehaviorGoal;
import inferno.data2.ai.ChangeCounterGoal;
import inferno.data2.ai.ChangeProfileGoal;
import inferno.data2.ai.ChangeTagGoal;
import inferno.data2.ai.DetachGoal;
import inferno.data2.ai.ElevatorGoal;
import inferno.data2.ai.ExitGoal;
import inferno.data2.ai.FillRoomGoal;
import inferno.data2.ai.IGoal;
import inferno.data2.ai.IWaitUntilSrc;
import inferno.data2.ai.JoinOccGroupGoal;
import inferno.data2.ai.PointGoal;
import inferno.data2.ai.RoomGoal;
import inferno.data2.ai.SetOccPropGoal;
import inferno.data2.ai.SubUnitGoal;
import inferno.data2.ai.WaitForAssistanceGoal;
import inferno.data2.ai.WaitForCounterGoal;
import inferno.data2.ai.WaitGoal;
import inferno.data2.ai.WaitIntervalGoal;
import inferno.data2.ai.WaitTime;
import inferno.data2.ai.WaitUntilGoal;
import inferno.data2.ai.WaitUntilInsideGoal;
import inferno.data2.ai.WaitUntilTaggedGoal;
import inferno.data2.value.ConstFunction1d;
import inferno.data2.value.IFunction1d;
import inferno.data2.value.PiecewiseFunction1d;
import inferno.geom.Inter;
import inferno.io.fdsout.DataFinder;
import inferno.io.fdsout.DataFinderSmvPlot3d;
import inferno.io.fdsout.DataInquisitor;
import inferno.io.fdsout.KbLink;
import inferno.sim.BehaviorSim;
import inferno.sim.ElevatorModel;
import inferno.sim.EngineOp;
import inferno.sim.IDoorFlowrate;
import inferno.sim.IOccGroup;
import inferno.sim.KB;
import inferno.sim.KnownFuncs;
import inferno.sim.OccAdder;
import inferno.sim.OccGroup;
import inferno.sim.OccGroupType;
import inferno.sim.OccProfileSim;
import inferno.sim.OccSource;
import inferno.sim.Param;
import inferno.sim.VehicleBody;
import inferno.sim.steering.ITpSource;
import inferno.util.BigDecimalOp;
import inferno.util.ComparePredicate;
import inferno.util.Util;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.vecmath.Color3b;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.units.ConstantUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.CSVLineParser;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Global;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.LogNormCurve;
import thunderheadeng.util.stat.StdNormCurve;
import thunderheadeng.util.stat.UniformCurve;
import thunderheadeng.util.stat.UrnUtil;
import thunderheadeng.util.theUtil;

public class SimpleParser {
    private static final int VERSION_001 = 1;
    private static final int VERSION_002 = 2;
    private static final int VERSION_003 = 3;
    private static final int VERSION_004 = 4;
    public static final int VERSION_005 = 5;
    public static final int VERSION_006 = 6;
    public static final int VERSION_007 = 7;
    public static final int VERSION_008 = 8;
    private static final String CMD_ADD_BLOCKAGE = "add_blockage";
    private static final String CMD_REMOVE_BLOCKAGE = "remove_blockage";
    private static final String CMD_OPEN_DOOR = "open_door";
    private static final String CMD_CLOSE_DOOR = "close_door";
    private static final String CMD_CHANGE_DOOR_DIR = "change_door_dir";
    private static final String CMD_SET_SPEED_MOD = "set_speed_mod";
    public static final Unit LENGTH_UNIT = SI.METER;
    public static final Unit VEL_UNIT = SI.METER.divide(SI.SECOND);
    public static final Unit TIME_UNIT = SI.SECOND;
    public static final String INLINE_PROP_DIAMETER = "OccProfile.DIAMETER";
    public static final String INLINE_PROP_GEOM_DIAMETER = "OccProfile.GEOM_DIAMETER";
    public static final String INLINE_PROP_HEIGHT = "OccProfile.HEIGHT";
    private final InputStream d_is;
    private final String d_absolutePath;
    private final KB d_kb;
    private final Param d_param;
    private long d_lastLineN;
    private String d_lastLine;
    private int d_version = 1;
    private final Map<Integer, MeshBuilder.MTri> d_triFileOrder;
    private final Map<Color3b, Color3b> d_colorPool;
    private final Map<SlopeSpeed, SlopeSpeed> d_slopeSpeedPool;

    public SimpleParser(InputStream is, File dir, String fileName) {
        this.d_is = is;
        this.d_absolutePath = dir.getAbsolutePath();
        this.d_lastLineN = 0L;
        this.d_lastLine = null;
        this.d_param = new Param(fileName, dir.getAbsolutePath());
        this.d_kb = new KB(this.d_param);
        this.d_triFileOrder = new HashMap<Integer, MeshBuilder.MTri>();
        this.d_colorPool = new HashMap<Color3b, Color3b>();
        this.d_slopeSpeedPool = new HashMap<SlopeSpeed, SlopeSpeed>();
        this.d_slopeSpeedPool.put(KnownFuncs.SFPE_STAIR_SPEED, KnownFuncs.SFPE_STAIR_SPEED);
        this.d_slopeSpeedPool.put(KnownFuncs.SFPE_RAMP_SPEED, KnownFuncs.SFPE_RAMP_SPEED);
    }

    public KB getKB() {
        return this.d_kb;
    }

    public Param getParam() {
        return this.d_param;
    }

    public long getLastLineN() {
        return this.d_lastLineN;
    }

    public String getLastLine() {
        return this.d_lastLine;
    }

    public void run() throws Exception {
        State state = State.UNKNOWN;
        Scanner scan = new Scanner(this.d_is, "UTF-8");
        ParseData pdata = new ParseData(this.d_kb);
        while (scan.hasNext()) {
            String line = scan.nextLine().trim();
            ++this.d_lastLineN;
            this.d_lastLine = line;
            if (line.length() == 0 || line.startsWith("#")) continue;
            if (line.startsWith("[")) {
                state = State.UNKNOWN;
                String sectTitle = line.substring(1, line.length() - 1);
                for (State s : State.values()) {
                    if (!s.token.equalsIgnoreCase(sectTitle)) continue;
                    state = s;
                    break;
                }
                String stateChange = state != State.UNKNOWN ? "reading " + state.token : "Unrecognized section: " + line;
                System.out.println(stateChange);
                continue;
            }
            if (state == State.NAVMESH && pdata.navmb == null) {
                pdata.navmb = new MeshBuilder(pdata.pList);
            } else if (state == State.GEOMMESH && pdata.geommb == null) {
                pdata.geommb = new MeshBuilder(pdata.pList);
            }
            switch (state) {
                case VERSION: {
                    this.d_version = this.parseVersion(line);
                    break;
                }
                case MATERIALS: {
                    pdata.mats.add(this.parseMat(line));
                    break;
                }
                case DISTRIBUTIONS: {
                    pdata.distributions.add(SimpleParser.parseDistribution(line, true));
                    break;
                }
                case FUNCTIONS: {
                    pdata.functions.add(this.parseFunction(line));
                    break;
                }
                case NODES: {
                    this.parseNode(line, pdata.tags);
                    break;
                }
                case DOORS: {
                    pdata.doorLines.add(line);
                    break;
                }
                case OCCS: {
                    pdata.occLines.add(line);
                    break;
                }
                case VERTS: {
                    Point3d vert = this.parseVert(line);
                    pdata.pList.add(vert);
                    break;
                }
                case NAVMESH: {
                    this.parseMeshTri(pdata.navmb, line);
                    break;
                }
                case GEOMMESH: {
                    this.parseMeshTri(pdata.geommb, line);
                    break;
                }
                case PARAM: {
                    this.parseParam(line);
                    break;
                }
                case PROFILES: {
                    pdata.profLines.add(line);
                    break;
                }
                case BEHAVIORS: {
                    pdata.behaviorLines.add(line);
                    break;
                }
                case TAGS: {
                    pdata.tagLines.add(line);
                    break;
                }
                case EDGES: {
                    pdata.edgeLines.add(line);
                    break;
                }
                case STAIRS: {
                    this.parseStair(line);
                    break;
                }
                case ELEVATORS: {
                    pdata.elevatorLines.add(line);
                    break;
                }
                case ELEVATOR_DISCHARGE: {
                    pdata.elevatorDischargeLines.add(line);
                    break;
                }
                case ELEVATOR_LEVEL_DATA: {
                    pdata.elevatorLevelDataLines.add(line);
                    break;
                }
                case ELEVATOR_LINKS: {
                    pdata.elevatorLinkLines.add(line);
                    break;
                }
                case ELEVATOR_PRIORITY: {
                    pdata.elevatorPriorityLines.add(line);
                    break;
                }
                case SUBUNITS: {
                    pdata.subunitLines.add(line);
                    break;
                }
                case BLOCKAGES: {
                    pdata.blockagesLines.add(line);
                    break;
                }
                case CAMERAS: {
                    this.parseCamera(line);
                    break;
                }
                case EVENTS: {
                    pdata.evtLines.add(line);
                    break;
                }
                case JSON: {
                    this.parseJSON(line);
                    break;
                }
                case META: {
                    this.parseMeta(line);
                    break;
                }
                case ASSISTED_EVAC_TEAMS: {
                    pdata.aeGoalsLines.add(line);
                    break;
                }
                case OCCSHAPES: {
                    pdata.occShapeLines.add(line);
                    break;
                }
                case OCC_SOURCES: {
                    pdata.occSourcesLines.add(line);
                    break;
                }
                case COUNTERS: {
                    pdata.counters.add(this.parseCounter(line));
                    break;
                }
                case GROUPS: {
                    pdata.occGroupLines.add(line);
                    break;
                }
                case GROUP_TEMPLATES: {
                    pdata.occGroupTypeLines.add(line);
                    break;
                }
                case COMPONENT_RESTRICTIONS: {
                    pdata.compRestrictionsLines.add(line);
                    break;
                }
                case UNKNOWN: {
                    System.out.println("Ignoring Line: " + line);
                }
            }
        }
        if (pdata.geommb != null) {
            System.err.println("WARNING: Section geommesh is deprecated and will be ignored.");
        }
        this.finishParsing(pdata);
    }

    public void finishParsing(ParseData pdata) throws IOException {
        MeshBuilder mb = pdata.navmb;
        TagGenerator tags = pdata.tags;
        for (String doorLine : pdata.doorLines) {
            this.parseDoor(doorLine, pdata.distributions);
        }
        for (Blockage blkg : this.d_kb.getBlockages()) {
            int[] indices = blkg.getTriIds();
            for (int i = 0; i < indices.length; ++i) {
                int indexInMemory;
                int indexInFile = indices[i];
                MeshBuilder.MTri mtri = this.d_triFileOrder.get(indexInFile);
                indices[i] = indexInMemory = mb.indexOf(mtri);
            }
        }
        for (String edgeLine : pdata.edgeLines) {
            this.parseEdge(mb, edgeLine);
        }
        ArrayList<MeshBuilder.Error> errors = new ArrayList<MeshBuilder.Error>();
        ConstantUnitSrc lenUnit = new ConstantUnitSrc(SI.METER);
        Mesh mesh = mb.finish(errors, lenUnit);
        this.d_param.out.println("mesh has " + mesh.getTris().length + " triangles");
        this.d_kb.setMesh(mesh);
        for (String line : pdata.subunitLines) {
            this.parseSubUnits(line);
        }
        for (String blockageLine : pdata.blockagesLines) {
            this.parseBlockage(blockageLine, pdata.mats);
        }
        for (int i = 0; i < pdata.elevatorDischargeLines.size(); ++i) {
            String elevatorLine = !pdata.elevatorLines.isEmpty() ? pdata.elevatorLines.get(i) : null;
            this.parseElevatorDischarge(pdata.elevatorDischargeLines.get(i), elevatorLine);
        }
        for (String line : pdata.elevatorLevelDataLines) {
            this.parseElevatorLevelData(line);
        }
        for (String line : pdata.elevatorPriorityLines) {
            this.parseElevatorPriority(line);
        }
        for (String line : pdata.elevatorLinkLines) {
            this.parseElevatorLink(line);
        }
        for (IElevator elevator : this.d_kb.getElevatorModel().getElevators()) {
            elevator.endInit();
        }
        this.d_kb.getElevatorModel().initTriSearchConnections(mesh.getTris());
        ArrayList<OccProfileSim.IShapeGen> occShapes = new ArrayList<OccProfileSim.IShapeGen>(pdata.occShapeLines.size());
        for (String occShapeLine : pdata.occShapeLines) {
            occShapes.add(this.parseOccShape(occShapeLine, pdata.distributions));
        }
        HashMap<Integer, String> aeTeamNameMap = new HashMap<Integer, String>();
        ArrayList<AssistedEvacTeam> assistedEvacuationData = new ArrayList<AssistedEvacTeam>();
        for (String string : pdata.aeGoalsLines) {
            AssistedEvacTeam assistedEvacTeam = this.parseAssistedEvacData(string);
            assistedEvacuationData.add(assistedEvacTeam);
            aeTeamNameMap.put(assistedEvacTeam.teamId, assistedEvacTeam.teamName);
        }
        this.d_kb.setAssistedEvacTeams(assistedEvacuationData);
        LinkedHashMap<Integer, OccProfileSim.CompRestrictions> compRestrictionsMap = new LinkedHashMap<Integer, OccProfileSim.CompRestrictions>();
        for (String string : pdata.compRestrictionsLines) {
            this.parseCompRestrictions(string, compRestrictionsMap, this.d_kb.getNodes());
        }
        ParseProfileInfo parseProfileInfo = new ParseProfileInfo(pdata.functions, pdata.distributions, occShapes, aeTeamNameMap, compRestrictionsMap);
        for (String string : pdata.profLines) {
            pdata.profiles.add(this.parseProfile(string, parseProfileInfo));
        }
        ArrayList<OccGroup> arrayList = new ArrayList<OccGroup>();
        for (String string : pdata.occGroupLines) {
            arrayList.add((OccGroup)this.parseOccGroup(string, pdata.distributions, pdata.profiles, false));
        }
        this.d_kb.addOccupantGroups(arrayList);
        ArrayList<OccGroupType> arrayList2 = new ArrayList<OccGroupType>();
        for (String string : pdata.occGroupTypeLines) {
            arrayList2.add((OccGroupType)this.parseOccGroup(string, pdata.distributions, pdata.profiles, true));
        }
        this.d_kb.setOccupantGroupTypes(arrayList2);
        for (String string : pdata.tagLines) {
            pdata.tags.add(this.parseTag(string));
        }
        ParseGoalInfo parseGoalInfo = new ParseGoalInfo(parseProfileInfo, assistedEvacuationData, pdata.counters, tags, arrayList, arrayList2);
        for (String line : pdata.behaviorLines) {
            pdata.behaviors.add(this.parseBehavior(line, parseGoalInfo, pdata.profiles, pdata.distributions));
        }
        for (BehaviorSim behavior : pdata.behaviors) {
            this.finalizeBehavior(behavior, parseGoalInfo.changeBehaviorIdMap, pdata.behaviors, pdata.distributions);
        }
        for (String occSourceLine : pdata.occSourcesLines) {
            OccSource occSource = this.parseOccSource(occSourceLine, pdata.functions, pdata.profiles, pdata.behaviors, pdata.distributions);
            if (occSource == null) continue;
            this.d_kb.addOccSource(occSource);
        }
        Random random = new Random(0L);
        Random aggrGen = new Random(0L);
        OccAdder occAdder = new OccAdder(this.d_kb.getMesh());
        for (String line : pdata.occLines) {
            Occupant o = this.parseOccFromJson(line, occAdder, random, aggrGen, pdata.profiles, pdata.behaviors, pdata.functions, occShapes, aeTeamNameMap, compRestrictionsMap);
            if (o != null) continue;
            System.err.println("Invalid occupant specified: " + line);
        }
        occAdder.finish(this.d_kb);
        for (int i = 0; i < pdata.occGroupLines.size(); ++i) {
            this.finishParsingOccGroup(pdata.occGroupLines.get(i), (OccGroup)arrayList.get(i));
        }
        tags.finish(this.d_kb);
        this.d_kb.init();
        for (String evtLine : pdata.evtLines) {
            this.parseEvent(evtLine);
        }
    }

    private void finalizeBehavior(BehaviorSim behavior, Map<ChangeBehaviorGoal, Integer> changeBehaviorIdMap, List<BehaviorSim> behaviors, List<IDistributedVal<?>> distributions) {
        for (IGoal goal : behavior.goals) {
            if (!(goal instanceof ChangeBehaviorGoal)) continue;
            ChangeBehaviorGoal changeBehavior = (ChangeBehaviorGoal)goal;
            IUrn behaviorIndexUrn = (IUrn)distributions.get(changeBehaviorIdMap.get(changeBehavior));
            IUrn<BehaviorSim> behaviorUrn = SimpleParser.toObjectUrn(behaviorIndexUrn, behaviors);
            changeBehavior.init(behaviorUrn);
        }
    }

    private void parseCompRestrictions(String line, Map<Integer, OccProfileSim.CompRestrictions> compRestrictionsMap, List<ANode> nodeList) {
        int colix = line.indexOf(58);
        JSONParser parser = new JSONParser();
        int ix = Integer.parseInt(line.substring(0, colix));
        try {
            Object obj = parser.parse(line.substring(colix + 1));
            JSONObject json = (JSONObject)obj;
            JSONArray array = (JSONArray)json.get("components");
            Set<ANode> comps = this.parseRestrictedComponents(array);
            boolean reject = "reject".equals(json.get("action"));
            boolean elevatorsFromBehavior = (Boolean)json.get("elevators-from-behavior");
            compRestrictionsMap.put(ix, new OccProfileSim.CompRestrictions(comps, reject, elevatorsFromBehavior));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private OccSource parseOccSource(String line, List<IFunction1d> functions, List<OccProfileSim> profiles, List<BehaviorSim> behaviors, List<IDistributedVal<?>> distributions) {
        int colix = line.indexOf(58);
        JSONParser parser = new JSONParser();
        try {
            Object obj = parser.parse(line.substring(colix + 1));
            JSONObject json = (JSONObject)obj;
            String name = (String)json.get("name");
            if (name == null) {
                name = "";
            }
            JSONObject boundsJson = (JSONObject)json.get("bounds");
            Point3d min = this.parsePoint3d(new TokenIterator(this.getTokens((String)boundsJson.get("min"), "(), ", false)));
            Point3d max = this.parsePoint3d(new TokenIterator(this.getTokens((String)boundsJson.get("max"), "(), ", false)));
            AABox bounds = new AABox(min, max);
            long flowRateIxL = (Long)json.get("flowrate");
            int flowRateIx = (int)flowRateIxL;
            IFunction1d flowRate = functions.get(flowRateIx);
            int profileUrnId = (int)((Long)json.get("profiles")).longValue();
            IUrn profileIndexUrn = (IUrn)distributions.get(profileUrnId);
            IUrn<OccProfileSim> profUrn = SimpleParser.toObjectUrn(profileIndexUrn, profiles);
            int behaviorUrnId = (int)((Long)json.get("behaviors")).longValue();
            IUrn behaviorIndexUrn = (IUrn)distributions.get(behaviorUrnId);
            IUrn<BehaviorSim> behaviorUrn = SimpleParser.toObjectUrn(behaviorIndexUrn, behaviors);
            boolean enforceFlowrate = (Boolean)json.get("enforceFlowrate");
            Object compIx = json.get("component");
            ANode component = null;
            if (compIx != null) {
                component = this.d_kb.getNodes().get((int)((Long)compIx).longValue());
            }
            IUrn<OccGroupType> groupTemplateUrn = null;
            int groupTemplateUrnId = (int)((Long)json.get("groupTemplates")).longValue();
            IUrn groupTemplateIndexUrn = (IUrn)distributions.get(groupTemplateUrnId);
            groupTemplateUrn = SimpleParser.toObjectUrn(groupTemplateIndexUrn, this.d_kb.getOccupantGroupTypes());
            return new OccSource(name, bounds, flowRate, profUrn, behaviorUrn, enforceFlowrate, component, groupTemplateUrn, this.d_kb);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T> IUrn<T> toObjectUrn(IUrn<Integer> urn, List<T> indexList) {
        Map<Integer, Double> weights = urn.getWeights();
        LinkedIdentityHashMap urnMap = new LinkedIdentityHashMap();
        weights.forEach((k, v) -> urnMap.put(indexList.get((int)k), v));
        return UrnUtil.newUrn(urnMap);
    }

    public Counter parseCounter(String line) {
        TokenIterator toks = new TokenIterator(this.getTokens(line, " ,=", true));
        double initValue = toks.nextDouble();
        return new Counter(initValue);
    }

    private IOccGroup parseOccGroup(String line, List<IDistributedVal<?>> distributions, List<OccProfileSim> profiles, boolean isGroupType) {
        int colix = line.indexOf(58);
        int groupID = Integer.parseInt(line.substring(0, colix));
        JSONParser parser = new JSONParser();
        try {
            IOccGroup group;
            Object obj = parser.parse(line.substring(colix + 1));
            JSONObject json = (JSONObject)obj;
            double maxDistance = (Double)json.get("maxDistance");
            double slowdownTime = (Double)json.get("slowdownTime");
            boolean requiresLeader = (Boolean)json.get("requiresLeader");
            boolean respectSocialDist = json.getOrDefault("respectSocialDist", false);
            String name = "";
            if (json.containsKey("name")) {
                name = (String)json.get("name");
            }
            Color color = this.parseJSONColor(json.get("color"));
            if (isGroupType) {
                boolean allowSmallerGroups = (Boolean)json.get("allowSmallerGroups");
                ICurve minNumberOfMembers = null;
                if (allowSmallerGroups) {
                    int minNumberOfMembersID = (int)((Long)json.get("minNumberOfMembers")).longValue();
                    minNumberOfMembers = (ICurve)distributions.get(minNumberOfMembersID);
                }
                int prefNumberOfMembersID = (int)((Long)json.get("prefNumberOfMembers")).longValue();
                ICurve prefNumberOfMembers = (ICurve)distributions.get(prefNumberOfMembersID);
                boolean useExactCalc = (Boolean)json.get("exactDistanceCalculation");
                double heightMultiplier = !useExactCalc ? (Double)json.get("heightMultiplier") : 0.0;
                Object leaderProfID = json.get("leaderProfile");
                OccProfileSim leaderProf = null;
                if (leaderProfID != null) {
                    leaderProf = profiles.get(((Long)leaderProfID).intValue());
                }
                boolean restrictRoom = (Boolean)json.get("restrictRoom");
                boolean specifyProfiles = (Boolean)json.get("specifyProfiles");
                LinkedIdentityHashMap<OccProfileSim, OccGroupType.GroupCreationData> profMap = null;
                if (specifyProfiles) {
                    profMap = new LinkedIdentityHashMap<OccProfileSim, OccGroupType.GroupCreationData>();
                    JSONArray profArray = (JSONArray)json.get("profiles");
                    for (Object o : profArray) {
                        JSONObject profJson = (JSONObject)o;
                        boolean allowSmallerGroupsProf = (Boolean)profJson.get("allowSmallerGroups");
                        ICurve minNumberOfMembersProf = allowSmallerGroupsProf ? (ICurve)distributions.get((int)((Long)profJson.get("minNumberOfMembers")).longValue()) : null;
                        ICurve prefNumberOfMembersProf = (ICurve)distributions.get((int)((Long)profJson.get("prefNumberOfMembers")).longValue());
                        OccProfileSim prof = profiles.get((int)((Long)profJson.get("profile")).longValue());
                        OccGroupType.GroupCreationData data = new OccGroupType.GroupCreationData(prefNumberOfMembersProf, allowSmallerGroupsProf, minNumberOfMembersProf);
                        profMap.put(prof, data);
                    }
                }
                boolean isNoGroupType = (Boolean)json.get("ungrouped");
                group = new OccGroupType(groupID, name, maxDistance, slowdownTime, requiresLeader, minNumberOfMembers, prefNumberOfMembers, allowSmallerGroups, useExactCalc, heightMultiplier, specifyProfiles, profMap, leaderProf, restrictRoom, color, isNoGroupType, respectSocialDist);
            } else {
                Color templateColor = this.parseJSONColor(json.get("templateColor"));
                group = new OccGroup(groupID, name, maxDistance, slowdownTime, requiresLeader, respectSocialDist, color, templateColor);
            }
            return group;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void finishParsingOccGroup(String line, OccGroup occGroup) {
        int colix = line.indexOf(58);
        JSONParser parser = new JSONParser();
        try {
            Object leader;
            Object obj = parser.parse(line.substring(colix + 1));
            JSONObject json = (JSONObject)obj;
            JSONArray initMembersAr = (JSONArray)json.get("members");
            if (initMembersAr != null) {
                for (Object idObj : initMembersAr) {
                    if (!(idObj instanceof Long)) continue;
                    int id = (int)((Long)idObj).longValue();
                    Occupant occ = this.d_kb.getOccs().get(id);
                    occGroup.addOccOnInit(occ);
                }
            }
            if ((leader = json.get("leader")) != null) {
                int leaderId = (int)((Long)leader).longValue();
                occGroup.addLeaderOnInit(this.d_kb.getOccs().get(leaderId));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public AssistedEvacTeam parseAssistedEvacData(String line) {
        String[] tokens = this.getTokens(line, " ,=", true);
        int colix = line.indexOf(58);
        int id = Integer.parseInt(line.substring(0, colix));
        ArrayList<Integer> teamGoals = new ArrayList<Integer>();
        String teamName = null;
        block8: for (int index = 0; index < tokens.length; ++index) {
            switch (tokens[index]) {
                case "goals": {
                    String[] goalsTokens = this.getTokens(tokens[++index], "|", false);
                    if (goalsTokens[0].equals("NA")) continue block8;
                    for (int i = 0; i < goalsTokens.length; ++i) {
                        teamGoals.add(Integer.parseInt(goalsTokens[i]));
                    }
                    continue block8;
                }
                case "name": {
                    teamName = tokens[++index];
                    continue block8;
                }
                default: {
                    System.err.printf("warning: %s \"%s\" (ignored)\n", "unknown assisted evacuation parameter", tokens[index]);
                }
            }
        }
        return new AssistedEvacTeam(teamName, teamGoals, id);
    }

    public int parseVersion(String line) {
        return Integer.parseInt(line);
    }

    public Material parseMat(String line) {
        String[] tokens = this.getTokens(line, true);
        String imgName = tokens[0];
        double width = Double.parseDouble(tokens[1]);
        double height = Double.parseDouble(tokens[2]);
        return new Material(imgName, width, height);
    }

    public IFunction1d parseFunction(String line) throws IOException {
        int colix = line.indexOf(58);
        JSONParser parser = new JSONParser();
        try {
            Object obj = parser.parse(line.substring(colix + 1));
            JSONObject json = (JSONObject)obj;
            String type = (String)json.get("type");
            if (type.equalsIgnoreCase("const")) {
                double val = (Double)json.get("val");
                return new ConstFunction1d(val);
            }
            if (type.equalsIgnoreCase("pw")) {
                JSONArray xj = (JSONArray)json.get("x");
                JSONArray yj = (JSONArray)json.get("y");
                boolean extrapolate = (Boolean)json.get("extrapolate");
                double[] x = new double[xj.size()];
                for (int i = 0; i < x.length; ++i) {
                    x[i] = (Double)xj.get(i);
                }
                double[] y = new double[yj.size()];
                for (int i = 0; i < y.length; ++i) {
                    y[i] = (Double)yj.get(i);
                }
                return new PiecewiseFunction1d(x, y, extrapolate);
            }
            assert (false);
            return null;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IDistributedVal<?> parseDistribution(String line, boolean hasHeader) throws IOException {
        int colix = hasHeader ? line.indexOf(58) : -1;
        JSONParser parser = new JSONParser();
        try {
            Object obj = parser.parse(line.substring(colix + 1));
            JSONObject json = (JSONObject)obj;
            Object urn = json.get("urn");
            return urn != null ? SimpleParser.parseOrderedUrn(line, hasHeader) : SimpleParser.parseCurve(line, hasHeader);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ICurve parseCurve(String line, boolean hasHeader) throws IOException {
        int colix = hasHeader ? line.indexOf(58) : -1;
        JSONParser parser = new JSONParser();
        try {
            Object obj = parser.parse(line.substring(colix + 1));
            JSONObject json = (JSONObject)obj;
            String type = (String)json.get("type");
            if (type.equalsIgnoreCase("cc")) {
                UnitDouble val = Global.parseUnitDouble((CharSequence)json.get("val"), null, Locale.US);
                return new ConstantCurve(val);
            }
            if (type.equalsIgnoreCase("logNorm")) {
                UnitDouble mean = Global.parseUnitDouble((CharSequence)json.get("mean"), null, Locale.US);
                UnitDouble stDev = Global.parseUnitDouble((CharSequence)json.get("stDev"), null, Locale.US);
                UnitDouble min = Global.parseUnitDouble((CharSequence)json.get("min"), null, Locale.US);
                UnitDouble max = Global.parseUnitDouble((CharSequence)json.get("max"), null, Locale.US);
                return new LogNormCurve(min, max, mean, stDev);
            }
            if (type.equalsIgnoreCase("stdNorm")) {
                UnitDouble mean = Global.parseUnitDouble((CharSequence)json.get("mean"), null, Locale.US);
                UnitDouble stDev = Global.parseUnitDouble((CharSequence)json.get("stDev"), null, Locale.US);
                UnitDouble min = Global.parseUnitDouble((CharSequence)json.get("min"), null, Locale.US);
                UnitDouble max = Global.parseUnitDouble((CharSequence)json.get("max"), null, Locale.US);
                return new StdNormCurve(min, max, mean, stDev);
            }
            if (type.equalsIgnoreCase("unif")) {
                UnitDouble min = Global.parseUnitDouble((CharSequence)json.get("min"), null, Locale.US);
                UnitDouble max = Global.parseUnitDouble((CharSequence)json.get("max"), null, Locale.US);
                return new UniformCurve(min, max);
            }
            assert (false);
            return null;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (java.text.ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String unescapeName(String name) {
        if (name.startsWith("\"") && name.endsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        if (name.isEmpty()) {
            return "";
        }
        String[] toks = this.getTokens(name, "", false, true, false, false);
        assert (toks.length == 1);
        return toks[0];
    }

    public void parseNode(String line, TagGenerator tags) throws IOException {
        TokenIterator toks = new TokenIterator(this.getTokens(line, " ,=", true, true, true, true));
        String name = this.unescapeName(toks.next());
        ANode n = new ANode(name);
        this.d_kb.addNode(n);
        toks.next();
        n.setAnimationId(Integer.parseInt(toks.next()));
        while (toks.hasMore()) {
            String param = toks.next();
            switch (param.toLowerCase()) {
                case "tags": {
                    String tagStr = toks.next();
                    Set<Tag> ntags = SimpleParser.getTags(tagStr, tags, false);
                    if (ntags.isEmpty()) break;
                    n.setTags(new ArrayList<Tag>(ntags));
                    break;
                }
                case "count": {
                    int count = toks.nextInt();
                    n.setCapacity(new ANode.Count(count));
                    break;
                }
                case "dens": {
                    double density = toks.nextDouble();
                    n.setCapacity(new ANode.Density(density, n));
                    break;
                }
            }
        }
    }

    public void parseDoor(String line, List<IDistributedVal<?>> distributions) throws IOException {
        TokenIterator tokens = new TokenIterator(this.getTokens(line, true));
        int ixNode = tokens.nextInt();
        ANode n = this.d_kb.getNodes().get(ixNode);
        double effWid = tokens.nextDouble();
        String strR1 = tokens.next();
        ANode r1 = null;
        if (!strR1.equals("-")) {
            int ixR1 = Integer.parseInt(strR1);
            r1 = this.d_kb.getNodes().get(ixR1);
        }
        String strR2 = tokens.next();
        ANode r2 = null;
        if (!strR2.equals("-")) {
            int ixR2 = Integer.parseInt(strR2);
            r2 = this.d_kb.getNodes().get(ixR2);
        }
        IDoorFlowrate flowrate = this.parseFlowrate(tokens);
        DoorDir onewayDir = this.parseDoorDir(tokens);
        String wt = tokens.next();
        IDistributedVal<UnitDouble> waitTime = wt.equals("-") ? null : distributions.get(Integer.parseInt(wt));
        n.createDoorQueueData(this.d_kb, this.getParam(), r1, r2, flowrate, effWid, waitTime);
        n.setDoorDir(onewayDir);
    }

    private IDoorFlowrate parseFlowrate(TokenIterator tokens) throws IOException {
        String frStr = tokens.next();
        if (frStr.equals("-")) {
            return null;
        }
        Double val = Double.parseDouble(frStr);
        return Double.isInfinite(val) ? IDoorFlowrate.UNLIMITED : new IDoorFlowrate.Fixed(val);
    }

    private DoorDir parseDoorDir(TokenIterator tokens) throws IOException {
        if (!tokens.hasMore()) {
            return null;
        }
        String dirStr = tokens.next();
        if (dirStr.equals("-")) {
            return null;
        }
        if (dirStr.equals("dir+")) {
            return DoorDir.POSITIVE;
        }
        if (dirStr.equals("dir-")) {
            return DoorDir.NEGATIVE;
        }
        throw new IOException(String.format("Unknown door direction: %s", dirStr));
    }

    public void parseStair(String line) {
        String[] tokens = this.getTokens(line, true);
        int ixNode = Integer.parseInt(tokens[0]);
        ANode n = this.d_kb.getNodes().get(ixNode);
        double rise = Double.parseDouble(tokens[1]);
        double tread = Double.parseDouble(tokens[2]);
        n.createStairData(this.d_kb, rise, tread);
    }

    private static ICurve cc(double val, Unit u) {
        return new ConstantCurve(new UnitDouble(val, u));
    }

    public OccProfileSim.IShapeGen parseOccShape(String line, List<IDistributedVal<?>> distributions) {
        TokenIterator tokens = new TokenIterator(this.getTokens(line, " ,=", true));
        String type = "";
        String name = "";
        ICurve shoulderWidth = null;
        Double geomWidth = null;
        ICurve height = null;
        Point3d[] points = new Point3d[]{};
        List<Point3d> attachments = Collections.emptyList();
        VehicleBody.AnimType atype = VehicleBody.AnimType.NORMAL;
        String model = null;
        boolean lateral = false;
        Supplier<Point3d> parsePoint = () -> {
            double x = tokens.nextDouble();
            double y = tokens.nextDouble();
            double z = tokens.nextDouble();
            return new Point3d(x, y, z);
        };
        Supplier<Point3d[]> parsePointList = () -> {
            int pcount = tokens.nextInt();
            Point3d[] p = new Point3d[pcount];
            for (int m = 0; m < pcount; ++m) {
                p[m] = (Point3d)parsePoint.get();
            }
            return p;
        };
        Point3d occAvatarOffset = GeomConstants.PNT3D_ORIGIN;
        Point3d origin = GeomConstants.PNT3D_ORIGIN;
        while (tokens.hasMore()) {
            String tstr = tokens.next();
            block15 : switch (tstr.toLowerCase()) {
                case "name": {
                    name = tokens.next();
                    break;
                }
                case "type": {
                    switch (type = tokens.next().toLowerCase()) {
                        case "poly": {
                            points = parsePointList.get();
                        }
                    }
                    break;
                }
                case "diameter": {
                    shoulderWidth = SimpleParser.cc(tokens.nextDouble(), SI.METER);
                    break;
                }
                case "diameterdist": {
                    shoulderWidth = (ICurve)distributions.get(tokens.nextInt());
                    break;
                }
                case "height": {
                    height = SimpleParser.cc(tokens.nextDouble(), SI.METER);
                    break;
                }
                case "heightdist": {
                    height = (ICurve)distributions.get(tokens.nextInt());
                    break;
                }
                case "geomdiameter": {
                    geomWidth = tokens.nextDouble();
                    break;
                }
                case "attachedagentspositions": {
                    attachments = Arrays.asList((Object[])parsePointList.get());
                    break;
                }
                case "anim": {
                    String animtype = tokens.next();
                    switch (animtype.toLowerCase()) {
                        case "wheelchair": {
                            atype = VehicleBody.AnimType.WHEELCHAIR;
                            break block15;
                        }
                        case "bed": {
                            atype = VehicleBody.AnimType.BED;
                        }
                    }
                    break;
                }
                case "model": {
                    model = tokens.next();
                    if (!model.equals("<shape>")) break;
                    model = "";
                    break;
                }
                case "occavataroffset": {
                    occAvatarOffset = parsePoint.get();
                    break;
                }
                case "origin": {
                    origin = parsePoint.get();
                    break;
                }
                case "lateral": {
                    lateral = tokens.nextBoolean();
                }
            }
        }
        if (shoulderWidth != null) {
            return new OccProfileSim.CylShapeGen(shoulderWidth, geomWidth != null ? new UnitDouble(geomWidth, LENGTH_UNIT) : null, height);
        }
        if (!(height instanceof ConstantCurve)) {
            System.err.println("WARNING: Polygon height not specified as a constant - using average instead.");
        }
        double polyHeight = height.getAvg().get(LENGTH_UNIT);
        if (name.isEmpty()) {
            name = "Polygon";
        }
        VehicleBody vbody = new VehicleBody(name, origin, points, polyHeight, lateral, attachments, atype, occAvatarOffset, model);
        return new OccProfileSim.PolyShapeGen(vbody);
    }

    private Object getOccProp(JSONObject json, Random rnd, long seed, String name, OccProfileSim parentProfile, OccProfileSim.Prop<?> prop, Class<?> targetClass) {
        return this.getOccProp(json, rnd, seed, name, parentProfile, prop, targetClass, null);
    }

    private Object getOccProp(JSONObject json, Random rnd, long seed, OccProfileSim parentProfile, OccProfileSim.Prop<?> prop, Class<?> targetClass) {
        return this.getOccProp(json, rnd, seed, prop.key.toString(), parentProfile, prop, targetClass);
    }

    private float getComfortDist(JSONObject json, Random rnd, long seed, OccProfileSim parentProfile, double occRadius) {
        Object ret = json.get("comfortDist");
        if (ret instanceof Number) {
            return ((Number)ret).floatValue();
        }
        if (ret instanceof String) {
            return Float.parseFloat((String)ret);
        }
        return (float)parentProfile.getComfortDistance(rnd, seed, new UnitDouble(occRadius, SI.METER)).get(SI.METER);
    }

    private Object getOccProp(JSONObject json, Random rnd, long seed, String name, OccProfileSim parentProfile, OccProfileSim.Prop<?> prop, Class<?> targetClass, Unit unit) {
        Object ret = json.get(name);
        return this.getOccProp(ret, rnd, seed, parentProfile, prop, targetClass, unit);
    }

    private Object getOccProp(Object ret, Random rnd, long seed, OccProfileSim parentProfile, OccProfileSim.Prop prop, Class<?> targetClass, Unit unit) {
        Object v;
        if (ret == null && prop != null) {
            Object profileProp = prop.isDistributed() ? parentProfile.getDistVal(prop, rnd, seed) : parentProfile.getProperty(prop);
            if (prop == OccProfileSim.PROP_PRINT_EXTRA_OUTPUT) {
                profileProp = (Boolean)profileProp != false ? 1 : 0;
            } else if (profileProp instanceof OccProfileSim.Spacing) {
                profileProp = parentProfile.getSpacingVal(rnd, seed);
            }
            if (profileProp instanceof UnitDouble) {
                profileProp = unit != null ? ((UnitDouble)profileProp).getValue(unit) : ((UnitDouble)profileProp).getValueNoUnit();
            }
            ret = profileProp;
        }
        if (targetClass != null && (v = SimpleParser.parseValue(ret, targetClass)) != null) {
            return v;
        }
        return ret;
    }

    private static <T> T parseValue(Object ret, Class<T> targetClass) {
        if (ret != null && !targetClass.equals(ret.getClass())) {
            boolean retString = ret.getClass().equals(String.class);
            if (targetClass.equals(Double.class)) {
                return (T)(retString ? Double.valueOf(Double.parseDouble((String)ret)) : Double.valueOf(((Number)ret).doubleValue()));
            }
            if (targetClass.equals(Float.class)) {
                return (T)(retString ? Float.valueOf(Float.parseFloat((String)ret)) : Float.valueOf(((Number)ret).floatValue()));
            }
            if (targetClass.equals(Integer.class)) {
                return (T)(retString ? Integer.valueOf(Integer.parseInt((String)ret)) : Integer.valueOf(((Number)ret).intValue()));
            }
            if (targetClass.equals(Long.class)) {
                return (T)(retString ? Long.valueOf(Long.parseLong((String)ret)) : Long.valueOf(((Number)ret).longValue()));
            }
            if (targetClass.equals(Boolean.class)) {
                return (T)(retString ? Boolean.valueOf(Boolean.parseBoolean((String)ret)) : (Boolean)ret);
            }
            if (targetClass.equals(Point3f.class)) {
                StringTokenizer st = new StringTokenizer((String)ret, "(), ");
                return (T)new Point3f(Float.parseFloat(st.nextToken()), Float.parseFloat(st.nextToken()), Float.parseFloat(st.nextToken()));
            }
            if (Enum.class.isAssignableFrom(targetClass) && ret instanceof String) {
                return Enum.valueOf(targetClass, (String)ret);
            }
            assert (false);
            return null;
        }
        return (T)ret;
    }

    private Set<ANode> parseRestrictedComponents(JSONArray array) {
        HashSet<ANode> restrictedComps = new HashSet<ANode>();
        for (int i = 0; i < array.size(); ++i) {
            restrictedComps.add(this.d_kb.getNodes().get((int)((Long)array.get(i)).longValue()));
        }
        return restrictedComps;
    }

    private static <T> T getCustomOccProp(JSONObject json, String key, Class<T> targetClass, T defVal) {
        Object jsonVal = json.get(key);
        if (jsonVal == null) {
            return defVal;
        }
        return SimpleParser.parseValue(jsonVal, targetClass);
    }

    public Occupant parseOccFromJson(String line, OccAdder adder, Random seedGen, Random priorityGen, List<OccProfileSim> profiles, List<BehaviorSim> behaviors, List<IFunction1d> functions, List<OccProfileSim.IShapeGen> occShapes, HashMap<Integer, String> aeTeamNameMap, Map<Integer, OccProfileSim.CompRestrictions> compRestrictionsMap) throws IOException {
        int colix = line.indexOf(58);
        JSONParser parser = new JSONParser();
        Occupant occ = null;
        try {
            String orientString;
            Long orientSeed;
            Object obj = parser.parse(line.substring(colix + 1));
            JSONObject json = (JSONObject)obj;
            Random rnd = new Random();
            OccProfileSim parentProfile = profiles.get((int)((Long)json.get("profile")).longValue());
            Long rseed = (Long)json.get("rseed");
            if (rseed == null) {
                rseed = theUtil.randomSeed(rnd);
            }
            if ((orientSeed = (Long)json.get("orientSeed")) == null) {
                orientSeed = rseed;
            }
            String name = (String)json.get("name");
            int ixOccProf = (int)((Long)json.get("behavior")).longValue();
            BehaviorSim behavior = behaviors.get(ixOccProf);
            String ptString = (String)json.get("loc");
            StringTokenizer st = new StringTokenizer(ptString, " ");
            Point3d pt = new Point3d(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()));
            IFunction1d fundamental = KnownFuncs.SFPE_FUNDAMENTAL_DIAGRAM;
            IFunction1d stairFracUp = KnownFuncs.SFPE_STAIR_FUNCTION;
            IFunction1d stairFundUp = null;
            IFunction1d stairFracDown = KnownFuncs.SFPE_STAIR_FUNCTION;
            IFunction1d stairFundDown = null;
            IFunction1d rampFracUp = KnownFuncs.SFPE_RAMP_FUNCTION;
            IFunction1d rampFundUp = null;
            IFunction1d rampFracDown = KnownFuncs.SFPE_RAMP_FUNCTION;
            IFunction1d rampFundDown = null;
            occ = adder.add(name, rseed, orientSeed, parentProfile, behavior, pt, this.d_kb);
            if (occ == null) {
                return null;
            }
            String modelid = (String)this.getOccProp(json, rnd, (long)rseed, (String)OccProfileSim.PROP_OCCMODEL.key, parentProfile, OccProfileSim.PROP_OCCMODEL, String.class);
            occ.avatar = modelid.equals("<null>") ? null : modelid;
            occ.maxVel = ((Float)this.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_MAXVEL.key, parentProfile, OccProfileSim.PROP_MAXVEL, Float.class, VEL_UNIT)).floatValue();
            occ.accelFactor = 1.0f / ((Float)this.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_ACCEL_TIME.key, parentProfile, OccProfileSim.PROP_ACCEL_TIME, Float.class, TIME_UNIT)).floatValue();
            Double occDiameter = SimpleParser.getCustomOccProp(json, INLINE_PROP_DIAMETER, Double.class, null);
            if (occDiameter != null) {
                Double geomDiam = SimpleParser.getCustomOccProp(json, INLINE_PROP_GEOM_DIAMETER, Double.class, occDiameter);
                Double height = SimpleParser.getCustomOccProp(json, INLINE_PROP_HEIGHT, Double.class, 1.8288);
                occ.bodyShape = new CylinderShape(pt, occDiameter * 0.5, geomDiam * 0.5, height, occ.orient, occ.id);
            } else {
                Object bodyShapeProp = this.getOccProp(json, rnd, rseed, parentProfile, OccProfileSim.PROP_SHAPE, null);
                OccProfileSim.IShapeGen bodyShape = bodyShapeProp instanceof OccProfileSim.IShapeGen ? (OccProfileSim.IShapeGen)bodyShapeProp : occShapes.get(((Number)bodyShapeProp).intValue());
                occ.bodyShape = bodyShape.generateShape(occ, rnd, rseed, this.d_kb);
            }
            Point3f c = (Point3f)this.getOccProp(json, rnd, (long)rseed, (String)OccProfileSim.PROP_COLOR.key, parentProfile, OccProfileSim.PROP_COLOR, Point3f.class);
            occ.visColor = this.finalizeColor(new Color3b(theUtil.toCCb(c.x), theUtil.toCCb(c.y), theUtil.toCCb(c.z)));
            occ.reacTime = ((Float)this.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_REAC_TIME.key, parentProfile, null, Float.class, TIME_UNIT)).floatValue();
            double priority = (Double)this.getOccProp(json, rnd, (long)rseed, (String)OccProfileSim.PROP_PRIORITY_LEVEL.key, parentProfile, OccProfileSim.PROP_PRIORITY_LEVEL, Double.class);
            occ.minSqueezeFactor = ((Float)this.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_MIN_SQUEEZE_FACTOR_CONST.key, parentProfile, OccProfileSim.PROP_MIN_SQUEEZE_FACTOR_CONST, Float.class, Unit.ONE)).floatValue();
            occ.persistTime = ((Float)this.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_PERSIST_TIME.key, parentProfile, OccProfileSim.PROP_PERSIST_TIME, Float.class, TIME_UNIT)).floatValue();
            occ.collisionResponseTime = ((Float)this.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_COLLISION_RESPONSE_TIME.key, parentProfile, OccProfileSim.PROP_COLLISION_RESPONSE_TIME, Float.class, TIME_UNIT)).floatValue();
            occ.comfortDist = this.getComfortDist(json, rnd, rseed, parentProfile, occ.bodyShape.getOccRadius());
            occ.socialDist = ((Float)this.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_SOCIAL_DIST.key, parentProfile, OccProfileSim.PROP_SOCIAL_DIST, Float.class, LENGTH_UNIT)).floatValue();
            occ.slowFactor = ((Float)this.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_SLOW_FACTOR.key, parentProfile, OccProfileSim.PROP_SLOW_FACTOR, Float.class, Unit.ONE)).floatValue();
            occ.reqAssistedBy = (Boolean)this.getOccProp(json, rnd, (long)rseed, (String)OccProfileSim.PROP_ASSIST.key, parentProfile, OccProfileSim.PROP_ASSIST, Boolean.class);
            occ.requiresAssistance = (Boolean)this.getOccProp(json, rnd, (long)rseed, (String)OccProfileSim.PROP_REQUIRES_ASSISTANCE.key, parentProfile, OccProfileSim.PROP_REQUIRES_ASSISTANCE, Boolean.class);
            occ.obeyOnewayDoors = (Boolean)this.getOccProp(json, rnd, (long)rseed, (String)OccProfileSim.PROP_OBEY_ONEWAY_DOORS.key, parentProfile, OccProfileSim.PROP_OBEY_ONEWAY_DOORS, Boolean.class);
            occ.movingTerrainPref = (EscalatorPreference)((Object)this.getOccProp(json, rnd, (long)rseed, (String)OccProfileSim.PROP_ESCALATOR_PREF.key, parentProfile, OccProfileSim.PROP_ESCALATOR_PREF, EscalatorPreference.class));
            occ.localQueueTimeFactor = (Double)this.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_LOCAL_QUEUE_TIME_FACTOR.key, parentProfile, OccProfileSim.PROP_LOCAL_QUEUE_TIME_FACTOR, Double.class, Unit.ONE);
            occ.localTravelTimeFactor = (Double)this.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_LOCAL_TRAVEL_TIME_FACTOR.key, parentProfile, OccProfileSim.PROP_LOCAL_TRAVEL_TIME_FACTOR, Double.class, Unit.ONE);
            occ.tailTimeFactor = (Double)this.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_TAIL_TIME_FACTOR.key, parentProfile, OccProfileSim.PROP_TAIL_TIME_FACTOR, Double.class, Unit.ONE);
            occ.currDoorFactor = (Double)this.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_CURR_DOOR_PREF.key, parentProfile, OccProfileSim.PROP_CURR_DOOR_PREF, Double.class, Unit.ONE);
            occ.distTravelledFactor = (Double)this.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_CURRENT_ROOM_DIST_PENALTY.key, parentProfile, null, Double.class, LENGTH_UNIT);
            occ.boundaryLayer = ((Float)this.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_BOUNDARY_LAYER.key, parentProfile, OccProfileSim.PROP_BOUNDARY_LAYER, Float.class, LENGTH_UNIT)).floatValue();
            occ.outputTimeHistory = (Integer)this.getOccProp(json, rnd, rseed, (String)OccProfileSim.PROP_PRINT_EXTRA_OUTPUT.key, parentProfile, OccProfileSim.PROP_PRINT_EXTRA_OUTPUT, Integer.class, Unit.ONE);
            Object compRest = this.getOccProp(json, rnd, (long)rseed, (String)OccProfileSim.PROP_RESTRICTED_COMPONENTS.key, parentProfile, OccProfileSim.PROP_RESTRICTED_COMPONENTS, null);
            if (compRest instanceof Number) {
                occ.compRestrictions = compRestrictionsMap.get(((Number)compRest).intValue());
            } else if (compRest instanceof OccProfileSim.CompRestrictions) {
                occ.compRestrictions = (OccProfileSim.CompRestrictions)compRest;
            }
            double elevatorWaitTime = (Double)this.getOccProp(json, rnd, (long)rseed, (String)OccProfileSim.PROP_ELEVATOR_WAIT_TIME.key, parentProfile, OccProfileSim.PROP_ELEVATOR_WAIT_TIME, Double.class);
            occ.elevatorWaitTime = new OccProfileSim.ElevatorWaitTime(elevatorWaitTime);
            fundamental = this.safeGetFunc(functions, json.get((String)OccProfileSim.PROP_FUNDAMENTAL.key));
            if (fundamental == null) {
                fundamental = parentProfile.getProperty(OccProfileSim.PROP_FUNDAMENTAL);
            }
            if ((stairFracUp = this.safeGetFunc(functions, json.get((String)OccProfileSim.PROP_STAIR_SPEED_UP.key))) == null) {
                stairFracUp = parentProfile.getProperty(OccProfileSim.PROP_STAIR_SPEED_UP);
            }
            if ((stairFundUp = this.safeGetFunc(functions, json.get((String)OccProfileSim.PROP_STAIR_FUNDAMENTAL_UP.key))) == null) {
                stairFundUp = (IFunction1d)parentProfile.getProperty(OccProfileSim.PROP_STAIR_FUNDAMENTAL_UP).apply(parentProfile);
            }
            if ((stairFracDown = this.safeGetFunc(functions, json.get((String)OccProfileSim.PROP_STAIR_SPEED_DOWN.key))) == null) {
                stairFracDown = parentProfile.getProperty(OccProfileSim.PROP_STAIR_SPEED_DOWN);
            }
            if ((stairFundDown = this.safeGetFunc(functions, json.get((String)OccProfileSim.PROP_STAIR_FUNDAMENTAL_DOWN.key))) == null) {
                stairFundDown = (IFunction1d)parentProfile.getProperty(OccProfileSim.PROP_STAIR_FUNDAMENTAL_DOWN).apply(parentProfile);
            }
            if ((rampFracUp = this.safeGetFunc(functions, json.get((String)OccProfileSim.PROP_RAMP_SPEED_UP.key))) == null) {
                rampFracUp = parentProfile.getProperty(OccProfileSim.PROP_RAMP_SPEED_UP);
            }
            if ((rampFundUp = this.safeGetFunc(functions, json.get((String)OccProfileSim.PROP_RAMP_FUNDAMENTAL_UP.key))) == null) {
                rampFundUp = (IFunction1d)parentProfile.getProperty(OccProfileSim.PROP_RAMP_FUNDAMENTAL_UP).apply(parentProfile);
            }
            if ((rampFracDown = this.safeGetFunc(functions, json.get((String)OccProfileSim.PROP_RAMP_SPEED_DOWN.key))) == null) {
                rampFracDown = parentProfile.getProperty(OccProfileSim.PROP_RAMP_SPEED_DOWN);
            }
            if ((rampFundDown = this.safeGetFunc(functions, json.get((String)OccProfileSim.PROP_RAMP_FUNDAMENTAL_DOWN.key))) == null) {
                rampFundDown = (IFunction1d)parentProfile.getProperty(OccProfileSim.PROP_RAMP_FUNDAMENTAL_DOWN).apply(parentProfile);
            }
            if ((orientString = (String)json.get((String)OccProfileSim.PROP_INIT_ORIENT.key)) != null) {
                st = new StringTokenizer(orientString, " ");
                occ.orient = new Vector3d(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()));
            } else {
                double angleRad = ((UnitDouble)parentProfile.getDistVal(OccProfileSim.PROP_INIT_ORIENT, rnd, orientSeed)).getValue(SI.RADIAN);
                Vector3d orient = new Vector3d(1.0, 0.0, 0.0);
                Inter.rotateTuple2D(orient, (float)angleRad, new Point3d(0.0, 0.0, 0.0));
                occ.orient = orient;
            }
            if (stairFundUp == null) {
                stairFundUp = fundamental;
            }
            if (stairFundDown == null) {
                stairFundDown = fundamental;
            }
            if (rampFundUp == null) {
                rampFundUp = fundamental;
            }
            if (rampFundDown == null) {
                rampFundDown = fundamental;
            }
            occ.fundamental = fundamental;
            occ.stairSpeed = this.finalizeSlopeSpeed(new SlopeSpeed(stairFracUp, stairFundUp, stairFracDown, stairFundDown));
            occ.rampSpeed = this.finalizeSlopeSpeed(new SlopeSpeed(rampFracUp, rampFundUp, rampFracDown, rampFundDown));
            if (Double.isNaN(priority)) {
                priority = OccPriority.init(0, priorityGen.nextDouble());
            }
            occ.priority = priority;
            return occ;
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    private IFunction1d safeGetFunc(List<IFunction1d> functions, Object index) {
        if (index == null) {
            return null;
        }
        return functions.get((int)((Long)index).longValue());
    }

    private SlopeSpeed finalizeSlopeSpeed(SlopeSpeed speed) {
        return this.finalizePoolItem(this.d_slopeSpeedPool, speed);
    }

    private Color3b finalizeColor(Color3b color) {
        return this.finalizePoolItem(this.d_colorPool, color);
    }

    private <T> T finalizePoolItem(Map<T, T> pool, T item) {
        T eitem = pool.putIfAbsent(item, item);
        return eitem != null ? eitem : item;
    }

    private static byte parseColorComp(String val) {
        float fval = Float.parseFloat(val);
        return (byte)(fval * 255.0f);
    }

    public Point3d parseVert(String line) {
        String[] tokens = this.getTokens(line, true);
        return new Point3d(Double.parseDouble(tokens[0]), Double.parseDouble(tokens[1]), Double.parseDouble(tokens[2]));
    }

    public boolean parseMeshTri(MeshBuilder mb, String line) {
        String[] tokens = this.getTokens(line, true);
        String strNode = tokens[0];
        String type = tokens[1];
        Tri.Terrain terrain = null;
        if (type.equalsIgnoreCase("open")) {
            terrain = Tri.Terrain.OPEN;
        } else if (type.equalsIgnoreCase("stair")) {
            terrain = Tri.Terrain.STAIR;
        } else if (type.equalsIgnoreCase("ramp")) {
            terrain = Tri.Terrain.RAMP;
        }
        int iv1 = Integer.parseInt(tokens[2]);
        int iv2 = Integer.parseInt(tokens[3]);
        int iv3 = Integer.parseInt(tokens[4]);
        int nodeIx = Integer.parseInt(strNode);
        ANode node = this.d_kb.getNodes().get(nodeIx);
        MeshBuilder.MTri mtri = mb.addTri(node, terrain, iv1, iv2, iv3);
        if (mtri != null) {
            this.d_triFileOrder.put(this.d_triFileOrder.size(), mtri);
            return true;
        }
        System.err.printf("[SimpleParser.parseMeshTri()] unable to add triangle %s%n", this.d_triFileOrder.size());
        return false;
    }

    private Point3d parsePoint3d(TokenIterator tokens) throws IOException {
        return new Point3d(tokens.nextDouble(), tokens.nextDouble(), tokens.nextDouble());
    }

    private Vector3d parseVector3d(TokenIterator tokens) throws IOException {
        return new Vector3d(tokens.nextDouble(), tokens.nextDouble(), tokens.nextDouble());
    }

    private Point2d parsePoint2d(TokenIterator tokens) throws IOException {
        return new Point2d(tokens.nextDouble(), tokens.nextDouble());
    }

    private Vector2d parseVector2d(TokenIterator tokens) throws IOException {
        return new Vector2d(tokens.nextDouble(), tokens.nextDouble());
    }

    private double[] parseDoubles(TokenIterator tokens, int count) throws IOException {
        double[] result = new double[count];
        for (int m = 0; m < count; ++m) {
            result[m] = tokens.nextDouble();
        }
        return result;
    }

    private static Point3d parsePoint3d(String str) {
        return SimpleParser.parsePoint3d(str, "() ,");
    }

    private static Point3d parsePoint3d(String str, String delimiters) {
        List<String> tokens = CSVLineParser.parse(str, delimiters, "");
        return new Point3d(Double.parseDouble(tokens.get(0)), Double.parseDouble(tokens.get(1)), Double.parseDouble(tokens.get(2)));
    }

    private static Vector3d parseVector3d(String str, String delimiters) {
        List<String> tokens = CSVLineParser.parse(str, delimiters, "");
        return new Vector3d(Double.parseDouble(tokens.get(0)), Double.parseDouble(tokens.get(1)), Double.parseDouble(tokens.get(2)));
    }

    private static void throwexc(String format, Object ... args) throws IOException {
        throw new IOException(String.format(format, args));
    }

    private Collection<ANode> parseNodeList(String str) {
        if (str.equalsIgnoreCase("nearest") || str.equalsIgnoreCase("any")) {
            return null;
        }
        List<String> tokens = CSVLineParser.parse(str, "() ,", "");
        ArrayDeque<ANode> allowedExits = new ArrayDeque<ANode>();
        for (String node : tokens) {
            int ixGoal = Integer.parseInt(node);
            ANode exit = this.d_kb.getNodes().get(ixGoal);
            allowedExits.add(exit);
        }
        return Collections.unmodifiableCollection(allowedExits);
    }

    private static String format(Point3d p) {
        return String.format("(%.2f, %.2f, %.2f)", p.x, p.y, p.z);
    }

    private static Set<Tag> getTags(String tagStr, TagGenerator tagGen, boolean predefAllowed) throws IOException {
        if (tagStr.startsWith("(") && tagStr.endsWith(")")) {
            tagStr = tagStr.substring(1, tagStr.length() - 1);
        }
        TokenIterator tagToks = new TokenIterator(CSVLineParser.parse(new ArrayList<String>(), tagStr, " ,", "\"\"()", null, Character.valueOf('\\'), 0));
        LinkedHashSet<Tag> tags = new LinkedHashSet<Tag>();
        while (tagToks.hasMore()) {
            String stag = tagToks.next();
            Tag tag = tagGen.getTag(stag);
            if (tag.predefined && !predefAllowed) {
                SimpleParser.throwexc("May not used pre-defined tag: %s", tag.name);
            }
            tags.add(tag);
        }
        return tags;
    }

    private IGoal parseGoal(String goalStr, ParseGoalInfo pgi, List<IGoal> currGoals, List<OccProfileSim> profiles, List<IDistributedVal<?>> distributions) throws IOException {
        TokenIterator toks = new TokenIterator(CSVLineParser.parse(new ArrayList<String>(), goalStr, " ,", "()\"\"", null, Character.valueOf('\\'), 3));
        JSONParser jsonParser = new JSONParser();
        String tok = toks.next();
        switch (tok.toUpperCase()) {
            case "GOTO": {
                tok = toks.next();
                switch (tok.toUpperCase()) {
                    case "POINT": {
                        Point3d pt = SimpleParser.parsePoint3d(toks.next());
                        double r = toks.nextDouble();
                        Tri tri = this.d_kb.getMesh().getTri(pt);
                        if (tri == null) {
                            SimpleParser.throwexc(Intl.intl("GOTO POINT, %s, is not located on navigation mesh."), SimpleParser.format(pt));
                        }
                        return new PointGoal(new ITpSource.ConstTpSource(new TriPoint(tri, pt)), r);
                    }
                    case "OCCUPANT": {
                        int occId = toks.nextInt();
                        double r = toks.nextDouble();
                        return new PointGoal(new ITpSource.AgentTpSource(this.d_kb, occId), r);
                    }
                    case "EXIT": {
                        Collection<ANode> nodes = this.parseNodeList(toks);
                        return new ExitGoal(nodes);
                    }
                    case "ROOM": {
                        Collection<ANode> rooms = this.parseNodeList(toks);
                        return new RoomGoal(rooms);
                    }
                    case "ELEVATOR": {
                        ArrayList<IElevator> elevs;
                        boolean anyElev = toks.curr().equalsIgnoreCase("ANY");
                        if (anyElev) {
                            elevs = this.d_kb.getElevatorModel().getElevators();
                        } else {
                            elevs = new ArrayList();
                            while (toks.hasMore()) {
                                int index = toks.nextInt();
                                IElevator elevator = this.d_kb.getElevatorModel().getElevator(index);
                                elevs.add(elevator);
                            }
                            elevs = Collections.unmodifiableList(elevs);
                        }
                        ElevatorGoal eg = new ElevatorGoal(this.d_kb, anyElev, elevs);
                        return eg;
                    }
                    case "SUBUNIT": {
                        int suIndex = Integer.parseInt(toks.next());
                        QSubUnit su = this.d_kb.getSubUnits().get(suIndex);
                        SubUnitGoal sg = new SubUnitGoal(su);
                        return sg;
                    }
                }
                Collection<ANode> nodes = this.parseNodeList(tok);
                return new ExitGoal(nodes);
            }
            case "WAIT": {
                tok = toks.curr();
                if (tok.equalsIgnoreCase("POINT")) {
                    toks.next();
                    toks.next();
                }
                if (tok.equalsIgnoreCase("CURVE")) {
                    toks.next();
                    return new WaitGoal((IDistributedVal)pgi.distributions.get(toks.nextInt()));
                }
                if (toks.getRemaining() >= 2) {
                    toks.next();
                }
                double t = toks.nextDouble();
                return new WaitGoal(t);
            }
            case "WAIT_UNTIL": {
                tok = toks.curr();
                if (tok.equalsIgnoreCase("IWaitUntilSrc.SIMPLE")) {
                    toks.next();
                    ICurve waitCurve = (ICurve)pgi.distributions.get(toks.nextInt());
                    return new WaitUntilGoal(new IWaitUntilSrc.SimpleWaitUntilSrc(waitCurve));
                }
                if (tok.equalsIgnoreCase("IWaitUntilSrc.CYCLE")) {
                    toks.next();
                    ICurve firstWait = (ICurve)pgi.distributions.get(toks.nextInt());
                    ICurve interval = (ICurve)pgi.distributions.get(toks.nextInt());
                    return new WaitUntilGoal(new IWaitUntilSrc.CycledWaitUntilSrc(firstWait, interval));
                }
                if (tok.equalsIgnoreCase("IWaitUntilSrc.LIST")) {
                    ArrayList<ICurve> curves = new ArrayList<ICurve>();
                    String next = toks.next();
                    next = toks.next();
                    Integer nextInt = Integer.parseInt(next);
                    while (nextInt != null || toks.hasMore()) {
                        int ixCurve = nextInt != null ? nextInt.intValue() : toks.nextInt();
                        nextInt = null;
                        ICurve curve = (ICurve)pgi.distributions.get(ixCurve);
                        curves.add(curve);
                    }
                    return new WaitUntilGoal(new IWaitUntilSrc.ListedWaitUntilSrc(curves));
                }
            }
            case "WAIT_INTERVAL": {
                double t = toks.nextDouble();
                return new WaitIntervalGoal(t);
            }
            case "WAIT_TIME": {
                double t = toks.nextDouble();
                return new WaitTime(t);
            }
            case "WAIT_UNTIL_INSIDE": {
                ArrayList<ANode> rooms = new ArrayList<ANode>();
                while (toks.hasMore()) {
                    int ixNode = toks.nextInt();
                    ANode room = this.d_kb.getNodes().get(ixNode);
                    rooms.add(room);
                }
                return new WaitUntilInsideGoal(rooms);
            }
            case "TAG": {
                String tagStr = toks.next();
                Set<Tag> tags = SimpleParser.getTags(tagStr, pgi.tags, true);
                return new ChangeTagGoal(ChangeTagGoal.Op.TAG, tags);
            }
            case "UNTAG": {
                String tagStr = toks.next();
                Set<Tag> tags = SimpleParser.getTags(tagStr, pgi.tags, true);
                return new ChangeTagGoal(ChangeTagGoal.Op.UNTAG, tags);
            }
            case "WAIT_UNTIL_ALL_TAGGED": {
                String tagStr = toks.next();
                Set<Tag> tags = SimpleParser.getTags(tagStr, pgi.tags, true);
                if (tags.isEmpty()) {
                    throw new IOException("No tags specified");
                }
                Predicate<Tag> tagFilter = Filters.accept(tags);
                return new WaitUntilTaggedGoal(Predicates.alwaysTrue(), Predicates.alwaysTrue(), tagFilter);
            }
            case "WAIT_COUNTER": {
                ComparePredicate.Type type;
                Counter counter = pgi.counters.get(toks.nextInt());
                String op = toks.next();
                double rval = toks.nextDouble();
                switch (op) {
                    case "<": {
                        type = ComparePredicate.Type.LESS;
                        break;
                    }
                    case "<=": {
                        type = ComparePredicate.Type.LEQUAL;
                        break;
                    }
                    case ">": {
                        type = ComparePredicate.Type.GREATER;
                        break;
                    }
                    case ">=": {
                        type = ComparePredicate.Type.GEQUAL;
                        break;
                    }
                    case "==": {
                        type = ComparePredicate.Type.EQUAL;
                        break;
                    }
                    default: {
                        throw new IOException(String.format("Unknown counter condition: %s", op));
                    }
                }
                ComparePredicate condition = new ComparePredicate(type, BigDecimal.valueOf(rval));
                return new WaitForCounterGoal(counter, condition);
            }
            case "CHANGE_COUNTER": {
                BigDecimalOp.Type type;
                Counter counter = pgi.counters.get(toks.nextInt());
                String op = toks.next();
                double rval = toks.nextDouble();
                switch (op.toLowerCase()) {
                    case "+": 
                    case "add": {
                        type = BigDecimalOp.Type.ADD;
                        break;
                    }
                    case "-": 
                    case "sub": 
                    case "subtract": {
                        type = BigDecimalOp.Type.SUBTRACT;
                        break;
                    }
                    case "*": 
                    case "mul": 
                    case "multiply": {
                        type = BigDecimalOp.Type.MULTIPLY;
                        break;
                    }
                    case "/": 
                    case "div": 
                    case "divide": {
                        type = BigDecimalOp.Type.DIVIDE;
                        break;
                    }
                    default: {
                        throw new IOException(String.format("Unknown counter op: %s", op));
                    }
                }
                return new ChangeCounterGoal(counter, new BigDecimalOp(type, BigDecimal.valueOf(rval)));
            }
            case "SET_PROP": {
                String name = toks.next();
                String sval = toks.next();
                IPropertySet.Prop<?> prop = OccProfileSim.PROP_TYPES_MAP.get(name);
                if (prop == null) {
                    throw new IOException(String.format("Unknown profile property: %s", name));
                }
                if (!(prop instanceof OccProfileSim.IOccProp)) {
                    SimpleParser.throwexc("Profile property cannot be changed: %s", name);
                }
                try {
                    JSONObject jobj = (JSONObject)jsonParser.parse(sval);
                    Object jsonVal = jobj.get("val");
                    Object val = this.parseProfileProp(prop, jsonVal, pgi);
                    return new SetOccPropGoal<Object>((OccProfileSim.IOccProp)((Object)prop), val);
                }
                catch (ParseException e) {
                    throw new IOException(e);
                }
            }
            case "DETACH_ASSISTANTS": {
                Collection prevTeams = Util.reverseStream(currGoals).filter(g -> g instanceof WaitForAssistanceGoal).map(g -> ((WaitForAssistanceGoal)g).teams).findFirst().orElse(Collections.emptySet());
                if (prevTeams.isEmpty()) {
                    return DetachGoal.DETACH_ALL;
                }
                return new DetachGoal(prevTeams);
            }
            case "ASSIST": {
                int teamId = toks.nextInt();
                AssistedEvacTeam team = pgi.teams.get(teamId);
                return new AssistOccupantsGoal(team);
            }
            case "GET_ASSISTANCE": {
                ArrayList<AssistedEvacTeam> teams = new ArrayList<AssistedEvacTeam>();
                while (toks.hasMore()) {
                    teams.add(pgi.teams.get(toks.nextInt()));
                }
                return new WaitForAssistanceGoal(theUtil.toArray(teams, AssistedEvacTeam.class));
            }
            case "FILL_ROOM": {
                return FillRoomGoal.ALWAYS;
            }
            case "FILL_ROOM_IF_NECESSARY": {
                return FillRoomGoal.ONLY_IF_NECESSARY;
            }
            case "JOIN_GROUP": {
                int groupId = toks.nextInt();
                OccGroup group = pgi.groups.get(groupId);
                return new JoinOccGroupGoal(group);
            }
            case "JOIN_GROUP_TYPE": {
                int groupTypeId = toks.nextInt();
                OccGroupType groupType = pgi.groupTypes.get(groupTypeId);
                return new JoinOccGroupGoal(groupType);
            }
            case "CHANGE_BEHAVIOR": {
                int urnId = toks.nextInt();
                ChangeBehaviorGoal changeBehaviorGoal = new ChangeBehaviorGoal();
                pgi.changeBehaviorIdMap.put(changeBehaviorGoal, urnId);
                return changeBehaviorGoal;
            }
            case "CHANGE_PROFILE": {
                int urnId = toks.nextInt();
                ChangeProfileGoal changeProfileGoal = new ChangeProfileGoal(ChangeProfileGoal.UI_PROP_FILTER);
                changeProfileGoal.init(SimpleParser.toObjectUrn((IUrn)distributions.get(urnId), profiles));
                return changeProfileGoal;
            }
        }
        throw new IOException(String.format("Unknown goal: %s", tok));
    }

    private Collection<ANode> parseNodeList(TokenIterator toks) {
        String next = toks.next();
        if (next.equalsIgnoreCase("nearest") || next.equalsIgnoreCase("any")) {
            return null;
        }
        Integer nextInt = Integer.parseInt(next);
        ArrayList<ANode> nodes = new ArrayList<ANode>();
        while (nextInt != null || toks.hasMore()) {
            int ixNode = nextInt != null ? nextInt.intValue() : toks.nextInt();
            nextInt = null;
            ANode node = this.d_kb.getNodes().get(ixNode);
            nodes.add(node);
        }
        return nodes;
    }

    public BehaviorSim parseBehavior(String line, ParseGoalInfo pgi, List<OccProfileSim> profiles, List<IDistributedVal<?>> distributions) throws IOException {
        try {
            String[] tokens = this.getTokens(line, "", true, true, true);
            JSONParser jsonp = new JSONParser();
            JSONObject json = (JSONObject)jsonp.parse(tokens[0]);
            String name = (String)json.get("name");
            String script = (String)json.get("script");
            Color color = this.parseJSONColor(json.get("color"));
            String[] scriptTokens = this.getTokens(script, ";", false, true, true);
            ArrayList<IGoal> goals = new ArrayList<IGoal>();
            for (String strGoal : scriptTokens) {
                goals.add(this.parseGoal(strGoal, pgi, goals, profiles, distributions));
            }
            goals.trimToSize();
            return new BehaviorSim(name, color, Collections.unmodifiableList(goals));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Tag parseTag(String line) throws IOException {
        int colix = line.indexOf(58);
        line = line.substring(colix + 1);
        JSONParser parser = new JSONParser();
        try {
            JSONObject json = (JSONObject)parser.parse(line);
            Tag tag = new Tag((String)json.get("name"), (String)json.get("desc"), (Boolean)json.get("predefined"));
            return tag;
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    public OccProfileSim parseProfile(String line, ParseProfileInfo ppi) throws IOException {
        int colix = line.indexOf(58);
        JSONParser parser = new JSONParser();
        try {
            Object obj = parser.parse(line.substring(colix + 1));
            JSONObject json = (JSONObject)obj;
            OccProfileSim occProfile = new OccProfileSim();
            Map<Object, IPropertySet.Prop<?>> allProps = OccProfileSim.PROP_TYPES_MAP;
            for (Map.Entry<Object, IPropertySet.Prop<?>> entry : allProps.entrySet()) {
                Object prop = json.get(entry.getKey());
                if (prop == null) continue;
                Object val = this.parseProfileProp(entry.getValue(), prop, ppi);
                occProfile.setProperty((Object)entry.getValue(), val);
            }
            return occProfile;
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    private static Point3f parseJSONColorP3f(Object jsonVal) {
        if (jsonVal instanceof String) {
            StringTokenizer st = new StringTokenizer((String)jsonVal, "(), ");
            return new Point3f(Float.parseFloat(st.nextToken()), Float.parseFloat(st.nextToken()), Float.parseFloat(st.nextToken()));
        }
        if (jsonVal instanceof JSONArray) {
            JSONArray arr = (JSONArray)jsonVal;
            Double r = (Double)arr.get(0);
            Double g = (Double)arr.get(1);
            Double b = (Double)arr.get(2);
            return new Point3f(r.floatValue(), g.floatValue(), b.floatValue());
        }
        assert (jsonVal == null);
        return null;
    }

    private Color parseJSONColor(Object jsonVal) {
        if (jsonVal == null) {
            return null;
        }
        if (jsonVal instanceof String) {
            StringTokenizer st = new StringTokenizer((String)jsonVal, " ");
            return new Color(Float.parseFloat(st.nextToken()), Float.parseFloat(st.nextToken()), Float.parseFloat(st.nextToken()), Float.parseFloat(st.nextToken()));
        }
        if (jsonVal instanceof JSONArray) {
            JSONArray color = (JSONArray)jsonVal;
            Double r = (Double)color.get(0);
            Double g = (Double)color.get(1);
            Double b = (Double)color.get(2);
            Double a = (Double)color.get(3);
            return new Color(r.floatValue(), g.floatValue(), b.floatValue(), a.floatValue());
        }
        assert (false);
        return null;
    }

    private Object parseProfileProp(IPropertySet.Prop<?> prop, Object jsonVal, ParseProfileInfo ppi) {
        if (prop == OccProfileSim.PROP_COLOR) {
            return SimpleParser.parseJSONColorP3f(jsonVal);
        }
        if (jsonVal instanceof String && prop instanceof OccProfileSim.NullableProp && "null".equals(jsonVal)) {
            return ((OccProfileSim.NullableProp)prop).nullValue;
        }
        if (jsonVal instanceof String) {
            return jsonVal;
        }
        if (jsonVal instanceof Double) {
            return jsonVal;
        }
        if (jsonVal instanceof Boolean) {
            return jsonVal;
        }
        if (prop instanceof IFunction1d || prop instanceof OccProfileSim.Function1dProp) {
            long propL = (Long)jsonVal;
            return ppi.functions.get((int)propL);
        }
        if (prop instanceof OccProfileSim.ProfileFunctionProp) {
            long propL = (Long)jsonVal;
            return new OccProfileSim.ConstProfileFunction(ppi.functions.get((int)propL));
        }
        if (prop instanceof OccProfileSim.Prop && (((OccProfileSim.Prop)prop).isAssignableFrom(ICurve.class) || ((OccProfileSim.Prop)prop).isAssignableFrom(IUrn.class))) {
            long propL = (Long)jsonVal;
            return ppi.distributions.get((int)propL);
        }
        if (prop instanceof OccProfileSim.UnitDoubleOccProp) {
            double propD = (Double)jsonVal;
            return new UnitDouble(propD, ((OccProfileSim.UnitDoubleOccProp)prop).defaultUnit);
        }
        if (prop instanceof OccProfileSim.Prop && ((OccProfileSim.Prop)prop).isAssignableFrom(OccProfileSim.IShapeGen.class)) {
            if (jsonVal != null) {
                long propL = (Long)jsonVal;
                return ppi.occShapes.get((int)propL);
            }
        } else if (prop.equals(OccProfileSim.PROP_SPACING)) {
            try {
                OccProfileSim.Spacing spacing = SimpleParser.parseSpacingCurve(jsonVal.toString());
                return spacing;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (prop.equals(OccProfileSim.PROP_RESTRICTED_COMPONENTS)) {
            return ppi.compRestrictionsMap.get((int)((Long)jsonVal).longValue());
        }
        return prop.defVal;
    }

    private static OccProfileSim.Spacing parseSpacingCurve(String line) throws IOException {
        JSONParser parser = new JSONParser();
        try {
            Object obj = parser.parse(line);
            JSONObject json = (JSONObject)obj;
            OccProfileSim.SpacingType spacingType = OccProfileSim.SpacingType.valueOf((String)json.get("type"));
            String curveString = json.get("val").toString();
            ICurve curve = SimpleParser.parseCurve(curveString, false);
            return new OccProfileSim.Spacing(spacingType, curve);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static IUrn<?> parseOrderedUrn(String line, boolean hasHeader) throws IOException {
        int colix = hasHeader ? line.indexOf(58) : -1;
        JSONParser parser = new JSONParser();
        try {
            Object obj = parser.parse(line.substring(colix + 1));
            JSONObject json = (JSONObject)obj;
            JSONArray array = (JSONArray)json.get("urn");
            String type = (String)json.get("type");
            return SimpleParser.parseOrderedUrn(array, type);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static IUrn<?> parseOrderedUrn(JSONArray jsonArray, String type) {
        if (jsonArray.size() == 0) {
            return null;
        }
        BiConsumer<JSONArray, Map> fillMap = (array, map) -> {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject obj = (JSONObject)array.get(i);
                assert (obj.keySet().size() == 1);
                String key = (String)obj.keySet().iterator().next();
                Double val = (Double)obj.get(key);
                map.put(key, val);
            }
        };
        BiConsumer<JSONArray, Map> fillIntMap = (array, map) -> {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject obj = (JSONObject)array.get(i);
                assert (obj.keySet().size() == 1);
                String key = (String)obj.keySet().iterator().next();
                Integer ikey = Integer.parseInt(key);
                Double val = (Double)obj.get(key);
                map.put(ikey, val);
            }
        };
        BiConsumer<JSONArray, Map> fillBoolMap = (array, map) -> {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject obj = (JSONObject)array.get(i);
                assert (obj.keySet().size() == 1);
                String key = (String)obj.keySet().iterator().next();
                Boolean bkey = Boolean.parseBoolean(key);
                Double val = (Double)obj.get(key);
                map.put(bkey, val);
            }
        };
        BiConsumer<JSONArray, Map> fillUdMap = (array, map) -> {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject obj = (JSONObject)array.get(i);
                assert (obj.keySet().size() == 1);
                String key = (String)obj.keySet().iterator().next();
                try {
                    UnitDouble udkey = Global.parseUnitDouble(key);
                    Double val = (Double)obj.get(key);
                    map.put(udkey, val);
                    continue;
                }
                catch (java.text.ParseException e) {
                    e.printStackTrace();
                }
            }
        };
        LinkedHashMap map2 = null;
        if (type.equals("int")) {
            LinkedHashMap intMap = new LinkedHashMap();
            fillIntMap.accept(jsonArray, intMap);
            map2 = intMap;
        } else if (type.equals("bool")) {
            LinkedHashMap boolMap = new LinkedHashMap();
            fillBoolMap.accept(jsonArray, boolMap);
            map2 = boolMap;
        } else if (type.equals("ud")) {
            LinkedHashMap udMap = new LinkedHashMap();
            fillUdMap.accept(jsonArray, udMap);
            map2 = udMap;
        } else if (type.equals("string")) {
            LinkedHashMap strMap = new LinkedHashMap();
            fillMap.accept(jsonArray, strMap);
            map2 = strMap;
        } else assert (false);
        return UrnUtil.newUrn(map2);
    }

    private static boolean isNonNegativeInteger(String str) {
        try {
            int i = Integer.parseInt(str);
            return 0 <= i;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void parseElevatorDischarge(String line, String elevatorLine) throws IOException {
        String[] tokens = this.getTokens(line, true);
        int dischargeNodeId = Integer.parseInt(tokens[0]);
        ANode dischargeNode = this.d_kb.getNodes().get(dischargeNodeId);
        double openTime = Double.parseDouble(tokens[1]);
        double closeDelay = Double.parseDouble(tokens[2]);
        double szFactor = Double.parseDouble(tokens[3]);
        double maxDensity = Double.parseDouble(tokens[4]);
        String name = "";
        boolean isDoubleDeck = false;
        double callDistance = this.d_kb.getParams().elevator_call_distance;
        ANode initNode = dischargeNode;
        if (elevatorLine != null) {
            try {
                JSONParser parser = new JSONParser();
                Object obj = parser.parse(elevatorLine);
                JSONObject json = (JSONObject)obj;
                name = (String)json.get("name");
                isDoubleDeck = (Boolean)json.get("double_deck");
                callDistance = (Double)json.get("call_distance");
                int initNodeId = (int)((Long)json.get("initial_floor")).longValue();
                initNode = this.d_kb.getNodes().get(initNodeId);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        EvacElevator elev = new EvacElevator(name, dischargeNode, openTime, closeDelay, szFactor, maxDensity, initNode, callDistance, isDoubleDeck);
        this.d_kb.getElevatorModel().addElevator(elev);
    }

    public void parseElevatorLevelData(String line) throws IOException {
        double closeTime;
        double openTime;
        String[] tokens = this.getTokens(line, false);
        int elevatorId = Integer.parseInt(tokens[0]);
        int pickupNodeId = Integer.parseInt(tokens[1]);
        ANode pickupNode = this.d_kb.getNodes().get(pickupNodeId);
        int levelId = Integer.parseInt(tokens[2]);
        int tokix = 3;
        if (tokens.length >= 7) {
            openTime = Double.parseDouble(tokens[tokix++]);
            closeTime = Double.parseDouble(tokens[tokix++]);
        } else {
            closeTime = 0.0;
            openTime = 0.0;
        }
        double pickupTime = Double.parseDouble(tokens[tokix++]);
        double dischargeTime = Double.parseDouble(tokens[tokix++]);
        double tFirstAvailable = Double.parseDouble(tokens[tokix++]);
        boolean isEnabled = tFirstAvailable != Double.POSITIVE_INFINITY;
        IElevator elev = this.d_kb.getElevatorModel().getElevator(elevatorId);
        ElevatorLevel elevLvl = new ElevatorLevel(levelId, pickupNode, openTime, closeTime, pickupTime, dischargeTime, tFirstAvailable, isEnabled);
        elev.addLevel(elevLvl);
    }

    public void parseElevatorLink(String line) throws IOException {
        String[] tokens = this.getTokens(line, false);
        ElevatorModel elevModel = this.d_kb.getElevatorModel();
        ArrayDeque<IElevator> linkedElevs = new ArrayDeque<IElevator>();
        for (String elevIdStr : tokens) {
            int elevId = Integer.parseInt(elevIdStr);
            IElevator elev = elevModel.getElevator(elevId);
            linkedElevs.add(elev);
        }
        this.d_kb.getElevatorModel().linkElevators(linkedElevs);
    }

    public void parseElevatorPriority(String line) {
        String[] tokens = this.getTokens(line, false);
        int elevId = Integer.parseInt(tokens[0]);
        ArrayList<Integer> priorityFloorIds = new ArrayList<Integer>();
        for (int i = 1; i < tokens.length; ++i) {
            String tok = tokens[i];
            priorityFloorIds.add(Integer.parseInt(tok));
        }
        IElevator elev = this.d_kb.getElevatorModel().getElevator(elevId);
        elev.setTopPriorityFloors(priorityFloorIds);
    }

    public void parseSubUnits(String line) {
        int colix = line.indexOf(58);
        JSONParser parser = new JSONParser();
        try {
            Object obj = parser.parse(line.substring(colix + 1));
            JSONObject json = (JSONObject)obj;
            ArrayList<QServicePoint> services = new ArrayList<QServicePoint>();
            JSONArray serviceObjects = (JSONArray)json.get("services");
            for (Object servicePoint : serviceObjects) {
                Point3d serviceP3d = SimpleParser.parsePoint3d(servicePoint.toString());
                TriPoint serviceTP = new TriPoint(this.d_kb.getMesh().getTri(serviceP3d), serviceP3d);
                services.add(new QServicePoint(serviceTP));
            }
            ArrayList<QOccLineQueue> queues = new ArrayList<QOccLineQueue>();
            JSONArray queueObjects = (JSONArray)json.get("queues");
            for (Object queueObj : queueObjects) {
                JSONObject asdf = (JSONObject)queueObj;
                boolean followPath = (Boolean)asdf.get("followpath");
                ArrayList<Point3d> qPoints = new ArrayList<Point3d>();
                for (Object point : (JSONArray)asdf.get("points")) {
                    qPoints.add(SimpleParser.parsePoint3d(point.toString()));
                }
                QOccLineQueue occQ = new QOccLineQueue(this.d_kb, qPoints);
                occQ.SetFollowPath(followPath);
                queues.add(occQ);
            }
            QSubUnit newUnit = new QSubUnit(this.d_kb, services, queues, null, QSuperUnit.QBalancingType.SELF_BALANCING);
            this.d_kb.addSubUnit(newUnit);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private static int[] parseIndexes(TokenIterator tokens, int count) {
        count = Math.min(tokens.getRemaining(), count);
        int[] ixes = new int[count];
        for (int m = 0; m < count; ++m) {
            ixes[m] = tokens.nextInt();
        }
        return ixes;
    }

    public void parseBlockage(String line, List<Material> mats) throws IOException {
        TokenIterator tokens = new TokenIterator(this.getTokens(line, true));
        String blkgName = tokens.next();
        int matIx = -1;
        if (this.d_version >= 4) {
            matIx = tokens.nextInt();
        }
        double velFactor = tokens.nextDouble();
        int[] triIds = SimpleParser.parseIndexes(tokens, Integer.MAX_VALUE);
        this.getTris(triIds);
        Material mat = matIx == -1 ? null : mats.get(matIx);
        int blkgId = this.getKB().getBlockages().size();
        Blockage blkg = new Blockage(blkgId, blkgName, mat, velFactor, triIds);
        this.getKB().addBlockage(blkg);
    }

    public void parseCamera(String line) throws IOException {
        TokenIterator tokens = new TokenIterator(this.getTokens(line, " ,()", true));
        Camera camera = new Camera(this.getKB().getCameras().size());
        camera.set(Camera.PROP_NAME, tokens.next());
        Camera.Type type = tokens.next().equals("2D") ? Camera.Type.ORTHO : Camera.Type.PERSPECTIVE;
        camera.set(Camera.PROP_TYPE, type);
        camera.set(Camera.PROP_FOV, tokens.nextDouble());
        camera.set(Camera.PROP_LOC, this.parsePoint3d(tokens));
        camera.set(Camera.PROP_REF, this.parsePoint3d(tokens));
        camera.set(Camera.PROP_UP, this.parseVector3d(tokens));
        camera.set(Camera.PROP_ZOOM, tokens.nextDouble());
        camera.set(Camera.PROP_ZOOM_LOC, this.parsePoint2d(tokens));
        boolean controllable = tokens.nextInt() != 0;
        camera.set(Camera.PROP_SECURITY, controllable);
        if (controllable) {
            camera.set(Camera.PROP_PTZ_ORIENT, this.parseVector3d(tokens));
            camera.set(Camera.PROP_PAN_INFO, SimpleParser.parsePTZSpec(tokens));
            camera.set(Camera.PROP_TILT_INFO, SimpleParser.parsePTZSpec(tokens));
            camera.set(Camera.PROP_ZOOM_INFO, SimpleParser.parsePTZSpec(tokens));
        }
        this.getKB().addCamera(camera);
    }

    private static Camera.PTZSpec parsePTZSpec(TokenIterator tokens) {
        return new Camera.PTZSpec(tokens.nextDouble(), tokens.nextDouble(), tokens.nextDouble());
    }

    public void parseMeta(String line) {
        this.getKB().addMetaData(line);
    }

    public void parseEvent(String line) throws IOException {
        BitSet quotedVals = new BitSet();
        List<String> tokList = CSVLineParser.parse(line, " ,", "\"", quotedVals);
        TokenIterator tokens = new TokenIterator(tokList);
        double t = tokens.nextDouble();
        String cmd = tokens.next();
        if (cmd.equalsIgnoreCase(CMD_ADD_BLOCKAGE)) {
            String blkgId = tokens.next();
            List<Blockage> blockages = this.findBlockages(blkgId, quotedVals.get(2));
            for (Blockage blockage : blockages) {
                this.d_kb.addEvent(t, new EngineOp.AddBlockage(blockage));
            }
        } else if (cmd.equalsIgnoreCase(CMD_REMOVE_BLOCKAGE)) {
            String blkgId = tokens.next();
            List<Blockage> blockages = this.findBlockages(blkgId, quotedVals.get(2));
            for (Blockage blockage : blockages) {
                this.d_kb.addEvent(t, new EngineOp.RemoveBlockage(blockage));
            }
        } else if (cmd.equalsIgnoreCase(CMD_OPEN_DOOR)) {
            int doorNodeIx = tokens.nextInt();
            ANode node = this.d_kb.getNodes().get(doorNodeIx);
            this.d_kb.addEvent(t, EngineOp.SetDoorState.openDoor(node));
        } else if (cmd.equalsIgnoreCase(CMD_CLOSE_DOOR)) {
            int doorNodeIx = tokens.nextInt();
            double reopenTime = tokens.nextDouble();
            ANode node = this.d_kb.getNodes().get(doorNodeIx);
            ITimeEstimate tEst = reopenTime != -1.0 ? new ITimeEstimate.Specific(reopenTime) : ITimeEstimate.FOREVER;
            this.d_kb.addEvent(t, EngineOp.SetDoorState.closeDoor(node, tEst));
        } else if (cmd.equalsIgnoreCase(CMD_CHANGE_DOOR_DIR)) {
            Vector2d dir = this.parseVector2d(tokens);
            int doorNodeIx = tokens.nextInt();
            ANode node = this.d_kb.getNodes().get(doorNodeIx);
            this.d_kb.addEvent(t, EngineOp.SetDoorState.openAndSetDirection(node, dir));
        } else if (cmd.equalsIgnoreCase(CMD_SET_SPEED_MOD)) {
            SpeedModifier.Type type;
            String typeName = tokens.next();
            double value = tokens.nextDouble();
            if (typeName.equalsIgnoreCase("CONSTANT")) {
                type = SpeedModifier.Type.CONSTANT;
            } else if (typeName.equalsIgnoreCase("FACTOR")) {
                type = SpeedModifier.Type.FACTOR;
            } else {
                throw new IOException(String.format(Intl.intl("Invalid speed modifier type: %s"), typeName));
            }
            SpeedModifier mod = new SpeedModifier(type, value);
            int[] tixes = SimpleParser.parseIndexes(tokens, Integer.MAX_VALUE);
            List<Tri> tris = this.getTris(tixes);
            this.d_kb.addEvent(t, new EngineOp.SetSpeedModifier(tris, mod));
        } else {
            throw new IllegalArgumentException("Unknown Command: " + cmd);
        }
    }

    public void parseJSON(String line) throws IOException {
        SimpleParser.parseJSON(this.d_kb, line);
    }

    public static void parseJSON(KB kb, String line) throws IOException {
        Object smvLinkObj;
        Object customScripts;
        JSONObject lineData = (JSONObject)JSONValue.parse(line);
        Object densRegions = lineData.get("density-regions");
        if (densRegions != null) {
            JSONArray regions = (JSONArray)densRegions;
            for (Object regionObj : regions) {
                JSONObject region = (JSONObject)regionObj;
                String name = (String)region.get("name");
                String minStr = (String)region.get("min");
                String maxStr = (String)region.get("max");
                Point3d min = SimpleParser.parsePoint3d(minStr);
                Point3d max = SimpleParser.parsePoint3d(maxStr);
                kb.addDensityRegion(new Region(name, new AABox(min, max)));
            }
        }
        if ((customScripts = lineData.get("custom-scripts")) != null) {
            JSONArray scripts = (JSONArray)customScripts;
            for (Object scriptObj : scripts) {
                JSONObject scriptJson = (JSONObject)scriptObj;
                String srcEncoded = (String)scriptJson.get("src_base64");
                byte[] decodedString = Base64.getDecoder().decode(srcEncoded);
                kb.addScript(new String(decodedString));
            }
        }
        if ((smvLinkObj = lineData.get("smv_pl3d")) != null) {
            String smvFn = (String)smvLinkObj;
            File smvFile = new File(smvFn);
            DataFinderSmvPlot3d smvDataFinder = new DataFinderSmvPlot3d(smvFile);
            DataInquisitor inquisitor = new DataInquisitor(smvDataFinder);
            KbLink smvLink = new KbLink(inquisitor);
            DataFinder.Quantity[] knownQuantities = inquisitor.getQuantities();
            JSONArray sensors = (JSONArray)lineData.get("sensors");
            for (Object sensorObj : sensors) {
                JSONObject sensor = (JSONObject)sensorObj;
                String pl3dQuantity = (String)sensor.get("pl3d_quantity");
                String label = (String)sensor.get("label");
                DataFinder.Quantity q = null;
                for (DataFinder.Quantity knownQuantity : knownQuantities) {
                    if (!knownQuantity.fdsName.equals(pl3dQuantity) && !knownQuantity.friendlyName.equals(pl3dQuantity)) continue;
                    q = knownQuantity;
                    break;
                }
                if (q == null) {
                    throw new IllegalArgumentException("Unknown Quantity: " + pl3dQuantity);
                }
                smvLink.addSensor(new KbLink.SensorInfo(q, label));
            }
            kb.setFdsOutputData(smvLink);
        }
    }

    private List<Blockage> findBlockages(String blkgId, boolean quoted) {
        if (quoted) {
            return this.d_kb.getBlockages(blkgId);
        }
        try {
            int id = Integer.parseInt(blkgId);
            if (id >= this.d_kb.getBlockages().size()) {
                throw new NumberFormatException();
            }
            return Arrays.asList(this.d_kb.getBlockages().get(id));
        }
        catch (NumberFormatException e) {
            return this.d_kb.getBlockages(blkgId);
        }
    }

    private List<Tri> getTris(int[] triids) throws IOException {
        Tri[] mtris = this.d_kb.getMesh().getTris();
        ArrayList<Tri> tris = new ArrayList<Tri>(triids.length);
        for (int triid : triids) {
            if (triid >= mtris.length || triid < 0) {
                String msg = String.format(Intl.intl("Invalid tri index: %d"), triid);
                throw new IOException(msg);
            }
            tris.add(mtris[triid]);
        }
        return tris;
    }

    public void parseEdge(MeshBuilder mb, String line) {
        String[] tokens = this.getTokens(line, true);
        if (tokens[0].equalsIgnoreCase("door")) {
            ANode node = this.d_kb.getNodes().get(Integer.parseInt(tokens[1]));
            int ixVert1 = Integer.parseInt(tokens[2]);
            int ixVert2 = Integer.parseInt(tokens[3]);
            mb.addDoorEdge(node, ixVert1, ixVert2);
        } else if (tokens[0].equalsIgnoreCase("exit_door")) {
            ANode node = this.d_kb.getNodes().get(Integer.parseInt(tokens[1]));
            int ixVert1 = Integer.parseInt(tokens[2]);
            int ixVert2 = Integer.parseInt(tokens[3]);
            mb.addExitDoorEdge(node, ixVert1, ixVert2);
        } else if (tokens[0].equalsIgnoreCase("boundary")) {
            int ixVert1 = Integer.parseInt(tokens[1]);
            int ixVert2 = Integer.parseInt(tokens[2]);
            mb.addBoundaryEdge(ixVert1, ixVert2);
        } else {
            throw new RuntimeException("unknown edge type: " + tokens[0]);
        }
    }

    public void parseParam(String line) {
        String[] tokens = this.getTokens(line, false);
        this.d_param.set(tokens[0], tokens[1], this.d_absolutePath);
    }

    private String[] getTokens(String str, String delims, boolean hasIndex) {
        return this.getTokens(str, delims, hasIndex, true, false);
    }

    private String[] getTokens(String str, String delims, boolean hasIndex, boolean allowEscapeChar, boolean keepAll) {
        return this.getTokens(str, delims, hasIndex, allowEscapeChar, keepAll, false);
    }

    private String[] getTokens(String str, String delims, boolean hasIndex, boolean allowEscapeChar, boolean keepAll, boolean grouping) {
        if (hasIndex) {
            int colix = str.indexOf(58);
            str = str.substring(colix + 1);
        }
        Character escapeChar = allowEscapeChar ? Character.valueOf('\\') : null;
        int options = 0;
        if (keepAll) {
            options |= 3;
        }
        String quote = grouping ? "\"\"()" : "\"";
        List<String> tokList = CSVLineParser.parse(new ArrayList<String>(), str, delims, quote, null, escapeChar, options);
        String[] toks = new String[tokList.size()];
        return tokList.toArray(toks);
    }

    private String[] getTokens(String str, boolean hasIndex) {
        return this.getTokens(str, " ,", hasIndex);
    }

    private String[] removeEmpty(String[] strArr) {
        ArrayList<String> nonEmpty = new ArrayList<String>();
        for (String s : strArr) {
            if (s.length() <= 0) continue;
            nonEmpty.add(s);
        }
        return nonEmpty.toArray(new String[nonEmpty.size()]);
    }

    private static class ParseProfileInfo {
        public final List<IFunction1d> functions;
        public final List<IDistributedVal<?>> distributions;
        public final List<OccProfileSim.IShapeGen> occShapes;
        public final HashMap<Integer, String> aeTeamNameMap;
        public final Map<Integer, OccProfileSim.CompRestrictions> compRestrictionsMap;

        public ParseProfileInfo(List<IFunction1d> functions, List<IDistributedVal<?>> distributions, List<OccProfileSim.IShapeGen> occShapes, HashMap<Integer, String> aeTeamNameMap, Map<Integer, OccProfileSim.CompRestrictions> compRestrictionsMap) {
            this.functions = functions;
            this.distributions = distributions;
            this.occShapes = occShapes;
            this.aeTeamNameMap = aeTeamNameMap;
            this.compRestrictionsMap = compRestrictionsMap;
        }
    }

    private static class TagGenerator {
        public final Map<String, Tag> tags = new LinkedHashMap<String, Tag>();
        private static final Function<String, Tag> s_newTag = name -> new Tag((String)name, (String)name, false);

        public TagGenerator(KB kb) {
            for (PredefTag ptag : PredefTag.values()) {
                Tag tag = kb.getPredefTag(ptag);
                this.add(tag);
            }
        }

        public void add(Tag tag) {
            this.tags.put(tag.name, tag);
        }

        public Tag getTag(String name) {
            return this.tags.computeIfAbsent(name, s_newTag);
        }

        public void finish(KB kb) {
            kb.addTags(theUtil.filter(this.tags.values(), t -> !t.predefined));
        }
    }

    private static class ParseGoalInfo
    extends ParseProfileInfo {
        public final List<AssistedEvacTeam> teams;
        public final List<Counter> counters;
        public final TagGenerator tags;
        public final List<OccGroup> groups;
        public final List<OccGroupType> groupTypes;
        public final Map<ChangeBehaviorGoal, Integer> changeBehaviorIdMap;

        public ParseGoalInfo(ParseProfileInfo ppi, List<AssistedEvacTeam> teams, List<Counter> counters, TagGenerator tags, List<OccGroup> groups, List<OccGroupType> groupTypes) {
            super(ppi.functions, ppi.distributions, ppi.occShapes, ppi.aeTeamNameMap, ppi.compRestrictionsMap);
            this.counters = counters;
            this.teams = teams;
            this.tags = tags;
            this.groups = groups;
            this.groupTypes = groupTypes;
            this.changeBehaviorIdMap = new HashMap<ChangeBehaviorGoal, Integer>();
        }
    }

    private static class TokenIterator {
        public final List<String> tokens;
        public int tix;

        public TokenIterator(String[] tokens) {
            this(Arrays.asList(tokens), 0);
        }

        public TokenIterator(String[] tokens, int tix) {
            this(Arrays.asList(tokens), tix);
        }

        public TokenIterator(List<String> tokens) {
            this(tokens, 0);
        }

        public TokenIterator(List<String> tokens, int tix) {
            this.tokens = tokens;
            this.tix = tix;
        }

        public String curr() {
            return this.tokens.get(this.tix);
        }

        public String next() {
            return this.tokens.get(this.tix++);
        }

        public int nextInt() {
            return Integer.parseInt(this.next());
        }

        public double nextDouble() {
            return Double.parseDouble(this.next());
        }

        public float nextFloat() {
            return Float.parseFloat(this.next());
        }

        public long nextLong() {
            return Long.parseLong(this.next());
        }

        public boolean nextBoolean() {
            return Boolean.parseBoolean(this.next());
        }

        public boolean hasMore() {
            return this.tix < this.tokens.size();
        }

        public int getRemaining() {
            return this.tokens.size() - this.tix;
        }

        public void rewind(int count) {
            this.tix -= count;
        }
    }

    protected static class ParseData {
        final ArrayList<Point3d> pList = new ArrayList();
        MeshBuilder navmb = null;
        MeshBuilder geommb = null;
        final List<BehaviorSim> behaviors = new ArrayList<BehaviorSim>();
        final List<OccProfileSim> profiles = new ArrayList<OccProfileSim>();
        final List<Material> mats = new ArrayList<Material>();
        final List<IDistributedVal<?>> distributions = new ArrayList();
        final List<IFunction1d> functions = new ArrayList<IFunction1d>();
        final List<Counter> counters = new ArrayList<Counter>();
        final TagGenerator tags;
        final List<String> edgeLines = new ArrayList<String>();
        final List<String> doorLines = new ArrayList<String>();
        final List<String> occLines = new ArrayList<String>();
        final List<String> behaviorLines = new ArrayList<String>();
        final List<String> profLines = new ArrayList<String>();
        final List<String> evtLines = new ArrayList<String>();
        final List<String> aeGoalsLines = new ArrayList<String>();
        final List<String> occShapeLines = new ArrayList<String>();
        final List<String> occSourcesLines = new ArrayList<String>();
        final List<String> tagLines = new ArrayList<String>();
        final List<String> blockagesLines = new ArrayList<String>();
        final List<String> occGroupLines = new ArrayList<String>();
        final List<String> occGroupTypeLines = new ArrayList<String>();
        final List<String> elevatorLines = new ArrayList<String>();
        final List<String> elevatorDischargeLines = new ArrayList<String>();
        final List<String> elevatorLevelDataLines = new ArrayList<String>();
        final List<String> elevatorLinkLines = new ArrayList<String>();
        final List<String> elevatorPriorityLines = new ArrayList<String>();
        final List<String> subunitLines = new ArrayList<String>();
        final List<String> compRestrictionsLines = new ArrayList<String>();

        public ParseData(KB kb) {
            this.tags = new TagGenerator(kb);
        }
    }

    private static enum State {
        UNKNOWN(""),
        VERSION("version"),
        PARAM("param"),
        MATERIALS("materials"),
        NODES("nodes"),
        DOORS("doors"),
        STAIRS("stairs"),
        OCCS("occupants"),
        VERTS("verts"),
        NAVMESH("navmesh"),
        GEOMMESH("geommesh"),
        PROFILES("profiles"),
        BEHAVIORS("behaviors"),
        TAGS("tags"),
        EDGES("edges"),
        FLOORS("floors"),
        ELEVATORS("elevators"),
        ELEVATOR_DISCHARGE("elevator-discharge"),
        ELEVATOR_LEVEL_DATA("elevator-level-data"),
        ELEVATOR_LINKS("elevator-links"),
        ELEVATOR_PRIORITY("elevator-priority"),
        SUBUNITS("subunits"),
        BLOCKAGES("blockages"),
        CAMERAS("cameras"),
        EVENTS("events"),
        JSON("json"),
        META("meta"),
        DISTRIBUTIONS("distributions"),
        FUNCTIONS("functions"),
        ASSISTED_EVAC_TEAMS("assisted-evac-teams"),
        OCCSHAPES("occshapes"),
        OCC_SOURCES("occupant-sources"),
        COUNTERS("counters"),
        GROUPS("groups"),
        GROUP_TEMPLATES("group-templates"),
        COMPONENT_RESTRICTIONS("component-restrictions");

        public final String token;

        private State(String token) {
            this.token = token;
        }
    }
}

